/*
 * Decompiled with CFR 0.152.
 */
package org.dstorerdb.cmdintepreter.cmd;

import java.util.ArrayList;
import org.dstorerdb.cmdintepreter.cmd.BadSyntaxException;
import org.dstorerdb.cmdintepreter.cmd.Interpretable;

public class Command
implements Interpretable {
    private String order;
    private String[] options;

    public Command(String order, String ... options) {
        this.order = order;
        this.options = options;
    }

    public Command(String strCmd) throws BadSyntaxException {
        this.buildCommand(strCmd);
    }

    private void countComillas(String strCommand) throws BadSyntaxException {
        int count = 0;
        char[] chars = strCommand.toCharArray();
        for (int i = 0; i < chars.length; ++i) {
            if (chars[i] != '\'') continue;
            ++count;
        }
        if (count > 0 && count % 2 != 0) {
            throw new BadSyntaxException("Sintaxis del comando invalida");
        }
    }

    private void buildCommand(String strCommand) throws BadSyntaxException {
        ArrayList<String> listOptions = new ArrayList<String>();
        StringBuilder sbCurrent = new StringBuilder();
        String[] spaceSplit = strCommand.split(" ");
        this.order = spaceSplit[0];
        if (this.order.contains("'")) {
            throw new BadSyntaxException("La orden no puede contener comillas");
        }
        boolean addingPhrase = false;
        int spaceSplitLen = spaceSplit.length;
        for (int i = 1; i < spaceSplitLen; ++i) {
            String split = spaceSplit[i];
            if (addingPhrase) {
                if (!split.contains("'")) {
                    sbCurrent.append(split);
                    if (i >= spaceSplitLen - 1) continue;
                    sbCurrent.append(' ');
                    continue;
                }
                if (split.endsWith("'")) {
                    sbCurrent.append(split);
                    listOptions.add(sbCurrent.toString());
                    sbCurrent.delete(0, sbCurrent.length());
                    addingPhrase = false;
                    continue;
                }
                throw new BadSyntaxException("Error de sintaxis en la opcion " + split);
            }
            if (split.startsWith("'") && !split.endsWith("'")) {
                addingPhrase = true;
                sbCurrent.append(split).append(' ');
                continue;
            }
            listOptions.add(split);
        }
        if (addingPhrase) {
            listOptions.add(sbCurrent.append('\'').toString());
        }
        this.options = new String[listOptions.size()];
        this.options = listOptions.toArray(this.options);
    }

    public boolean hasOptions() {
        return this.options != null;
    }

    public boolean isNumberOption(int index) {
        try {
            Long.parseLong(this.getOptionAt(index));
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    public boolean hasNumberID(String option) {
        char lastC = option.charAt(option.length() - 1);
        return option.length() > 1 && (lastC == 'L' || lastC == 'I' || lastC == 'S' || lastC == 'B' || lastC == 'F' || lastC == 'D');
    }

    public int getOptionAsNumber(int index) {
        return this.isNumberOption(index) ? Integer.parseInt(this.getOptionAt(index)) : -1;
    }

    public int getOptionsCount() {
        return this.hasOptions() ? this.options.length : 0;
    }

    public String getOrder() {
        return this.order;
    }

    public String[] getOptions() {
        return this.options;
    }

    public String getOptionAt(int index) {
        return this.options[index];
    }

    public String toString() {
        StringBuilder sbCmd = new StringBuilder();
        sbCmd.append(this.order);
        int optLen = this.options != null ? this.options.length : 0;
        for (int i = 0; i < optLen; ++i) {
            sbCmd.append(' ').append(this.options[i]);
        }
        return sbCmd.toString();
    }
}

