/*
 * Decompiled with CFR 0.152.
 */
package org.dstorerdb.common.streams;

import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import org.dstorerdb.common.streams.StreamBuffer;
import org.dstorerdb.encryptor.encryptor.Encryptor;
import org.dstorerdb.encryptor.exceptions.InvalidTextException;

public class StringInputStream
extends DataInputStream {
    private final Encryptor encryptor = new Encryptor();
    private final StreamBuffer streamBuffer = new StreamBuffer();
    private static final short BUFF_SIZE = 1024;

    public StringInputStream(InputStream in) {
        super(in);
    }

    private void addBytes(byte[] array, StringBuilder sbStr) {
        byte b;
        for (int i = 0; i < array.length && (b = array[i]) != 0; ++i) {
            sbStr.append((char)b);
        }
    }

    private Byte[] getAvailableBytes(byte[] array) {
        byte b;
        ArrayList<Byte> listBytes = new ArrayList<Byte>();
        for (int i = 0; i < array.length && (b = array[i]) != 0; ++i) {
            listBytes.add(b);
        }
        return (Byte[])listBytes.toArray();
    }

    private int getBuffSize(int bytesAvailable) {
        if (bytesAvailable <= 1024) {
            return bytesAvailable;
        }
        int bigThat = bytesAvailable / 1024;
        return bigThat <= 10 ? bytesAvailable : 10240;
    }

    private void waitForData() throws IOException {
        while (!this.hasData()) {
        }
    }

    private void waitForData(long millis) throws IOException {
        long ti = System.currentTimeMillis();
        while (!this.hasData() && System.currentTimeMillis() - ti < millis) {
        }
    }

    public boolean hasData() throws IOException {
        return this.available() > 0;
    }

    public String readString() throws IOException, InvalidTextException {
        this.waitForData();
        int bufferSize = this.getBuffSize(this.available());
        byte[] bytes = new byte[bufferSize];
        while (this.hasData()) {
            this.read(bytes);
            this.streamBuffer.addBytes(bytes);
            bytes = new byte[bufferSize];
        }
        String msg = this.streamBuffer.getAllBytes();
        return this.encryptor.decrypt(msg);
    }
}

