/*
 * Decompiled with CFR 0.152.
 */
package org.dstorerdb.encryptor.encryptor;

import org.dstorerdb.encryptor.encryptor.AbstractEncryptor;
import org.dstorerdb.encryptor.encryptor.SysEncryptor;
import org.dstorerdb.encryptor.exceptions.InvalidTextException;

public class Encryptor
extends AbstractEncryptor {
    private final SysEncryptor SYS_ENCRYPTOR = new SysEncryptor();
    protected static final byte MULTIPLIER = -1;
    protected static final byte ADDER = 5;
    protected static final char NULL = '\u0014';

    public Encryptor() {
        this("powerx7");
    }

    public Encryptor(String strKey) {
        super(strKey);
    }

    @Override
    protected char getEncryptedChar(char c) {
        return (char)(c - 5);
    }

    @Override
    protected char getDecryptedChar(char c) {
        return (char)(c + 5);
    }

    @Override
    public synchronized String encrypt(String text) throws InvalidTextException {
        if (text == null || text.isEmpty()) {
            throw new InvalidTextException("El texto a encriptar es invalido");
        }
        this.sBuilder.delete(0, this.sBuilder.length());
        char[] txtChars = text.toCharArray();
        int charsLen = txtChars.length;
        this.sBuilder.append(this.getEncryptedChar(this.key.getFirstChar()));
        for (int i = 0; i < charsLen; ++i) {
            this.sBuilder.append(this.getEncryptedChar(txtChars[i]));
        }
        this.sBuilder.append(this.getEncryptedChar('\u0014'));
        char[] keyChars = this.key.getChars(1, this.key.getKeyLenght());
        int kcLen = keyChars.length;
        for (int i = 0; i < kcLen; ++i) {
            this.sBuilder.append(this.getEncryptedChar(keyChars[i]));
        }
        return this.SYS_ENCRYPTOR.encrypt(this.sBuilder.toString());
    }

    @Override
    public synchronized String decrypt(String text) throws InvalidTextException {
        char c;
        if (text == null || text.isEmpty()) {
            throw new InvalidTextException("El texto a desencriptar es invalido");
        }
        text = this.SYS_ENCRYPTOR.decrypt(text);
        this.sBuilder.delete(0, this.sBuilder.length());
        char[] txtChars = text.toCharArray();
        int charsLen = txtChars.length;
        for (int i = 1; i < charsLen && (c = this.getDecryptedChar(txtChars[i])) != '\u0014'; ++i) {
            this.sBuilder.append(c);
        }
        return this.sBuilder.toString();
    }

    public static void main(String[] args) throws InvalidTextException {
        Encryptor enc = new Encryptor();
        String txt = "errord-Orden no valida/002";
        String e = enc.encrypt(txt);
        String d = enc.decrypt(e);
        System.out.println(txt);
        System.out.println(e);
        System.out.println(d);
    }
}

