/*
 * Decompiled with CFR 0.152.
 */
package org.dstorerdb.server.net.thread;

import org.dstorerdb.cmdintepreter.cmd.BadSyntaxException;
import org.dstorerdb.cmdintepreter.cmd.Command;
import org.dstorerdb.common.interfaces.Communicable;
import org.dstorerdb.common.model.User;
import org.dstorerdb.server.net.Client;
import org.dstorerdb.server.net.Server;
import org.dstorerdb.server.net.thread.ConnectionManager;
import org.dstorerdb.server.system.UserManager;

public class TClient
extends Thread
implements Communicable {
    private final Client client;
    private final StringBuilder sbMsg;
    private final ConnectionManager connManager;
    private boolean isConnected;

    public TClient(Client client) {
        this.client = client;
        this.sbMsg = new StringBuilder();
        this.isConnected = true;
        this.connManager = new ConnectionManager(client.getRemoteAddress(), this.getId());
        this.setName("TClient: " + client.getUser().getNick());
    }

    public boolean isConnected() {
        return this.client.isConnected();
    }

    public void closeStreams() {
        this.client.closeStreams();
    }

    public void closeConnection() {
        this.client.closeStreams();
        this.client.closeSocket();
    }

    public Client getClient() {
        return this.client;
    }

    public User getUser() {
        return this.client.getUser();
    }

    public UserManager getUserManager() {
        return this.client.getUserManager();
    }

    public void disconnectClient() {
        this.isConnected = false;
    }

    public void execCommand(String strCommand) throws BadSyntaxException {
        this.client.getInterpreter().execCommand(new Command(strCommand));
    }

    public void sendResponseMessage() {
        this.sendData(this.client.getInterpreter().getResponseMsg());
    }

    public void sendSyntaxErrorMessage(String msg) {
        this.sbMsg.append("errorsyn").append('-').append(msg).append("/002");
        this.sendData(this.sbMsg.toString());
        this.sbMsg.delete(0, this.sbMsg.length());
    }

    public void sendData(String data) {
        this.client.sendData(data);
    }

    public String getReceivData() {
        String msg = this.client.getReceivData();
        return msg.substring(0, msg.length() - 4);
    }

    @Override
    public void run() {
        while (this.isConnected()) {
            String msgRec = this.getReceivData();
            System.out.println("TClientComandoRecibido: " + msgRec);
            try {
                this.execCommand(msgRec);
                System.out.println("TClientResponseMessage: " + this.client.getInterpreter().getResponseMsg());
                this.sendResponseMessage();
            }
            catch (BadSyntaxException ex) {
                this.sendSyntaxErrorMessage(ex.getMessage());
            }
        }
        Server.getServer().disconnectClient(this.getId());
    }
}

