/*
 * Decompiled with CFR 0.152.
 */
package org.dstorerdb.server.net.thread;

import java.io.IOException;
import java.net.Socket;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.dstorerdb.cmdintepreter.cmd.BadSyntaxException;
import org.dstorerdb.cmdintepreter.cmd.CmdOrder;
import org.dstorerdb.cmdintepreter.cmd.Command;
import org.dstorerdb.cmdintepreter.cmd.Interpreter;
import org.dstorerdb.common.interfaces.Communicable;
import org.dstorerdb.common.model.User;
import org.dstorerdb.common.streams.StringInputStream;
import org.dstorerdb.common.streams.StringOutputStream;
import org.dstorerdb.encryptor.exceptions.InvalidTextException;
import org.dstorerdb.server.net.Client;
import org.dstorerdb.server.net.Server;
import org.dstorerdb.server.system.UserManager;

public class TRequestManager
extends Thread
implements Communicable {
    private final Socket sockRequest;
    private final StringOutputStream outputStream;
    private final StringInputStream inputStream;
    private Interpreter requestInterpreter;
    private boolean connected;

    public TRequestManager(Socket sockRequest) throws IOException {
        this.sockRequest = sockRequest;
        this.outputStream = new StringOutputStream(sockRequest.getOutputStream());
        this.inputStream = new StringInputStream(sockRequest.getInputStream());
        this.instanceInterpreter();
        this.setName("TRequestManager: " + this.getId());
    }

    private void instanceInterpreter() {
        this.requestInterpreter = new Interpreter();
        this.requestInterpreter.setListener(cmd -> {
            String CMD_ORDER = cmd.getOrder();
            int optCount = cmd.getOptionsCount();
            StringBuilder sbMsg = new StringBuilder();
            switch (CMD_ORDER) {
                case "close": {
                    if (optCount == 0) {
                        this.buildMessage("OK", "Conexion cerrada con exito");
                        this.connected = false;
                        break;
                    }
                    this.buildMessage("errparam", "Este comando no posee parametros");
                    break;
                }
                case "login": {
                    if (cmd.hasOptions()) {
                        if (cmd.getOptionsCount() == 2) {
                            String nick = cmd.getOptionAt(0);
                            String passw = cmd.getOptionAt(1);
                            boolean isValid = Server.getServer().getInfoManager().existsUser(nick, passw);
                            if (isValid) {
                                sbMsg.append("OK").append('-').append("Login correcto!").append("/002");
                                this.requestInterpreter.setResponseMsg(sbMsg.toString());
                                User loged = new User(nick, passw);
                                Client newCli = new Client(loged, this.sockRequest, this.outputStream, this.inputStream);
                                Server.getServer().addClient(newCli);
                                break;
                            }
                            sbMsg.append("errlog").append('-').append("Error de login").append("/002");
                            this.requestInterpreter.setResponseMsg(sbMsg.toString());
                            break;
                        }
                        sbMsg.append("errparam").append('-').append("Cantidad de opciones invalida").append("/002");
                        this.requestInterpreter.setResponseMsg(sbMsg.toString());
                        break;
                    }
                    sbMsg.append("errparam").append('-').append("Comando sin opciones").append("/002");
                    this.requestInterpreter.setResponseMsg(sbMsg.toString());
                    break;
                }
                case "register": {
                    if (cmd.getOptionsCount() == 3) {
                        String pass2;
                        String nick = cmd.getOptionAt(0);
                        String pass1 = cmd.getOptionAt(1);
                        if (!pass1.equals(pass2 = cmd.getOptionAt(2))) {
                            sbMsg.append("errorreg").append('-').append("Las contrase\u00f1as no coinciden").append("/002");
                            this.requestInterpreter.setResponseMsg(sbMsg.toString());
                            break;
                        }
                        pass2 = null;
                        User newUser = new User(nick, pass1);
                        boolean created = UserManager.create(newUser);
                        sbMsg.append(created ? "OK" : "errorreg").append('-').append(created ? "Usuario creado con exito" : "Nick ya existente").append("/002");
                        this.requestInterpreter.setResponseMsg(sbMsg.toString());
                        break;
                    }
                    sbMsg.append("errparam").append('-').append("Cantidad de opciones invalida").append("/002");
                    this.requestInterpreter.setResponseMsg(sbMsg.toString());
                    break;
                }
                default: {
                    if (CmdOrder.isAvailableOrder((String)CMD_ORDER)) {
                        sbMsg.append("err").append('-').append("Comando no disponible para su uso");
                    } else {
                        sbMsg.append("errord").append('-').append("Comando desconocido");
                    }
                    sbMsg.append("/002");
                    this.requestInterpreter.setResponseMsg(sbMsg.toString());
                    sbMsg = null;
                }
            }
        });
    }

    private void buildMessage(String header, String msg) {
        StringBuilder sbMsg = new StringBuilder();
        sbMsg.append(header).append('-').append(msg).append("/002");
        this.requestInterpreter.setResponseMsg(sbMsg.toString());
    }

    public void execCommand(String strCommand) throws BadSyntaxException {
        this.requestInterpreter.execCommand(new Command(strCommand));
    }

    public void sendResponseMessage() {
        this.sendData(this.requestInterpreter.getResponseMsg());
    }

    public void sendSyntaxErrorMessage(String msg) {
        StringBuilder sbMsg = new StringBuilder();
        sbMsg.append("errorsyn").append('-').append(msg).append("/002");
        this.sendData(sbMsg.toString());
        sbMsg.delete(0, sbMsg.length());
    }

    public void sendData(String data) {
        try {
            this.outputStream.writeString(data);
        }
        catch (IOException | InvalidTextException ex) {
            Logger.getLogger(TRequestManager.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public String getReceivData() {
        try {
            String msg = this.inputStream.readString();
            return msg.substring(0, msg.length() - 4);
        }
        catch (IOException | InvalidTextException ex) {
            Logger.getLogger(TRequestManager.class.getName()).log(Level.SEVERE, null, ex);
            return null;
        }
    }

    @Override
    public void run() {
        try {
            String msg = this.getReceivData();
            System.out.println("Dato recibido: " + msg);
            this.execCommand(msg);
            System.out.println("Respuesta a enviar: " + this.requestInterpreter.getResponseMsg());
            this.sendResponseMessage();
            System.out.println("Se envio respuesta!");
        }
        catch (BadSyntaxException ex) {
            this.sendSyntaxErrorMessage(ex.getMessage());
        }
    }
}

