/*
 * Decompiled with CFR 0.152.
 */
package org.dstorerdb.server.system;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.lang.reflect.Field;
import java.nio.file.Files;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.dstorerdb.server.system.UserManager;
import org.mpizutil.electrolist.structure.ElectroList;

public class UserList {
    private File fileList;
    private String name;
    private ElectroList listData;
    private BufferedWriter buffFileWriter;

    public UserList(File parent, String name) {
        this(new File(parent, name));
    }

    public UserList(File fileList) {
        this(fileList, false);
    }

    public UserList(File fileList, boolean create) {
        try {
            this.fileList = fileList;
            if (create && !fileList.exists()) {
                fileList.createNewFile();
            }
            this.name = fileList.getName();
            this.listData = new ElectroList();
            this.buffFileWriter = new BufferedWriter(new FileWriter(fileList, true));
            this.loadList();
        }
        catch (IOException ex) {
            System.out.println("Lista no creada anteriormente");
            Logger.getLogger(UserList.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public UserList(String filePath) {
        this(new File(filePath));
    }

    public UserList(File folderUser, String listName, UserManager.OPEN_LIST_OPTION openOption) {
        this(new File(folderUser, listName), openOption == UserManager.OPEN_LIST_OPTION.CREATE);
    }

    private Object getCastedObject(String strObj) {
        if (strObj.startsWith("'") && strObj.endsWith("'") || strObj.startsWith("\"") && strObj.endsWith("\"")) {
            return strObj.substring(1, strObj.length() - 1);
        }
        int strLen = strObj.length();
        char numId = strObj.charAt(strLen - 1);
        switch (numId) {
            case 'L': {
                return Long.parseLong(strObj.substring(0, strLen - 1));
            }
            case 'I': {
                return Integer.parseInt(strObj.substring(0, strLen - 1));
            }
            case 'S': {
                return Short.parseShort(strObj.substring(0, strLen - 1));
            }
            case 'B': {
                return Byte.parseByte(strObj.substring(0, strLen - 1));
            }
            case 'F': {
                return Float.valueOf(Float.parseFloat(strObj.substring(0, strLen - 1)));
            }
            case 'D': {
                return Double.parseDouble(strObj.substring(0, strLen - 1));
            }
        }
        return null;
    }

    private String getCastedString(Object obj) {
        String className;
        if (obj instanceof String) {
            return '\'' + obj.toString() + '\'';
        }
        switch (className = obj.getClass().getSimpleName().toLowerCase()) {
            case "long": {
                return obj.toString() + 'L';
            }
            case "integer": {
                return obj.toString() + 'I';
            }
            case "int": {
                return obj.toString() + 'I';
            }
            case "short": {
                return obj.toString() + 'S';
            }
            case "byte": {
                return obj.toString() + 'B';
            }
            case "float": {
                return obj.toString() + 'F';
            }
            case "double": {
                return obj.toString() + 'D';
            }
        }
        return null;
    }

    private String[] getFileElements() throws IOException {
        List<String> fileLines = Files.readAllLines(this.fileList.toPath());
        if (fileLines.isEmpty()) {
            return null;
        }
        StringBuilder sbLines = new StringBuilder();
        for (String line : fileLines) {
            sbLines.append(line);
        }
        return sbLines.toString().split("~~");
    }

    private void saveList() {
        try {
            this.buffFileWriter.close();
            this.buffFileWriter = new BufferedWriter(new FileWriter(this.fileList));
            StringBuilder sbObjects = new StringBuilder();
            for (Object object : this.listData) {
                sbObjects.append(this.getCastedString(object));
                sbObjects.append("~~");
            }
            sbObjects.deleteCharAt(sbObjects.length() - 1);
            sbObjects.deleteCharAt(sbObjects.length() - 1);
            this.buffFileWriter.write(sbObjects.toString());
            this.buffFileWriter.flush();
            sbObjects = null;
        }
        catch (IOException ex) {
            Logger.getLogger(UserList.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    private void loadList() throws IOException {
        String[] splitElements = this.getFileElements();
        if (splitElements == null) {
            return;
        }
        int splitLen = splitElements.length;
        for (int i = 0; i < splitLen; ++i) {
            this.listData.add(this.getCastedObject(splitElements[i]));
        }
        splitElements = null;
    }

    private void writeData(String data) {
        try {
            if (!this.listData.isEmpty()) {
                this.buffFileWriter.write("~~");
            }
            this.buffFileWriter.write(data);
        }
        catch (IOException ex) {
            Logger.getLogger(UserList.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    private int getSizeOf(Object obj) {
        if (obj instanceof String) {
            return obj.toString().length();
        }
        try {
            Field sizeField = obj.getClass().getDeclaredField("SIZE");
            return Integer.parseInt(sizeField.get(obj).toString()) / 8;
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException ex) {
            Logger.getLogger(UserList.class.getName()).log(Level.SEVERE, null, ex);
            return -1;
        }
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        try {
            this.name = name;
            this.buffFileWriter.close();
            this.fileList.renameTo(new File(this.fileList.getParentFile(), name));
            this.buffFileWriter = new BufferedWriter(new FileWriter(this.fileList, true));
        }
        catch (IOException ex) {
            Logger.getLogger(UserList.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public ElectroList getListData() {
        return this.listData;
    }

    public File getFileList() {
        return this.fileList;
    }

    public void add(String data) {
        try {
            Object obj = this.getCastedObject(data);
            this.writeData(data);
            this.buffFileWriter.flush();
            this.listData.add(obj);
        }
        catch (IOException ex) {
            Logger.getLogger(UserList.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public void add(int index, String data) {
        Object obj = this.getCastedObject(data);
        this.listData.add(index, obj);
        this.saveList();
    }

    public void add(String ... data) {
        try {
            for (int i = 0; i < data.length; ++i) {
                String sing = data[i];
                this.listData.add(this.getCastedObject(sing));
                this.writeData(sing);
            }
            this.buffFileWriter.flush();
        }
        catch (IOException ex) {
            Logger.getLogger(UserList.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public void add(int index, String ... data) {
        int dataLen = data.length;
        for (int i = 0; i < dataLen; ++i) {
            this.listData.add(index + i, (Object)data[i]);
        }
        this.saveList();
    }

    public void clearAll() {
        try {
            this.listData.clear();
            this.buffFileWriter.close();
            this.buffFileWriter = new BufferedWriter(new FileWriter(this.fileList));
        }
        catch (IOException ex) {
            Logger.getLogger(UserList.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public void delete() {
        try {
            this.listData.clear();
            this.buffFileWriter.close();
            this.fileList.delete();
        }
        catch (IOException ex) {
            Logger.getLogger(UserList.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public boolean deleteInIndex(int index) {
        try {
            this.listData.remove(0);
            return true;
        }
        catch (NullPointerException e) {
            return false;
        }
    }

    public boolean deleteIf(String filter, String symbol) {
        boolean isRemoved = false;
        if (symbol.equals("=")) {
            try {
                isRemoved = this.listData.removeIf(e -> e.equals(filter));
                this.buffFileWriter.close();
                this.buffFileWriter = new BufferedWriter(new FileWriter(this.fileList));
                this.saveList();
            }
            catch (IOException ex) {
                Logger.getLogger(UserList.class.getName()).log(Level.SEVERE, null, ex);
            }
        } else {
            try {
                isRemoved = this.listData.removeIf(e -> e.toString().contains(filter));
                this.buffFileWriter.close();
                this.buffFileWriter = new BufferedWriter(new FileWriter(this.fileList));
                this.saveList();
            }
            catch (IOException ex) {
                Logger.getLogger(UserList.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        return isRemoved;
    }

    public int getSizeOf() {
        int sizeOf = 0;
        for (Object object : this.listData) {
            sizeOf += this.getSizeOf(object);
        }
        return sizeOf;
    }

    public String getAll() {
        if (this.listData.isEmpty()) {
            return "EMPTY";
        }
        StringBuilder sbList = new StringBuilder();
        for (Object object : this.listData) {
            sbList.append(object.toString()).append("~~");
        }
        return sbList.substring(0, sbList.length() - 2);
    }

    public String getByRange(int start, int end) {
        if (start >= this.listData.size() || end >= this.listData.size()) {
            return "BAD_RANGE";
        }
        if (this.listData.isEmpty()) {
            return "EMPTY";
        }
        if (start == end) {
            return this.listData.get(end).toString();
        }
        StringBuilder sbData = new StringBuilder();
        ElectroList listResults = this.listData.get(start, end);
        for (String result : listResults) {
            sbData.append(result).append("~~");
        }
        return sbData.substring(0, sbData.length() - 2);
    }

    public String getByIndex(int index) {
        if (index < 0 || index >= this.listData.size()) {
            return "BAD_RANGE";
        }
        if (this.listData.isEmpty()) {
            return "EMPTY";
        }
        return this.listData.get(index).toString();
    }

    public void setAllTo(String data) {
        int numAdd = this.listData.size();
        this.listData.clear();
        for (int i = 0; i < numAdd; ++i) {
            this.listData.add(this.getCastedObject(data));
        }
        this.saveList();
    }

    public boolean setElement(int index, String newElement) {
        if (this.listData.isEmpty() || this.listData.size() >= index) {
            return false;
        }
        this.listData.set(index, (Object)newElement);
        this.saveList();
        return true;
    }
}

