/*
 * Decompiled with CFR 0.152.
 */
package clojure.lang;

import clojure.lang.AFn;
import clojure.lang.ArraySeq;
import clojure.lang.IFn;
import clojure.lang.IHashEq;
import clojure.lang.IPending;
import clojure.lang.IPersistentCollection;
import clojure.lang.IPersistentMap;
import clojure.lang.ISeq;
import clojure.lang.Murmur3;
import clojure.lang.Obj;
import clojure.lang.PersistentList;
import clojure.lang.RT;
import clojure.lang.SeqIterator;
import clojure.lang.Sequential;
import clojure.lang.Util;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;

public final class LazyTransformer
extends Obj
implements ISeq,
Sequential,
List,
IPending,
IHashEq {
    IStepper stepper;
    Object first = null;
    LazyTransformer rest = null;

    public LazyTransformer(IStepper stepper) {
        this.stepper = stepper;
    }

    public static LazyTransformer create(IFn xform, Object coll) {
        return new LazyTransformer(new Stepper(xform, RT.iter(coll)));
    }

    public static LazyTransformer createMulti(IFn xform, Object[] colls) {
        Iterator[] iters = new Iterator[colls.length];
        for (int i = 0; i < colls.length; ++i) {
            iters[i] = RT.iter(colls[i]);
        }
        return new LazyTransformer(new MultiStepper(xform, iters));
    }

    private LazyTransformer(IPersistentMap meta, Object first, LazyTransformer rest) {
        super(meta);
        this.stepper = null;
        this.first = first;
        this.rest = rest;
    }

    @Override
    public Obj withMeta(IPersistentMap meta) {
        this.seq();
        return new LazyTransformer(meta, this.first, this.rest);
    }

    @Override
    public final synchronized ISeq seq() {
        if (this.stepper != null) {
            this.stepper.step(this);
        }
        if (this.rest == null) {
            return null;
        }
        return this;
    }

    @Override
    public Object first() {
        if (this.stepper != null) {
            this.seq();
        }
        if (this.rest == null) {
            return null;
        }
        return this.first;
    }

    @Override
    public ISeq next() {
        if (this.stepper != null) {
            this.seq();
        }
        if (this.rest == null) {
            return null;
        }
        return this.rest.seq();
    }

    @Override
    public ISeq more() {
        if (this.stepper != null) {
            this.seq();
        }
        if (this.rest == null) {
            return PersistentList.EMPTY;
        }
        return this.rest;
    }

    @Override
    public int count() {
        int c = 0;
        for (ISeq s = this.seq(); s != null; s = s.next()) {
            ++c;
        }
        return c;
    }

    @Override
    public ISeq cons(Object o) {
        return RT.cons(o, this.seq());
    }

    @Override
    public IPersistentCollection empty() {
        return PersistentList.EMPTY;
    }

    @Override
    public boolean equiv(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Sequential) && !(o instanceof List)) {
            return false;
        }
        ISeq ms = RT.seq(o);
        ISeq s = this.seq();
        while (s != null) {
            if (ms == null || !Util.equiv(s.first(), ms.first())) {
                return false;
            }
            s = s.next();
            ms = ms.next();
        }
        return ms == null;
    }

    @Override
    public int hashCode() {
        ISeq s = this.seq();
        if (s == null) {
            return 1;
        }
        return Util.hash(this.seq());
    }

    @Override
    public int hasheq() {
        return Murmur3.hashOrdered(this);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Sequential) && !(o instanceof List)) {
            return false;
        }
        ISeq ms = RT.seq(o);
        ISeq s = this.seq();
        while (s != null) {
            if (ms == null || !Util.equals(s.first(), ms.first())) {
                return false;
            }
            s = s.next();
            ms = ms.next();
        }
        return ms == null;
    }

    @Override
    public Object[] toArray() {
        return RT.seqToArray(this.seq());
    }

    @Override
    public boolean add(Object o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean remove(Object o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean addAll(Collection c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean retainAll(Collection c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean removeAll(Collection c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean containsAll(Collection c) {
        for (Object o : c) {
            if (this.contains(o)) continue;
            return false;
        }
        return true;
    }

    @Override
    public Object[] toArray(Object[] a) {
        return RT.seqToPassedArray(this.seq(), a);
    }

    @Override
    public int size() {
        return this.count();
    }

    @Override
    public boolean isEmpty() {
        return this.seq() == null;
    }

    @Override
    public boolean contains(Object o) {
        for (ISeq s = this.seq(); s != null; s = s.next()) {
            if (!Util.equiv(s.first(), o)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Iterator iterator() {
        return new SeqIterator(this);
    }

    private List reify() {
        return new ArrayList(this);
    }

    public List subList(int fromIndex, int toIndex) {
        return this.reify().subList(fromIndex, toIndex);
    }

    public Object set(int index, Object element) {
        throw new UnsupportedOperationException();
    }

    public Object remove(int index) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int indexOf(Object o) {
        ISeq s = this.seq();
        int i = 0;
        while (s != null) {
            if (Util.equiv(s.first(), o)) {
                return i;
            }
            s = s.next();
            ++i;
        }
        return -1;
    }

    @Override
    public int lastIndexOf(Object o) {
        return this.reify().lastIndexOf(o);
    }

    public ListIterator listIterator() {
        return this.reify().listIterator();
    }

    public ListIterator listIterator(int index) {
        return this.reify().listIterator(index);
    }

    public Object get(int index) {
        return RT.nth(this, index);
    }

    public void add(int index, Object element) {
        throw new UnsupportedOperationException();
    }

    public boolean addAll(int index, Collection c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public synchronized boolean isRealized() {
        return this.stepper == null;
    }

    static class MultiStepper
    implements IStepper {
        Iterator[] iters;
        Object[] nexts;
        IFn xform;
        static IFn stepfn = new AFn(){

            @Override
            public Object invoke(Object result) {
                LazyTransformer lt = (LazyTransformer)result;
                lt.stepper = null;
                return lt;
            }

            @Override
            public Object invoke(Object result, Object input) {
                LazyTransformer lt = (LazyTransformer)result;
                lt.first = input;
                lt.rest = new LazyTransformer(lt.stepper);
                lt.stepper = null;
                return lt.rest;
            }
        };

        MultiStepper(IFn xform, Iterator[] iters) {
            this.iters = iters;
            this.nexts = new Object[iters.length];
            this.xform = (IFn)xform.invoke(stepfn);
        }

        boolean hasNext() {
            for (Iterator iter : this.iters) {
                if (iter.hasNext()) continue;
                return false;
            }
            return true;
        }

        ISeq next() {
            for (int i = 0; i < this.iters.length; ++i) {
                this.nexts[i] = this.iters[i].next();
            }
            return new ArraySeq(this.nexts, 0);
        }

        @Override
        public void step(LazyTransformer lt) {
            while (lt.stepper != null && this.hasNext()) {
                if (!RT.isReduced(this.xform.applyTo(RT.cons(lt, this.next())))) continue;
                lt.stepper = null;
                LazyTransformer et = lt;
                while (et.rest != null) {
                    et = et.rest;
                    et.stepper = null;
                }
                this.xform.invoke(et);
                return;
            }
            if (lt.stepper != null) {
                this.xform.invoke(lt);
            }
        }
    }

    static class Stepper
    implements IStepper {
        Iterator iter;
        IFn xform;
        static IFn stepfn = new AFn(){

            @Override
            public Object invoke(Object result) {
                LazyTransformer lt = (LazyTransformer)result;
                lt.stepper = null;
                return result;
            }

            @Override
            public Object invoke(Object result, Object input) {
                LazyTransformer lt = (LazyTransformer)result;
                lt.first = input;
                lt.rest = new LazyTransformer(lt.stepper);
                lt.stepper = null;
                return lt.rest;
            }
        };

        Stepper(IFn xform, Iterator iter) {
            this.iter = iter;
            this.xform = (IFn)xform.invoke(stepfn);
        }

        @Override
        public void step(LazyTransformer lt) {
            while (lt.stepper != null && this.iter.hasNext()) {
                if (!RT.isReduced(this.xform.invoke(lt, this.iter.next()))) continue;
                lt.stepper = null;
                LazyTransformer et = lt;
                while (et.rest != null) {
                    et = et.rest;
                    et.stepper = null;
                }
                this.xform.invoke(et);
                return;
            }
            if (lt.stepper != null) {
                this.xform.invoke(lt);
            }
        }
    }

    static interface IStepper {
        public void step(LazyTransformer var1);
    }
}

