;; Compiled from /home/eob/clean-src/fgolib/src/fmt.go
(ns
 fmt
 (:gen-class)
 (:require [clojure.string :as string])
 (:import (clojure.lang Ratio IPersistentVector APersistentMap)))

(set! *warn-on-reflection* true)

(def Printf printf)

(def Print print)

(defn-
 strip-zero-after-decimal
 [s]
 (string/replace (str s) #"^([1-9][0-9]*)\.0$" "$1"))

(defn-
 to-string-like-go
 [x]
 (cond
  (instance? String x)
  x
  (instance? Ratio x)
  (str (long x))
  (instance? Number x)
  (strip-zero-after-decimal x)
  (instance? IPersistentVector x)
  (str "[" (string/join " " (map to-string-like-go x)) "]")
  (instance? APersistentMap x)
  (str
   "map["
   (string/join
    " "
    (for
     [[key val] x]
     (str (to-string-like-go key) ":" (to-string-like-go val))))
   "]")
  :else
  (str x)))

(defn
 Println
 [& args]
 (let
  [as (map (fn* [p1__9#] (to-string-like-go p1__9#)) args)]
  (println (string/join " " as))))

