;; Compiled from src/funcgo/symboltable.go
(ns
 funcgo.symboltable
 (:gen-class)
 (:require [clojure.string :as string]))

(set! *warn-on-reflection* true)

(defn
 New
 []
 (ref
  {"long" :type,
   "double" :type,
   "boolean" :type,
   :unused-packages #{},
   :unused-types #{}}))

(defn
 Package-imported
 [st pkg]
 (dosync
  (alter
   st
   (fn*
    [p1__46#]
    (assoc
     p1__46#
     pkg
     :package
     :unused-packages
     (conj (@st :unused-packages) pkg))))))

(defn
 Package-created
 [st pkg]
 (dosync (alter st (fn* [p1__47#] (assoc p1__47# pkg :package)))))

(defn
 Type-imported
 [st typ]
 (dosync
  (alter
   st
   (fn*
    [p1__48#]
    (assoc
     p1__48#
     typ
     :type
     :unused-types
     (conj (@st :unused-types) typ))))))

(defn
 Type-created
 [st typ]
 (dosync (alter st (fn* [p1__49#] (assoc p1__49# typ :type)))))

(defn
 Has-package
 [st pkg]
 (do
  (dosync
   (alter
    st
    (fn*
     [p1__50#]
     (assoc
      p1__50#
      :unused-packages
      (disj (@st :unused-packages) pkg)))))
  (= (@st pkg) :package)))

(defn
 Has-type
 [st typ]
 (do
  (dosync
   (alter
    st
    (fn*
     [p1__51#]
     (assoc p1__51# :unused-types (disj (@st :unused-types) typ)))))
  (= (@st typ) :type)))

(defn
 Packages
 [st]
 (let
  [packages (for [[symbol key] @st :when (= key :package)] symbol)]
  (str "[" (string/join ", " packages) "]")))

(defn
 Types
 [st]
 (let
  [packages (for [[symbol key] @st :when (= key :type)] symbol)]
  (str "[" (string/join ", " packages) "]")))

(defn
 Check-all-used
 [st]
 (let
  [pkgs (@st :unused-packages) typs (@st :unused-types)]
  (when
   (not-empty pkgs)
   (let
    [pkgs-s (string/join ", " pkgs)]
    (throw
     (Exception.
      (str "Packages imported but never used: [" pkgs-s "]")))))
  (when
   (not-empty typs)
   (let
    [typs-s (string/join ", " typs)]
    (throw
     (Exception.
      (str "Types imported but never used: [" typs-s "]")))))))

