;; Compiled from src/funcgo/codegen.go
(ns
 funcgo.codegen
 (:gen-class)
 (:require
  [clojure.string :as s]
  [instaparse.core :as insta]
  [funcgo.symboltable :as symbols]))

(set! *warn-on-reflection* true)

(let
 [k-async-rules #{:chan :goroutine :sendstmt :take}]
 (defn-
  code-generator
  [symbol-table goscript?]
  (do
   (defn- no-dot [^String s] (not (re-find #"\." s)))
   (defn-
    java-class?
    [clazz]
    (try (Class/forName clazz) true (catch Exception e false)))
   (defn-
    has-type
    [^String typ]
    (or
     (or
      (symbols/Has-type symbol-table typ)
      (and goscript? (. typ (startsWith "js."))))
     (and
      (and (not goscript?) (no-dot typ))
      (java-class? (str "java.lang." typ)))))
   (defn- list-str [& item] (str "(" (s/join " " item) ")"))
   (defn- blank-join [& xs] (s/join " " xs))
   (defn- vec-str [& item] (str "[" (s/join " " item) "]"))
   (defn-
    infix
    ([expression] expression)
    ([left operator right] (list-str operator left right)))
   (defn-
    public?
    [identifier]
    (or (re-find #"^[A-Z]" identifier) (= identifier "main")))
   (defn- constant-func [s] (fn [] s))
   (defn-
    split-path
    [^String path]
    (let
     [slash
      (. path (lastIndexOf (long \/)))
      before-slash
      (subs path 0 (+ slash 1))
      after-slash
      (subs path (+ slash 1))]
     [(s/replace before-slash \/ \.)
      (s/replace after-slash #"\.gos?$" "")]))
   (defn-
    decl-block-func
    [typ]
    (fn
     [& xs]
     (let
      [consts (butlast xs) expressions (last xs)]
      (str "(" typ " [" (s/join " " consts) "] " expressions ")"))))
   (defn-
    import-spec
    ([imported] (import-spec (last (s/split imported #"\.")) imported))
    ([identifier imported]
     (if
      (= identifier "_")
      (vec-str imported)
      (do
       (symbols/Package-imported symbol-table identifier)
       (vec-str imported ":as" identifier)))))
   (defn-
    extern-import-spec
    [identifier]
    (do (symbols/Package-imported symbol-table identifier) ""))
   (defn-
    vardecl
    ([identifier expression]
     (if
      (public? identifier)
      (list-str "def" identifier expression)
      (list-str "def" "^:private" identifier expression)))
    ([identifier typ expression]
     (if
      (public? identifier)
      (list-str "def" (str "^" typ) identifier expression)
      (list-str
       "def"
       "^:private"
       (str "^" typ)
       identifier
       expression))))
   (defn-
    def_
    [identifier expression]
    (if
     (public? identifier)
     (list-str "def" identifier expression)
     (list-str "def" "^:private" identifier expression)))
   {:boolcaseclause blank-join,
    :indexed (fn [xs i] (list-str "nth" xs i)),
    :shortvardecl
    (fn
     ([identifier expression] (def_ identifier expression))
     ([ident1 ident2 expr1 expr2]
      (blank-join (def_ ident1 expr1) (def_ ident2 expr2)))
     ([ident1 ident2 ident3 expr1 expr2 expr3]
      (blank-join
       (def_ ident1 expr1)
       (def_ ident2 expr2)
       (def_ ident3 expr3)))),
    :importspec import-spec,
    :finally (fn* [p1__8#] (list-str "finally" p1__8#)),
    :exponent str,
    :returnchar (constant-func "\\return"),
    :chan (fn ([] "(chan)") ([n] (list-str "chan" n))),
    :functioncall list-str,
    :vardecl2
    (fn
     ([identifier1 identifier2 expression1 expression2]
      (blank-join
       (vardecl identifier1 expression1)
       (vardecl identifier2 expression2)))
     ([identifier1 identifier2 typ expression1 expression2]
      (blank-join
       (vardecl identifier1 typ expression1)
       (vardecl identifier2 typ expression2)))),
    :littleuvalue (fn [d1 d2 d3 d4] (str "\\u" d1 d2 d3 d4)),
    :primarrayvardecl
    (fn
     [identifier number primtype]
     (let
      [elements
       (apply blank-join (dotimes [_ (read-string number)] "0"))]
      (list-str
       "def"
       identifier
       (list-str "vector-of" (str ":" primtype) elements)))),
    :methodparameters blank-join,
    :block
    (fn
     ([expr] expr)
     ([expr0 & expr-rest]
      (str "(do " (s/join " " (cons expr0 expr-rest)) ")"))),
    :imported (fn* [& rest__21#] (s/join "." rest__21#)),
    :typeclassesimportspec blank-join,
    :tryexpr
    (fn
     ([expressions catches] (list-str "try" expressions catches))
     ([expressions catches finally]
      (list-str "try" expressions catches finally))),
    :long (constant-func "long"),
    :double (constant-func "double"),
    :arrayvardecl
    (fn
     [identifier number typ]
     (let
      [elements
       (apply blank-join (dotimes [_ (read-string number)] "nil"))]
      (list-str "def" identifier (list-str "vector" elements)))),
    :precedence1 infix,
    :decimals identity,
    :structlit (fn [typ & exprs] (apply list-str (str typ ".") exprs)),
    :bigintlit str,
    :fortimes
    (fn
     [identifier count expressions]
     (str "(dotimes [" identifier " " count "] " expressions ")")),
    :interpretedstringlit
    (fn* [& rest__23#] (str "\"" (apply str rest__23#) "\"")),
    :typename
    (fn
     [& segments]
     (let
      [typ (s/join "." segments)]
      (when
       (not (has-type typ))
       (throw
        (Exception.
         (format
          "type \"%s\" does not appear in type imports %s"
          typ
          (symbols/Types symbol-table)))))
      typ)),
    :letifelseexpr
    (fn
     ([lhs rhs condition exprs]
      (str
       "(let ["
       lhs
       " "
       rhs
       "] "
       (list-str "when" condition exprs)
       ")"))
     ([lhs rhs condition block1 block2]
      (str
       "(let ["
       lhs
       " "
       rhs
       "] "
       (list-str "if" condition block1 block2)
       ")"))),
    :javastatic (fn* [& rest__31#] (s/join "/" rest__31#)),
    :constswitch
    (fn [expr & clauses] (apply list-str "case" expr clauses)),
    :structspec
    (fn
     [java-identifier & fields]
     (do
      (symbols/Type-created symbol-table java-identifier)
      (list-str
       "defrecord"
       java-identifier
       (apply vec-str fields)
       (if
        (empty? fields)
        ""
        (let
         [fs
          (s/split (nth fields 0) #" +")
          fs-only
          (filter (fn [^String s] (not (. s (startsWith "^")))) fs)]
         (str
          "Object (toString [this] "
          (list-str "str" "\"{\"" (s/join " \" \" " fs-only) "\"}\"")
          ")")))))),
    :precedence2 infix,
    :bigfloatlit str,
    :goroutine (fn [routine] (list-str "go" routine)),
    :functionpartn
    (fn
     ([parameters expression] (str "[" parameters "] " expression))
     ([parameters typ expression]
      (str "^" typ " [" parameters "] " expression))),
    :shiftright (constant-func "bit-shift-right"),
    :squotechar (constant-func "\\'"),
    :hexdigit identity,
    :typeconversion list-str,
    :interfacespec
    (fn
     [& args]
     (do
      (symbols/Type-created symbol-table (first args))
      (apply list-str "defprotocol" args))),
    :shiftleft (constant-func "bit-shift-left"),
    :unquote (fn* [p1__29#] (str "~" p1__29#)),
    :new (fn* [p1__9#] (str p1__9# ".")),
    :dropslice (fn [xs i] (list-str "drop" i xs)),
    :vardecl1 vardecl,
    :symbol
    (fn
     ([identifier] identifier)
     ([pkg identifier]
      (do
       (when
        (not (symbols/Has-package symbol-table pkg))
        (throw
         (Exception.
          (format
           "package \"%s\" in %s.%s does not appear in imports %s"
           pkg
           pkg
           identifier
           (symbols/Packages symbol-table)))))
       (str pkg "/" identifier)))),
    :methodimpl
    (fn
     [java-identifier function]
     (list-str java-identifier function)),
    :mod (constant-func "mod"),
    :variadic (fn* [p1__15#] (str "& " p1__15#)),
    :precedence0 infix,
    :or (constant-func "or"),
    :unquotesplicing (fn* [p1__30#] (str "~@" p1__30#)),
    :fields blank-join,
    :typeimportdecl
    (fn
     ([] "")
     ([& import-specs] (apply list-str ":import" import-specs))),
    :dictdestruct
    (fn* [& rest__10#] (str \{ (s/join " " rest__10#) "}")),
    :mulop identity,
    :typedmethodspec
    (fn
     ([java-identifier typ]
      (list-str (str "^" typ) java-identifier "[this]"))
     ([java-identifier methodparams typ]
      (list-str
       (str "^" typ)
       java-identifier
       (str "[this " methodparams "]")))),
    :escapedidentifier identity,
    :isidentifier
    (fn
     [initial identifier]
     (str (s/lower-case initial) identifier "?")),
    :precedence5 infix,
    :dashidentifier (fn* [p1__26#] (str "-" p1__26#)),
    :not (constant-func "not"),
    :floatlit str,
    :decimallit identity,
    :takeslice (fn [xs i] (list-str "take" i xs)),
    :voidmethodspec
    (fn
     ([java-identifier] (list-str java-identifier "[this]"))
     ([java-identifier methodparams]
      (list-str java-identifier (str "[this " methodparams "]")))),
    :externimportspec extern-import-spec,
    :dquotechar (constant-func "\\\""),
    :clojureescape identity,
    :newlinechar (constant-func "\\newline"),
    :string (constant-func "String"),
    :expressionlist blank-join,
    :variadiccall
    (fn [function & params] (apply list-str "apply" function params)),
    :equals (constant-func "="),
    :untypedmethodimpl
    (fn
     ([name block] (list-str name (str "[this]") block))
     ([name params block]
      (list-str name (str "[this " params "]") block))),
    :ifelseexpr
    (fn
     ([condition exprs] (list-str "when" condition exprs))
     ([condition block1 block2]
      (list-str "if" condition block1 block2))),
    :octaldigit identity,
    :percentvaradic (constant-func "%&"),
    :typepackageimportspec (fn* [& rest__7#] (s/join "." rest__7#)),
    :sendstmt (fn [channel expr] (list-str ">!!" channel expr)),
    :catches blank-join,
    :loop (decl-block-func "loop"),
    :addop identity,
    :syntaxquote (fn* [p1__28#] (str "`" p1__28#)),
    :tabchar (constant-func "\\tab"),
    :const
    (fn [identifier expression] (str identifier " " expression)),
    :islabel
    (fn*
     [p1__19#]
     (str ":" (s/replace (s/lower-case p1__19#) #"_" "-") "?")),
    :forcstyle
    (fn
     [ident ident-again count ident-yet-again expressions]
     (do
      (when
       (or (not= ident ident-again) (not= ident ident-yet-again))
       (throw
        (Exception.
         "cannot mix different identifiers in c-style for loop")))
      (str "(dotimes [" ident " " count "] " expressions ")"))),
    :functiondecl
    (fn
     [identifier function]
     (let
      [defn (if (public? identifier) "defn" "defn-")]
      (list-str defn identifier function))),
    :dictdestructelem (fn [destruct label] (str destruct " " label)),
    :typeimportspec
    (fn
     [typepackage & typeclasses]
     (do
      (doseq
       [typeclass typeclasses]
       (symbols/Type-imported symbol-table typeclass))
      (apply list-str typepackage typeclasses))),
    :javafield
    (fn [expression identifier] (list-str "." expression identifier)),
    :javamethodcall
    (fn
     ([expression identifier]
      (str "(. " expression " (" identifier "))"))
     ([expression identifier call]
      (str "(. " expression " (" identifier " " call "))"))),
    :macroimportdecl
    (fn
     ([] "")
     ([& import-specs]
      (apply list-str ":require-macros" import-specs))),
    :dictlit (fn* [& rest__16#] (apply str rest__16#)),
    :importdecls blank-join,
    :underscorejavaidentifier (fn* [p1__32#] (str "-" p1__32#)),
    :funclikedecl
    (fn
     [funclike identifier function]
     (list-str funclike identifier function)),
    :label
    (fn*
     [p1__18#]
     (str ":" (s/replace (s/lower-case p1__18#) #"_" "-"))),
    :typedmethodimpl
    (fn
     ([name typ block]
      (list-str (str "^" typ) name (str "[this]") block))
     ([name params typ block]
      (list-str (str "^" typ) name (str "[this " params "]") block))),
    :catch
    (fn
     [typ exception expressions]
     (list-str "catch" typ exception expressions)),
    :vecdestruct vec-str,
    :expressions blank-join,
    :noteq (constant-func "not="),
    :deref (fn* [p1__27#] (str "@" p1__27#)),
    :assoc (fn [symbol & items] (apply list-str "assoc" symbol items)),
    :binaryop identity,
    :constswitchcase (fn ([] "") ([cond] cond)),
    :precedence3 infix,
    :octalbytevalue (fn [d1 d2 d3] (str "\\o" d1 d2 d3)),
    :len (fn [call] (list-str "count" call)),
    :backslashchar (constant-func "\\\\"),
    :identifier
    (fn
     [string]
     (s/replace
      string
      #"\p{Ll}\p{Lu}"
      (fn*
       [p1__20#]
       (str (first p1__20#) "-" (s/lower-case (last p1__20#)))))),
    :and (constant-func "and"),
    :letconstswitch
    (fn
     [lhs rhs expr & clauses]
     (str
      "(let ["
      lhs
      " "
      rhs
      "] "
      (apply list-str "case" expr clauses)
      ")")),
    :methodparam
    (fn ([symbol] symbol) ([symbol typ] (str "^" typ " " symbol))),
    :spacechar (constant-func "\\space"),
    :constcaseclause blank-join,
    :setlit (fn* [& rest__17#] (str "#{" (s/join " " rest__17#) "}")),
    :unaryexpr
    (fn [operator expression] (list-str operator expression)),
    :backspacechar (constant-func "\\backspace"),
    :functionpart0
    (fn
     ([expression] (str "[] " expression))
     ([typ expression] (str "^" typ " [] " expression))),
    :implements
    (fn
     [protocol concrete & methodimpls]
     (do
      (symbols/Type-created symbol-table concrete)
      (apply
       list-str
       (concat (list "extend-type" concrete protocol) methodimpls)))),
    :associnpath vec-str,
    :vfunctionpart0
    (fn
     ([variadic expression] (str "[" variadic "] " expression))
     ([variadic typ expression]
      (str "^" typ " [" variadic "] " expression))),
    :bitxor (constant-func "bit-xor"),
    :functionparts
    (fn* [& rest__14#] (str "(" (s/join ") (" rest__14#) ")")),
    :shortfunctionlit
    (fn
     [expr]
     (if
      (and (= (first expr) \() (= (last expr) \)))
      (str "#" expr)
      (list-str "fn" "[]" expr))),
    :regex
    (fn*
     [& rest__22#]
     (str "#\"" (s/escape (apply str rest__22#) {\" "\\\""}) "\"")),
    :precedence4 infix,
    :percent (constant-func "%"),
    :typeswitch
    (fn
     [x & args]
     (do
      (defn-
       recursing
       [acc remaining]
       (do
        (defn-
         type-case
         []
         (let
          [typ (first remaining) expr (second remaining)]
          (str acc " " (list-str "instance?" typ x) " " expr)))
        (case
         (count remaining)
         1
         (let [[expr] remaining] (str acc " :else " expr ")"))
         2
         (str (type-case) ")")
         (recur (type-case) (drop 2 remaining)))))
      (recursing "(cond" args))),
    :unicodechar (fn* [p1__24#] (str "\\" p1__24#)),
    :boolswitchcase (fn ([] ":else") ([cond] cond)),
    :dissoc
    (fn [symbol & items] (apply list-str "dissoc" symbol items)),
    :percentnum (fn* [p1__13#] (str "%" p1__13#)),
    :constantlist (fn ([c] c) ([c0 & c] (apply list-str c0 c))),
    :bitnot (constant-func "bit-not"),
    :typedidentifier
    (fn [identifier typ] (str "^" typ " " identifier)),
    :forlazy
    (fn
     ([identifier seq expressions]
      (str "(for [" identifier " " seq "] " expressions ")"))
     ([identifier seq condition expressions]
      (str
       "(for ["
       identifier
       " "
       seq
       " :when "
       condition
       "] "
       expressions
       ")"))),
    :variadicdestruct (fn* [p1__11#] (str "& " p1__11#)),
    :mutidentifier
    (fn
     [initial identifier]
     (str (s/lower-case initial) identifier "!")),
    :forrange
    (fn
     [identifier seq expressions]
     (str "(doseq [" identifier " " seq "] " expressions ")")),
    :consts blank-join,
    :parameters blank-join,
    :rawstringlit
    (fn*
     [p1__25#]
     (str "\"" (s/escape p1__25# char-escape-string) "\"")),
    :withconst (decl-block-func "let"),
    :take (constant-func "<!!"),
    :relop identity,
    :topwithconst (decl-block-func "let"),
    :associtem blank-join,
    :dictelement (fn [key value] (str key " " value " ")),
    :associn
    (fn [symbol path value] (list-str "assoc-in" symbol path value)),
    :boolswitch (fn [& clauses] (apply list-str "cond" clauses)),
    :typedidentifiers
    (fn
     [& args]
     (let
      [typ
       (last args)
       identifiers
       (butlast args)
       decls
       (for [identifier identifiers] (str "^" typ " " identifier))]
      (apply blank-join decls))),
    :veclit vec-str,
    :escapedslash (constant-func "/"),
    :vfunctionpartn
    (fn
     ([parameters variadic expression]
      (str "[" parameters " " variadic "] " expression))
     ([parameters variadic typ expression]
      (str "^" typ " [" parameters " " variadic "] " expression))),
    :nonpkgfile identity,
    :functionlit (fn* [p1__12#] (list-str "fn" p1__12#)),
    :sourcefile blank-join}))
 (defn-
  packageclause-func
  [symbol-table ^String path goscript? sync?]
  (let
   [[parent name]
    (split-path path)
    sync-import
    (if
     sync?
     []
     (do
      (print " (uses async channels) ")
      [(list-str
        ":require"
        "[clojure.core.async :as async :refer [chan go <!! >!!]]")]))]
   (when goscript? (symbols/Package-created symbol-table "js"))
   (fn
    [imported import-decls]
    (let
     [full-imported (str parent imported)]
     (when
      (not= imported name)
      (throw
       (Exception.
        (str
         "Got package \""
         imported
         "\" instead of expected \""
         name
         "\" in \""
         path
         "\""))))
     (if
      goscript?
      (apply list-str "ns" full-imported import-decls sync-import)
      (str
       (apply
        list-str
        "ns"
        full-imported
        "(:gen-class)"
        import-decls
        sync-import)
       " (set! *warn-on-reflection* true)"))))))
 (defn-
  import-decl-func
  []
  (fn
   ([] "")
   ([& import-specs] (apply list-str ":require" import-specs))))
 (defn-
  uses-async
  [parsed]
  (do
   (defn-
    walk
    [vector]
    (if
     (empty? vector)
     false
     (let
      [f (first vector)]
      (if
       (and (vector? f) (uses-async f))
       true
       (recur (rest vector))))))
   (if
    (contains? k-async-rules (first parsed))
    true
    (walk (rest parsed)))))
 (defn
  Generate
  [^String path parsed sync?]
  (let
   [symbol-table
    (symbols/New)
    goscript?
    (. path (endsWith ".gos"))
    code-gen
    (assoc
     (code-generator symbol-table goscript?)
     :packageclause
     (packageclause-func
      symbol-table
      path
      goscript?
      (not (uses-async parsed)))
     :importdecl
     (import-decl-func))
    clj
    (insta/transform code-gen parsed)]
   (symbols/Check-all-used symbol-table)
   clj)))

