;; Compiled from src/funcgo/core.go
(ns
 funcgo.core
 (:gen-class)
 (:require
  [instaparse.core :as insta]
  [clojure.pprint :as pprint]
  [instaparse.failure :as failure]
  [clojure.string :as string]
  [funcgo.parser :as parser]
  [funcgo.codegen :as codegen]))

(set! *warn-on-reflection* true)

(defn
 Parse
 ([path fgo] (Parse path fgo :sourcefile))
 ([path fgo start-rule] (Parse path fgo start-rule false false))
 ([path fgo start-rule nodes? sync?]
  (let
   [parsed
    (parser/Parse
     (string/replace fgo #"\t" "        ")
     :start
     start-rule)]
   (if
    (insta/failure? parsed)
    (throw
     (Exception. (str (with-out-str (failure/pprint-failure parsed)))))
    (do
     (when nodes? (pprint/pprint parsed))
     (codegen/Generate path parsed sync?))))))

