;; Compiled from src/funcgo/core.go
(ns
 funcgo.core
 (:gen-class)
 (:require
  [instaparse.core :as insta]
  [clojure.pprint :as pprint]
  [instaparse.failure :as failure]
  [clojure.string :as string]
  [funcgo.parser :as parser]
  [funcgo.codegen :as codegen])
 (:import (java.io IOException)))

(set! *warn-on-reflection* true)

(defn- untabify [s] (string/replace s #"\t" "        "))

(defn
 Ambiguity
 [fgo]
 (let
  [preprocessed (untabify fgo)]
  (insta/parses parser/Parse preprocessed)))

(defn-
 parse
 [preprocessed start-rule ambiguity?]
 (if
  ambiguity?
  (let
   [parsed-list
    (insta/parses parser/Parse preprocessed :start start-rule)
    ambiguity
    (count parsed-list)]
   (case
    ambiguity
    0
    (do
     (spit "__preprocessed.go" preprocessed)
     (throw
      (IOException.
       "Parsing failure.  Turn off ambiguity flag to see details.")))
    1
    (nth parsed-list 0)
    (do (print " WARNING, ambiguity=" ambiguity) (nth parsed-list 0))))
  (let
   [parsed (parser/Parse preprocessed :start start-rule)]
   (if
    (insta/failure? parsed)
    (do
     (spit "__preprocessed.go" preprocessed)
     (throw
      (IOException.
       (str (with-out-str (failure/pprint-failure parsed))))))
    parsed))))

(defn
 Parse
 ([path fgo] (Parse path fgo :sourcefile))
 ([path fgo start-rule] (Parse path fgo start-rule false false false))
 ([path fgo start-rule nodes? sync? ambiguity?]
  (let
   [preprocessed
    (untabify fgo)
    parsed
    (parse preprocessed start-rule ambiguity?)]
   (when nodes? (pprint/pprint parsed))
   (codegen/Generate path parsed sync?))))

