;; Compiled from src/funcgo/symboltable.go
(ns
 funcgo.symboltable
 (:gen-class)
 (:require [clojure.string :as string])
 (:import (java.io IOException)))

(set! *warn-on-reflection* true)

(defn
 New
 []
 (ref
  {"long" :type,
   "double" :type,
   "boolean" :type,
   :unused-packages #{},
   :unused-types #{}}))

(defn
 Package-imported
 [st pkg]
 (dosync
  (alter
   st
   (fn*
    [p1__1#]
    (assoc
     p1__1#
     pkg
     :package
     :unused-packages
     (conj (@st :unused-packages) pkg))))))

(defn
 Package-created
 [st pkg]
 (dosync (alter st (fn* [p1__2#] (assoc p1__2# pkg :package)))))

(defn
 Type-imported
 [st typ]
 (dosync
  (alter
   st
   (fn*
    [p1__3#]
    (assoc
     p1__3#
     typ
     :type
     :unused-types
     (conj (@st :unused-types) typ))))))

(defn
 Type-created
 [st typ]
 (dosync (alter st (fn* [p1__4#] (assoc p1__4# typ :type)))))

(defn
 Has-package
 [st pkg]
 (do
  (dosync
   (alter
    st
    (fn*
     [p1__5#]
     (assoc
      p1__5#
      :unused-packages
      (disj (@st :unused-packages) pkg)))))
  (= (@st pkg) :package)))

(defn
 Has-type
 [st typ]
 (do
  (dosync
   (alter
    st
    (fn*
     [p1__6#]
     (assoc p1__6# :unused-types (disj (@st :unused-types) typ)))))
  (= (@st typ) :type)))

(defn
 Packages
 [st]
 (let
  [packages (for [[symbol key] @st :when (= key :package)] symbol)]
  (str "[" (string/join ", " packages) "]")))

(defn
 Types
 [st]
 (let
  [packages (for [[symbol key] @st :when (= key :type)] symbol)]
  (str "[" (string/join ", " packages) "]")))

(defn
 Check-all-used
 [st]
 (let
  [pkgs (@st :unused-packages) typs (@st :unused-types)]
  (when
   (not-empty pkgs)
   (let
    [pkgs-s (string/join ", " pkgs)]
    (throw
     (IOException.
      (str "Packages imported but never used: [" pkgs-s "]")))))
  (when
   (not-empty typs)
   (let
    [typs-s (string/join ", " typs)]
    (throw
     (IOException.
      (str "Types imported but never used: [" typs-s "]")))))))

