;; Compiled from src/leiningen/fgoc.go
(ns
 leiningen.fgoc
 (:gen-class)
 (:require [clojure.java.io :as io] [leiningen.core.eval :as eval]))

(set! *warn-on-reflection* true)

(defn-
 dirs
 [project]
 (let
  [roots
   (for
    [[k v] project :when (or (= k :source-paths) (= k :test-paths))]
    (if (vector? v) (nth v 0) v))
   child-roots
   (for [[_ v] project :when (map? v)] (dirs v))]
  (concat roots child-roots)))

(defn-
 fgoc
 [project & args]
 (let
  [opts
   (filter (fn* [p1__1#] (= (first p1__1#) \-)) args)
   non-opts
   (filter (fn* [p1__2#] (not= (first p1__2#) \-)) args)
   roots
   (concat
    opts
    (if
     (seq non-opts)
     non-opts
     (set
      (map
       (fn [path] (. (io/file path) (getAbsolutePath)))
       (flatten (dirs project))))))]
  (eval/eval-in-project
   project
   (clojure.core/seq
    (clojure.core/concat (clojure.core/list 'main/Compile) roots))
   '(require '[funcgo.main :as main]))))

