/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.program;

import java.util.Hashtable;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.internal.carbon.CFRange;
import org.eclipse.swt.internal.carbon.LSApplicationParameters;
import org.eclipse.swt.internal.carbon.OS;
import org.eclipse.swt.internal.cocoa.Cocoa;

public final class Program {
    String name;
    byte[] fsRef;
    static final String PREFIX_HTTP = "http://";
    static final String PREFIX_HTTPS = "https://";

    Program() {
    }

    public static Program findProgram(String string) {
        char[] cArray;
        if (string == null) {
            SWT.error(4);
        }
        if (string.length() == 0) {
            return null;
        }
        if (string.charAt(0) != '.') {
            cArray = new char[string.length()];
            string.getChars(0, cArray.length, cArray, 0);
        } else {
            cArray = new char[string.length() - 1];
            string.getChars(1, string.length(), cArray, 0);
        }
        int n = OS.CFStringCreateWithCharacters(0, cArray, cArray.length);
        Program program = null;
        if (n != 0) {
            byte[] byArray = new byte[80];
            if (OS.LSGetApplicationForInfo(0, 0, n, -1, byArray, null) == 0) {
                program = Program.getProgram(byArray);
            }
            OS.CFRelease(n);
        }
        return program;
    }

    public static String[] getExtensions() {
        return new String[]{".txt", ".rtf", ".html", ".htm", ".xml", ".c", ".m", ".cp", ".cpp", ".c++", ".cc", ".cxx", ".mm", ".h", ".hpp", ".h++", ".hxx", ".java", ".jav", ".s", ".r", ".defs", ".mig", ".exp", ".js", ".jscript", ".javascript", ".sh", ".command", ".csh", ".pl", ".pm", ".py", ".rb", ".rbw", ".php", ".php3", ".php4", ".ph3", ".ph4", ".phtml", ".jnlp", ".applescript", ".scpt", ".o", ".exe", ".dll", ".class", ".jar", ".qtz", ".gtar", ".tar", ".gz", ".gzip", ".tgz", ".hqx", ".bin", ".vcf", ".vcard", ".jpg", ".jpeg", ".jp2", ".tif", ".tiff", ".pic", ".pct", ".pict", ".pntg", ".png", ".xbm", ".qif", ".qtif", ".icns", ".mov", ".qt", ".avi", ".vfw", ".mpg", ".mpeg", ".m75", ".m15", ".mp4", ".3gp", ".3gpp", ".3g2", ".3gp2", ".mp3", ".m4a", ".m4p", ".m4b", ".au", ".ulw", ".snd", ".aifc", ".aiff", ".aif", ".caf", ".bundle", ".app", ".plugin", ".mdimporter", ".wdgt", ".cpio", ".zip", ".framework", ".rtfd", ".dfont", ".otf", ".ttf", ".ttc", ".suit", ".pfb", ".pfa", ".icc", ".icm", ".pf", ".pdf", ".ps", ".eps", ".psd", ".ai", ".gif", ".bmp", ".ico", ".doc", ".xls", ".ppt", ".wav", ".wave", ".asf", ".wm", ".wmv", ".wmp", ".wma", ".asx", ".wmx", ".wvx", ".wax", ".key", ".kth", ".tga", ".sgi", ".exr", ".fpx", ".jfx", ".efx", ".sd2", ".rm", ".ram", ".ra", ".smil", ".sit", ".sitx", ".plist", ".nib", ".lproj", ".iPhoto", ".iChat", ".chat", ".rmf", ".xfdf", ".fdf", ".game", ".pgn", ".ics", ".vcs", ".aplmodel", ".icbu", ".icalevent", ".icaltodo", ".mailhold", ".mbox", ".imapmbox", ".emlx", ".mailextract", ".sherlock", ".tpl", ".prefPane", ".sliderSaver", ".saver", ".log", ".gcx"};
    }

    public static Program[] getPrograms() {
        Object object;
        Program[] programArray;
        Hashtable<String, Program> hashtable = new Hashtable<String, Program>();
        String[] stringArray = Program.getExtensions();
        byte[] byArray = new byte[80];
        int n = 0;
        while (n < stringArray.length) {
            programArray = stringArray[n];
            object = new char[programArray.length() - 1];
            programArray.getChars(1, programArray.length(), (char[])object, 0);
            int n2 = OS.CFStringCreateWithCharacters(0, (char[])object, ((Object)object).length);
            if (n2 != 0) {
                int n3;
                Program program;
                if (OS.LSGetApplicationForInfo(0, 0, n2, -1, byArray, null) == 0 && (program = Program.getProgram(byArray)) != null && hashtable.get(program.getName()) == null) {
                    hashtable.put(program.getName(), program);
                    byArray = new byte[80];
                }
                if (OS.VERSION >= 4160 && (n3 = OS.UTTypeCreateAllIdentifiersForTag(OS.kUTTagClassFilenameExtension(), n2, 0)) != 0) {
                    int n4 = OS.CFArrayGetCount(n3);
                    int n5 = 0;
                    while (n5 < n4) {
                        int n6;
                        int n7 = OS.CFArrayGetValueAtIndex(n3, n5);
                        if (n7 != 0 && (n6 = OS.LSCopyAllRoleHandlersForContentType(n7, -1)) != 0) {
                            int n8 = OS.CFArrayGetCount(n6);
                            int n9 = 0;
                            while (n9 < n8) {
                                Program program2;
                                int n10 = OS.CFArrayGetValueAtIndex(n6, n9);
                                if (n10 != 0 && OS.LSFindApplicationForInfo(0, n10, 0, byArray, null) == 0 && (program2 = Program.getProgram(byArray)) != null && hashtable.get(program2.getName()) == null) {
                                    hashtable.put(program2.getName(), program2);
                                    byArray = new byte[80];
                                }
                                ++n9;
                            }
                            OS.CFRelease(n6);
                        }
                        ++n5;
                    }
                    OS.CFRelease(n3);
                }
                OS.CFRelease(n2);
            }
            ++n;
        }
        n = 0;
        programArray = new Program[hashtable.size()];
        object = hashtable.elements();
        while (object.hasMoreElements()) {
            programArray[n++] = (Program)object.nextElement();
        }
        return programArray;
    }

    static int getURL(String string) {
        int n;
        int n2;
        char[] cArray = new char[string.length()];
        string.getChars(0, cArray.length, cArray, 0);
        int n3 = OS.CFStringCreateWithCharacters(0, cArray, cArray.length);
        if (n3 == 0) {
            return 0;
        }
        int n4 = n3;
        int n5 = Cocoa.objc_msgSend(Cocoa.C_NSFileManager, Cocoa.S_defaultManager);
        if (n5 != 0 && Cocoa.objc_msgSend(n5, Cocoa.S_fileExistsAtPath, n3) != 0 && (n2 = Cocoa.objc_msgSend(Cocoa.C_NSURL, Cocoa.S_fileURLWithPath, n3)) != 0 && (n = Cocoa.objc_msgSend(n2, Cocoa.S_absoluteString)) != 0) {
            n4 = n;
        }
        char[] cArray2 = new char[]{'%'};
        String string2 = string.toLowerCase();
        if (string2.startsWith(PREFIX_HTTP) || string2.startsWith(PREFIX_HTTPS)) {
            cArray2 = new char[]{'%', '#'};
        }
        int n6 = OS.CFStringCreateWithCharacters(0, cArray2, cArray2.length);
        int n7 = OS.CFURLCreateStringByAddingPercentEscapes(0, n4, n6, 0, 0x8000100);
        int n8 = 0;
        if (n7 != 0) {
            n8 = OS.CFURLCreateWithString(0, n7, 0);
            OS.CFRelease(n7);
        }
        if (n6 != 0) {
            OS.CFRelease(n6);
        }
        OS.CFRelease(n3);
        return n8;
    }

    public static boolean launch(String string) {
        if (string == null) {
            SWT.error(4);
        }
        int n = -1;
        int n2 = Program.getURL(string);
        if (n2 != 0) {
            n = OS.LSOpenCFURLRef(n2, null);
            OS.CFRelease(n2);
        }
        return n == 0;
    }

    public boolean execute(String string) {
        if (string == null) {
            SWT.error(4);
        }
        if (OS.VERSION < 4160) {
            return Program.launch(string);
        }
        int n = -1;
        int n2 = OS.NewPtr(this.fsRef.length);
        if (n2 != 0) {
            OS.memmove(n2, this.fsRef, this.fsRef.length);
            LSApplicationParameters lSApplicationParameters = new LSApplicationParameters();
            lSApplicationParameters.version = 0;
            lSApplicationParameters.flags = 0;
            lSApplicationParameters.application = n2;
            if (string.length() == 0) {
                n = OS.LSOpenApplication(lSApplicationParameters, null);
            } else {
                int n3 = Program.getURL(string);
                if (n3 != 0) {
                    int n4 = OS.CFArrayCreateMutable(0, 1, 0);
                    if (n4 != 0) {
                        OS.CFArrayAppendValue(n4, n3);
                        n = OS.LSOpenURLsWithRole(n4, -1, 0, lSApplicationParameters, null, 0);
                        OS.CFRelease(n4);
                    }
                    OS.CFRelease(n3);
                }
            }
            OS.DisposePtr(n2);
        }
        return n == 0;
    }

    ImageData createImageFromFamily(int n, int n2, int n3, int n4, int n5) {
        int n6 = OS.NewHandle(0);
        int n7 = OS.GetIconFamilyData(n, n2, n6);
        if (n7 != 0) {
            OS.DisposeHandle(n6);
            return null;
        }
        int n8 = OS.NewHandle(0);
        n7 = OS.GetIconFamilyData(n, n3, n8);
        if (n7 != 0) {
            OS.DisposeHandle(n8);
            OS.DisposeHandle(n6);
            return null;
        }
        int n9 = OS.GetHandleSize(n6);
        OS.HLock(n6);
        OS.HLock(n8);
        int[] nArray = new int[1];
        int[] nArray2 = new int[1];
        OS.memmove(nArray, n6, 4);
        OS.memmove(nArray2, n8, 4);
        byte[] byArray = new byte[n9];
        OS.memmove(byArray, nArray[0], n9);
        byte[] byArray2 = new byte[n4 * n5];
        OS.memmove(byArray2, nArray2[0], byArray2.length);
        OS.HUnlock(n8);
        OS.HUnlock(n6);
        OS.DisposeHandle(n8);
        OS.DisposeHandle(n6);
        ImageData imageData = new ImageData(n4, n5, 32, new PaletteData(0xFF0000, 65280, 255), 4, byArray);
        imageData.alphaData = byArray2;
        return imageData;
    }

    public ImageData getImageData() {
        int[] nArray = new int[1];
        OS.GetIconRefFromFileInfo(this.fsRef, 0, null, 0, 0, 0, nArray, null);
        int[] nArray2 = new int[1];
        int n = OS.IconRefToIconFamily(nArray[0], -1, nArray2);
        OS.ReleaseIconRef(nArray[0]);
        if (n != 0) {
            return null;
        }
        ImageData imageData = this.createImageFromFamily(nArray2[0], 1769157426, 1933077867, 16, 16);
        OS.DisposeHandle(nArray2[0]);
        if (imageData == null) {
            RGB[] rGBArray = new RGB[]{new RGB(255, 255, 255), new RGB(95, 95, 95), new RGB(128, 128, 128), new RGB(192, 192, 192), new RGB(223, 223, 191), new RGB(255, 223, 159), new RGB(0, 0, 0)};
            imageData = new ImageData(16, 16, 4, new PaletteData(rGBArray));
            imageData.transparentPixel = 6;
            String[] stringArray = new String[]{"CCCCCCCCGGG", "CFAAAAACBGG", "CAAAAAACFBG", "CAAAAAACBBB", "CAAAAAAAAEB", "CAAAAAAAAEB", "CAAAAAAAAEB", "CAAAAAAAAEB", "CAAAAAAAAEB", "CAAAAAAAAEB", "CAAAAAAAAEB", "CAAAAAAAAEB", "CDDDDDDDDDB", "CBBBBBBBBBB"};
            int n2 = 0;
            while (n2 < stringArray.length) {
                int n3 = 0;
                while (n3 < 11) {
                    imageData.setPixel(n3 + 3, n2 + 1, stringArray[n2].charAt(n3) - 65);
                    ++n3;
                }
                ++n2;
            }
        }
        return imageData;
    }

    public String getName() {
        return this.name;
    }

    static Program getProgram(byte[] byArray) {
        String string = "";
        int[] nArray = new int[1];
        OS.LSCopyDisplayNameForRef(byArray, nArray);
        if (nArray[0] != 0) {
            int n = OS.CFStringGetLength(nArray[0]);
            if (n != 0) {
                char[] cArray = new char[n];
                CFRange cFRange = new CFRange();
                cFRange.length = n;
                OS.CFStringGetCharacters(nArray[0], cFRange, cArray);
                string = new String(cArray);
            }
            OS.CFRelease(nArray[0]);
        }
        Program program = new Program();
        program.fsRef = byArray;
        program.name = string;
        return program;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof Program) {
            Program program = (Program)object;
            return this.name.equals(program.name);
        }
        return false;
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public String toString() {
        return "Program {" + this.name + "}";
    }
}

