/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.printing;

import org.eclipse.swt.SWT;
import org.eclipse.swt.internal.C;
import org.eclipse.swt.internal.Callback;
import org.eclipse.swt.internal.cocoa.NSApplication;
import org.eclipse.swt.internal.cocoa.NSData;
import org.eclipse.swt.internal.cocoa.NSKeyedArchiver;
import org.eclipse.swt.internal.cocoa.NSMutableDictionary;
import org.eclipse.swt.internal.cocoa.NSNumber;
import org.eclipse.swt.internal.cocoa.NSObject;
import org.eclipse.swt.internal.cocoa.NSPrintInfo;
import org.eclipse.swt.internal.cocoa.NSPrintPanel;
import org.eclipse.swt.internal.cocoa.NSPrinter;
import org.eclipse.swt.internal.cocoa.NSString;
import org.eclipse.swt.internal.cocoa.OS;
import org.eclipse.swt.internal.cocoa.SWTPrintPanelDelegate;
import org.eclipse.swt.printing.PrinterData;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Shell;

public class PrintDialog
extends Dialog {
    PrinterData printerData = new PrinterData();
    int returnCode;
    static Callback dialogCallback5;
    static final byte[] SWT_OBJECT;
    static /* synthetic */ Class class$0;

    static {
        byte[] byArray = new byte[11];
        byArray[0] = 83;
        byArray[1] = 87;
        byArray[2] = 84;
        byArray[3] = 95;
        byArray[4] = 79;
        byArray[5] = 66;
        byArray[6] = 74;
        byArray[7] = 69;
        byArray[8] = 67;
        byArray[9] = 84;
        SWT_OBJECT = byArray;
    }

    public PrintDialog(Shell shell) {
        this(shell, 32768);
    }

    public PrintDialog(Shell shell, int n) {
        super(shell, PrintDialog.checkStyle(shell, n));
        this.checkSubclass();
    }

    static int checkStyle(Shell shell, int n) {
        int n2 = 229376;
        if ((n & 0x10000000) != 0) {
            if (PrintDialog.getSheetEnabled()) {
                if (shell == null) {
                    n &= 0xEFFFFFFF;
                }
            } else {
                n &= 0xEFFFFFFF;
            }
            if ((n & n2) == 0) {
                n |= shell == null ? 65536 : 32768;
            }
        }
        return n;
    }

    public void setPrinterData(PrinterData printerData) {
        this.printerData = printerData;
    }

    public PrinterData getPrinterData() {
        return this.printerData;
    }

    public PrinterData open() {
        int n;
        Object object;
        NSObject nSObject;
        PrinterData printerData = null;
        NSPrintPanel nSPrintPanel = NSPrintPanel.printPanel();
        NSPrintInfo nSPrintInfo = new NSPrintInfo(NSPrintInfo.sharedPrintInfo().copy());
        nSPrintInfo.setOrientation(this.printerData.orientation == 2 ? 1 : 0);
        NSMutableDictionary nSMutableDictionary = nSPrintInfo.dictionary();
        nSMutableDictionary.setValue(NSNumber.numberWithBool(this.printerData.collate), OS.NSPrintMustCollate);
        nSMutableDictionary.setValue(NSNumber.numberWithInt(this.printerData.copyCount), OS.NSPrintCopies);
        if (this.printerData.printToFile) {
            nSMutableDictionary.setValue(OS.NSPrintSaveJob, OS.NSPrintJobDisposition);
        }
        if (this.printerData.fileName != null && this.printerData.fileName.length() > 0) {
            nSMutableDictionary.setValue(NSString.stringWith(this.printerData.fileName), OS.NSPrintSavePath);
        }
        nSMutableDictionary.setValue(NSNumber.numberWithBool(this.printerData.scope == 0), OS.NSPrintAllPages);
        if (this.printerData.scope == 1) {
            nSMutableDictionary.setValue(NSNumber.numberWithInt(this.printerData.startPage), OS.NSPrintFirstPage);
            nSMutableDictionary.setValue(NSNumber.numberWithInt(this.printerData.endPage), OS.NSPrintLastPage);
        }
        nSPrintPanel.setOptions(0x100 | nSPrintPanel.options());
        if ((this.getStyle() & 0x10000000) != 0) {
            this.initClasses();
            nSObject = (SWTPrintPanelDelegate)new SWTPrintPanelDelegate().alloc().init();
            int n2 = OS.NewGlobalRef(this);
            if (n2 == 0) {
                SWT.error(2);
            }
            OS.object_setInstanceVariable(((SWTPrintPanelDelegate)nSObject).id, SWT_OBJECT, n2);
            this.returnCode = -1;
            object = this.getParent();
            nSPrintPanel.beginSheetWithPrintInfo(nSPrintInfo, ((Shell)object).view.window(), nSObject, OS.sel_panelDidEnd_returnCode_contextInfo_, 0);
            NSApplication nSApplication = NSApplication.sharedApplication();
            while (this.returnCode == -1) {
                nSApplication.run();
            }
            if (nSObject != null) {
                nSObject.release();
            }
            if (n2 != 0) {
                OS.DeleteGlobalRef(n2);
            }
            n = this.returnCode;
        } else {
            n = nSPrintPanel.runModalWithPrintInfo(nSPrintInfo);
        }
        if (n != 0) {
            nSObject = nSPrintInfo.printer();
            NSString nSString = ((NSPrinter)nSObject).name();
            printerData = new PrinterData("Mac", nSString.getString());
            printerData.printToFile = nSPrintInfo.jobDisposition().isEqual(OS.NSPrintSaveJob);
            if (printerData.printToFile) {
                object = new NSString(nSMutableDictionary.objectForKey(OS.NSPrintSavePath));
                printerData.fileName = ((NSString)object).getString();
            }
            int n3 = printerData.scope = new NSNumber(nSMutableDictionary.objectForKey(OS.NSPrintAllPages)).intValue() != 0 ? 0 : 1;
            if (printerData.scope == 1) {
                printerData.startPage = new NSNumber(nSMutableDictionary.objectForKey(OS.NSPrintFirstPage)).intValue();
                printerData.endPage = new NSNumber(nSMutableDictionary.objectForKey(OS.NSPrintLastPage)).intValue();
            }
            printerData.collate = new NSNumber(nSMutableDictionary.objectForKey(OS.NSPrintMustCollate)).intValue() != 0;
            printerData.collate = false;
            printerData.copyCount = new NSNumber(nSMutableDictionary.objectForKey(OS.NSPrintCopies)).intValue();
            printerData.copyCount = 1;
            printerData.orientation = nSPrintInfo.orientation() == 1 ? 2 : 1;
            object = NSKeyedArchiver.archivedDataWithRootObject(nSPrintInfo);
            printerData.otherData = new byte[((NSData)object).length()];
            OS.memmove(printerData.otherData, ((NSData)object).bytes(), printerData.otherData.length);
            this.printerData = printerData;
        }
        nSPrintInfo.release();
        return printerData;
    }

    public int getScope() {
        return this.printerData.scope;
    }

    static boolean getSheetEnabled() {
        return !"false".equals(System.getProperty("org.eclipse.swt.sheet"));
    }

    static int dialogProc(int n, int n2, int n3, int n4, int n5) {
        int[] nArray = new int[1];
        OS.object_getInstanceVariable(n, SWT_OBJECT, nArray);
        if (nArray[0] == 0) {
            return 0;
        }
        if (n2 == OS.sel_panelDidEnd_returnCode_contextInfo_) {
            PrintDialog printDialog = (PrintDialog)OS.JNIGetObject(nArray[0]);
            if (printDialog == null) {
                return 0;
            }
            printDialog.panelDidEnd_returnCode_contextInfo(n, n2, n3, n4, n5);
        }
        return 0;
    }

    void initClasses() {
        String string = "SWTPrintPanelDelegate";
        if (OS.objc_lookUpClass(string) != 0) {
            return;
        }
        dialogCallback5 = new Callback(this.getClass(), "dialogProc", 5);
        int n = dialogCallback5.getAddress();
        if (n == 0) {
            SWT.error(3);
        }
        byte[] byArray = new byte[2];
        byArray[0] = 42;
        byte[] byArray2 = byArray;
        int n2 = C.PTR_SIZEOF;
        int n3 = C.PTR_SIZEOF == 4 ? 2 : 3;
        int n4 = OS.objc_allocateClassPair(OS.class_NSObject, string, 0);
        OS.class_addIvar(n4, SWT_OBJECT, n2, (byte)n3, byArray2);
        OS.class_addMethod(n4, OS.sel_panelDidEnd_returnCode_contextInfo_, n, "@:@i@");
        OS.objc_registerClassPair(n4);
    }

    void panelDidEnd_returnCode_contextInfo(int n, int n2, int n3, int n4, int n5) {
        this.returnCode = n4;
        NSApplication nSApplication = NSApplication.sharedApplication();
        nSApplication.stop(null);
    }

    public void setScope(int n) {
        this.printerData.scope = n;
    }

    public int getStartPage() {
        return this.printerData.startPage;
    }

    public void setStartPage(int n) {
        this.printerData.startPage = n;
    }

    public int getEndPage() {
        return this.printerData.endPage;
    }

    public void setEndPage(int n) {
        this.printerData.endPage = n;
    }

    public boolean getPrintToFile() {
        return this.printerData.printToFile;
    }

    public void setPrintToFile(boolean bl) {
        this.printerData.printToFile = bl;
    }

    protected void checkSubclass() {
        String string;
        String string2 = this.getClass().getName();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.swt.printing.PrintDialog");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (!(string = clazz.getName()).equals(string2)) {
            SWT.error(43);
        }
    }
}

