/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.graphics;

import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.internal.gtk.GdkColor;
import org.eclipse.swt.internal.gtk.OS;

public final class Color
extends Resource {
    public GdkColor handle;

    Color(Device device) {
        super(device);
    }

    public Color(Device device, int n, int n2, int n3) {
        super(device);
        this.init(n, n2, n3);
        this.init();
    }

    public Color(Device device, RGB rGB) {
        super(device);
        if (rGB == null) {
            SWT.error(4);
        }
        this.init(rGB.red, rGB.green, rGB.blue);
        this.init();
    }

    void destroy() {
        int n = this.handle.pixel;
        if (this.device.colorRefCount != null) {
            int n2 = n;
            this.device.colorRefCount[n2] = this.device.colorRefCount[n2] - 1;
            if (this.device.colorRefCount[n2] == 0) {
                this.device.gdkColors[n] = null;
            }
        }
        long l = OS.gdk_colormap_get_system();
        OS.gdk_colormap_free_colors(l, this.handle, 1);
        this.handle = null;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof Color)) {
            return false;
        }
        Color color = (Color)object;
        GdkColor gdkColor = color.handle;
        if (this.handle == gdkColor) {
            return true;
        }
        return this.device == color.device && this.handle.red == gdkColor.red && this.handle.green == gdkColor.green && this.handle.blue == gdkColor.blue;
    }

    public int getBlue() {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        return this.handle.blue >> 8 & 0xFF;
    }

    public int getGreen() {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        return this.handle.green >> 8 & 0xFF;
    }

    public int getRed() {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        return this.handle.red >> 8 & 0xFF;
    }

    public int hashCode() {
        if (this.isDisposed()) {
            return 0;
        }
        return this.handle.red ^ this.handle.green ^ this.handle.blue;
    }

    public RGB getRGB() {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        return new RGB(this.getRed(), this.getGreen(), this.getBlue());
    }

    public static Color gtk_new(Device device, GdkColor gdkColor) {
        Color color = new Color(device);
        color.handle = gdkColor;
        return color;
    }

    void init(int n, int n2, int n3) {
        if (n > 255 || n < 0 || n2 > 255 || n2 < 0 || n3 > 255 || n3 < 0) {
            SWT.error(5);
        }
        GdkColor gdkColor = new GdkColor();
        gdkColor.red = (short)(n & 0xFF | (n & 0xFF) << 8);
        gdkColor.green = (short)(n2 & 0xFF | (n2 & 0xFF) << 8);
        gdkColor.blue = (short)(n3 & 0xFF | (n3 & 0xFF) << 8);
        long l = OS.gdk_colormap_get_system();
        if (!OS.gdk_colormap_alloc_color(l, gdkColor, true, true)) {
            gdkColor = new GdkColor();
            OS.gdk_colormap_alloc_color(l, gdkColor, true, true);
        }
        this.handle = gdkColor;
        if (this.device.colorRefCount != null) {
            GdkColor gdkColor2 = new GdkColor();
            gdkColor2.red = this.handle.red;
            gdkColor2.green = this.handle.green;
            gdkColor2.blue = this.handle.blue;
            gdkColor2.pixel = this.handle.pixel;
            this.device.gdkColors[gdkColor2.pixel] = gdkColor2;
            int n4 = gdkColor2.pixel;
            this.device.colorRefCount[n4] = this.device.colorRefCount[n4] + 1;
        }
    }

    public boolean isDisposed() {
        return this.handle == null;
    }

    public String toString() {
        if (this.isDisposed()) {
            return "Color {*DISPOSED*}";
        }
        return "Color {" + this.getRed() + ", " + this.getGreen() + ", " + this.getBlue() + "}";
    }
}

