(use '[leiningen.exec :only (deps)])

(deps '[[s3sync "0.1.0-SNAPSHOT"]])

(require '[s3sync.core :as s3s])

(def cred (s3sync.misc/read-resource "test_rw.clj"))

(def locals (s3s/file-seq "/Users/mike/Dropbox/eightnotrump/s3-master/public"))

(def s3-extensions-map 
  {"jpg"  {:cache-control "public,max-age=259200" :content-type "image/jpeg"}
   "mp4"  {:cache-control "public,max-age=259200" :content-type "video/mp4"}
   "png"  {:cache-control "public,max-age=300"    :content-type "image/png"}
   "css"  {:cache-control "public,max-age=300"    :content-type "text/css"}
   "js"   {:cache-control "public,max-age=300"    :content-type "application/javascript"}
   "html" {:cache-control nil             :content-type "text/html"}
   "xml"  {:cache-control "public,max-age=300"    :content-type "application/xml"}})

(def locals (s3s/add-meta-by-extension s3-extensions-map locals))

(s3s/sync cred "preview.eightnotrump.com" locals {:check-metadata true})
