(ns erinite.figwheel
  (:require
    [environ.core :refer [env]]
    [figwheel-sidecar.auto-builder :as fig-auto]
    [figwheel-sidecar.core :as fig]
    [clojurescript-build.auto :as auto]
    [erinite.tools.server]))

(def figwheel-server nil)
(def figwheel-builder nil)

(defn stop-figwheel
  "Stop figwheel autobuilder."
  []
  (when figwheel-builder
    (auto/stop-autobuild! figwheel-builder)
    (def figwheel-builder nil)))


(defn start-figwheel
  "Start figwheel server and autobuilder."
  []
  (if-not figwheel-server
    (do
      (println "Starting Figwheel & DevTools UI")
      (def figwheel-server (fig/start-server (assoc
                                               (env :-figwheel)
                                               :ignore :ignore
                                                :ring-handler 'erinite.tools.server/handler))))
    (println "Restarting figwheel autobuilder"))
  (let [build   (get-in env [:-cljsbuild :dev-build])
        config  {:builds [(get-in env [:-cljsbuild :builds build])]
                 :figwheel-server figwheel-server}]
    (stop-figwheel)
    (def figwheel-builder (fig-auto/autobuild* config))))


(defn dump-figwheel-conf
  "Get the figwheel configuration."
  []
  {:figwheel-server (env :-figwheel)
   :cljs-builds     (get-in env [:-cljsbuild :builds])})

