(ns erinite.tools.server
  (:require
    [ring.middleware.defaults :refer [api-defaults wrap-defaults]]
    [prone.middleware :refer [wrap-exceptions]]
    [bidi.ring :as bidi-ring]
    [hiccup.core :refer [html]]))


(def routes ["/_tools/"
             (fn [r] {:status 200
                      :headers {"Content-Type" "text/html"}
                      :body 
                      (html
                        [:html
                         [:body
                          [:div.tools]
                          [:script "document.write(\"test\");"]]]) })])

(def handler (-> routes
                 bidi-ring/make-handler
                 (wrap-defaults api-defaults)
                 wrap-exceptions))

