(ns lein-erinite.plugin
  (:use [robert.hooke :only (add-hook)])
  (:require leiningen.core.main))

(defn- add-cljs-to-env [func task-name project args]
  (func
    task-name
    (-> project
        (assoc-in [:env :-system] (get-in project [:api :system-ctor])) 
        (assoc-in [:env :-figwheel] (:figwheel project)) 
        (assoc-in [:env :-cljsbuild] (:cljsbuild project)))
    args))

(defn hooks []
  (add-hook #'leiningen.core.main/apply-task #'add-cljs-to-env))

