(ns org.euandre.http.exception
  "HTTP-related exceptions.")

(defn exception [status-code message type error-map]
  (throw (ex-info message
                  (merge error-map
                         {:exception/status-code status-code
                          :exception/type        type}))))

(defmacro gen-exception-fns [exception-input-data]
  (let [definitions (mapv (fn [[code message ex-name]]
                            (let [fn-name (-> ex-name
                                              name
                                              (str "!")
                                              symbol
                                              (vary-meta assoc :arglists ''([error-map])))]
                              `(def ~fn-name
                                 (partial exception ~code ~message ~ex-name))))
                          exception-input-data)]
    `(do ~@definitions)))

(gen-exception-fns
 [[400 "Invalid Input" :invalid-input]
  [401 "Unauthorized" :unauthorized]
  [404 "Not Found" :not-found]
  [409 "Conflict" :conflict]
  [412 "Precondition Failed" :precondition-failed]
  [429 "Too Many Requests" :too-many-requests]
  [500 "Server Error" :server-error]])
