(ns org.euandre.misc.exception
  "HTTP-related exceptions.")

(defn exception [status-code msg type error-map]
  (throw (ex-info msg
                  (merge error-map
                         {::status-code status-code
                          ::msg         msg
                          ::type        type}))))

(def invalid-input!       (partial exception 400 "Invalid Input" :invalid-input))
(def unauthorized!        (partial exception 401 "Unauthorized" :unauthorized))
(def not-found!           (partial exception 404 "Not Found" :not-found))
(def conflict!            (partial exception 409 "Conflict" :not-found))
(def precondition-failed! (partial exception 412 "Precondition Failed" :precondition-failed))
(def server-error!        (partial exception 500 "Server Error" :server-error))
