(ns org.euandre.misc.edn.email
  "edn readers and custom printers for Email.")

(def ^:private email-regex
  "https://davidcel.is/posts/stop-validating-email-addresses-with-regex/
   :shrug:"
  #"^.+@.+\..+$")

(defrecord Email [email-string]
  Object
  (toString [_] email-string))

(defn validate-email [email]
  (cond
    (and (not (string? email))
         (not (instance? Email email)))
    {:email.validation/valid?     false
     :email.validation/reason     :email.validation/not-a-string
     :email.validation/reason-str (str "Input email '" email "' is not a string or #email.")}

    (not (re-matches email-regex (str email)))
    {:email.validation/valid?     false
     :email.validation/reason     :email.validation/invalid-email
     :email.validation/reason-str (str "Input email '" email "' is not recognized as a valid email.")}

    true
    {:email.validation/valid?     true
     :email.validation/reason     :email.validation/valid
     :email.validation/reason-str "Valid email"}))

(defn string->email [email-string]
  (let [{:email.validation/keys [valid? reason-str]} (validate-email email-string)]
    (assert valid? reason-str)
    (->Email email-string)))

(defmethod print-method Email [email ^java.io.Writer writer]
  (.write writer "#email ")
  (print-method (str email) writer))

(defmethod print-dup Email [email ^java.io.Writer writer]
  (.write writer "#email ")
  (print-method (str email) writer))
