(ns org.euandre.misc.spec.generators
  (:require [clojure.spec.gen.alpha :as s.gen]))

;; Taken from "Building test check Generators - Gary Fredericks", around minute 32
;; https://www.youtube.com/watch?v=F4VZPxLZUdA
(def gen-datetime-components
  (s.gen/hash-map
   :year   (s.gen/fmap #(+ % 2017) (s.gen/int))
   :month  (s.gen/large-integer* {:min 1 :max 12})
   :day    (s.gen/large-integer* {:min 1 :max 31})
   :hour   (s.gen/large-integer* {:min 0 :max 23})
   :minute (s.gen/large-integer* {:min 0 :max 59})
   :second (s.gen/large-integer* {:min 0 :max 59})
   :millis (s.gen/large-integer* {:min 0 :max 999})))

(defn construct-datetime [{:keys [year month day hour minute second millis]}]
  (let [format-str "%04d-%02d-%02dT%02d:%02d:%02d.%03dZ"]
    (try
      (java.time.Instant/parse
       (format format-str
               year month day hour minute second millis))
      (catch Exception e
        ;; "kind of dumb, but it works and it's easy"
        ;; FIXME: improve this
        (java.time.Instant/parse
         (format format-str
                 year month 28 hour minute second millis))))))
