(ns org.euandre.om-auth.components
  (:require [clojure.edn :as edn]
            [com.stuartsierra.component :as component]
            [io.pedestal.http :as http]
            [datomic.api :as d]
            [org.euandre.om-auth.db.schema :as db.schema]
            [org.euandre.om-auth.logic.auth :as logic.auth]
            [io.pedestal.interceptor :as i]))

(defrecord Crypto [config-component jwt-backend]
  component/Lifecycle
  (start [this]
    (assoc this :jws-backend (logic.auth/jws-backend (get-in config-component [:config :jwt-signing-secret]))))
  (stop [this]
    (assoc this :jws-backend nil))
  http.components/IWebAppComponent
  (webapp-component [this]
    (:jws-backend this)))

(defn new-crypto []
  (map->Crypto {}))
