(ns org.euandre.om-auth.controllers.email
  (:require [org.httpkit.client :as http]
            [clojure.data.json :as json]
            [org.euandre.om-auth.logic.email :as logic.email]
            [org.euandre.misc.exception :as exception]))

(def +mandrill-send-email-endpoint+
  "https://mandrillapp.com/api/1.0/messages/send.json")

(defn send-email! [email mandrill-key]
  (let [request-payload       {:key     mandrill-key
                               :message email}
        {:keys [body status]} @(http/post +mandrill-send-email-endpoint+ {:body (json/write-str request-payload)})
        parsed-body           (json/read-str body)]
    (when-not (= 200 status)
      (exception/server-error! {::exception/reason     ::send-to-mandrill-error
                                ::exception/reason-str "Error sending email"
                                ::exception/data       parsed-body}))
    (when (= "rejected" (get (first parsed-body) "status"))
      (exception/server-error! {::exception/reason     ::mandril-error
                                ::exception/reason-str "Error sending email (in Mandrill)"
                                ::exception/data       parsed-body}))
    parsed-body))

(defn send-confirmation-email! [email confirmation-id {:keys [mandrill-key issuer-url]}]
  (send-email! (logic.email/new-registration-email email confirmation-id issuer-url) mandrill-key))

(defn send-reset-password-email! [email reset-password-id {:keys [mandrill-key issuer-url]}]
  (send-email! (logic.email/new-reset-password-email email reset-password-id issuer-url) mandrill-key))

(defn confirm-email! [id])
