(ns org.euandre.om-auth.logic.graph
  (:require [org.euandre.misc.exception :as exception]
            [com.wsscode.pathom.core :as pathom]))

(defn ident-uuid-value [{{:keys [key]} :ast :as env}]
  (let [id (pathom/ident-value env)]
    (when-not id
      (exception/invalid-input! {::exception/reason     ::missing-id-value-in-ident
                                 ::exception/reason-str "Missing ident value in lookup ref tuple."
                                 ::exception/details    {:ident key}}))
    (when-not (uuid? id)
      (exception/invalid-input! {::exception/reason     ::id-is-not-an-uuid
                                 ::exception/reason-str "Ident value isn't an UUID."
                                 ::exception/details    {:ident key}}))
    id))
