(ns org.euandre.om-auth.test.aux
  (:require [io.pedestal.http.route :as route]
            [io.pedestal.http :as http]
            [clojure.edn :as edn]
            [com.stuartsierra.component :as component]
            pires.components
            [io.pedestal.test :as pedestal-test]))

(def ^:dynamic *headers*
  {"Content-Type" "application/edn"})

(defonce system-fn (atom nil))

(defn url-for [routes route-identifier]
  (if (string? route-identifier)
    route-identifier
    ((route/url-for-routes routes) route-identifier)))

(defn request!
  ([method raw-response? service route-name status-code]
   (request! method raw-response? service route-name status-code nil))
  ([method raw-response? service route-name status-code request-body & options]
   (let [route-url (url-for (::http/routes service) route-name)
         response  (apply pedestal-test/response-for
                          (::http/service-fn service)
                          method
                          route-url
                          :headers *headers*
                          :body (pr-str request-body)
                          options)]
     (assert (= status-code (:status response))
             (do
               (str "Expected response status code to be " status-code ", got " (pr-str (:status response)))
               (pr-str (:body response))))
     (if raw-response?
       response
       (edn/read-string {:readers (merge *data-readers*
                                         {'error identity})}
                        (:body response))))))

(def GET-raw  (partial request! :get  true))
(def POST-raw (partial request! :post true))
(def GET      (partial request! :get  false))
(def POST     (partial request! :post false))

(defn query! [service status-code query]
  (POST service :query status-code query))

(defmacro with-system
  [system-under-test-var components-bindings & body]
  `(let [~system-under-test-var       (component/start (pires.components/system :test)) ;; FIXME: get the system function from somewhere
         service#                     (get-in ~system-under-test-var [:pedestal :service])
         datomic#                     (get-in ~system-under-test-var [:datomic-connection :conn])
         GET#                         (partial GET service#)
         GET-raw#                     (partial GET-raw service#)
         POST#                        (partial POST service#)
         POST-raw#                    (partial POST-raw service#)
         query-raw#                   (partial query! service#)
         q#                           #(query-raw# 200 {:q %})
         {:keys ~components-bindings} {:datomic  datomic#
                                       :query    query-raw#
                                       :q        q#
                                       :service  service#
                                       :GET      GET#
                                       :GET-raw  GET-raw#
                                       :POST     POST#
                                       :POST-raw POST-raw#}]
     (try
       ~@body
       (finally
         (component/stop ~system-under-test-var)))))

(defmacro as-user
  [system-under-test-var email variables-bindings & body]
  `(let [password#        ~(str (java.util.UUID/randomUUID) " password " (java.util.UUID/randomUUID))
         confirmation-id# ~(java.util.UUID/randomUUID)
         service#         (get-in ~system-under-test-var [:pedestal :service])
         GET#             (partial GET service#)
         q#               #(query! service# 200 {:q %})]
     (with-redefs [org.euandre.om-auth.controllers.graph.auth/new-confirmation-id (constantly confirmation-id#)
                   org.euandre.om-auth.controllers.email/send-email!              (constantly true)] ;; FIXME: Use test key instead
       (q# `[(~'auth/register
              {:user/email    ~~email
               :user/password ~password#})])
       (GET# (str "/auth/confirm-email/" confirmation-id#) 200))
     (let [tokens#                     (get-in (q# `[(~'auth/login
                                                      {:user/email    ~~email
                                                       :user/password ~password#})])
                                               `[~'auth/login :result])
           access-token#               (:user/access-token tokens#)
           {:keys ~variables-bindings} {:password        password#
                                        :access-token    access-token#
                                        :refresh-token   (:user/refresh-token tokens#)
                                        :tokens          tokens#
                                        :confirmation-id confirmation-id#}]
       (binding [*headers* (assoc *headers* "Authorization" (str "Bearer " access-token#))]
         ~@body))))
