(ns org.euandreh.http.protocols.edn-database)

(defprotocol IEdnDatabase
  "IEdnDatabase targets reading and writing edn data to a file from multiple threads.

   Useful for data that needs to be persisted but doesn't require a full-blown database."
  (read! [this] "Read the edn file content and store it in memory. Get the path from `org.euandreh.http.protocols.edn/path`. Defaults to `{}` if the file doesn't exist.")
  (write! [this new-database] "Write the given `new-database` to the in-memory copy and to the file under `org.euandreh.http.protocols.edn/path`. Creates the file (and parent folders) if it doesn't exist yet.")
  (db [this] "Get the current value of the in-memory database. The in-memory value stays in sync with the disk value.")
  (path [this] "Return the path for the edn file where the database value is written as is."))
