(ns org.euandreh.http.protocols.edn-file)

(defprotocol IEdnFile
  "IEdnFile targets reading edn data from a file from multiple threads.

   Useful for dynamic configuration data that can be refreshed at run-time."
  (cached-content [this] "Get the latest know data from the file (if not fetched already) or from memory.")
  (refresh [this] "Drop the content from memory. The next call to `org.euandreh.http.protocols.edn-file/cached-content` will fetch the new data."))
