(ns org.euandreh.http.utils
  (:require [clojure.spec.alpha :as s]))

(defn api-version
  "Return the SHA version from inside the `config` map.

   If the `config` changes the return value will return along with it."
  [{{:keys [config]} :components}]
  {:status 200
   :body   {:version (:version config)}})

(s/def ::config (s/keys :req-un [::version]))
(s/def ::components (s/keys :req-un [::config]))
(s/def ::request (s/keys :req-un [::components]))
(s/def ::status #{200})
(s/def ::version string?)
(s/def ::body (s/keys :req-un [::version]))
(s/def ::response (s/keys :req-un [::status ::body]))

(s/fdef api-version
  :args (s/cat :request ::request)
  :ret ::response
  :fn #(= (get-in % [:args :request :components :config :version])
          (get-in % [:ret :body :version])))
