(defproject org.euandreh/misc "0.1.1"
  :description "Misc Clojure functions and utilities."
  :url "https://gitlab.com/EuAndreh/org.euandreh.misc"
  :license {:name         "GNU General Public License"
            :url          "https://www.gnu.org/licenses/gpl-3.0.html"
            :distribution :repo}
  :min-lein-version "2.4.2"

  :plugins [[funcool/codeina "0.5.0"]
            [lein-cloverage "1.0.9"]
            [lein-kibit "0.1.5"]
            [lein-cljfmt "0.5.7"]
            [lein-ancient "0.6.15"]]

  :codeina {:sources        ["src"]
            :target         "public/api"
            :src-uri        "https://gitlab.com/EuAndreh/org.euandreh.misc/blob/master/"
            :src-uri-prefix "#L"}

  :cljfmt {:indents {for-all [[:block 1]]}}

  :dependencies [[org.clojure/clojure "1.9.0"]
                 [lambdaisland/uri "1.1.0"]
                 [com.cemerick/url "0.1.1"]
                 [org.clojure/test.check "0.9.0"]
                 [com.velisco/strgen "0.1.5"]]

  :profiles {:dev {:aliases {"lint" ["do" "cljfmt" "check," "kibit"]
                             "docs" ["do" "doc," "cloverage" "-o" "public/coverage"]}}}

  :deploy-repositories [["releases" :clojars]])
