// Compiled by ClojureScript 1.9.946 {}
goog.provide('cljs.core.async');
goog.require('cljs.core');
goog.require('cljs.core.async.impl.protocols');
goog.require('cljs.core.async.impl.channels');
goog.require('cljs.core.async.impl.buffers');
goog.require('cljs.core.async.impl.timers');
goog.require('cljs.core.async.impl.dispatch');
goog.require('cljs.core.async.impl.ioc_helpers');
cljs.core.async.fn_handler = (function cljs$core$async$fn_handler(var_args){
var G__25233 = arguments.length;
switch (G__25233) {
case 1:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1 = (function (f){
return cljs.core.async.fn_handler.call(null,f,true);
});

cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2 = (function (f,blockable){
if(typeof cljs.core.async.t_cljs$core$async25234 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async25234 = (function (f,blockable,meta25235){
this.f = f;
this.blockable = blockable;
this.meta25235 = meta25235;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async25234.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_25236,meta25235__$1){
var self__ = this;
var _25236__$1 = this;
return (new cljs.core.async.t_cljs$core$async25234(self__.f,self__.blockable,meta25235__$1));
});

cljs.core.async.t_cljs$core$async25234.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_25236){
var self__ = this;
var _25236__$1 = this;
return self__.meta25235;
});

cljs.core.async.t_cljs$core$async25234.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async25234.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
});

cljs.core.async.t_cljs$core$async25234.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.blockable;
});

cljs.core.async.t_cljs$core$async25234.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.f;
});

cljs.core.async.t_cljs$core$async25234.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"blockable","blockable",-28395259,null),new cljs.core.Symbol(null,"meta25235","meta25235",825113737,null)], null);
});

cljs.core.async.t_cljs$core$async25234.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async25234.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async25234";

cljs.core.async.t_cljs$core$async25234.cljs$lang$ctorPrWriter = (function (this__8811__auto__,writer__8812__auto__,opt__8813__auto__){
return cljs.core._write.call(null,writer__8812__auto__,"cljs.core.async/t_cljs$core$async25234");
});

cljs.core.async.__GT_t_cljs$core$async25234 = (function cljs$core$async$__GT_t_cljs$core$async25234(f__$1,blockable__$1,meta25235){
return (new cljs.core.async.t_cljs$core$async25234(f__$1,blockable__$1,meta25235));
});

}

return (new cljs.core.async.t_cljs$core$async25234(f,blockable,cljs.core.PersistentArrayMap.EMPTY));
});

cljs.core.async.fn_handler.cljs$lang$maxFixedArity = 2;

/**
 * Returns a fixed buffer of size n. When full, puts will block/park.
 */
cljs.core.async.buffer = (function cljs$core$async$buffer(n){
return cljs.core.async.impl.buffers.fixed_buffer.call(null,n);
});
/**
 * Returns a buffer of size n. When full, puts will complete but
 *   val will be dropped (no transfer).
 */
cljs.core.async.dropping_buffer = (function cljs$core$async$dropping_buffer(n){
return cljs.core.async.impl.buffers.dropping_buffer.call(null,n);
});
/**
 * Returns a buffer of size n. When full, puts will complete, and be
 *   buffered, but oldest elements in buffer will be dropped (not
 *   transferred).
 */
cljs.core.async.sliding_buffer = (function cljs$core$async$sliding_buffer(n){
return cljs.core.async.impl.buffers.sliding_buffer.call(null,n);
});
/**
 * Returns true if a channel created with buff will never block. That is to say,
 * puts into this buffer will never cause the buffer to be full. 
 */
cljs.core.async.unblocking_buffer_QMARK_ = (function cljs$core$async$unblocking_buffer_QMARK_(buff){
if(!((buff == null))){
if((false) || ((cljs.core.PROTOCOL_SENTINEL === buff.cljs$core$async$impl$protocols$UnblockingBuffer$))){
return true;
} else {
if((!buff.cljs$lang$protocol_mask$partition$)){
return cljs.core.native_satisfies_QMARK_.call(null,cljs.core.async.impl.protocols.UnblockingBuffer,buff);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_.call(null,cljs.core.async.impl.protocols.UnblockingBuffer,buff);
}
});
/**
 * Creates a channel with an optional buffer, an optional transducer (like (map f),
 *   (filter p) etc or a composition thereof), and an optional exception handler.
 *   If buf-or-n is a number, will create and use a fixed buffer of that size. If a
 *   transducer is supplied a buffer must be specified. ex-handler must be a
 *   fn of one argument - if an exception occurs during transformation it will be called
 *   with the thrown value as an argument, and any non-nil return value will be placed
 *   in the channel.
 */
cljs.core.async.chan = (function cljs$core$async$chan(var_args){
var G__25240 = arguments.length;
switch (G__25240) {
case 0:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.chan.call(null,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1 = (function (buf_or_n){
return cljs.core.async.chan.call(null,buf_or_n,null,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2 = (function (buf_or_n,xform){
return cljs.core.async.chan.call(null,buf_or_n,xform,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3 = (function (buf_or_n,xform,ex_handler){
var buf_or_n__$1 = ((cljs.core._EQ_.call(null,buf_or_n,(0)))?null:buf_or_n);
if(cljs.core.truth_(xform)){
if(cljs.core.truth_(buf_or_n__$1)){
} else {
throw (new Error(["Assert failed: ","buffer must be supplied when transducer is","\n","buf-or-n"].join('')));
}
} else {
}

return cljs.core.async.impl.channels.chan.call(null,((typeof buf_or_n__$1 === 'number')?cljs.core.async.buffer.call(null,buf_or_n__$1):buf_or_n__$1),xform,ex_handler);
});

cljs.core.async.chan.cljs$lang$maxFixedArity = 3;

/**
 * Creates a promise channel with an optional transducer, and an optional
 *   exception-handler. A promise channel can take exactly one value that consumers
 *   will receive. Once full, puts complete but val is dropped (no transfer).
 *   Consumers will block until either a value is placed in the channel or the
 *   channel is closed. See chan for the semantics of xform and ex-handler.
 */
cljs.core.async.promise_chan = (function cljs$core$async$promise_chan(var_args){
var G__25243 = arguments.length;
switch (G__25243) {
case 0:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.promise_chan.call(null,null);
});

cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1 = (function (xform){
return cljs.core.async.promise_chan.call(null,xform,null);
});

cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2 = (function (xform,ex_handler){
return cljs.core.async.chan.call(null,cljs.core.async.impl.buffers.promise_buffer.call(null),xform,ex_handler);
});

cljs.core.async.promise_chan.cljs$lang$maxFixedArity = 2;

/**
 * Returns a channel that will close after msecs
 */
cljs.core.async.timeout = (function cljs$core$async$timeout(msecs){
return cljs.core.async.impl.timers.timeout.call(null,msecs);
});
/**
 * takes a val from port. Must be called inside a (go ...) block. Will
 *   return nil if closed. Will park if nothing is available.
 *   Returns true unless port is already closed
 */
cljs.core.async._LT__BANG_ = (function cljs$core$async$_LT__BANG_(port){
throw (new Error("<! used not in (go ...) block"));
});
/**
 * Asynchronously takes a val from port, passing to fn1. Will pass nil
 * if closed. If on-caller? (default true) is true, and value is
 * immediately available, will call fn1 on calling thread.
 * Returns nil.
 */
cljs.core.async.take_BANG_ = (function cljs$core$async$take_BANG_(var_args){
var G__25246 = arguments.length;
switch (G__25246) {
case 2:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,fn1){
return cljs.core.async.take_BANG_.call(null,port,fn1,true);
});

cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,fn1,on_caller_QMARK_){
var ret = cljs.core.async.impl.protocols.take_BANG_.call(null,port,cljs.core.async.fn_handler.call(null,fn1));
if(cljs.core.truth_(ret)){
var val_25248 = cljs.core.deref.call(null,ret);
if(cljs.core.truth_(on_caller_QMARK_)){
fn1.call(null,val_25248);
} else {
cljs.core.async.impl.dispatch.run.call(null,((function (val_25248,ret){
return (function (){
return fn1.call(null,val_25248);
});})(val_25248,ret))
);
}
} else {
}

return null;
});

cljs.core.async.take_BANG_.cljs$lang$maxFixedArity = 3;

cljs.core.async.nop = (function cljs$core$async$nop(_){
return null;
});
cljs.core.async.fhnop = cljs.core.async.fn_handler.call(null,cljs.core.async.nop);
/**
 * puts a val into port. nil values are not allowed. Must be called
 *   inside a (go ...) block. Will park if no buffer space is available.
 *   Returns true unless port is already closed.
 */
cljs.core.async._GT__BANG_ = (function cljs$core$async$_GT__BANG_(port,val){
throw (new Error(">! used not in (go ...) block"));
});
/**
 * Asynchronously puts a val into port, calling fn0 (if supplied) when
 * complete. nil values are not allowed. Will throw if closed. If
 * on-caller? (default true) is true, and the put is immediately
 * accepted, will call fn0 on calling thread.  Returns nil.
 */
cljs.core.async.put_BANG_ = (function cljs$core$async$put_BANG_(var_args){
var G__25250 = arguments.length;
switch (G__25250) {
case 2:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,val){
var temp__4655__auto__ = cljs.core.async.impl.protocols.put_BANG_.call(null,port,val,cljs.core.async.fhnop);
if(cljs.core.truth_(temp__4655__auto__)){
var ret = temp__4655__auto__;
return cljs.core.deref.call(null,ret);
} else {
return true;
}
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,val,fn1){
return cljs.core.async.put_BANG_.call(null,port,val,fn1,true);
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4 = (function (port,val,fn1,on_caller_QMARK_){
var temp__4655__auto__ = cljs.core.async.impl.protocols.put_BANG_.call(null,port,val,cljs.core.async.fn_handler.call(null,fn1));
if(cljs.core.truth_(temp__4655__auto__)){
var retb = temp__4655__auto__;
var ret = cljs.core.deref.call(null,retb);
if(cljs.core.truth_(on_caller_QMARK_)){
fn1.call(null,ret);
} else {
cljs.core.async.impl.dispatch.run.call(null,((function (ret,retb,temp__4655__auto__){
return (function (){
return fn1.call(null,ret);
});})(ret,retb,temp__4655__auto__))
);
}

return ret;
} else {
return true;
}
});

cljs.core.async.put_BANG_.cljs$lang$maxFixedArity = 4;

cljs.core.async.close_BANG_ = (function cljs$core$async$close_BANG_(port){
return cljs.core.async.impl.protocols.close_BANG_.call(null,port);
});
cljs.core.async.random_array = (function cljs$core$async$random_array(n){
var a = (new Array(n));
var n__9133__auto___25252 = n;
var x_25253 = (0);
while(true){
if((x_25253 < n__9133__auto___25252)){
(a[x_25253] = (0));

var G__25254 = (x_25253 + (1));
x_25253 = G__25254;
continue;
} else {
}
break;
}

var i = (1);
while(true){
if(cljs.core._EQ_.call(null,i,n)){
return a;
} else {
var j = cljs.core.rand_int.call(null,i);
(a[i] = (a[j]));

(a[j] = i);

var G__25255 = (i + (1));
i = G__25255;
continue;
}
break;
}
});
cljs.core.async.alt_flag = (function cljs$core$async$alt_flag(){
var flag = cljs.core.atom.call(null,true);
if(typeof cljs.core.async.t_cljs$core$async25256 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async25256 = (function (flag,meta25257){
this.flag = flag;
this.meta25257 = meta25257;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async25256.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (flag){
return (function (_25258,meta25257__$1){
var self__ = this;
var _25258__$1 = this;
return (new cljs.core.async.t_cljs$core$async25256(self__.flag,meta25257__$1));
});})(flag))
;

cljs.core.async.t_cljs$core$async25256.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (flag){
return (function (_25258){
var self__ = this;
var _25258__$1 = this;
return self__.meta25257;
});})(flag))
;

cljs.core.async.t_cljs$core$async25256.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async25256.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.deref.call(null,self__.flag);
});})(flag))
;

cljs.core.async.t_cljs$core$async25256.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
return true;
});})(flag))
;

cljs.core.async.t_cljs$core$async25256.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_.call(null,self__.flag,null);

return true;
});})(flag))
;

cljs.core.async.t_cljs$core$async25256.getBasis = ((function (flag){
return (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"meta25257","meta25257",563548239,null)], null);
});})(flag))
;

cljs.core.async.t_cljs$core$async25256.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async25256.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async25256";

cljs.core.async.t_cljs$core$async25256.cljs$lang$ctorPrWriter = ((function (flag){
return (function (this__8811__auto__,writer__8812__auto__,opt__8813__auto__){
return cljs.core._write.call(null,writer__8812__auto__,"cljs.core.async/t_cljs$core$async25256");
});})(flag))
;

cljs.core.async.__GT_t_cljs$core$async25256 = ((function (flag){
return (function cljs$core$async$alt_flag_$___GT_t_cljs$core$async25256(flag__$1,meta25257){
return (new cljs.core.async.t_cljs$core$async25256(flag__$1,meta25257));
});})(flag))
;

}

return (new cljs.core.async.t_cljs$core$async25256(flag,cljs.core.PersistentArrayMap.EMPTY));
});
cljs.core.async.alt_handler = (function cljs$core$async$alt_handler(flag,cb){
if(typeof cljs.core.async.t_cljs$core$async25259 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async25259 = (function (flag,cb,meta25260){
this.flag = flag;
this.cb = cb;
this.meta25260 = meta25260;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async25259.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_25261,meta25260__$1){
var self__ = this;
var _25261__$1 = this;
return (new cljs.core.async.t_cljs$core$async25259(self__.flag,self__.cb,meta25260__$1));
});

cljs.core.async.t_cljs$core$async25259.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_25261){
var self__ = this;
var _25261__$1 = this;
return self__.meta25260;
});

cljs.core.async.t_cljs$core$async25259.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async25259.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.active_QMARK_.call(null,self__.flag);
});

cljs.core.async.t_cljs$core$async25259.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
});

cljs.core.async.t_cljs$core$async25259.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.async.impl.protocols.commit.call(null,self__.flag);

return self__.cb;
});

cljs.core.async.t_cljs$core$async25259.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"cb","cb",-2064487928,null),new cljs.core.Symbol(null,"meta25260","meta25260",-1984793855,null)], null);
});

cljs.core.async.t_cljs$core$async25259.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async25259.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async25259";

cljs.core.async.t_cljs$core$async25259.cljs$lang$ctorPrWriter = (function (this__8811__auto__,writer__8812__auto__,opt__8813__auto__){
return cljs.core._write.call(null,writer__8812__auto__,"cljs.core.async/t_cljs$core$async25259");
});

cljs.core.async.__GT_t_cljs$core$async25259 = (function cljs$core$async$alt_handler_$___GT_t_cljs$core$async25259(flag__$1,cb__$1,meta25260){
return (new cljs.core.async.t_cljs$core$async25259(flag__$1,cb__$1,meta25260));
});

}

return (new cljs.core.async.t_cljs$core$async25259(flag,cb,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * returns derefable [val port] if immediate, nil if enqueued
 */
cljs.core.async.do_alts = (function cljs$core$async$do_alts(fret,ports,opts){
var flag = cljs.core.async.alt_flag.call(null);
var n = cljs.core.count.call(null,ports);
var idxs = cljs.core.async.random_array.call(null,n);
var priority = new cljs.core.Keyword(null,"priority","priority",1431093715).cljs$core$IFn$_invoke$arity$1(opts);
var ret = (function (){var i = (0);
while(true){
if((i < n)){
var idx = (cljs.core.truth_(priority)?i:(idxs[i]));
var port = cljs.core.nth.call(null,ports,idx);
var wport = ((cljs.core.vector_QMARK_.call(null,port))?port.call(null,(0)):null);
var vbox = (cljs.core.truth_(wport)?(function (){var val = port.call(null,(1));
return cljs.core.async.impl.protocols.put_BANG_.call(null,wport,val,cljs.core.async.alt_handler.call(null,flag,((function (i,val,idx,port,wport,flag,n,idxs,priority){
return (function (p1__25262_SHARP_){
return fret.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__25262_SHARP_,wport], null));
});})(i,val,idx,port,wport,flag,n,idxs,priority))
));
})():cljs.core.async.impl.protocols.take_BANG_.call(null,port,cljs.core.async.alt_handler.call(null,flag,((function (i,idx,port,wport,flag,n,idxs,priority){
return (function (p1__25263_SHARP_){
return fret.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__25263_SHARP_,port], null));
});})(i,idx,port,wport,flag,n,idxs,priority))
)));
if(cljs.core.truth_(vbox)){
return cljs.core.async.impl.channels.box.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.deref.call(null,vbox),(function (){var or__8186__auto__ = wport;
if(cljs.core.truth_(or__8186__auto__)){
return or__8186__auto__;
} else {
return port;
}
})()], null));
} else {
var G__25264 = (i + (1));
i = G__25264;
continue;
}
} else {
return null;
}
break;
}
})();
var or__8186__auto__ = ret;
if(cljs.core.truth_(or__8186__auto__)){
return or__8186__auto__;
} else {
if(cljs.core.contains_QMARK_.call(null,opts,new cljs.core.Keyword(null,"default","default",-1987822328))){
var temp__4657__auto__ = (function (){var and__8174__auto__ = cljs.core.async.impl.protocols.active_QMARK_.call(null,flag);
if(cljs.core.truth_(and__8174__auto__)){
return cljs.core.async.impl.protocols.commit.call(null,flag);
} else {
return and__8174__auto__;
}
})();
if(cljs.core.truth_(temp__4657__auto__)){
var got = temp__4657__auto__;
return cljs.core.async.impl.channels.box.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"default","default",-1987822328).cljs$core$IFn$_invoke$arity$1(opts),new cljs.core.Keyword(null,"default","default",-1987822328)], null));
} else {
return null;
}
} else {
return null;
}
}
});
/**
 * Completes at most one of several channel operations. Must be called
 * inside a (go ...) block. ports is a vector of channel endpoints,
 * which can be either a channel to take from or a vector of
 *   [channel-to-put-to val-to-put], in any combination. Takes will be
 *   made as if by <!, and puts will be made as if by >!. Unless
 *   the :priority option is true, if more than one port operation is
 *   ready a non-deterministic choice will be made. If no operation is
 *   ready and a :default value is supplied, [default-val :default] will
 *   be returned, otherwise alts! will park until the first operation to
 *   become ready completes. Returns [val port] of the completed
 *   operation, where val is the value taken for takes, and a
 *   boolean (true unless already closed, as per put!) for puts.
 * 
 *   opts are passed as :key val ... Supported options:
 * 
 *   :default val - the value to use if none of the operations are immediately ready
 *   :priority true - (default nil) when true, the operations will be tried in order.
 * 
 *   Note: there is no guarantee that the port exps or val exprs will be
 *   used, nor in what order should they be, so they should not be
 *   depended upon for side effects.
 */
cljs.core.async.alts_BANG_ = (function cljs$core$async$alts_BANG_(var_args){
var args__9364__auto__ = [];
var len__9357__auto___25270 = arguments.length;
var i__9358__auto___25271 = (0);
while(true){
if((i__9358__auto___25271 < len__9357__auto___25270)){
args__9364__auto__.push((arguments[i__9358__auto___25271]));

var G__25272 = (i__9358__auto___25271 + (1));
i__9358__auto___25271 = G__25272;
continue;
} else {
}
break;
}

var argseq__9365__auto__ = ((((1) < args__9364__auto__.length))?(new cljs.core.IndexedSeq(args__9364__auto__.slice((1)),(0),null)):null);
return cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__9365__auto__);
});

cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (ports,p__25267){
var map__25268 = p__25267;
var map__25268__$1 = ((((!((map__25268 == null)))?((((map__25268.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__25268.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__25268):map__25268);
var opts = map__25268__$1;
throw (new Error("alts! used not in (go ...) block"));
});

cljs.core.async.alts_BANG_.cljs$lang$maxFixedArity = (1);

cljs.core.async.alts_BANG_.cljs$lang$applyTo = (function (seq25265){
var G__25266 = cljs.core.first.call(null,seq25265);
var seq25265__$1 = cljs.core.next.call(null,seq25265);
return cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__25266,seq25265__$1);
});

/**
 * Puts a val into port if it's possible to do so immediately.
 *   nil values are not allowed. Never blocks. Returns true if offer succeeds.
 */
cljs.core.async.offer_BANG_ = (function cljs$core$async$offer_BANG_(port,val){
var ret = cljs.core.async.impl.protocols.put_BANG_.call(null,port,val,cljs.core.async.fn_handler.call(null,cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return cljs.core.deref.call(null,ret);
} else {
return null;
}
});
/**
 * Takes a val from port if it's possible to do so immediately.
 *   Never blocks. Returns value if successful, nil otherwise.
 */
cljs.core.async.poll_BANG_ = (function cljs$core$async$poll_BANG_(port){
var ret = cljs.core.async.impl.protocols.take_BANG_.call(null,port,cljs.core.async.fn_handler.call(null,cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return cljs.core.deref.call(null,ret);
} else {
return null;
}
});
/**
 * Takes elements from the from channel and supplies them to the to
 * channel. By default, the to channel will be closed when the from
 * channel closes, but can be determined by the close?  parameter. Will
 * stop consuming the from channel if the to channel closes
 */
cljs.core.async.pipe = (function cljs$core$async$pipe(var_args){
var G__25274 = arguments.length;
switch (G__25274) {
case 2:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2 = (function (from,to){
return cljs.core.async.pipe.call(null,from,to,true);
});

cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3 = (function (from,to,close_QMARK_){
var c__25187__auto___25320 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__25187__auto___25320){
return (function (){
var f__25188__auto__ = (function (){var switch__25099__auto__ = ((function (c__25187__auto___25320){
return (function (state_25298){
var state_val_25299 = (state_25298[(1)]);
if((state_val_25299 === (7))){
var inst_25294 = (state_25298[(2)]);
var state_25298__$1 = state_25298;
var statearr_25300_25321 = state_25298__$1;
(statearr_25300_25321[(2)] = inst_25294);

(statearr_25300_25321[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25299 === (1))){
var state_25298__$1 = state_25298;
var statearr_25301_25322 = state_25298__$1;
(statearr_25301_25322[(2)] = null);

(statearr_25301_25322[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25299 === (4))){
var inst_25277 = (state_25298[(7)]);
var inst_25277__$1 = (state_25298[(2)]);
var inst_25278 = (inst_25277__$1 == null);
var state_25298__$1 = (function (){var statearr_25302 = state_25298;
(statearr_25302[(7)] = inst_25277__$1);

return statearr_25302;
})();
if(cljs.core.truth_(inst_25278)){
var statearr_25303_25323 = state_25298__$1;
(statearr_25303_25323[(1)] = (5));

} else {
var statearr_25304_25324 = state_25298__$1;
(statearr_25304_25324[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25299 === (13))){
var state_25298__$1 = state_25298;
var statearr_25305_25325 = state_25298__$1;
(statearr_25305_25325[(2)] = null);

(statearr_25305_25325[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25299 === (6))){
var inst_25277 = (state_25298[(7)]);
var state_25298__$1 = state_25298;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_25298__$1,(11),to,inst_25277);
} else {
if((state_val_25299 === (3))){
var inst_25296 = (state_25298[(2)]);
var state_25298__$1 = state_25298;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_25298__$1,inst_25296);
} else {
if((state_val_25299 === (12))){
var state_25298__$1 = state_25298;
var statearr_25306_25326 = state_25298__$1;
(statearr_25306_25326[(2)] = null);

(statearr_25306_25326[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25299 === (2))){
var state_25298__$1 = state_25298;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_25298__$1,(4),from);
} else {
if((state_val_25299 === (11))){
var inst_25287 = (state_25298[(2)]);
var state_25298__$1 = state_25298;
if(cljs.core.truth_(inst_25287)){
var statearr_25307_25327 = state_25298__$1;
(statearr_25307_25327[(1)] = (12));

} else {
var statearr_25308_25328 = state_25298__$1;
(statearr_25308_25328[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25299 === (9))){
var state_25298__$1 = state_25298;
var statearr_25309_25329 = state_25298__$1;
(statearr_25309_25329[(2)] = null);

(statearr_25309_25329[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25299 === (5))){
var state_25298__$1 = state_25298;
if(cljs.core.truth_(close_QMARK_)){
var statearr_25310_25330 = state_25298__$1;
(statearr_25310_25330[(1)] = (8));

} else {
var statearr_25311_25331 = state_25298__$1;
(statearr_25311_25331[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25299 === (14))){
var inst_25292 = (state_25298[(2)]);
var state_25298__$1 = state_25298;
var statearr_25312_25332 = state_25298__$1;
(statearr_25312_25332[(2)] = inst_25292);

(statearr_25312_25332[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25299 === (10))){
var inst_25284 = (state_25298[(2)]);
var state_25298__$1 = state_25298;
var statearr_25313_25333 = state_25298__$1;
(statearr_25313_25333[(2)] = inst_25284);

(statearr_25313_25333[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25299 === (8))){
var inst_25281 = cljs.core.async.close_BANG_.call(null,to);
var state_25298__$1 = state_25298;
var statearr_25314_25334 = state_25298__$1;
(statearr_25314_25334[(2)] = inst_25281);

(statearr_25314_25334[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__25187__auto___25320))
;
return ((function (switch__25099__auto__,c__25187__auto___25320){
return (function() {
var cljs$core$async$state_machine__25100__auto__ = null;
var cljs$core$async$state_machine__25100__auto____0 = (function (){
var statearr_25315 = [null,null,null,null,null,null,null,null];
(statearr_25315[(0)] = cljs$core$async$state_machine__25100__auto__);

(statearr_25315[(1)] = (1));

return statearr_25315;
});
var cljs$core$async$state_machine__25100__auto____1 = (function (state_25298){
while(true){
var ret_value__25101__auto__ = (function (){try{while(true){
var result__25102__auto__ = switch__25099__auto__.call(null,state_25298);
if(cljs.core.keyword_identical_QMARK_.call(null,result__25102__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__25102__auto__;
}
break;
}
}catch (e25316){if((e25316 instanceof Object)){
var ex__25103__auto__ = e25316;
var statearr_25317_25335 = state_25298;
(statearr_25317_25335[(5)] = ex__25103__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_25298);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e25316;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__25101__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__25336 = state_25298;
state_25298 = G__25336;
continue;
} else {
return ret_value__25101__auto__;
}
break;
}
});
cljs$core$async$state_machine__25100__auto__ = function(state_25298){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__25100__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__25100__auto____1.call(this,state_25298);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$state_machine__25100__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__25100__auto____0;
cljs$core$async$state_machine__25100__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__25100__auto____1;
return cljs$core$async$state_machine__25100__auto__;
})()
;})(switch__25099__auto__,c__25187__auto___25320))
})();
var state__25189__auto__ = (function (){var statearr_25318 = f__25188__auto__.call(null);
(statearr_25318[(6)] = c__25187__auto___25320);

return statearr_25318;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__25189__auto__);
});})(c__25187__auto___25320))
);


return to;
});

cljs.core.async.pipe.cljs$lang$maxFixedArity = 3;

cljs.core.async.pipeline_STAR_ = (function cljs$core$async$pipeline_STAR_(n,to,xf,from,close_QMARK_,ex_handler,type){
if((n > (0))){
} else {
throw (new Error("Assert failed: (pos? n)"));
}

var jobs = cljs.core.async.chan.call(null,n);
var results = cljs.core.async.chan.call(null,n);
var process = ((function (jobs,results){
return (function (p__25337){
var vec__25338 = p__25337;
var v = cljs.core.nth.call(null,vec__25338,(0),null);
var p = cljs.core.nth.call(null,vec__25338,(1),null);
var job = vec__25338;
if((job == null)){
cljs.core.async.close_BANG_.call(null,results);

return null;
} else {
var res = cljs.core.async.chan.call(null,(1),xf,ex_handler);
var c__25187__auto___25509 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__25187__auto___25509,res,vec__25338,v,p,job,jobs,results){
return (function (){
var f__25188__auto__ = (function (){var switch__25099__auto__ = ((function (c__25187__auto___25509,res,vec__25338,v,p,job,jobs,results){
return (function (state_25345){
var state_val_25346 = (state_25345[(1)]);
if((state_val_25346 === (1))){
var state_25345__$1 = state_25345;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_25345__$1,(2),res,v);
} else {
if((state_val_25346 === (2))){
var inst_25342 = (state_25345[(2)]);
var inst_25343 = cljs.core.async.close_BANG_.call(null,res);
var state_25345__$1 = (function (){var statearr_25347 = state_25345;
(statearr_25347[(7)] = inst_25342);

return statearr_25347;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_25345__$1,inst_25343);
} else {
return null;
}
}
});})(c__25187__auto___25509,res,vec__25338,v,p,job,jobs,results))
;
return ((function (switch__25099__auto__,c__25187__auto___25509,res,vec__25338,v,p,job,jobs,results){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__25100__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__25100__auto____0 = (function (){
var statearr_25348 = [null,null,null,null,null,null,null,null];
(statearr_25348[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__25100__auto__);

(statearr_25348[(1)] = (1));

return statearr_25348;
});
var cljs$core$async$pipeline_STAR__$_state_machine__25100__auto____1 = (function (state_25345){
while(true){
var ret_value__25101__auto__ = (function (){try{while(true){
var result__25102__auto__ = switch__25099__auto__.call(null,state_25345);
if(cljs.core.keyword_identical_QMARK_.call(null,result__25102__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__25102__auto__;
}
break;
}
}catch (e25349){if((e25349 instanceof Object)){
var ex__25103__auto__ = e25349;
var statearr_25350_25510 = state_25345;
(statearr_25350_25510[(5)] = ex__25103__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_25345);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e25349;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__25101__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__25511 = state_25345;
state_25345 = G__25511;
continue;
} else {
return ret_value__25101__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__25100__auto__ = function(state_25345){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__25100__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__25100__auto____1.call(this,state_25345);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$pipeline_STAR__$_state_machine__25100__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__25100__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__25100__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__25100__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__25100__auto__;
})()
;})(switch__25099__auto__,c__25187__auto___25509,res,vec__25338,v,p,job,jobs,results))
})();
var state__25189__auto__ = (function (){var statearr_25351 = f__25188__auto__.call(null);
(statearr_25351[(6)] = c__25187__auto___25509);

return statearr_25351;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__25189__auto__);
});})(c__25187__auto___25509,res,vec__25338,v,p,job,jobs,results))
);


cljs.core.async.put_BANG_.call(null,p,res);

return true;
}
});})(jobs,results))
;
var async = ((function (jobs,results,process){
return (function (p__25352){
var vec__25353 = p__25352;
var v = cljs.core.nth.call(null,vec__25353,(0),null);
var p = cljs.core.nth.call(null,vec__25353,(1),null);
var job = vec__25353;
if((job == null)){
cljs.core.async.close_BANG_.call(null,results);

return null;
} else {
var res = cljs.core.async.chan.call(null,(1));
xf.call(null,v,res);

cljs.core.async.put_BANG_.call(null,p,res);

return true;
}
});})(jobs,results,process))
;
var n__9133__auto___25512 = n;
var __25513 = (0);
while(true){
if((__25513 < n__9133__auto___25512)){
var G__25356_25514 = type;
var G__25356_25515__$1 = (((G__25356_25514 instanceof cljs.core.Keyword))?G__25356_25514.fqn:null);
switch (G__25356_25515__$1) {
case "compute":
var c__25187__auto___25517 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (__25513,c__25187__auto___25517,G__25356_25514,G__25356_25515__$1,n__9133__auto___25512,jobs,results,process,async){
return (function (){
var f__25188__auto__ = (function (){var switch__25099__auto__ = ((function (__25513,c__25187__auto___25517,G__25356_25514,G__25356_25515__$1,n__9133__auto___25512,jobs,results,process,async){
return (function (state_25369){
var state_val_25370 = (state_25369[(1)]);
if((state_val_25370 === (1))){
var state_25369__$1 = state_25369;
var statearr_25371_25518 = state_25369__$1;
(statearr_25371_25518[(2)] = null);

(statearr_25371_25518[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25370 === (2))){
var state_25369__$1 = state_25369;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_25369__$1,(4),jobs);
} else {
if((state_val_25370 === (3))){
var inst_25367 = (state_25369[(2)]);
var state_25369__$1 = state_25369;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_25369__$1,inst_25367);
} else {
if((state_val_25370 === (4))){
var inst_25359 = (state_25369[(2)]);
var inst_25360 = process.call(null,inst_25359);
var state_25369__$1 = state_25369;
if(cljs.core.truth_(inst_25360)){
var statearr_25372_25519 = state_25369__$1;
(statearr_25372_25519[(1)] = (5));

} else {
var statearr_25373_25520 = state_25369__$1;
(statearr_25373_25520[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25370 === (5))){
var state_25369__$1 = state_25369;
var statearr_25374_25521 = state_25369__$1;
(statearr_25374_25521[(2)] = null);

(statearr_25374_25521[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25370 === (6))){
var state_25369__$1 = state_25369;
var statearr_25375_25522 = state_25369__$1;
(statearr_25375_25522[(2)] = null);

(statearr_25375_25522[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25370 === (7))){
var inst_25365 = (state_25369[(2)]);
var state_25369__$1 = state_25369;
var statearr_25376_25523 = state_25369__$1;
(statearr_25376_25523[(2)] = inst_25365);

(statearr_25376_25523[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(__25513,c__25187__auto___25517,G__25356_25514,G__25356_25515__$1,n__9133__auto___25512,jobs,results,process,async))
;
return ((function (__25513,switch__25099__auto__,c__25187__auto___25517,G__25356_25514,G__25356_25515__$1,n__9133__auto___25512,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__25100__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__25100__auto____0 = (function (){
var statearr_25377 = [null,null,null,null,null,null,null];
(statearr_25377[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__25100__auto__);

(statearr_25377[(1)] = (1));

return statearr_25377;
});
var cljs$core$async$pipeline_STAR__$_state_machine__25100__auto____1 = (function (state_25369){
while(true){
var ret_value__25101__auto__ = (function (){try{while(true){
var result__25102__auto__ = switch__25099__auto__.call(null,state_25369);
if(cljs.core.keyword_identical_QMARK_.call(null,result__25102__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__25102__auto__;
}
break;
}
}catch (e25378){if((e25378 instanceof Object)){
var ex__25103__auto__ = e25378;
var statearr_25379_25524 = state_25369;
(statearr_25379_25524[(5)] = ex__25103__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_25369);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e25378;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__25101__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__25525 = state_25369;
state_25369 = G__25525;
continue;
} else {
return ret_value__25101__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__25100__auto__ = function(state_25369){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__25100__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__25100__auto____1.call(this,state_25369);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$pipeline_STAR__$_state_machine__25100__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__25100__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__25100__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__25100__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__25100__auto__;
})()
;})(__25513,switch__25099__auto__,c__25187__auto___25517,G__25356_25514,G__25356_25515__$1,n__9133__auto___25512,jobs,results,process,async))
})();
var state__25189__auto__ = (function (){var statearr_25380 = f__25188__auto__.call(null);
(statearr_25380[(6)] = c__25187__auto___25517);

return statearr_25380;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__25189__auto__);
});})(__25513,c__25187__auto___25517,G__25356_25514,G__25356_25515__$1,n__9133__auto___25512,jobs,results,process,async))
);


break;
case "async":
var c__25187__auto___25526 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (__25513,c__25187__auto___25526,G__25356_25514,G__25356_25515__$1,n__9133__auto___25512,jobs,results,process,async){
return (function (){
var f__25188__auto__ = (function (){var switch__25099__auto__ = ((function (__25513,c__25187__auto___25526,G__25356_25514,G__25356_25515__$1,n__9133__auto___25512,jobs,results,process,async){
return (function (state_25393){
var state_val_25394 = (state_25393[(1)]);
if((state_val_25394 === (1))){
var state_25393__$1 = state_25393;
var statearr_25395_25527 = state_25393__$1;
(statearr_25395_25527[(2)] = null);

(statearr_25395_25527[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25394 === (2))){
var state_25393__$1 = state_25393;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_25393__$1,(4),jobs);
} else {
if((state_val_25394 === (3))){
var inst_25391 = (state_25393[(2)]);
var state_25393__$1 = state_25393;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_25393__$1,inst_25391);
} else {
if((state_val_25394 === (4))){
var inst_25383 = (state_25393[(2)]);
var inst_25384 = async.call(null,inst_25383);
var state_25393__$1 = state_25393;
if(cljs.core.truth_(inst_25384)){
var statearr_25396_25528 = state_25393__$1;
(statearr_25396_25528[(1)] = (5));

} else {
var statearr_25397_25529 = state_25393__$1;
(statearr_25397_25529[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25394 === (5))){
var state_25393__$1 = state_25393;
var statearr_25398_25530 = state_25393__$1;
(statearr_25398_25530[(2)] = null);

(statearr_25398_25530[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25394 === (6))){
var state_25393__$1 = state_25393;
var statearr_25399_25531 = state_25393__$1;
(statearr_25399_25531[(2)] = null);

(statearr_25399_25531[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25394 === (7))){
var inst_25389 = (state_25393[(2)]);
var state_25393__$1 = state_25393;
var statearr_25400_25532 = state_25393__$1;
(statearr_25400_25532[(2)] = inst_25389);

(statearr_25400_25532[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(__25513,c__25187__auto___25526,G__25356_25514,G__25356_25515__$1,n__9133__auto___25512,jobs,results,process,async))
;
return ((function (__25513,switch__25099__auto__,c__25187__auto___25526,G__25356_25514,G__25356_25515__$1,n__9133__auto___25512,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__25100__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__25100__auto____0 = (function (){
var statearr_25401 = [null,null,null,null,null,null,null];
(statearr_25401[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__25100__auto__);

(statearr_25401[(1)] = (1));

return statearr_25401;
});
var cljs$core$async$pipeline_STAR__$_state_machine__25100__auto____1 = (function (state_25393){
while(true){
var ret_value__25101__auto__ = (function (){try{while(true){
var result__25102__auto__ = switch__25099__auto__.call(null,state_25393);
if(cljs.core.keyword_identical_QMARK_.call(null,result__25102__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__25102__auto__;
}
break;
}
}catch (e25402){if((e25402 instanceof Object)){
var ex__25103__auto__ = e25402;
var statearr_25403_25533 = state_25393;
(statearr_25403_25533[(5)] = ex__25103__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_25393);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e25402;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__25101__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__25534 = state_25393;
state_25393 = G__25534;
continue;
} else {
return ret_value__25101__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__25100__auto__ = function(state_25393){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__25100__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__25100__auto____1.call(this,state_25393);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$pipeline_STAR__$_state_machine__25100__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__25100__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__25100__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__25100__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__25100__auto__;
})()
;})(__25513,switch__25099__auto__,c__25187__auto___25526,G__25356_25514,G__25356_25515__$1,n__9133__auto___25512,jobs,results,process,async))
})();
var state__25189__auto__ = (function (){var statearr_25404 = f__25188__auto__.call(null);
(statearr_25404[(6)] = c__25187__auto___25526);

return statearr_25404;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__25189__auto__);
});})(__25513,c__25187__auto___25526,G__25356_25514,G__25356_25515__$1,n__9133__auto___25512,jobs,results,process,async))
);


break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__25356_25515__$1)].join('')));

}

var G__25535 = (__25513 + (1));
__25513 = G__25535;
continue;
} else {
}
break;
}

var c__25187__auto___25536 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__25187__auto___25536,jobs,results,process,async){
return (function (){
var f__25188__auto__ = (function (){var switch__25099__auto__ = ((function (c__25187__auto___25536,jobs,results,process,async){
return (function (state_25426){
var state_val_25427 = (state_25426[(1)]);
if((state_val_25427 === (1))){
var state_25426__$1 = state_25426;
var statearr_25428_25537 = state_25426__$1;
(statearr_25428_25537[(2)] = null);

(statearr_25428_25537[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25427 === (2))){
var state_25426__$1 = state_25426;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_25426__$1,(4),from);
} else {
if((state_val_25427 === (3))){
var inst_25424 = (state_25426[(2)]);
var state_25426__$1 = state_25426;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_25426__$1,inst_25424);
} else {
if((state_val_25427 === (4))){
var inst_25407 = (state_25426[(7)]);
var inst_25407__$1 = (state_25426[(2)]);
var inst_25408 = (inst_25407__$1 == null);
var state_25426__$1 = (function (){var statearr_25429 = state_25426;
(statearr_25429[(7)] = inst_25407__$1);

return statearr_25429;
})();
if(cljs.core.truth_(inst_25408)){
var statearr_25430_25538 = state_25426__$1;
(statearr_25430_25538[(1)] = (5));

} else {
var statearr_25431_25539 = state_25426__$1;
(statearr_25431_25539[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25427 === (5))){
var inst_25410 = cljs.core.async.close_BANG_.call(null,jobs);
var state_25426__$1 = state_25426;
var statearr_25432_25540 = state_25426__$1;
(statearr_25432_25540[(2)] = inst_25410);

(statearr_25432_25540[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25427 === (6))){
var inst_25412 = (state_25426[(8)]);
var inst_25407 = (state_25426[(7)]);
var inst_25412__$1 = cljs.core.async.chan.call(null,(1));
var inst_25413 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_25414 = [inst_25407,inst_25412__$1];
var inst_25415 = (new cljs.core.PersistentVector(null,2,(5),inst_25413,inst_25414,null));
var state_25426__$1 = (function (){var statearr_25433 = state_25426;
(statearr_25433[(8)] = inst_25412__$1);

return statearr_25433;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_25426__$1,(8),jobs,inst_25415);
} else {
if((state_val_25427 === (7))){
var inst_25422 = (state_25426[(2)]);
var state_25426__$1 = state_25426;
var statearr_25434_25541 = state_25426__$1;
(statearr_25434_25541[(2)] = inst_25422);

(statearr_25434_25541[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25427 === (8))){
var inst_25412 = (state_25426[(8)]);
var inst_25417 = (state_25426[(2)]);
var state_25426__$1 = (function (){var statearr_25435 = state_25426;
(statearr_25435[(9)] = inst_25417);

return statearr_25435;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_25426__$1,(9),results,inst_25412);
} else {
if((state_val_25427 === (9))){
var inst_25419 = (state_25426[(2)]);
var state_25426__$1 = (function (){var statearr_25436 = state_25426;
(statearr_25436[(10)] = inst_25419);

return statearr_25436;
})();
var statearr_25437_25542 = state_25426__$1;
(statearr_25437_25542[(2)] = null);

(statearr_25437_25542[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});})(c__25187__auto___25536,jobs,results,process,async))
;
return ((function (switch__25099__auto__,c__25187__auto___25536,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__25100__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__25100__auto____0 = (function (){
var statearr_25438 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_25438[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__25100__auto__);

(statearr_25438[(1)] = (1));

return statearr_25438;
});
var cljs$core$async$pipeline_STAR__$_state_machine__25100__auto____1 = (function (state_25426){
while(true){
var ret_value__25101__auto__ = (function (){try{while(true){
var result__25102__auto__ = switch__25099__auto__.call(null,state_25426);
if(cljs.core.keyword_identical_QMARK_.call(null,result__25102__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__25102__auto__;
}
break;
}
}catch (e25439){if((e25439 instanceof Object)){
var ex__25103__auto__ = e25439;
var statearr_25440_25543 = state_25426;
(statearr_25440_25543[(5)] = ex__25103__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_25426);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e25439;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__25101__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__25544 = state_25426;
state_25426 = G__25544;
continue;
} else {
return ret_value__25101__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__25100__auto__ = function(state_25426){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__25100__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__25100__auto____1.call(this,state_25426);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$pipeline_STAR__$_state_machine__25100__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__25100__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__25100__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__25100__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__25100__auto__;
})()
;})(switch__25099__auto__,c__25187__auto___25536,jobs,results,process,async))
})();
var state__25189__auto__ = (function (){var statearr_25441 = f__25188__auto__.call(null);
(statearr_25441[(6)] = c__25187__auto___25536);

return statearr_25441;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__25189__auto__);
});})(c__25187__auto___25536,jobs,results,process,async))
);


var c__25187__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__25187__auto__,jobs,results,process,async){
return (function (){
var f__25188__auto__ = (function (){var switch__25099__auto__ = ((function (c__25187__auto__,jobs,results,process,async){
return (function (state_25479){
var state_val_25480 = (state_25479[(1)]);
if((state_val_25480 === (7))){
var inst_25475 = (state_25479[(2)]);
var state_25479__$1 = state_25479;
var statearr_25481_25545 = state_25479__$1;
(statearr_25481_25545[(2)] = inst_25475);

(statearr_25481_25545[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25480 === (20))){
var state_25479__$1 = state_25479;
var statearr_25482_25546 = state_25479__$1;
(statearr_25482_25546[(2)] = null);

(statearr_25482_25546[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25480 === (1))){
var state_25479__$1 = state_25479;
var statearr_25483_25547 = state_25479__$1;
(statearr_25483_25547[(2)] = null);

(statearr_25483_25547[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25480 === (4))){
var inst_25444 = (state_25479[(7)]);
var inst_25444__$1 = (state_25479[(2)]);
var inst_25445 = (inst_25444__$1 == null);
var state_25479__$1 = (function (){var statearr_25484 = state_25479;
(statearr_25484[(7)] = inst_25444__$1);

return statearr_25484;
})();
if(cljs.core.truth_(inst_25445)){
var statearr_25485_25548 = state_25479__$1;
(statearr_25485_25548[(1)] = (5));

} else {
var statearr_25486_25549 = state_25479__$1;
(statearr_25486_25549[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25480 === (15))){
var inst_25457 = (state_25479[(8)]);
var state_25479__$1 = state_25479;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_25479__$1,(18),to,inst_25457);
} else {
if((state_val_25480 === (21))){
var inst_25470 = (state_25479[(2)]);
var state_25479__$1 = state_25479;
var statearr_25487_25550 = state_25479__$1;
(statearr_25487_25550[(2)] = inst_25470);

(statearr_25487_25550[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25480 === (13))){
var inst_25472 = (state_25479[(2)]);
var state_25479__$1 = (function (){var statearr_25488 = state_25479;
(statearr_25488[(9)] = inst_25472);

return statearr_25488;
})();
var statearr_25489_25551 = state_25479__$1;
(statearr_25489_25551[(2)] = null);

(statearr_25489_25551[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25480 === (6))){
var inst_25444 = (state_25479[(7)]);
var state_25479__$1 = state_25479;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_25479__$1,(11),inst_25444);
} else {
if((state_val_25480 === (17))){
var inst_25465 = (state_25479[(2)]);
var state_25479__$1 = state_25479;
if(cljs.core.truth_(inst_25465)){
var statearr_25490_25552 = state_25479__$1;
(statearr_25490_25552[(1)] = (19));

} else {
var statearr_25491_25553 = state_25479__$1;
(statearr_25491_25553[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25480 === (3))){
var inst_25477 = (state_25479[(2)]);
var state_25479__$1 = state_25479;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_25479__$1,inst_25477);
} else {
if((state_val_25480 === (12))){
var inst_25454 = (state_25479[(10)]);
var state_25479__$1 = state_25479;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_25479__$1,(14),inst_25454);
} else {
if((state_val_25480 === (2))){
var state_25479__$1 = state_25479;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_25479__$1,(4),results);
} else {
if((state_val_25480 === (19))){
var state_25479__$1 = state_25479;
var statearr_25492_25554 = state_25479__$1;
(statearr_25492_25554[(2)] = null);

(statearr_25492_25554[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25480 === (11))){
var inst_25454 = (state_25479[(2)]);
var state_25479__$1 = (function (){var statearr_25493 = state_25479;
(statearr_25493[(10)] = inst_25454);

return statearr_25493;
})();
var statearr_25494_25555 = state_25479__$1;
(statearr_25494_25555[(2)] = null);

(statearr_25494_25555[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25480 === (9))){
var state_25479__$1 = state_25479;
var statearr_25495_25556 = state_25479__$1;
(statearr_25495_25556[(2)] = null);

(statearr_25495_25556[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25480 === (5))){
var state_25479__$1 = state_25479;
if(cljs.core.truth_(close_QMARK_)){
var statearr_25496_25557 = state_25479__$1;
(statearr_25496_25557[(1)] = (8));

} else {
var statearr_25497_25558 = state_25479__$1;
(statearr_25497_25558[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25480 === (14))){
var inst_25459 = (state_25479[(11)]);
var inst_25457 = (state_25479[(8)]);
var inst_25457__$1 = (state_25479[(2)]);
var inst_25458 = (inst_25457__$1 == null);
var inst_25459__$1 = cljs.core.not.call(null,inst_25458);
var state_25479__$1 = (function (){var statearr_25498 = state_25479;
(statearr_25498[(11)] = inst_25459__$1);

(statearr_25498[(8)] = inst_25457__$1);

return statearr_25498;
})();
if(inst_25459__$1){
var statearr_25499_25559 = state_25479__$1;
(statearr_25499_25559[(1)] = (15));

} else {
var statearr_25500_25560 = state_25479__$1;
(statearr_25500_25560[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25480 === (16))){
var inst_25459 = (state_25479[(11)]);
var state_25479__$1 = state_25479;
var statearr_25501_25561 = state_25479__$1;
(statearr_25501_25561[(2)] = inst_25459);

(statearr_25501_25561[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25480 === (10))){
var inst_25451 = (state_25479[(2)]);
var state_25479__$1 = state_25479;
var statearr_25502_25562 = state_25479__$1;
(statearr_25502_25562[(2)] = inst_25451);

(statearr_25502_25562[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25480 === (18))){
var inst_25462 = (state_25479[(2)]);
var state_25479__$1 = state_25479;
var statearr_25503_25563 = state_25479__$1;
(statearr_25503_25563[(2)] = inst_25462);

(statearr_25503_25563[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25480 === (8))){
var inst_25448 = cljs.core.async.close_BANG_.call(null,to);
var state_25479__$1 = state_25479;
var statearr_25504_25564 = state_25479__$1;
(statearr_25504_25564[(2)] = inst_25448);

(statearr_25504_25564[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__25187__auto__,jobs,results,process,async))
;
return ((function (switch__25099__auto__,c__25187__auto__,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__25100__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__25100__auto____0 = (function (){
var statearr_25505 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_25505[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__25100__auto__);

(statearr_25505[(1)] = (1));

return statearr_25505;
});
var cljs$core$async$pipeline_STAR__$_state_machine__25100__auto____1 = (function (state_25479){
while(true){
var ret_value__25101__auto__ = (function (){try{while(true){
var result__25102__auto__ = switch__25099__auto__.call(null,state_25479);
if(cljs.core.keyword_identical_QMARK_.call(null,result__25102__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__25102__auto__;
}
break;
}
}catch (e25506){if((e25506 instanceof Object)){
var ex__25103__auto__ = e25506;
var statearr_25507_25565 = state_25479;
(statearr_25507_25565[(5)] = ex__25103__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_25479);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e25506;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__25101__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__25566 = state_25479;
state_25479 = G__25566;
continue;
} else {
return ret_value__25101__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__25100__auto__ = function(state_25479){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__25100__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__25100__auto____1.call(this,state_25479);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$pipeline_STAR__$_state_machine__25100__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__25100__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__25100__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__25100__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__25100__auto__;
})()
;})(switch__25099__auto__,c__25187__auto__,jobs,results,process,async))
})();
var state__25189__auto__ = (function (){var statearr_25508 = f__25188__auto__.call(null);
(statearr_25508[(6)] = c__25187__auto__);

return statearr_25508;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__25189__auto__);
});})(c__25187__auto__,jobs,results,process,async))
);

return c__25187__auto__;
});
/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the async function af, with parallelism n. af
 *   must be a function of two arguments, the first an input value and
 *   the second a channel on which to place the result(s). af must close!
 *   the channel before returning.  The presumption is that af will
 *   return immediately, having launched some asynchronous operation
 *   whose completion/callback will manipulate the result channel. Outputs
 *   will be returned in order relative to  the inputs. By default, the to
 *   channel will be closed when the from channel closes, but can be
 *   determined by the close?  parameter. Will stop consuming the from
 *   channel if the to channel closes.
 */
cljs.core.async.pipeline_async = (function cljs$core$async$pipeline_async(var_args){
var G__25568 = arguments.length;
switch (G__25568) {
case 4:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4 = (function (n,to,af,from){
return cljs.core.async.pipeline_async.call(null,n,to,af,from,true);
});

cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5 = (function (n,to,af,from,close_QMARK_){
return cljs.core.async.pipeline_STAR_.call(null,n,to,af,from,close_QMARK_,null,new cljs.core.Keyword(null,"async","async",1050769601));
});

cljs.core.async.pipeline_async.cljs$lang$maxFixedArity = 5;

/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the transducer xf, with parallelism n. Because
 *   it is parallel, the transducer will be applied independently to each
 *   element, not across elements, and may produce zero or more outputs
 *   per input.  Outputs will be returned in order relative to the
 *   inputs. By default, the to channel will be closed when the from
 *   channel closes, but can be determined by the close?  parameter. Will
 *   stop consuming the from channel if the to channel closes.
 * 
 *   Note this is supplied for API compatibility with the Clojure version.
 *   Values of N > 1 will not result in actual concurrency in a
 *   single-threaded runtime.
 */
cljs.core.async.pipeline = (function cljs$core$async$pipeline(var_args){
var G__25571 = arguments.length;
switch (G__25571) {
case 4:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4 = (function (n,to,xf,from){
return cljs.core.async.pipeline.call(null,n,to,xf,from,true);
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5 = (function (n,to,xf,from,close_QMARK_){
return cljs.core.async.pipeline.call(null,n,to,xf,from,close_QMARK_,null);
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6 = (function (n,to,xf,from,close_QMARK_,ex_handler){
return cljs.core.async.pipeline_STAR_.call(null,n,to,xf,from,close_QMARK_,ex_handler,new cljs.core.Keyword(null,"compute","compute",1555393130));
});

cljs.core.async.pipeline.cljs$lang$maxFixedArity = 6;

/**
 * Takes a predicate and a source channel and returns a vector of two
 *   channels, the first of which will contain the values for which the
 *   predicate returned true, the second those for which it returned
 *   false.
 * 
 *   The out channels will be unbuffered by default, or two buf-or-ns can
 *   be supplied. The channels will close after the source channel has
 *   closed.
 */
cljs.core.async.split = (function cljs$core$async$split(var_args){
var G__25574 = arguments.length;
switch (G__25574) {
case 2:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 4:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.split.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.split.call(null,p,ch,null,null);
});

cljs.core.async.split.cljs$core$IFn$_invoke$arity$4 = (function (p,ch,t_buf_or_n,f_buf_or_n){
var tc = cljs.core.async.chan.call(null,t_buf_or_n);
var fc = cljs.core.async.chan.call(null,f_buf_or_n);
var c__25187__auto___25623 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__25187__auto___25623,tc,fc){
return (function (){
var f__25188__auto__ = (function (){var switch__25099__auto__ = ((function (c__25187__auto___25623,tc,fc){
return (function (state_25600){
var state_val_25601 = (state_25600[(1)]);
if((state_val_25601 === (7))){
var inst_25596 = (state_25600[(2)]);
var state_25600__$1 = state_25600;
var statearr_25602_25624 = state_25600__$1;
(statearr_25602_25624[(2)] = inst_25596);

(statearr_25602_25624[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25601 === (1))){
var state_25600__$1 = state_25600;
var statearr_25603_25625 = state_25600__$1;
(statearr_25603_25625[(2)] = null);

(statearr_25603_25625[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25601 === (4))){
var inst_25577 = (state_25600[(7)]);
var inst_25577__$1 = (state_25600[(2)]);
var inst_25578 = (inst_25577__$1 == null);
var state_25600__$1 = (function (){var statearr_25604 = state_25600;
(statearr_25604[(7)] = inst_25577__$1);

return statearr_25604;
})();
if(cljs.core.truth_(inst_25578)){
var statearr_25605_25626 = state_25600__$1;
(statearr_25605_25626[(1)] = (5));

} else {
var statearr_25606_25627 = state_25600__$1;
(statearr_25606_25627[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25601 === (13))){
var state_25600__$1 = state_25600;
var statearr_25607_25628 = state_25600__$1;
(statearr_25607_25628[(2)] = null);

(statearr_25607_25628[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25601 === (6))){
var inst_25577 = (state_25600[(7)]);
var inst_25583 = p.call(null,inst_25577);
var state_25600__$1 = state_25600;
if(cljs.core.truth_(inst_25583)){
var statearr_25608_25629 = state_25600__$1;
(statearr_25608_25629[(1)] = (9));

} else {
var statearr_25609_25630 = state_25600__$1;
(statearr_25609_25630[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25601 === (3))){
var inst_25598 = (state_25600[(2)]);
var state_25600__$1 = state_25600;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_25600__$1,inst_25598);
} else {
if((state_val_25601 === (12))){
var state_25600__$1 = state_25600;
var statearr_25610_25631 = state_25600__$1;
(statearr_25610_25631[(2)] = null);

(statearr_25610_25631[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25601 === (2))){
var state_25600__$1 = state_25600;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_25600__$1,(4),ch);
} else {
if((state_val_25601 === (11))){
var inst_25577 = (state_25600[(7)]);
var inst_25587 = (state_25600[(2)]);
var state_25600__$1 = state_25600;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_25600__$1,(8),inst_25587,inst_25577);
} else {
if((state_val_25601 === (9))){
var state_25600__$1 = state_25600;
var statearr_25611_25632 = state_25600__$1;
(statearr_25611_25632[(2)] = tc);

(statearr_25611_25632[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25601 === (5))){
var inst_25580 = cljs.core.async.close_BANG_.call(null,tc);
var inst_25581 = cljs.core.async.close_BANG_.call(null,fc);
var state_25600__$1 = (function (){var statearr_25612 = state_25600;
(statearr_25612[(8)] = inst_25580);

return statearr_25612;
})();
var statearr_25613_25633 = state_25600__$1;
(statearr_25613_25633[(2)] = inst_25581);

(statearr_25613_25633[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25601 === (14))){
var inst_25594 = (state_25600[(2)]);
var state_25600__$1 = state_25600;
var statearr_25614_25634 = state_25600__$1;
(statearr_25614_25634[(2)] = inst_25594);

(statearr_25614_25634[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25601 === (10))){
var state_25600__$1 = state_25600;
var statearr_25615_25635 = state_25600__$1;
(statearr_25615_25635[(2)] = fc);

(statearr_25615_25635[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25601 === (8))){
var inst_25589 = (state_25600[(2)]);
var state_25600__$1 = state_25600;
if(cljs.core.truth_(inst_25589)){
var statearr_25616_25636 = state_25600__$1;
(statearr_25616_25636[(1)] = (12));

} else {
var statearr_25617_25637 = state_25600__$1;
(statearr_25617_25637[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__25187__auto___25623,tc,fc))
;
return ((function (switch__25099__auto__,c__25187__auto___25623,tc,fc){
return (function() {
var cljs$core$async$state_machine__25100__auto__ = null;
var cljs$core$async$state_machine__25100__auto____0 = (function (){
var statearr_25618 = [null,null,null,null,null,null,null,null,null];
(statearr_25618[(0)] = cljs$core$async$state_machine__25100__auto__);

(statearr_25618[(1)] = (1));

return statearr_25618;
});
var cljs$core$async$state_machine__25100__auto____1 = (function (state_25600){
while(true){
var ret_value__25101__auto__ = (function (){try{while(true){
var result__25102__auto__ = switch__25099__auto__.call(null,state_25600);
if(cljs.core.keyword_identical_QMARK_.call(null,result__25102__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__25102__auto__;
}
break;
}
}catch (e25619){if((e25619 instanceof Object)){
var ex__25103__auto__ = e25619;
var statearr_25620_25638 = state_25600;
(statearr_25620_25638[(5)] = ex__25103__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_25600);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e25619;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__25101__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__25639 = state_25600;
state_25600 = G__25639;
continue;
} else {
return ret_value__25101__auto__;
}
break;
}
});
cljs$core$async$state_machine__25100__auto__ = function(state_25600){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__25100__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__25100__auto____1.call(this,state_25600);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$state_machine__25100__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__25100__auto____0;
cljs$core$async$state_machine__25100__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__25100__auto____1;
return cljs$core$async$state_machine__25100__auto__;
})()
;})(switch__25099__auto__,c__25187__auto___25623,tc,fc))
})();
var state__25189__auto__ = (function (){var statearr_25621 = f__25188__auto__.call(null);
(statearr_25621[(6)] = c__25187__auto___25623);

return statearr_25621;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__25189__auto__);
});})(c__25187__auto___25623,tc,fc))
);


return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [tc,fc], null);
});

cljs.core.async.split.cljs$lang$maxFixedArity = 4;

/**
 * f should be a function of 2 arguments. Returns a channel containing
 *   the single result of applying f to init and the first item from the
 *   channel, then applying f to that result and the 2nd item, etc. If
 *   the channel closes without yielding items, returns init and f is not
 *   called. ch must close before reduce produces a result.
 */
cljs.core.async.reduce = (function cljs$core$async$reduce(f,init,ch){
var c__25187__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__25187__auto__){
return (function (){
var f__25188__auto__ = (function (){var switch__25099__auto__ = ((function (c__25187__auto__){
return (function (state_25660){
var state_val_25661 = (state_25660[(1)]);
if((state_val_25661 === (7))){
var inst_25656 = (state_25660[(2)]);
var state_25660__$1 = state_25660;
var statearr_25662_25680 = state_25660__$1;
(statearr_25662_25680[(2)] = inst_25656);

(statearr_25662_25680[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25661 === (1))){
var inst_25640 = init;
var state_25660__$1 = (function (){var statearr_25663 = state_25660;
(statearr_25663[(7)] = inst_25640);

return statearr_25663;
})();
var statearr_25664_25681 = state_25660__$1;
(statearr_25664_25681[(2)] = null);

(statearr_25664_25681[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25661 === (4))){
var inst_25643 = (state_25660[(8)]);
var inst_25643__$1 = (state_25660[(2)]);
var inst_25644 = (inst_25643__$1 == null);
var state_25660__$1 = (function (){var statearr_25665 = state_25660;
(statearr_25665[(8)] = inst_25643__$1);

return statearr_25665;
})();
if(cljs.core.truth_(inst_25644)){
var statearr_25666_25682 = state_25660__$1;
(statearr_25666_25682[(1)] = (5));

} else {
var statearr_25667_25683 = state_25660__$1;
(statearr_25667_25683[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25661 === (6))){
var inst_25647 = (state_25660[(9)]);
var inst_25640 = (state_25660[(7)]);
var inst_25643 = (state_25660[(8)]);
var inst_25647__$1 = f.call(null,inst_25640,inst_25643);
var inst_25648 = cljs.core.reduced_QMARK_.call(null,inst_25647__$1);
var state_25660__$1 = (function (){var statearr_25668 = state_25660;
(statearr_25668[(9)] = inst_25647__$1);

return statearr_25668;
})();
if(inst_25648){
var statearr_25669_25684 = state_25660__$1;
(statearr_25669_25684[(1)] = (8));

} else {
var statearr_25670_25685 = state_25660__$1;
(statearr_25670_25685[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25661 === (3))){
var inst_25658 = (state_25660[(2)]);
var state_25660__$1 = state_25660;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_25660__$1,inst_25658);
} else {
if((state_val_25661 === (2))){
var state_25660__$1 = state_25660;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_25660__$1,(4),ch);
} else {
if((state_val_25661 === (9))){
var inst_25647 = (state_25660[(9)]);
var inst_25640 = inst_25647;
var state_25660__$1 = (function (){var statearr_25671 = state_25660;
(statearr_25671[(7)] = inst_25640);

return statearr_25671;
})();
var statearr_25672_25686 = state_25660__$1;
(statearr_25672_25686[(2)] = null);

(statearr_25672_25686[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25661 === (5))){
var inst_25640 = (state_25660[(7)]);
var state_25660__$1 = state_25660;
var statearr_25673_25687 = state_25660__$1;
(statearr_25673_25687[(2)] = inst_25640);

(statearr_25673_25687[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25661 === (10))){
var inst_25654 = (state_25660[(2)]);
var state_25660__$1 = state_25660;
var statearr_25674_25688 = state_25660__$1;
(statearr_25674_25688[(2)] = inst_25654);

(statearr_25674_25688[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25661 === (8))){
var inst_25647 = (state_25660[(9)]);
var inst_25650 = cljs.core.deref.call(null,inst_25647);
var state_25660__$1 = state_25660;
var statearr_25675_25689 = state_25660__$1;
(statearr_25675_25689[(2)] = inst_25650);

(statearr_25675_25689[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});})(c__25187__auto__))
;
return ((function (switch__25099__auto__,c__25187__auto__){
return (function() {
var cljs$core$async$reduce_$_state_machine__25100__auto__ = null;
var cljs$core$async$reduce_$_state_machine__25100__auto____0 = (function (){
var statearr_25676 = [null,null,null,null,null,null,null,null,null,null];
(statearr_25676[(0)] = cljs$core$async$reduce_$_state_machine__25100__auto__);

(statearr_25676[(1)] = (1));

return statearr_25676;
});
var cljs$core$async$reduce_$_state_machine__25100__auto____1 = (function (state_25660){
while(true){
var ret_value__25101__auto__ = (function (){try{while(true){
var result__25102__auto__ = switch__25099__auto__.call(null,state_25660);
if(cljs.core.keyword_identical_QMARK_.call(null,result__25102__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__25102__auto__;
}
break;
}
}catch (e25677){if((e25677 instanceof Object)){
var ex__25103__auto__ = e25677;
var statearr_25678_25690 = state_25660;
(statearr_25678_25690[(5)] = ex__25103__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_25660);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e25677;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__25101__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__25691 = state_25660;
state_25660 = G__25691;
continue;
} else {
return ret_value__25101__auto__;
}
break;
}
});
cljs$core$async$reduce_$_state_machine__25100__auto__ = function(state_25660){
switch(arguments.length){
case 0:
return cljs$core$async$reduce_$_state_machine__25100__auto____0.call(this);
case 1:
return cljs$core$async$reduce_$_state_machine__25100__auto____1.call(this,state_25660);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$reduce_$_state_machine__25100__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$reduce_$_state_machine__25100__auto____0;
cljs$core$async$reduce_$_state_machine__25100__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$reduce_$_state_machine__25100__auto____1;
return cljs$core$async$reduce_$_state_machine__25100__auto__;
})()
;})(switch__25099__auto__,c__25187__auto__))
})();
var state__25189__auto__ = (function (){var statearr_25679 = f__25188__auto__.call(null);
(statearr_25679[(6)] = c__25187__auto__);

return statearr_25679;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__25189__auto__);
});})(c__25187__auto__))
);

return c__25187__auto__;
});
/**
 * async/reduces a channel with a transformation (xform f).
 *   Returns a channel containing the result.  ch must close before
 *   transduce produces a result.
 */
cljs.core.async.transduce = (function cljs$core$async$transduce(xform,f,init,ch){
var f__$1 = xform.call(null,f);
var c__25187__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__25187__auto__,f__$1){
return (function (){
var f__25188__auto__ = (function (){var switch__25099__auto__ = ((function (c__25187__auto__,f__$1){
return (function (state_25697){
var state_val_25698 = (state_25697[(1)]);
if((state_val_25698 === (1))){
var inst_25692 = cljs.core.async.reduce.call(null,f__$1,init,ch);
var state_25697__$1 = state_25697;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_25697__$1,(2),inst_25692);
} else {
if((state_val_25698 === (2))){
var inst_25694 = (state_25697[(2)]);
var inst_25695 = f__$1.call(null,inst_25694);
var state_25697__$1 = state_25697;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_25697__$1,inst_25695);
} else {
return null;
}
}
});})(c__25187__auto__,f__$1))
;
return ((function (switch__25099__auto__,c__25187__auto__,f__$1){
return (function() {
var cljs$core$async$transduce_$_state_machine__25100__auto__ = null;
var cljs$core$async$transduce_$_state_machine__25100__auto____0 = (function (){
var statearr_25699 = [null,null,null,null,null,null,null];
(statearr_25699[(0)] = cljs$core$async$transduce_$_state_machine__25100__auto__);

(statearr_25699[(1)] = (1));

return statearr_25699;
});
var cljs$core$async$transduce_$_state_machine__25100__auto____1 = (function (state_25697){
while(true){
var ret_value__25101__auto__ = (function (){try{while(true){
var result__25102__auto__ = switch__25099__auto__.call(null,state_25697);
if(cljs.core.keyword_identical_QMARK_.call(null,result__25102__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__25102__auto__;
}
break;
}
}catch (e25700){if((e25700 instanceof Object)){
var ex__25103__auto__ = e25700;
var statearr_25701_25703 = state_25697;
(statearr_25701_25703[(5)] = ex__25103__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_25697);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e25700;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__25101__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__25704 = state_25697;
state_25697 = G__25704;
continue;
} else {
return ret_value__25101__auto__;
}
break;
}
});
cljs$core$async$transduce_$_state_machine__25100__auto__ = function(state_25697){
switch(arguments.length){
case 0:
return cljs$core$async$transduce_$_state_machine__25100__auto____0.call(this);
case 1:
return cljs$core$async$transduce_$_state_machine__25100__auto____1.call(this,state_25697);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$transduce_$_state_machine__25100__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$transduce_$_state_machine__25100__auto____0;
cljs$core$async$transduce_$_state_machine__25100__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$transduce_$_state_machine__25100__auto____1;
return cljs$core$async$transduce_$_state_machine__25100__auto__;
})()
;})(switch__25099__auto__,c__25187__auto__,f__$1))
})();
var state__25189__auto__ = (function (){var statearr_25702 = f__25188__auto__.call(null);
(statearr_25702[(6)] = c__25187__auto__);

return statearr_25702;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__25189__auto__);
});})(c__25187__auto__,f__$1))
);

return c__25187__auto__;
});
/**
 * Puts the contents of coll into the supplied channel.
 * 
 *   By default the channel will be closed after the items are copied,
 *   but can be determined by the close? parameter.
 * 
 *   Returns a channel which will close after the items are copied.
 */
cljs.core.async.onto_chan = (function cljs$core$async$onto_chan(var_args){
var G__25706 = arguments.length;
switch (G__25706) {
case 2:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2 = (function (ch,coll){
return cljs.core.async.onto_chan.call(null,ch,coll,true);
});

cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3 = (function (ch,coll,close_QMARK_){
var c__25187__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__25187__auto__){
return (function (){
var f__25188__auto__ = (function (){var switch__25099__auto__ = ((function (c__25187__auto__){
return (function (state_25731){
var state_val_25732 = (state_25731[(1)]);
if((state_val_25732 === (7))){
var inst_25713 = (state_25731[(2)]);
var state_25731__$1 = state_25731;
var statearr_25733_25754 = state_25731__$1;
(statearr_25733_25754[(2)] = inst_25713);

(statearr_25733_25754[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25732 === (1))){
var inst_25707 = cljs.core.seq.call(null,coll);
var inst_25708 = inst_25707;
var state_25731__$1 = (function (){var statearr_25734 = state_25731;
(statearr_25734[(7)] = inst_25708);

return statearr_25734;
})();
var statearr_25735_25755 = state_25731__$1;
(statearr_25735_25755[(2)] = null);

(statearr_25735_25755[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25732 === (4))){
var inst_25708 = (state_25731[(7)]);
var inst_25711 = cljs.core.first.call(null,inst_25708);
var state_25731__$1 = state_25731;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_25731__$1,(7),ch,inst_25711);
} else {
if((state_val_25732 === (13))){
var inst_25725 = (state_25731[(2)]);
var state_25731__$1 = state_25731;
var statearr_25736_25756 = state_25731__$1;
(statearr_25736_25756[(2)] = inst_25725);

(statearr_25736_25756[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25732 === (6))){
var inst_25716 = (state_25731[(2)]);
var state_25731__$1 = state_25731;
if(cljs.core.truth_(inst_25716)){
var statearr_25737_25757 = state_25731__$1;
(statearr_25737_25757[(1)] = (8));

} else {
var statearr_25738_25758 = state_25731__$1;
(statearr_25738_25758[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25732 === (3))){
var inst_25729 = (state_25731[(2)]);
var state_25731__$1 = state_25731;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_25731__$1,inst_25729);
} else {
if((state_val_25732 === (12))){
var state_25731__$1 = state_25731;
var statearr_25739_25759 = state_25731__$1;
(statearr_25739_25759[(2)] = null);

(statearr_25739_25759[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25732 === (2))){
var inst_25708 = (state_25731[(7)]);
var state_25731__$1 = state_25731;
if(cljs.core.truth_(inst_25708)){
var statearr_25740_25760 = state_25731__$1;
(statearr_25740_25760[(1)] = (4));

} else {
var statearr_25741_25761 = state_25731__$1;
(statearr_25741_25761[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25732 === (11))){
var inst_25722 = cljs.core.async.close_BANG_.call(null,ch);
var state_25731__$1 = state_25731;
var statearr_25742_25762 = state_25731__$1;
(statearr_25742_25762[(2)] = inst_25722);

(statearr_25742_25762[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25732 === (9))){
var state_25731__$1 = state_25731;
if(cljs.core.truth_(close_QMARK_)){
var statearr_25743_25763 = state_25731__$1;
(statearr_25743_25763[(1)] = (11));

} else {
var statearr_25744_25764 = state_25731__$1;
(statearr_25744_25764[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25732 === (5))){
var inst_25708 = (state_25731[(7)]);
var state_25731__$1 = state_25731;
var statearr_25745_25765 = state_25731__$1;
(statearr_25745_25765[(2)] = inst_25708);

(statearr_25745_25765[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25732 === (10))){
var inst_25727 = (state_25731[(2)]);
var state_25731__$1 = state_25731;
var statearr_25746_25766 = state_25731__$1;
(statearr_25746_25766[(2)] = inst_25727);

(statearr_25746_25766[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25732 === (8))){
var inst_25708 = (state_25731[(7)]);
var inst_25718 = cljs.core.next.call(null,inst_25708);
var inst_25708__$1 = inst_25718;
var state_25731__$1 = (function (){var statearr_25747 = state_25731;
(statearr_25747[(7)] = inst_25708__$1);

return statearr_25747;
})();
var statearr_25748_25767 = state_25731__$1;
(statearr_25748_25767[(2)] = null);

(statearr_25748_25767[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__25187__auto__))
;
return ((function (switch__25099__auto__,c__25187__auto__){
return (function() {
var cljs$core$async$state_machine__25100__auto__ = null;
var cljs$core$async$state_machine__25100__auto____0 = (function (){
var statearr_25749 = [null,null,null,null,null,null,null,null];
(statearr_25749[(0)] = cljs$core$async$state_machine__25100__auto__);

(statearr_25749[(1)] = (1));

return statearr_25749;
});
var cljs$core$async$state_machine__25100__auto____1 = (function (state_25731){
while(true){
var ret_value__25101__auto__ = (function (){try{while(true){
var result__25102__auto__ = switch__25099__auto__.call(null,state_25731);
if(cljs.core.keyword_identical_QMARK_.call(null,result__25102__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__25102__auto__;
}
break;
}
}catch (e25750){if((e25750 instanceof Object)){
var ex__25103__auto__ = e25750;
var statearr_25751_25768 = state_25731;
(statearr_25751_25768[(5)] = ex__25103__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_25731);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e25750;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__25101__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__25769 = state_25731;
state_25731 = G__25769;
continue;
} else {
return ret_value__25101__auto__;
}
break;
}
});
cljs$core$async$state_machine__25100__auto__ = function(state_25731){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__25100__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__25100__auto____1.call(this,state_25731);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$state_machine__25100__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__25100__auto____0;
cljs$core$async$state_machine__25100__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__25100__auto____1;
return cljs$core$async$state_machine__25100__auto__;
})()
;})(switch__25099__auto__,c__25187__auto__))
})();
var state__25189__auto__ = (function (){var statearr_25752 = f__25188__auto__.call(null);
(statearr_25752[(6)] = c__25187__auto__);

return statearr_25752;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__25189__auto__);
});})(c__25187__auto__))
);

return c__25187__auto__;
});

cljs.core.async.onto_chan.cljs$lang$maxFixedArity = 3;

/**
 * Creates and returns a channel which contains the contents of coll,
 *   closing when exhausted.
 */
cljs.core.async.to_chan = (function cljs$core$async$to_chan(coll){
var ch = cljs.core.async.chan.call(null,cljs.core.bounded_count.call(null,(100),coll));
cljs.core.async.onto_chan.call(null,ch,coll);

return ch;
});

/**
 * @interface
 */
cljs.core.async.Mux = function(){};

cljs.core.async.muxch_STAR_ = (function cljs$core$async$muxch_STAR_(_){
if((!((_ == null))) && (!((_.cljs$core$async$Mux$muxch_STAR_$arity$1 == null)))){
return _.cljs$core$async$Mux$muxch_STAR_$arity$1(_);
} else {
var x__8869__auto__ = (((_ == null))?null:_);
var m__8870__auto__ = (cljs.core.async.muxch_STAR_[goog.typeOf(x__8869__auto__)]);
if(!((m__8870__auto__ == null))){
return m__8870__auto__.call(null,_);
} else {
var m__8870__auto____$1 = (cljs.core.async.muxch_STAR_["_"]);
if(!((m__8870__auto____$1 == null))){
return m__8870__auto____$1.call(null,_);
} else {
throw cljs.core.missing_protocol.call(null,"Mux.muxch*",_);
}
}
}
});


/**
 * @interface
 */
cljs.core.async.Mult = function(){};

cljs.core.async.tap_STAR_ = (function cljs$core$async$tap_STAR_(m,ch,close_QMARK_){
if((!((m == null))) && (!((m.cljs$core$async$Mult$tap_STAR_$arity$3 == null)))){
return m.cljs$core$async$Mult$tap_STAR_$arity$3(m,ch,close_QMARK_);
} else {
var x__8869__auto__ = (((m == null))?null:m);
var m__8870__auto__ = (cljs.core.async.tap_STAR_[goog.typeOf(x__8869__auto__)]);
if(!((m__8870__auto__ == null))){
return m__8870__auto__.call(null,m,ch,close_QMARK_);
} else {
var m__8870__auto____$1 = (cljs.core.async.tap_STAR_["_"]);
if(!((m__8870__auto____$1 == null))){
return m__8870__auto____$1.call(null,m,ch,close_QMARK_);
} else {
throw cljs.core.missing_protocol.call(null,"Mult.tap*",m);
}
}
}
});

cljs.core.async.untap_STAR_ = (function cljs$core$async$untap_STAR_(m,ch){
if((!((m == null))) && (!((m.cljs$core$async$Mult$untap_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mult$untap_STAR_$arity$2(m,ch);
} else {
var x__8869__auto__ = (((m == null))?null:m);
var m__8870__auto__ = (cljs.core.async.untap_STAR_[goog.typeOf(x__8869__auto__)]);
if(!((m__8870__auto__ == null))){
return m__8870__auto__.call(null,m,ch);
} else {
var m__8870__auto____$1 = (cljs.core.async.untap_STAR_["_"]);
if(!((m__8870__auto____$1 == null))){
return m__8870__auto____$1.call(null,m,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Mult.untap*",m);
}
}
}
});

cljs.core.async.untap_all_STAR_ = (function cljs$core$async$untap_all_STAR_(m){
if((!((m == null))) && (!((m.cljs$core$async$Mult$untap_all_STAR_$arity$1 == null)))){
return m.cljs$core$async$Mult$untap_all_STAR_$arity$1(m);
} else {
var x__8869__auto__ = (((m == null))?null:m);
var m__8870__auto__ = (cljs.core.async.untap_all_STAR_[goog.typeOf(x__8869__auto__)]);
if(!((m__8870__auto__ == null))){
return m__8870__auto__.call(null,m);
} else {
var m__8870__auto____$1 = (cljs.core.async.untap_all_STAR_["_"]);
if(!((m__8870__auto____$1 == null))){
return m__8870__auto____$1.call(null,m);
} else {
throw cljs.core.missing_protocol.call(null,"Mult.untap-all*",m);
}
}
}
});

/**
 * Creates and returns a mult(iple) of the supplied channel. Channels
 *   containing copies of the channel can be created with 'tap', and
 *   detached with 'untap'.
 * 
 *   Each item is distributed to all taps in parallel and synchronously,
 *   i.e. each tap must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow taps from holding up the mult.
 * 
 *   Items received when there are no taps get dropped.
 * 
 *   If a tap puts to a closed channel, it will be removed from the mult.
 */
cljs.core.async.mult = (function cljs$core$async$mult(ch){
var cs = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var m = (function (){
if(typeof cljs.core.async.t_cljs$core$async25770 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Mult}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async25770 = (function (ch,cs,meta25771){
this.ch = ch;
this.cs = cs;
this.meta25771 = meta25771;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async25770.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (cs){
return (function (_25772,meta25771__$1){
var self__ = this;
var _25772__$1 = this;
return (new cljs.core.async.t_cljs$core$async25770(self__.ch,self__.cs,meta25771__$1));
});})(cs))
;

cljs.core.async.t_cljs$core$async25770.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (cs){
return (function (_25772){
var self__ = this;
var _25772__$1 = this;
return self__.meta25771;
});})(cs))
;

cljs.core.async.t_cljs$core$async25770.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async25770.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (cs){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
});})(cs))
;

cljs.core.async.t_cljs$core$async25770.prototype.cljs$core$async$Mult$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async25770.prototype.cljs$core$async$Mult$tap_STAR_$arity$3 = ((function (cs){
return (function (_,ch__$1,close_QMARK_){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.assoc,ch__$1,close_QMARK_);

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async25770.prototype.cljs$core$async$Mult$untap_STAR_$arity$2 = ((function (cs){
return (function (_,ch__$1){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.dissoc,ch__$1);

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async25770.prototype.cljs$core$async$Mult$untap_all_STAR_$arity$1 = ((function (cs){
return (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_.call(null,self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async25770.getBasis = ((function (cs){
return (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"cs","cs",-117024463,null),new cljs.core.Symbol(null,"meta25771","meta25771",960269372,null)], null);
});})(cs))
;

cljs.core.async.t_cljs$core$async25770.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async25770.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async25770";

cljs.core.async.t_cljs$core$async25770.cljs$lang$ctorPrWriter = ((function (cs){
return (function (this__8811__auto__,writer__8812__auto__,opt__8813__auto__){
return cljs.core._write.call(null,writer__8812__auto__,"cljs.core.async/t_cljs$core$async25770");
});})(cs))
;

cljs.core.async.__GT_t_cljs$core$async25770 = ((function (cs){
return (function cljs$core$async$mult_$___GT_t_cljs$core$async25770(ch__$1,cs__$1,meta25771){
return (new cljs.core.async.t_cljs$core$async25770(ch__$1,cs__$1,meta25771));
});})(cs))
;

}

return (new cljs.core.async.t_cljs$core$async25770(ch,cs,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var dchan = cljs.core.async.chan.call(null,(1));
var dctr = cljs.core.atom.call(null,null);
var done = ((function (cs,m,dchan,dctr){
return (function (_){
if((cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.call(null,dchan,true);
} else {
return null;
}
});})(cs,m,dchan,dctr))
;
var c__25187__auto___25992 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__25187__auto___25992,cs,m,dchan,dctr,done){
return (function (){
var f__25188__auto__ = (function (){var switch__25099__auto__ = ((function (c__25187__auto___25992,cs,m,dchan,dctr,done){
return (function (state_25907){
var state_val_25908 = (state_25907[(1)]);
if((state_val_25908 === (7))){
var inst_25903 = (state_25907[(2)]);
var state_25907__$1 = state_25907;
var statearr_25909_25993 = state_25907__$1;
(statearr_25909_25993[(2)] = inst_25903);

(statearr_25909_25993[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25908 === (20))){
var inst_25806 = (state_25907[(7)]);
var inst_25818 = cljs.core.first.call(null,inst_25806);
var inst_25819 = cljs.core.nth.call(null,inst_25818,(0),null);
var inst_25820 = cljs.core.nth.call(null,inst_25818,(1),null);
var state_25907__$1 = (function (){var statearr_25910 = state_25907;
(statearr_25910[(8)] = inst_25819);

return statearr_25910;
})();
if(cljs.core.truth_(inst_25820)){
var statearr_25911_25994 = state_25907__$1;
(statearr_25911_25994[(1)] = (22));

} else {
var statearr_25912_25995 = state_25907__$1;
(statearr_25912_25995[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25908 === (27))){
var inst_25855 = (state_25907[(9)]);
var inst_25775 = (state_25907[(10)]);
var inst_25848 = (state_25907[(11)]);
var inst_25850 = (state_25907[(12)]);
var inst_25855__$1 = cljs.core._nth.call(null,inst_25848,inst_25850);
var inst_25856 = cljs.core.async.put_BANG_.call(null,inst_25855__$1,inst_25775,done);
var state_25907__$1 = (function (){var statearr_25913 = state_25907;
(statearr_25913[(9)] = inst_25855__$1);

return statearr_25913;
})();
if(cljs.core.truth_(inst_25856)){
var statearr_25914_25996 = state_25907__$1;
(statearr_25914_25996[(1)] = (30));

} else {
var statearr_25915_25997 = state_25907__$1;
(statearr_25915_25997[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25908 === (1))){
var state_25907__$1 = state_25907;
var statearr_25916_25998 = state_25907__$1;
(statearr_25916_25998[(2)] = null);

(statearr_25916_25998[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25908 === (24))){
var inst_25806 = (state_25907[(7)]);
var inst_25825 = (state_25907[(2)]);
var inst_25826 = cljs.core.next.call(null,inst_25806);
var inst_25784 = inst_25826;
var inst_25785 = null;
var inst_25786 = (0);
var inst_25787 = (0);
var state_25907__$1 = (function (){var statearr_25917 = state_25907;
(statearr_25917[(13)] = inst_25787);

(statearr_25917[(14)] = inst_25786);

(statearr_25917[(15)] = inst_25784);

(statearr_25917[(16)] = inst_25785);

(statearr_25917[(17)] = inst_25825);

return statearr_25917;
})();
var statearr_25918_25999 = state_25907__$1;
(statearr_25918_25999[(2)] = null);

(statearr_25918_25999[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25908 === (39))){
var state_25907__$1 = state_25907;
var statearr_25922_26000 = state_25907__$1;
(statearr_25922_26000[(2)] = null);

(statearr_25922_26000[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25908 === (4))){
var inst_25775 = (state_25907[(10)]);
var inst_25775__$1 = (state_25907[(2)]);
var inst_25776 = (inst_25775__$1 == null);
var state_25907__$1 = (function (){var statearr_25923 = state_25907;
(statearr_25923[(10)] = inst_25775__$1);

return statearr_25923;
})();
if(cljs.core.truth_(inst_25776)){
var statearr_25924_26001 = state_25907__$1;
(statearr_25924_26001[(1)] = (5));

} else {
var statearr_25925_26002 = state_25907__$1;
(statearr_25925_26002[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25908 === (15))){
var inst_25787 = (state_25907[(13)]);
var inst_25786 = (state_25907[(14)]);
var inst_25784 = (state_25907[(15)]);
var inst_25785 = (state_25907[(16)]);
var inst_25802 = (state_25907[(2)]);
var inst_25803 = (inst_25787 + (1));
var tmp25919 = inst_25786;
var tmp25920 = inst_25784;
var tmp25921 = inst_25785;
var inst_25784__$1 = tmp25920;
var inst_25785__$1 = tmp25921;
var inst_25786__$1 = tmp25919;
var inst_25787__$1 = inst_25803;
var state_25907__$1 = (function (){var statearr_25926 = state_25907;
(statearr_25926[(18)] = inst_25802);

(statearr_25926[(13)] = inst_25787__$1);

(statearr_25926[(14)] = inst_25786__$1);

(statearr_25926[(15)] = inst_25784__$1);

(statearr_25926[(16)] = inst_25785__$1);

return statearr_25926;
})();
var statearr_25927_26003 = state_25907__$1;
(statearr_25927_26003[(2)] = null);

(statearr_25927_26003[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25908 === (21))){
var inst_25829 = (state_25907[(2)]);
var state_25907__$1 = state_25907;
var statearr_25931_26004 = state_25907__$1;
(statearr_25931_26004[(2)] = inst_25829);

(statearr_25931_26004[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25908 === (31))){
var inst_25855 = (state_25907[(9)]);
var inst_25859 = done.call(null,null);
var inst_25860 = cljs.core.async.untap_STAR_.call(null,m,inst_25855);
var state_25907__$1 = (function (){var statearr_25932 = state_25907;
(statearr_25932[(19)] = inst_25859);

return statearr_25932;
})();
var statearr_25933_26005 = state_25907__$1;
(statearr_25933_26005[(2)] = inst_25860);

(statearr_25933_26005[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25908 === (32))){
var inst_25847 = (state_25907[(20)]);
var inst_25849 = (state_25907[(21)]);
var inst_25848 = (state_25907[(11)]);
var inst_25850 = (state_25907[(12)]);
var inst_25862 = (state_25907[(2)]);
var inst_25863 = (inst_25850 + (1));
var tmp25928 = inst_25847;
var tmp25929 = inst_25849;
var tmp25930 = inst_25848;
var inst_25847__$1 = tmp25928;
var inst_25848__$1 = tmp25930;
var inst_25849__$1 = tmp25929;
var inst_25850__$1 = inst_25863;
var state_25907__$1 = (function (){var statearr_25934 = state_25907;
(statearr_25934[(20)] = inst_25847__$1);

(statearr_25934[(21)] = inst_25849__$1);

(statearr_25934[(11)] = inst_25848__$1);

(statearr_25934[(12)] = inst_25850__$1);

(statearr_25934[(22)] = inst_25862);

return statearr_25934;
})();
var statearr_25935_26006 = state_25907__$1;
(statearr_25935_26006[(2)] = null);

(statearr_25935_26006[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25908 === (40))){
var inst_25875 = (state_25907[(23)]);
var inst_25879 = done.call(null,null);
var inst_25880 = cljs.core.async.untap_STAR_.call(null,m,inst_25875);
var state_25907__$1 = (function (){var statearr_25936 = state_25907;
(statearr_25936[(24)] = inst_25879);

return statearr_25936;
})();
var statearr_25937_26007 = state_25907__$1;
(statearr_25937_26007[(2)] = inst_25880);

(statearr_25937_26007[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25908 === (33))){
var inst_25866 = (state_25907[(25)]);
var inst_25868 = cljs.core.chunked_seq_QMARK_.call(null,inst_25866);
var state_25907__$1 = state_25907;
if(inst_25868){
var statearr_25938_26008 = state_25907__$1;
(statearr_25938_26008[(1)] = (36));

} else {
var statearr_25939_26009 = state_25907__$1;
(statearr_25939_26009[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25908 === (13))){
var inst_25796 = (state_25907[(26)]);
var inst_25799 = cljs.core.async.close_BANG_.call(null,inst_25796);
var state_25907__$1 = state_25907;
var statearr_25940_26010 = state_25907__$1;
(statearr_25940_26010[(2)] = inst_25799);

(statearr_25940_26010[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25908 === (22))){
var inst_25819 = (state_25907[(8)]);
var inst_25822 = cljs.core.async.close_BANG_.call(null,inst_25819);
var state_25907__$1 = state_25907;
var statearr_25941_26011 = state_25907__$1;
(statearr_25941_26011[(2)] = inst_25822);

(statearr_25941_26011[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25908 === (36))){
var inst_25866 = (state_25907[(25)]);
var inst_25870 = cljs.core.chunk_first.call(null,inst_25866);
var inst_25871 = cljs.core.chunk_rest.call(null,inst_25866);
var inst_25872 = cljs.core.count.call(null,inst_25870);
var inst_25847 = inst_25871;
var inst_25848 = inst_25870;
var inst_25849 = inst_25872;
var inst_25850 = (0);
var state_25907__$1 = (function (){var statearr_25942 = state_25907;
(statearr_25942[(20)] = inst_25847);

(statearr_25942[(21)] = inst_25849);

(statearr_25942[(11)] = inst_25848);

(statearr_25942[(12)] = inst_25850);

return statearr_25942;
})();
var statearr_25943_26012 = state_25907__$1;
(statearr_25943_26012[(2)] = null);

(statearr_25943_26012[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25908 === (41))){
var inst_25866 = (state_25907[(25)]);
var inst_25882 = (state_25907[(2)]);
var inst_25883 = cljs.core.next.call(null,inst_25866);
var inst_25847 = inst_25883;
var inst_25848 = null;
var inst_25849 = (0);
var inst_25850 = (0);
var state_25907__$1 = (function (){var statearr_25944 = state_25907;
(statearr_25944[(20)] = inst_25847);

(statearr_25944[(21)] = inst_25849);

(statearr_25944[(11)] = inst_25848);

(statearr_25944[(27)] = inst_25882);

(statearr_25944[(12)] = inst_25850);

return statearr_25944;
})();
var statearr_25945_26013 = state_25907__$1;
(statearr_25945_26013[(2)] = null);

(statearr_25945_26013[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25908 === (43))){
var state_25907__$1 = state_25907;
var statearr_25946_26014 = state_25907__$1;
(statearr_25946_26014[(2)] = null);

(statearr_25946_26014[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25908 === (29))){
var inst_25891 = (state_25907[(2)]);
var state_25907__$1 = state_25907;
var statearr_25947_26015 = state_25907__$1;
(statearr_25947_26015[(2)] = inst_25891);

(statearr_25947_26015[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25908 === (44))){
var inst_25900 = (state_25907[(2)]);
var state_25907__$1 = (function (){var statearr_25948 = state_25907;
(statearr_25948[(28)] = inst_25900);

return statearr_25948;
})();
var statearr_25949_26016 = state_25907__$1;
(statearr_25949_26016[(2)] = null);

(statearr_25949_26016[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25908 === (6))){
var inst_25839 = (state_25907[(29)]);
var inst_25838 = cljs.core.deref.call(null,cs);
var inst_25839__$1 = cljs.core.keys.call(null,inst_25838);
var inst_25840 = cljs.core.count.call(null,inst_25839__$1);
var inst_25841 = cljs.core.reset_BANG_.call(null,dctr,inst_25840);
var inst_25846 = cljs.core.seq.call(null,inst_25839__$1);
var inst_25847 = inst_25846;
var inst_25848 = null;
var inst_25849 = (0);
var inst_25850 = (0);
var state_25907__$1 = (function (){var statearr_25950 = state_25907;
(statearr_25950[(29)] = inst_25839__$1);

(statearr_25950[(20)] = inst_25847);

(statearr_25950[(21)] = inst_25849);

(statearr_25950[(30)] = inst_25841);

(statearr_25950[(11)] = inst_25848);

(statearr_25950[(12)] = inst_25850);

return statearr_25950;
})();
var statearr_25951_26017 = state_25907__$1;
(statearr_25951_26017[(2)] = null);

(statearr_25951_26017[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25908 === (28))){
var inst_25866 = (state_25907[(25)]);
var inst_25847 = (state_25907[(20)]);
var inst_25866__$1 = cljs.core.seq.call(null,inst_25847);
var state_25907__$1 = (function (){var statearr_25952 = state_25907;
(statearr_25952[(25)] = inst_25866__$1);

return statearr_25952;
})();
if(inst_25866__$1){
var statearr_25953_26018 = state_25907__$1;
(statearr_25953_26018[(1)] = (33));

} else {
var statearr_25954_26019 = state_25907__$1;
(statearr_25954_26019[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25908 === (25))){
var inst_25849 = (state_25907[(21)]);
var inst_25850 = (state_25907[(12)]);
var inst_25852 = (inst_25850 < inst_25849);
var inst_25853 = inst_25852;
var state_25907__$1 = state_25907;
if(cljs.core.truth_(inst_25853)){
var statearr_25955_26020 = state_25907__$1;
(statearr_25955_26020[(1)] = (27));

} else {
var statearr_25956_26021 = state_25907__$1;
(statearr_25956_26021[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25908 === (34))){
var state_25907__$1 = state_25907;
var statearr_25957_26022 = state_25907__$1;
(statearr_25957_26022[(2)] = null);

(statearr_25957_26022[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25908 === (17))){
var state_25907__$1 = state_25907;
var statearr_25958_26023 = state_25907__$1;
(statearr_25958_26023[(2)] = null);

(statearr_25958_26023[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25908 === (3))){
var inst_25905 = (state_25907[(2)]);
var state_25907__$1 = state_25907;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_25907__$1,inst_25905);
} else {
if((state_val_25908 === (12))){
var inst_25834 = (state_25907[(2)]);
var state_25907__$1 = state_25907;
var statearr_25959_26024 = state_25907__$1;
(statearr_25959_26024[(2)] = inst_25834);

(statearr_25959_26024[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25908 === (2))){
var state_25907__$1 = state_25907;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_25907__$1,(4),ch);
} else {
if((state_val_25908 === (23))){
var state_25907__$1 = state_25907;
var statearr_25960_26025 = state_25907__$1;
(statearr_25960_26025[(2)] = null);

(statearr_25960_26025[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25908 === (35))){
var inst_25889 = (state_25907[(2)]);
var state_25907__$1 = state_25907;
var statearr_25961_26026 = state_25907__$1;
(statearr_25961_26026[(2)] = inst_25889);

(statearr_25961_26026[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25908 === (19))){
var inst_25806 = (state_25907[(7)]);
var inst_25810 = cljs.core.chunk_first.call(null,inst_25806);
var inst_25811 = cljs.core.chunk_rest.call(null,inst_25806);
var inst_25812 = cljs.core.count.call(null,inst_25810);
var inst_25784 = inst_25811;
var inst_25785 = inst_25810;
var inst_25786 = inst_25812;
var inst_25787 = (0);
var state_25907__$1 = (function (){var statearr_25962 = state_25907;
(statearr_25962[(13)] = inst_25787);

(statearr_25962[(14)] = inst_25786);

(statearr_25962[(15)] = inst_25784);

(statearr_25962[(16)] = inst_25785);

return statearr_25962;
})();
var statearr_25963_26027 = state_25907__$1;
(statearr_25963_26027[(2)] = null);

(statearr_25963_26027[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25908 === (11))){
var inst_25784 = (state_25907[(15)]);
var inst_25806 = (state_25907[(7)]);
var inst_25806__$1 = cljs.core.seq.call(null,inst_25784);
var state_25907__$1 = (function (){var statearr_25964 = state_25907;
(statearr_25964[(7)] = inst_25806__$1);

return statearr_25964;
})();
if(inst_25806__$1){
var statearr_25965_26028 = state_25907__$1;
(statearr_25965_26028[(1)] = (16));

} else {
var statearr_25966_26029 = state_25907__$1;
(statearr_25966_26029[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25908 === (9))){
var inst_25836 = (state_25907[(2)]);
var state_25907__$1 = state_25907;
var statearr_25967_26030 = state_25907__$1;
(statearr_25967_26030[(2)] = inst_25836);

(statearr_25967_26030[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25908 === (5))){
var inst_25782 = cljs.core.deref.call(null,cs);
var inst_25783 = cljs.core.seq.call(null,inst_25782);
var inst_25784 = inst_25783;
var inst_25785 = null;
var inst_25786 = (0);
var inst_25787 = (0);
var state_25907__$1 = (function (){var statearr_25968 = state_25907;
(statearr_25968[(13)] = inst_25787);

(statearr_25968[(14)] = inst_25786);

(statearr_25968[(15)] = inst_25784);

(statearr_25968[(16)] = inst_25785);

return statearr_25968;
})();
var statearr_25969_26031 = state_25907__$1;
(statearr_25969_26031[(2)] = null);

(statearr_25969_26031[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25908 === (14))){
var state_25907__$1 = state_25907;
var statearr_25970_26032 = state_25907__$1;
(statearr_25970_26032[(2)] = null);

(statearr_25970_26032[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25908 === (45))){
var inst_25897 = (state_25907[(2)]);
var state_25907__$1 = state_25907;
var statearr_25971_26033 = state_25907__$1;
(statearr_25971_26033[(2)] = inst_25897);

(statearr_25971_26033[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25908 === (26))){
var inst_25839 = (state_25907[(29)]);
var inst_25893 = (state_25907[(2)]);
var inst_25894 = cljs.core.seq.call(null,inst_25839);
var state_25907__$1 = (function (){var statearr_25972 = state_25907;
(statearr_25972[(31)] = inst_25893);

return statearr_25972;
})();
if(inst_25894){
var statearr_25973_26034 = state_25907__$1;
(statearr_25973_26034[(1)] = (42));

} else {
var statearr_25974_26035 = state_25907__$1;
(statearr_25974_26035[(1)] = (43));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25908 === (16))){
var inst_25806 = (state_25907[(7)]);
var inst_25808 = cljs.core.chunked_seq_QMARK_.call(null,inst_25806);
var state_25907__$1 = state_25907;
if(inst_25808){
var statearr_25975_26036 = state_25907__$1;
(statearr_25975_26036[(1)] = (19));

} else {
var statearr_25976_26037 = state_25907__$1;
(statearr_25976_26037[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25908 === (38))){
var inst_25886 = (state_25907[(2)]);
var state_25907__$1 = state_25907;
var statearr_25977_26038 = state_25907__$1;
(statearr_25977_26038[(2)] = inst_25886);

(statearr_25977_26038[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25908 === (30))){
var state_25907__$1 = state_25907;
var statearr_25978_26039 = state_25907__$1;
(statearr_25978_26039[(2)] = null);

(statearr_25978_26039[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25908 === (10))){
var inst_25787 = (state_25907[(13)]);
var inst_25785 = (state_25907[(16)]);
var inst_25795 = cljs.core._nth.call(null,inst_25785,inst_25787);
var inst_25796 = cljs.core.nth.call(null,inst_25795,(0),null);
var inst_25797 = cljs.core.nth.call(null,inst_25795,(1),null);
var state_25907__$1 = (function (){var statearr_25979 = state_25907;
(statearr_25979[(26)] = inst_25796);

return statearr_25979;
})();
if(cljs.core.truth_(inst_25797)){
var statearr_25980_26040 = state_25907__$1;
(statearr_25980_26040[(1)] = (13));

} else {
var statearr_25981_26041 = state_25907__$1;
(statearr_25981_26041[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25908 === (18))){
var inst_25832 = (state_25907[(2)]);
var state_25907__$1 = state_25907;
var statearr_25982_26042 = state_25907__$1;
(statearr_25982_26042[(2)] = inst_25832);

(statearr_25982_26042[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25908 === (42))){
var state_25907__$1 = state_25907;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_25907__$1,(45),dchan);
} else {
if((state_val_25908 === (37))){
var inst_25875 = (state_25907[(23)]);
var inst_25866 = (state_25907[(25)]);
var inst_25775 = (state_25907[(10)]);
var inst_25875__$1 = cljs.core.first.call(null,inst_25866);
var inst_25876 = cljs.core.async.put_BANG_.call(null,inst_25875__$1,inst_25775,done);
var state_25907__$1 = (function (){var statearr_25983 = state_25907;
(statearr_25983[(23)] = inst_25875__$1);

return statearr_25983;
})();
if(cljs.core.truth_(inst_25876)){
var statearr_25984_26043 = state_25907__$1;
(statearr_25984_26043[(1)] = (39));

} else {
var statearr_25985_26044 = state_25907__$1;
(statearr_25985_26044[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25908 === (8))){
var inst_25787 = (state_25907[(13)]);
var inst_25786 = (state_25907[(14)]);
var inst_25789 = (inst_25787 < inst_25786);
var inst_25790 = inst_25789;
var state_25907__$1 = state_25907;
if(cljs.core.truth_(inst_25790)){
var statearr_25986_26045 = state_25907__$1;
(statearr_25986_26045[(1)] = (10));

} else {
var statearr_25987_26046 = state_25907__$1;
(statearr_25987_26046[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__25187__auto___25992,cs,m,dchan,dctr,done))
;
return ((function (switch__25099__auto__,c__25187__auto___25992,cs,m,dchan,dctr,done){
return (function() {
var cljs$core$async$mult_$_state_machine__25100__auto__ = null;
var cljs$core$async$mult_$_state_machine__25100__auto____0 = (function (){
var statearr_25988 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_25988[(0)] = cljs$core$async$mult_$_state_machine__25100__auto__);

(statearr_25988[(1)] = (1));

return statearr_25988;
});
var cljs$core$async$mult_$_state_machine__25100__auto____1 = (function (state_25907){
while(true){
var ret_value__25101__auto__ = (function (){try{while(true){
var result__25102__auto__ = switch__25099__auto__.call(null,state_25907);
if(cljs.core.keyword_identical_QMARK_.call(null,result__25102__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__25102__auto__;
}
break;
}
}catch (e25989){if((e25989 instanceof Object)){
var ex__25103__auto__ = e25989;
var statearr_25990_26047 = state_25907;
(statearr_25990_26047[(5)] = ex__25103__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_25907);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e25989;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__25101__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__26048 = state_25907;
state_25907 = G__26048;
continue;
} else {
return ret_value__25101__auto__;
}
break;
}
});
cljs$core$async$mult_$_state_machine__25100__auto__ = function(state_25907){
switch(arguments.length){
case 0:
return cljs$core$async$mult_$_state_machine__25100__auto____0.call(this);
case 1:
return cljs$core$async$mult_$_state_machine__25100__auto____1.call(this,state_25907);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$mult_$_state_machine__25100__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mult_$_state_machine__25100__auto____0;
cljs$core$async$mult_$_state_machine__25100__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mult_$_state_machine__25100__auto____1;
return cljs$core$async$mult_$_state_machine__25100__auto__;
})()
;})(switch__25099__auto__,c__25187__auto___25992,cs,m,dchan,dctr,done))
})();
var state__25189__auto__ = (function (){var statearr_25991 = f__25188__auto__.call(null);
(statearr_25991[(6)] = c__25187__auto___25992);

return statearr_25991;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__25189__auto__);
});})(c__25187__auto___25992,cs,m,dchan,dctr,done))
);


return m;
});
/**
 * Copies the mult source onto the supplied channel.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.tap = (function cljs$core$async$tap(var_args){
var G__26050 = arguments.length;
switch (G__26050) {
case 2:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2 = (function (mult,ch){
return cljs.core.async.tap.call(null,mult,ch,true);
});

cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3 = (function (mult,ch,close_QMARK_){
cljs.core.async.tap_STAR_.call(null,mult,ch,close_QMARK_);

return ch;
});

cljs.core.async.tap.cljs$lang$maxFixedArity = 3;

/**
 * Disconnects a target channel from a mult
 */
cljs.core.async.untap = (function cljs$core$async$untap(mult,ch){
return cljs.core.async.untap_STAR_.call(null,mult,ch);
});
/**
 * Disconnects all target channels from a mult
 */
cljs.core.async.untap_all = (function cljs$core$async$untap_all(mult){
return cljs.core.async.untap_all_STAR_.call(null,mult);
});

/**
 * @interface
 */
cljs.core.async.Mix = function(){};

cljs.core.async.admix_STAR_ = (function cljs$core$async$admix_STAR_(m,ch){
if((!((m == null))) && (!((m.cljs$core$async$Mix$admix_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$admix_STAR_$arity$2(m,ch);
} else {
var x__8869__auto__ = (((m == null))?null:m);
var m__8870__auto__ = (cljs.core.async.admix_STAR_[goog.typeOf(x__8869__auto__)]);
if(!((m__8870__auto__ == null))){
return m__8870__auto__.call(null,m,ch);
} else {
var m__8870__auto____$1 = (cljs.core.async.admix_STAR_["_"]);
if(!((m__8870__auto____$1 == null))){
return m__8870__auto____$1.call(null,m,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.admix*",m);
}
}
}
});

cljs.core.async.unmix_STAR_ = (function cljs$core$async$unmix_STAR_(m,ch){
if((!((m == null))) && (!((m.cljs$core$async$Mix$unmix_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$unmix_STAR_$arity$2(m,ch);
} else {
var x__8869__auto__ = (((m == null))?null:m);
var m__8870__auto__ = (cljs.core.async.unmix_STAR_[goog.typeOf(x__8869__auto__)]);
if(!((m__8870__auto__ == null))){
return m__8870__auto__.call(null,m,ch);
} else {
var m__8870__auto____$1 = (cljs.core.async.unmix_STAR_["_"]);
if(!((m__8870__auto____$1 == null))){
return m__8870__auto____$1.call(null,m,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.unmix*",m);
}
}
}
});

cljs.core.async.unmix_all_STAR_ = (function cljs$core$async$unmix_all_STAR_(m){
if((!((m == null))) && (!((m.cljs$core$async$Mix$unmix_all_STAR_$arity$1 == null)))){
return m.cljs$core$async$Mix$unmix_all_STAR_$arity$1(m);
} else {
var x__8869__auto__ = (((m == null))?null:m);
var m__8870__auto__ = (cljs.core.async.unmix_all_STAR_[goog.typeOf(x__8869__auto__)]);
if(!((m__8870__auto__ == null))){
return m__8870__auto__.call(null,m);
} else {
var m__8870__auto____$1 = (cljs.core.async.unmix_all_STAR_["_"]);
if(!((m__8870__auto____$1 == null))){
return m__8870__auto____$1.call(null,m);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.unmix-all*",m);
}
}
}
});

cljs.core.async.toggle_STAR_ = (function cljs$core$async$toggle_STAR_(m,state_map){
if((!((m == null))) && (!((m.cljs$core$async$Mix$toggle_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$toggle_STAR_$arity$2(m,state_map);
} else {
var x__8869__auto__ = (((m == null))?null:m);
var m__8870__auto__ = (cljs.core.async.toggle_STAR_[goog.typeOf(x__8869__auto__)]);
if(!((m__8870__auto__ == null))){
return m__8870__auto__.call(null,m,state_map);
} else {
var m__8870__auto____$1 = (cljs.core.async.toggle_STAR_["_"]);
if(!((m__8870__auto____$1 == null))){
return m__8870__auto____$1.call(null,m,state_map);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.toggle*",m);
}
}
}
});

cljs.core.async.solo_mode_STAR_ = (function cljs$core$async$solo_mode_STAR_(m,mode){
if((!((m == null))) && (!((m.cljs$core$async$Mix$solo_mode_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$solo_mode_STAR_$arity$2(m,mode);
} else {
var x__8869__auto__ = (((m == null))?null:m);
var m__8870__auto__ = (cljs.core.async.solo_mode_STAR_[goog.typeOf(x__8869__auto__)]);
if(!((m__8870__auto__ == null))){
return m__8870__auto__.call(null,m,mode);
} else {
var m__8870__auto____$1 = (cljs.core.async.solo_mode_STAR_["_"]);
if(!((m__8870__auto____$1 == null))){
return m__8870__auto____$1.call(null,m,mode);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.solo-mode*",m);
}
}
}
});

cljs.core.async.ioc_alts_BANG_ = (function cljs$core$async$ioc_alts_BANG_(var_args){
var args__9364__auto__ = [];
var len__9357__auto___26062 = arguments.length;
var i__9358__auto___26063 = (0);
while(true){
if((i__9358__auto___26063 < len__9357__auto___26062)){
args__9364__auto__.push((arguments[i__9358__auto___26063]));

var G__26064 = (i__9358__auto___26063 + (1));
i__9358__auto___26063 = G__26064;
continue;
} else {
}
break;
}

var argseq__9365__auto__ = ((((3) < args__9364__auto__.length))?(new cljs.core.IndexedSeq(args__9364__auto__.slice((3)),(0),null)):null);
return cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__9365__auto__);
});

cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (state,cont_block,ports,p__26056){
var map__26057 = p__26056;
var map__26057__$1 = ((((!((map__26057 == null)))?((((map__26057.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__26057.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__26057):map__26057);
var opts = map__26057__$1;
var statearr_26059_26065 = state;
(statearr_26059_26065[(1)] = cont_block);


var temp__4657__auto__ = cljs.core.async.do_alts.call(null,((function (map__26057,map__26057__$1,opts){
return (function (val){
var statearr_26060_26066 = state;
(statearr_26060_26066[(2)] = val);


return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state);
});})(map__26057,map__26057__$1,opts))
,ports,opts);
if(cljs.core.truth_(temp__4657__auto__)){
var cb = temp__4657__auto__;
var statearr_26061_26067 = state;
(statearr_26061_26067[(2)] = cljs.core.deref.call(null,cb));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
});

cljs.core.async.ioc_alts_BANG_.cljs$lang$maxFixedArity = (3);

cljs.core.async.ioc_alts_BANG_.cljs$lang$applyTo = (function (seq26052){
var G__26053 = cljs.core.first.call(null,seq26052);
var seq26052__$1 = cljs.core.next.call(null,seq26052);
var G__26054 = cljs.core.first.call(null,seq26052__$1);
var seq26052__$2 = cljs.core.next.call(null,seq26052__$1);
var G__26055 = cljs.core.first.call(null,seq26052__$2);
var seq26052__$3 = cljs.core.next.call(null,seq26052__$2);
return cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__26053,G__26054,G__26055,seq26052__$3);
});

/**
 * Creates and returns a mix of one or more input channels which will
 *   be put on the supplied out channel. Input sources can be added to
 *   the mix with 'admix', and removed with 'unmix'. A mix supports
 *   soloing, muting and pausing multiple inputs atomically using
 *   'toggle', and can solo using either muting or pausing as determined
 *   by 'solo-mode'.
 * 
 *   Each channel can have zero or more boolean modes set via 'toggle':
 * 
 *   :solo - when true, only this (ond other soloed) channel(s) will appear
 *        in the mix output channel. :mute and :pause states of soloed
 *        channels are ignored. If solo-mode is :mute, non-soloed
 *        channels are muted, if :pause, non-soloed channels are
 *        paused.
 * 
 *   :mute - muted channels will have their contents consumed but not included in the mix
 *   :pause - paused channels will not have their contents consumed (and thus also not included in the mix)
 */
cljs.core.async.mix = (function cljs$core$async$mix(out){
var cs = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var solo_modes = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"pause","pause",-2095325672),null,new cljs.core.Keyword(null,"mute","mute",1151223646),null], null), null);
var attrs = cljs.core.conj.call(null,solo_modes,new cljs.core.Keyword(null,"solo","solo",-316350075));
var solo_mode = cljs.core.atom.call(null,new cljs.core.Keyword(null,"mute","mute",1151223646));
var change = cljs.core.async.chan.call(null);
var changed = ((function (cs,solo_modes,attrs,solo_mode,change){
return (function (){
return cljs.core.async.put_BANG_.call(null,change,true);
});})(cs,solo_modes,attrs,solo_mode,change))
;
var pick = ((function (cs,solo_modes,attrs,solo_mode,change,changed){
return (function (attr,chs){
return cljs.core.reduce_kv.call(null,((function (cs,solo_modes,attrs,solo_mode,change,changed){
return (function (ret,c,v){
if(cljs.core.truth_(attr.call(null,v))){
return cljs.core.conj.call(null,ret,c);
} else {
return ret;
}
});})(cs,solo_modes,attrs,solo_mode,change,changed))
,cljs.core.PersistentHashSet.EMPTY,chs);
});})(cs,solo_modes,attrs,solo_mode,change,changed))
;
var calc_state = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick){
return (function (){
var chs = cljs.core.deref.call(null,cs);
var mode = cljs.core.deref.call(null,solo_mode);
var solos = pick.call(null,new cljs.core.Keyword(null,"solo","solo",-316350075),chs);
var pauses = pick.call(null,new cljs.core.Keyword(null,"pause","pause",-2095325672),chs);
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"solos","solos",1441458643),solos,new cljs.core.Keyword(null,"mutes","mutes",1068806309),pick.call(null,new cljs.core.Keyword(null,"mute","mute",1151223646),chs),new cljs.core.Keyword(null,"reads","reads",-1215067361),cljs.core.conj.call(null,(((cljs.core._EQ_.call(null,mode,new cljs.core.Keyword(null,"pause","pause",-2095325672))) && (!(cljs.core.empty_QMARK_.call(null,solos))))?cljs.core.vec.call(null,solos):cljs.core.vec.call(null,cljs.core.remove.call(null,pauses,cljs.core.keys.call(null,chs)))),change)], null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick))
;
var m = (function (){
if(typeof cljs.core.async.t_cljs$core$async26068 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mix}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async26068 = (function (out,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,meta26069){
this.out = out;
this.cs = cs;
this.solo_modes = solo_modes;
this.attrs = attrs;
this.solo_mode = solo_mode;
this.change = change;
this.changed = changed;
this.pick = pick;
this.calc_state = calc_state;
this.meta26069 = meta26069;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async26068.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_26070,meta26069__$1){
var self__ = this;
var _26070__$1 = this;
return (new cljs.core.async.t_cljs$core$async26068(self__.out,self__.cs,self__.solo_modes,self__.attrs,self__.solo_mode,self__.change,self__.changed,self__.pick,self__.calc_state,meta26069__$1));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async26068.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_26070){
var self__ = this;
var _26070__$1 = this;
return self__.meta26069;
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async26068.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async26068.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.out;
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async26068.prototype.cljs$core$async$Mix$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async26068.prototype.cljs$core$async$Mix$admix_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.assoc,ch,cljs.core.PersistentArrayMap.EMPTY);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async26068.prototype.cljs$core$async$Mix$unmix_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.dissoc,ch);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async26068.prototype.cljs$core$async$Mix$unmix_all_STAR_$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_.call(null,self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async26068.prototype.cljs$core$async$Mix$toggle_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,state_map){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.partial.call(null,cljs.core.merge_with,cljs.core.merge),state_map);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async26068.prototype.cljs$core$async$Mix$solo_mode_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,mode){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_(self__.solo_modes.call(null,mode))){
} else {
throw (new Error(["Assert failed: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(["mode must be one of: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(self__.solo_modes)].join('')),"\n","(solo-modes mode)"].join('')));
}

cljs.core.reset_BANG_.call(null,self__.solo_mode,mode);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async26068.getBasis = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (){
return new cljs.core.PersistentVector(null, 10, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"out","out",729986010,null),new cljs.core.Symbol(null,"cs","cs",-117024463,null),new cljs.core.Symbol(null,"solo-modes","solo-modes",882180540,null),new cljs.core.Symbol(null,"attrs","attrs",-450137186,null),new cljs.core.Symbol(null,"solo-mode","solo-mode",2031788074,null),new cljs.core.Symbol(null,"change","change",477485025,null),new cljs.core.Symbol(null,"changed","changed",-2083710852,null),new cljs.core.Symbol(null,"pick","pick",1300068175,null),new cljs.core.Symbol(null,"calc-state","calc-state",-349968968,null),new cljs.core.Symbol(null,"meta26069","meta26069",-1370832778,null)], null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async26068.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async26068.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async26068";

cljs.core.async.t_cljs$core$async26068.cljs$lang$ctorPrWriter = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (this__8811__auto__,writer__8812__auto__,opt__8813__auto__){
return cljs.core._write.call(null,writer__8812__auto__,"cljs.core.async/t_cljs$core$async26068");
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.__GT_t_cljs$core$async26068 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function cljs$core$async$mix_$___GT_t_cljs$core$async26068(out__$1,cs__$1,solo_modes__$1,attrs__$1,solo_mode__$1,change__$1,changed__$1,pick__$1,calc_state__$1,meta26069){
return (new cljs.core.async.t_cljs$core$async26068(out__$1,cs__$1,solo_modes__$1,attrs__$1,solo_mode__$1,change__$1,changed__$1,pick__$1,calc_state__$1,meta26069));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

}

return (new cljs.core.async.t_cljs$core$async26068(out,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__25187__auto___26232 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__25187__auto___26232,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function (){
var f__25188__auto__ = (function (){var switch__25099__auto__ = ((function (c__25187__auto___26232,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function (state_26172){
var state_val_26173 = (state_26172[(1)]);
if((state_val_26173 === (7))){
var inst_26087 = (state_26172[(2)]);
var state_26172__$1 = state_26172;
var statearr_26174_26233 = state_26172__$1;
(statearr_26174_26233[(2)] = inst_26087);

(statearr_26174_26233[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26173 === (20))){
var inst_26099 = (state_26172[(7)]);
var state_26172__$1 = state_26172;
var statearr_26175_26234 = state_26172__$1;
(statearr_26175_26234[(2)] = inst_26099);

(statearr_26175_26234[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26173 === (27))){
var state_26172__$1 = state_26172;
var statearr_26176_26235 = state_26172__$1;
(statearr_26176_26235[(2)] = null);

(statearr_26176_26235[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26173 === (1))){
var inst_26074 = (state_26172[(8)]);
var inst_26074__$1 = calc_state.call(null);
var inst_26076 = (inst_26074__$1 == null);
var inst_26077 = cljs.core.not.call(null,inst_26076);
var state_26172__$1 = (function (){var statearr_26177 = state_26172;
(statearr_26177[(8)] = inst_26074__$1);

return statearr_26177;
})();
if(inst_26077){
var statearr_26178_26236 = state_26172__$1;
(statearr_26178_26236[(1)] = (2));

} else {
var statearr_26179_26237 = state_26172__$1;
(statearr_26179_26237[(1)] = (3));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26173 === (24))){
var inst_26132 = (state_26172[(9)]);
var inst_26146 = (state_26172[(10)]);
var inst_26123 = (state_26172[(11)]);
var inst_26146__$1 = inst_26123.call(null,inst_26132);
var state_26172__$1 = (function (){var statearr_26180 = state_26172;
(statearr_26180[(10)] = inst_26146__$1);

return statearr_26180;
})();
if(cljs.core.truth_(inst_26146__$1)){
var statearr_26181_26238 = state_26172__$1;
(statearr_26181_26238[(1)] = (29));

} else {
var statearr_26182_26239 = state_26172__$1;
(statearr_26182_26239[(1)] = (30));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26173 === (4))){
var inst_26090 = (state_26172[(2)]);
var state_26172__$1 = state_26172;
if(cljs.core.truth_(inst_26090)){
var statearr_26183_26240 = state_26172__$1;
(statearr_26183_26240[(1)] = (8));

} else {
var statearr_26184_26241 = state_26172__$1;
(statearr_26184_26241[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26173 === (15))){
var inst_26117 = (state_26172[(2)]);
var state_26172__$1 = state_26172;
if(cljs.core.truth_(inst_26117)){
var statearr_26185_26242 = state_26172__$1;
(statearr_26185_26242[(1)] = (19));

} else {
var statearr_26186_26243 = state_26172__$1;
(statearr_26186_26243[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26173 === (21))){
var inst_26122 = (state_26172[(12)]);
var inst_26122__$1 = (state_26172[(2)]);
var inst_26123 = cljs.core.get.call(null,inst_26122__$1,new cljs.core.Keyword(null,"solos","solos",1441458643));
var inst_26124 = cljs.core.get.call(null,inst_26122__$1,new cljs.core.Keyword(null,"mutes","mutes",1068806309));
var inst_26125 = cljs.core.get.call(null,inst_26122__$1,new cljs.core.Keyword(null,"reads","reads",-1215067361));
var state_26172__$1 = (function (){var statearr_26187 = state_26172;
(statearr_26187[(12)] = inst_26122__$1);

(statearr_26187[(11)] = inst_26123);

(statearr_26187[(13)] = inst_26124);

return statearr_26187;
})();
return cljs.core.async.ioc_alts_BANG_.call(null,state_26172__$1,(22),inst_26125);
} else {
if((state_val_26173 === (31))){
var inst_26154 = (state_26172[(2)]);
var state_26172__$1 = state_26172;
if(cljs.core.truth_(inst_26154)){
var statearr_26188_26244 = state_26172__$1;
(statearr_26188_26244[(1)] = (32));

} else {
var statearr_26189_26245 = state_26172__$1;
(statearr_26189_26245[(1)] = (33));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26173 === (32))){
var inst_26131 = (state_26172[(14)]);
var state_26172__$1 = state_26172;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_26172__$1,(35),out,inst_26131);
} else {
if((state_val_26173 === (33))){
var inst_26122 = (state_26172[(12)]);
var inst_26099 = inst_26122;
var state_26172__$1 = (function (){var statearr_26190 = state_26172;
(statearr_26190[(7)] = inst_26099);

return statearr_26190;
})();
var statearr_26191_26246 = state_26172__$1;
(statearr_26191_26246[(2)] = null);

(statearr_26191_26246[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26173 === (13))){
var inst_26099 = (state_26172[(7)]);
var inst_26106 = inst_26099.cljs$lang$protocol_mask$partition0$;
var inst_26107 = (inst_26106 & (64));
var inst_26108 = inst_26099.cljs$core$ISeq$;
var inst_26109 = (cljs.core.PROTOCOL_SENTINEL === inst_26108);
var inst_26110 = (inst_26107) || (inst_26109);
var state_26172__$1 = state_26172;
if(cljs.core.truth_(inst_26110)){
var statearr_26192_26247 = state_26172__$1;
(statearr_26192_26247[(1)] = (16));

} else {
var statearr_26193_26248 = state_26172__$1;
(statearr_26193_26248[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26173 === (22))){
var inst_26131 = (state_26172[(14)]);
var inst_26132 = (state_26172[(9)]);
var inst_26130 = (state_26172[(2)]);
var inst_26131__$1 = cljs.core.nth.call(null,inst_26130,(0),null);
var inst_26132__$1 = cljs.core.nth.call(null,inst_26130,(1),null);
var inst_26133 = (inst_26131__$1 == null);
var inst_26134 = cljs.core._EQ_.call(null,inst_26132__$1,change);
var inst_26135 = (inst_26133) || (inst_26134);
var state_26172__$1 = (function (){var statearr_26194 = state_26172;
(statearr_26194[(14)] = inst_26131__$1);

(statearr_26194[(9)] = inst_26132__$1);

return statearr_26194;
})();
if(cljs.core.truth_(inst_26135)){
var statearr_26195_26249 = state_26172__$1;
(statearr_26195_26249[(1)] = (23));

} else {
var statearr_26196_26250 = state_26172__$1;
(statearr_26196_26250[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26173 === (36))){
var inst_26122 = (state_26172[(12)]);
var inst_26099 = inst_26122;
var state_26172__$1 = (function (){var statearr_26197 = state_26172;
(statearr_26197[(7)] = inst_26099);

return statearr_26197;
})();
var statearr_26198_26251 = state_26172__$1;
(statearr_26198_26251[(2)] = null);

(statearr_26198_26251[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26173 === (29))){
var inst_26146 = (state_26172[(10)]);
var state_26172__$1 = state_26172;
var statearr_26199_26252 = state_26172__$1;
(statearr_26199_26252[(2)] = inst_26146);

(statearr_26199_26252[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26173 === (6))){
var state_26172__$1 = state_26172;
var statearr_26200_26253 = state_26172__$1;
(statearr_26200_26253[(2)] = false);

(statearr_26200_26253[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26173 === (28))){
var inst_26142 = (state_26172[(2)]);
var inst_26143 = calc_state.call(null);
var inst_26099 = inst_26143;
var state_26172__$1 = (function (){var statearr_26201 = state_26172;
(statearr_26201[(15)] = inst_26142);

(statearr_26201[(7)] = inst_26099);

return statearr_26201;
})();
var statearr_26202_26254 = state_26172__$1;
(statearr_26202_26254[(2)] = null);

(statearr_26202_26254[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26173 === (25))){
var inst_26168 = (state_26172[(2)]);
var state_26172__$1 = state_26172;
var statearr_26203_26255 = state_26172__$1;
(statearr_26203_26255[(2)] = inst_26168);

(statearr_26203_26255[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26173 === (34))){
var inst_26166 = (state_26172[(2)]);
var state_26172__$1 = state_26172;
var statearr_26204_26256 = state_26172__$1;
(statearr_26204_26256[(2)] = inst_26166);

(statearr_26204_26256[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26173 === (17))){
var state_26172__$1 = state_26172;
var statearr_26205_26257 = state_26172__$1;
(statearr_26205_26257[(2)] = false);

(statearr_26205_26257[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26173 === (3))){
var state_26172__$1 = state_26172;
var statearr_26206_26258 = state_26172__$1;
(statearr_26206_26258[(2)] = false);

(statearr_26206_26258[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26173 === (12))){
var inst_26170 = (state_26172[(2)]);
var state_26172__$1 = state_26172;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_26172__$1,inst_26170);
} else {
if((state_val_26173 === (2))){
var inst_26074 = (state_26172[(8)]);
var inst_26079 = inst_26074.cljs$lang$protocol_mask$partition0$;
var inst_26080 = (inst_26079 & (64));
var inst_26081 = inst_26074.cljs$core$ISeq$;
var inst_26082 = (cljs.core.PROTOCOL_SENTINEL === inst_26081);
var inst_26083 = (inst_26080) || (inst_26082);
var state_26172__$1 = state_26172;
if(cljs.core.truth_(inst_26083)){
var statearr_26207_26259 = state_26172__$1;
(statearr_26207_26259[(1)] = (5));

} else {
var statearr_26208_26260 = state_26172__$1;
(statearr_26208_26260[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26173 === (23))){
var inst_26131 = (state_26172[(14)]);
var inst_26137 = (inst_26131 == null);
var state_26172__$1 = state_26172;
if(cljs.core.truth_(inst_26137)){
var statearr_26209_26261 = state_26172__$1;
(statearr_26209_26261[(1)] = (26));

} else {
var statearr_26210_26262 = state_26172__$1;
(statearr_26210_26262[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26173 === (35))){
var inst_26157 = (state_26172[(2)]);
var state_26172__$1 = state_26172;
if(cljs.core.truth_(inst_26157)){
var statearr_26211_26263 = state_26172__$1;
(statearr_26211_26263[(1)] = (36));

} else {
var statearr_26212_26264 = state_26172__$1;
(statearr_26212_26264[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26173 === (19))){
var inst_26099 = (state_26172[(7)]);
var inst_26119 = cljs.core.apply.call(null,cljs.core.hash_map,inst_26099);
var state_26172__$1 = state_26172;
var statearr_26213_26265 = state_26172__$1;
(statearr_26213_26265[(2)] = inst_26119);

(statearr_26213_26265[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26173 === (11))){
var inst_26099 = (state_26172[(7)]);
var inst_26103 = (inst_26099 == null);
var inst_26104 = cljs.core.not.call(null,inst_26103);
var state_26172__$1 = state_26172;
if(inst_26104){
var statearr_26214_26266 = state_26172__$1;
(statearr_26214_26266[(1)] = (13));

} else {
var statearr_26215_26267 = state_26172__$1;
(statearr_26215_26267[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26173 === (9))){
var inst_26074 = (state_26172[(8)]);
var state_26172__$1 = state_26172;
var statearr_26216_26268 = state_26172__$1;
(statearr_26216_26268[(2)] = inst_26074);

(statearr_26216_26268[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26173 === (5))){
var state_26172__$1 = state_26172;
var statearr_26217_26269 = state_26172__$1;
(statearr_26217_26269[(2)] = true);

(statearr_26217_26269[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26173 === (14))){
var state_26172__$1 = state_26172;
var statearr_26218_26270 = state_26172__$1;
(statearr_26218_26270[(2)] = false);

(statearr_26218_26270[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26173 === (26))){
var inst_26132 = (state_26172[(9)]);
var inst_26139 = cljs.core.swap_BANG_.call(null,cs,cljs.core.dissoc,inst_26132);
var state_26172__$1 = state_26172;
var statearr_26219_26271 = state_26172__$1;
(statearr_26219_26271[(2)] = inst_26139);

(statearr_26219_26271[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26173 === (16))){
var state_26172__$1 = state_26172;
var statearr_26220_26272 = state_26172__$1;
(statearr_26220_26272[(2)] = true);

(statearr_26220_26272[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26173 === (38))){
var inst_26162 = (state_26172[(2)]);
var state_26172__$1 = state_26172;
var statearr_26221_26273 = state_26172__$1;
(statearr_26221_26273[(2)] = inst_26162);

(statearr_26221_26273[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26173 === (30))){
var inst_26132 = (state_26172[(9)]);
var inst_26123 = (state_26172[(11)]);
var inst_26124 = (state_26172[(13)]);
var inst_26149 = cljs.core.empty_QMARK_.call(null,inst_26123);
var inst_26150 = inst_26124.call(null,inst_26132);
var inst_26151 = cljs.core.not.call(null,inst_26150);
var inst_26152 = (inst_26149) && (inst_26151);
var state_26172__$1 = state_26172;
var statearr_26222_26274 = state_26172__$1;
(statearr_26222_26274[(2)] = inst_26152);

(statearr_26222_26274[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26173 === (10))){
var inst_26074 = (state_26172[(8)]);
var inst_26095 = (state_26172[(2)]);
var inst_26096 = cljs.core.get.call(null,inst_26095,new cljs.core.Keyword(null,"solos","solos",1441458643));
var inst_26097 = cljs.core.get.call(null,inst_26095,new cljs.core.Keyword(null,"mutes","mutes",1068806309));
var inst_26098 = cljs.core.get.call(null,inst_26095,new cljs.core.Keyword(null,"reads","reads",-1215067361));
var inst_26099 = inst_26074;
var state_26172__$1 = (function (){var statearr_26223 = state_26172;
(statearr_26223[(16)] = inst_26098);

(statearr_26223[(17)] = inst_26096);

(statearr_26223[(18)] = inst_26097);

(statearr_26223[(7)] = inst_26099);

return statearr_26223;
})();
var statearr_26224_26275 = state_26172__$1;
(statearr_26224_26275[(2)] = null);

(statearr_26224_26275[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26173 === (18))){
var inst_26114 = (state_26172[(2)]);
var state_26172__$1 = state_26172;
var statearr_26225_26276 = state_26172__$1;
(statearr_26225_26276[(2)] = inst_26114);

(statearr_26225_26276[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26173 === (37))){
var state_26172__$1 = state_26172;
var statearr_26226_26277 = state_26172__$1;
(statearr_26226_26277[(2)] = null);

(statearr_26226_26277[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26173 === (8))){
var inst_26074 = (state_26172[(8)]);
var inst_26092 = cljs.core.apply.call(null,cljs.core.hash_map,inst_26074);
var state_26172__$1 = state_26172;
var statearr_26227_26278 = state_26172__$1;
(statearr_26227_26278[(2)] = inst_26092);

(statearr_26227_26278[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__25187__auto___26232,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
;
return ((function (switch__25099__auto__,c__25187__auto___26232,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function() {
var cljs$core$async$mix_$_state_machine__25100__auto__ = null;
var cljs$core$async$mix_$_state_machine__25100__auto____0 = (function (){
var statearr_26228 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_26228[(0)] = cljs$core$async$mix_$_state_machine__25100__auto__);

(statearr_26228[(1)] = (1));

return statearr_26228;
});
var cljs$core$async$mix_$_state_machine__25100__auto____1 = (function (state_26172){
while(true){
var ret_value__25101__auto__ = (function (){try{while(true){
var result__25102__auto__ = switch__25099__auto__.call(null,state_26172);
if(cljs.core.keyword_identical_QMARK_.call(null,result__25102__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__25102__auto__;
}
break;
}
}catch (e26229){if((e26229 instanceof Object)){
var ex__25103__auto__ = e26229;
var statearr_26230_26279 = state_26172;
(statearr_26230_26279[(5)] = ex__25103__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_26172);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e26229;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__25101__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__26280 = state_26172;
state_26172 = G__26280;
continue;
} else {
return ret_value__25101__auto__;
}
break;
}
});
cljs$core$async$mix_$_state_machine__25100__auto__ = function(state_26172){
switch(arguments.length){
case 0:
return cljs$core$async$mix_$_state_machine__25100__auto____0.call(this);
case 1:
return cljs$core$async$mix_$_state_machine__25100__auto____1.call(this,state_26172);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$mix_$_state_machine__25100__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mix_$_state_machine__25100__auto____0;
cljs$core$async$mix_$_state_machine__25100__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mix_$_state_machine__25100__auto____1;
return cljs$core$async$mix_$_state_machine__25100__auto__;
})()
;})(switch__25099__auto__,c__25187__auto___26232,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
})();
var state__25189__auto__ = (function (){var statearr_26231 = f__25188__auto__.call(null);
(statearr_26231[(6)] = c__25187__auto___26232);

return statearr_26231;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__25189__auto__);
});})(c__25187__auto___26232,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
);


return m;
});
/**
 * Adds ch as an input to the mix
 */
cljs.core.async.admix = (function cljs$core$async$admix(mix,ch){
return cljs.core.async.admix_STAR_.call(null,mix,ch);
});
/**
 * Removes ch as an input to the mix
 */
cljs.core.async.unmix = (function cljs$core$async$unmix(mix,ch){
return cljs.core.async.unmix_STAR_.call(null,mix,ch);
});
/**
 * removes all inputs from the mix
 */
cljs.core.async.unmix_all = (function cljs$core$async$unmix_all(mix){
return cljs.core.async.unmix_all_STAR_.call(null,mix);
});
/**
 * Atomically sets the state(s) of one or more channels in a mix. The
 *   state map is a map of channels -> channel-state-map. A
 *   channel-state-map is a map of attrs -> boolean, where attr is one or
 *   more of :mute, :pause or :solo. Any states supplied are merged with
 *   the current state.
 * 
 *   Note that channels can be added to a mix via toggle, which can be
 *   used to add channels in a particular (e.g. paused) state.
 */
cljs.core.async.toggle = (function cljs$core$async$toggle(mix,state_map){
return cljs.core.async.toggle_STAR_.call(null,mix,state_map);
});
/**
 * Sets the solo mode of the mix. mode must be one of :mute or :pause
 */
cljs.core.async.solo_mode = (function cljs$core$async$solo_mode(mix,mode){
return cljs.core.async.solo_mode_STAR_.call(null,mix,mode);
});

/**
 * @interface
 */
cljs.core.async.Pub = function(){};

cljs.core.async.sub_STAR_ = (function cljs$core$async$sub_STAR_(p,v,ch,close_QMARK_){
if((!((p == null))) && (!((p.cljs$core$async$Pub$sub_STAR_$arity$4 == null)))){
return p.cljs$core$async$Pub$sub_STAR_$arity$4(p,v,ch,close_QMARK_);
} else {
var x__8869__auto__ = (((p == null))?null:p);
var m__8870__auto__ = (cljs.core.async.sub_STAR_[goog.typeOf(x__8869__auto__)]);
if(!((m__8870__auto__ == null))){
return m__8870__auto__.call(null,p,v,ch,close_QMARK_);
} else {
var m__8870__auto____$1 = (cljs.core.async.sub_STAR_["_"]);
if(!((m__8870__auto____$1 == null))){
return m__8870__auto____$1.call(null,p,v,ch,close_QMARK_);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.sub*",p);
}
}
}
});

cljs.core.async.unsub_STAR_ = (function cljs$core$async$unsub_STAR_(p,v,ch){
if((!((p == null))) && (!((p.cljs$core$async$Pub$unsub_STAR_$arity$3 == null)))){
return p.cljs$core$async$Pub$unsub_STAR_$arity$3(p,v,ch);
} else {
var x__8869__auto__ = (((p == null))?null:p);
var m__8870__auto__ = (cljs.core.async.unsub_STAR_[goog.typeOf(x__8869__auto__)]);
if(!((m__8870__auto__ == null))){
return m__8870__auto__.call(null,p,v,ch);
} else {
var m__8870__auto____$1 = (cljs.core.async.unsub_STAR_["_"]);
if(!((m__8870__auto____$1 == null))){
return m__8870__auto____$1.call(null,p,v,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.unsub*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_ = (function cljs$core$async$unsub_all_STAR_(var_args){
var G__26282 = arguments.length;
switch (G__26282) {
case 1:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1 = (function (p){
if((!((p == null))) && (!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$1 == null)))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$1(p);
} else {
var x__8869__auto__ = (((p == null))?null:p);
var m__8870__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__8869__auto__)]);
if(!((m__8870__auto__ == null))){
return m__8870__auto__.call(null,p);
} else {
var m__8870__auto____$1 = (cljs.core.async.unsub_all_STAR_["_"]);
if(!((m__8870__auto____$1 == null))){
return m__8870__auto____$1.call(null,p);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.unsub-all*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2 = (function (p,v){
if((!((p == null))) && (!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$2 == null)))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$2(p,v);
} else {
var x__8869__auto__ = (((p == null))?null:p);
var m__8870__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__8869__auto__)]);
if(!((m__8870__auto__ == null))){
return m__8870__auto__.call(null,p,v);
} else {
var m__8870__auto____$1 = (cljs.core.async.unsub_all_STAR_["_"]);
if(!((m__8870__auto____$1 == null))){
return m__8870__auto____$1.call(null,p,v);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.unsub-all*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_.cljs$lang$maxFixedArity = 2;


/**
 * Creates and returns a pub(lication) of the supplied channel,
 *   partitioned into topics by the topic-fn. topic-fn will be applied to
 *   each value on the channel and the result will determine the 'topic'
 *   on which that value will be put. Channels can be subscribed to
 *   receive copies of topics using 'sub', and unsubscribed using
 *   'unsub'. Each topic will be handled by an internal mult on a
 *   dedicated channel. By default these internal channels are
 *   unbuffered, but a buf-fn can be supplied which, given a topic,
 *   creates a buffer with desired properties.
 * 
 *   Each item is distributed to all subs in parallel and synchronously,
 *   i.e. each sub must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow subs from holding up the pub.
 * 
 *   Items received when there are no matching subs get dropped.
 * 
 *   Note that if buf-fns are used then each topic is handled
 *   asynchronously, i.e. if a channel is subscribed to more than one
 *   topic it should not expect them to be interleaved identically with
 *   the source.
 */
cljs.core.async.pub = (function cljs$core$async$pub(var_args){
var G__26286 = arguments.length;
switch (G__26286) {
case 2:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2 = (function (ch,topic_fn){
return cljs.core.async.pub.call(null,ch,topic_fn,cljs.core.constantly.call(null,null));
});

cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3 = (function (ch,topic_fn,buf_fn){
var mults = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var ensure_mult = ((function (mults){
return (function (topic){
var or__8186__auto__ = cljs.core.get.call(null,cljs.core.deref.call(null,mults),topic);
if(cljs.core.truth_(or__8186__auto__)){
return or__8186__auto__;
} else {
return cljs.core.get.call(null,cljs.core.swap_BANG_.call(null,mults,((function (or__8186__auto__,mults){
return (function (p1__26284_SHARP_){
if(cljs.core.truth_(p1__26284_SHARP_.call(null,topic))){
return p1__26284_SHARP_;
} else {
return cljs.core.assoc.call(null,p1__26284_SHARP_,topic,cljs.core.async.mult.call(null,cljs.core.async.chan.call(null,buf_fn.call(null,topic))));
}
});})(or__8186__auto__,mults))
),topic);
}
});})(mults))
;
var p = (function (){
if(typeof cljs.core.async.t_cljs$core$async26287 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Pub}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async26287 = (function (ch,topic_fn,buf_fn,mults,ensure_mult,meta26288){
this.ch = ch;
this.topic_fn = topic_fn;
this.buf_fn = buf_fn;
this.mults = mults;
this.ensure_mult = ensure_mult;
this.meta26288 = meta26288;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async26287.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (mults,ensure_mult){
return (function (_26289,meta26288__$1){
var self__ = this;
var _26289__$1 = this;
return (new cljs.core.async.t_cljs$core$async26287(self__.ch,self__.topic_fn,self__.buf_fn,self__.mults,self__.ensure_mult,meta26288__$1));
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async26287.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (mults,ensure_mult){
return (function (_26289){
var self__ = this;
var _26289__$1 = this;
return self__.meta26288;
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async26287.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async26287.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (mults,ensure_mult){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async26287.prototype.cljs$core$async$Pub$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async26287.prototype.cljs$core$async$Pub$sub_STAR_$arity$4 = ((function (mults,ensure_mult){
return (function (p,topic,ch__$1,close_QMARK_){
var self__ = this;
var p__$1 = this;
var m = self__.ensure_mult.call(null,topic);
return cljs.core.async.tap.call(null,m,ch__$1,close_QMARK_);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async26287.prototype.cljs$core$async$Pub$unsub_STAR_$arity$3 = ((function (mults,ensure_mult){
return (function (p,topic,ch__$1){
var self__ = this;
var p__$1 = this;
var temp__4657__auto__ = cljs.core.get.call(null,cljs.core.deref.call(null,self__.mults),topic);
if(cljs.core.truth_(temp__4657__auto__)){
var m = temp__4657__auto__;
return cljs.core.async.untap.call(null,m,ch__$1);
} else {
return null;
}
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async26287.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$1 = ((function (mults,ensure_mult){
return (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.reset_BANG_.call(null,self__.mults,cljs.core.PersistentArrayMap.EMPTY);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async26287.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$2 = ((function (mults,ensure_mult){
return (function (_,topic){
var self__ = this;
var ___$1 = this;
return cljs.core.swap_BANG_.call(null,self__.mults,cljs.core.dissoc,topic);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async26287.getBasis = ((function (mults,ensure_mult){
return (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"topic-fn","topic-fn",-862449736,null),new cljs.core.Symbol(null,"buf-fn","buf-fn",-1200281591,null),new cljs.core.Symbol(null,"mults","mults",-461114485,null),new cljs.core.Symbol(null,"ensure-mult","ensure-mult",1796584816,null),new cljs.core.Symbol(null,"meta26288","meta26288",-550335003,null)], null);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async26287.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async26287.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async26287";

cljs.core.async.t_cljs$core$async26287.cljs$lang$ctorPrWriter = ((function (mults,ensure_mult){
return (function (this__8811__auto__,writer__8812__auto__,opt__8813__auto__){
return cljs.core._write.call(null,writer__8812__auto__,"cljs.core.async/t_cljs$core$async26287");
});})(mults,ensure_mult))
;

cljs.core.async.__GT_t_cljs$core$async26287 = ((function (mults,ensure_mult){
return (function cljs$core$async$__GT_t_cljs$core$async26287(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta26288){
return (new cljs.core.async.t_cljs$core$async26287(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta26288));
});})(mults,ensure_mult))
;

}

return (new cljs.core.async.t_cljs$core$async26287(ch,topic_fn,buf_fn,mults,ensure_mult,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__25187__auto___26407 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__25187__auto___26407,mults,ensure_mult,p){
return (function (){
var f__25188__auto__ = (function (){var switch__25099__auto__ = ((function (c__25187__auto___26407,mults,ensure_mult,p){
return (function (state_26361){
var state_val_26362 = (state_26361[(1)]);
if((state_val_26362 === (7))){
var inst_26357 = (state_26361[(2)]);
var state_26361__$1 = state_26361;
var statearr_26363_26408 = state_26361__$1;
(statearr_26363_26408[(2)] = inst_26357);

(statearr_26363_26408[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26362 === (20))){
var state_26361__$1 = state_26361;
var statearr_26364_26409 = state_26361__$1;
(statearr_26364_26409[(2)] = null);

(statearr_26364_26409[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26362 === (1))){
var state_26361__$1 = state_26361;
var statearr_26365_26410 = state_26361__$1;
(statearr_26365_26410[(2)] = null);

(statearr_26365_26410[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26362 === (24))){
var inst_26340 = (state_26361[(7)]);
var inst_26349 = cljs.core.swap_BANG_.call(null,mults,cljs.core.dissoc,inst_26340);
var state_26361__$1 = state_26361;
var statearr_26366_26411 = state_26361__$1;
(statearr_26366_26411[(2)] = inst_26349);

(statearr_26366_26411[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26362 === (4))){
var inst_26292 = (state_26361[(8)]);
var inst_26292__$1 = (state_26361[(2)]);
var inst_26293 = (inst_26292__$1 == null);
var state_26361__$1 = (function (){var statearr_26367 = state_26361;
(statearr_26367[(8)] = inst_26292__$1);

return statearr_26367;
})();
if(cljs.core.truth_(inst_26293)){
var statearr_26368_26412 = state_26361__$1;
(statearr_26368_26412[(1)] = (5));

} else {
var statearr_26369_26413 = state_26361__$1;
(statearr_26369_26413[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26362 === (15))){
var inst_26334 = (state_26361[(2)]);
var state_26361__$1 = state_26361;
var statearr_26370_26414 = state_26361__$1;
(statearr_26370_26414[(2)] = inst_26334);

(statearr_26370_26414[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26362 === (21))){
var inst_26354 = (state_26361[(2)]);
var state_26361__$1 = (function (){var statearr_26371 = state_26361;
(statearr_26371[(9)] = inst_26354);

return statearr_26371;
})();
var statearr_26372_26415 = state_26361__$1;
(statearr_26372_26415[(2)] = null);

(statearr_26372_26415[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26362 === (13))){
var inst_26316 = (state_26361[(10)]);
var inst_26318 = cljs.core.chunked_seq_QMARK_.call(null,inst_26316);
var state_26361__$1 = state_26361;
if(inst_26318){
var statearr_26373_26416 = state_26361__$1;
(statearr_26373_26416[(1)] = (16));

} else {
var statearr_26374_26417 = state_26361__$1;
(statearr_26374_26417[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26362 === (22))){
var inst_26346 = (state_26361[(2)]);
var state_26361__$1 = state_26361;
if(cljs.core.truth_(inst_26346)){
var statearr_26375_26418 = state_26361__$1;
(statearr_26375_26418[(1)] = (23));

} else {
var statearr_26376_26419 = state_26361__$1;
(statearr_26376_26419[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26362 === (6))){
var inst_26342 = (state_26361[(11)]);
var inst_26292 = (state_26361[(8)]);
var inst_26340 = (state_26361[(7)]);
var inst_26340__$1 = topic_fn.call(null,inst_26292);
var inst_26341 = cljs.core.deref.call(null,mults);
var inst_26342__$1 = cljs.core.get.call(null,inst_26341,inst_26340__$1);
var state_26361__$1 = (function (){var statearr_26377 = state_26361;
(statearr_26377[(11)] = inst_26342__$1);

(statearr_26377[(7)] = inst_26340__$1);

return statearr_26377;
})();
if(cljs.core.truth_(inst_26342__$1)){
var statearr_26378_26420 = state_26361__$1;
(statearr_26378_26420[(1)] = (19));

} else {
var statearr_26379_26421 = state_26361__$1;
(statearr_26379_26421[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26362 === (25))){
var inst_26351 = (state_26361[(2)]);
var state_26361__$1 = state_26361;
var statearr_26380_26422 = state_26361__$1;
(statearr_26380_26422[(2)] = inst_26351);

(statearr_26380_26422[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26362 === (17))){
var inst_26316 = (state_26361[(10)]);
var inst_26325 = cljs.core.first.call(null,inst_26316);
var inst_26326 = cljs.core.async.muxch_STAR_.call(null,inst_26325);
var inst_26327 = cljs.core.async.close_BANG_.call(null,inst_26326);
var inst_26328 = cljs.core.next.call(null,inst_26316);
var inst_26302 = inst_26328;
var inst_26303 = null;
var inst_26304 = (0);
var inst_26305 = (0);
var state_26361__$1 = (function (){var statearr_26381 = state_26361;
(statearr_26381[(12)] = inst_26327);

(statearr_26381[(13)] = inst_26304);

(statearr_26381[(14)] = inst_26303);

(statearr_26381[(15)] = inst_26302);

(statearr_26381[(16)] = inst_26305);

return statearr_26381;
})();
var statearr_26382_26423 = state_26361__$1;
(statearr_26382_26423[(2)] = null);

(statearr_26382_26423[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26362 === (3))){
var inst_26359 = (state_26361[(2)]);
var state_26361__$1 = state_26361;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_26361__$1,inst_26359);
} else {
if((state_val_26362 === (12))){
var inst_26336 = (state_26361[(2)]);
var state_26361__$1 = state_26361;
var statearr_26383_26424 = state_26361__$1;
(statearr_26383_26424[(2)] = inst_26336);

(statearr_26383_26424[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26362 === (2))){
var state_26361__$1 = state_26361;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_26361__$1,(4),ch);
} else {
if((state_val_26362 === (23))){
var state_26361__$1 = state_26361;
var statearr_26384_26425 = state_26361__$1;
(statearr_26384_26425[(2)] = null);

(statearr_26384_26425[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26362 === (19))){
var inst_26342 = (state_26361[(11)]);
var inst_26292 = (state_26361[(8)]);
var inst_26344 = cljs.core.async.muxch_STAR_.call(null,inst_26342);
var state_26361__$1 = state_26361;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_26361__$1,(22),inst_26344,inst_26292);
} else {
if((state_val_26362 === (11))){
var inst_26316 = (state_26361[(10)]);
var inst_26302 = (state_26361[(15)]);
var inst_26316__$1 = cljs.core.seq.call(null,inst_26302);
var state_26361__$1 = (function (){var statearr_26385 = state_26361;
(statearr_26385[(10)] = inst_26316__$1);

return statearr_26385;
})();
if(inst_26316__$1){
var statearr_26386_26426 = state_26361__$1;
(statearr_26386_26426[(1)] = (13));

} else {
var statearr_26387_26427 = state_26361__$1;
(statearr_26387_26427[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26362 === (9))){
var inst_26338 = (state_26361[(2)]);
var state_26361__$1 = state_26361;
var statearr_26388_26428 = state_26361__$1;
(statearr_26388_26428[(2)] = inst_26338);

(statearr_26388_26428[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26362 === (5))){
var inst_26299 = cljs.core.deref.call(null,mults);
var inst_26300 = cljs.core.vals.call(null,inst_26299);
var inst_26301 = cljs.core.seq.call(null,inst_26300);
var inst_26302 = inst_26301;
var inst_26303 = null;
var inst_26304 = (0);
var inst_26305 = (0);
var state_26361__$1 = (function (){var statearr_26389 = state_26361;
(statearr_26389[(13)] = inst_26304);

(statearr_26389[(14)] = inst_26303);

(statearr_26389[(15)] = inst_26302);

(statearr_26389[(16)] = inst_26305);

return statearr_26389;
})();
var statearr_26390_26429 = state_26361__$1;
(statearr_26390_26429[(2)] = null);

(statearr_26390_26429[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26362 === (14))){
var state_26361__$1 = state_26361;
var statearr_26394_26430 = state_26361__$1;
(statearr_26394_26430[(2)] = null);

(statearr_26394_26430[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26362 === (16))){
var inst_26316 = (state_26361[(10)]);
var inst_26320 = cljs.core.chunk_first.call(null,inst_26316);
var inst_26321 = cljs.core.chunk_rest.call(null,inst_26316);
var inst_26322 = cljs.core.count.call(null,inst_26320);
var inst_26302 = inst_26321;
var inst_26303 = inst_26320;
var inst_26304 = inst_26322;
var inst_26305 = (0);
var state_26361__$1 = (function (){var statearr_26395 = state_26361;
(statearr_26395[(13)] = inst_26304);

(statearr_26395[(14)] = inst_26303);

(statearr_26395[(15)] = inst_26302);

(statearr_26395[(16)] = inst_26305);

return statearr_26395;
})();
var statearr_26396_26431 = state_26361__$1;
(statearr_26396_26431[(2)] = null);

(statearr_26396_26431[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26362 === (10))){
var inst_26304 = (state_26361[(13)]);
var inst_26303 = (state_26361[(14)]);
var inst_26302 = (state_26361[(15)]);
var inst_26305 = (state_26361[(16)]);
var inst_26310 = cljs.core._nth.call(null,inst_26303,inst_26305);
var inst_26311 = cljs.core.async.muxch_STAR_.call(null,inst_26310);
var inst_26312 = cljs.core.async.close_BANG_.call(null,inst_26311);
var inst_26313 = (inst_26305 + (1));
var tmp26391 = inst_26304;
var tmp26392 = inst_26303;
var tmp26393 = inst_26302;
var inst_26302__$1 = tmp26393;
var inst_26303__$1 = tmp26392;
var inst_26304__$1 = tmp26391;
var inst_26305__$1 = inst_26313;
var state_26361__$1 = (function (){var statearr_26397 = state_26361;
(statearr_26397[(13)] = inst_26304__$1);

(statearr_26397[(14)] = inst_26303__$1);

(statearr_26397[(17)] = inst_26312);

(statearr_26397[(15)] = inst_26302__$1);

(statearr_26397[(16)] = inst_26305__$1);

return statearr_26397;
})();
var statearr_26398_26432 = state_26361__$1;
(statearr_26398_26432[(2)] = null);

(statearr_26398_26432[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26362 === (18))){
var inst_26331 = (state_26361[(2)]);
var state_26361__$1 = state_26361;
var statearr_26399_26433 = state_26361__$1;
(statearr_26399_26433[(2)] = inst_26331);

(statearr_26399_26433[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26362 === (8))){
var inst_26304 = (state_26361[(13)]);
var inst_26305 = (state_26361[(16)]);
var inst_26307 = (inst_26305 < inst_26304);
var inst_26308 = inst_26307;
var state_26361__$1 = state_26361;
if(cljs.core.truth_(inst_26308)){
var statearr_26400_26434 = state_26361__$1;
(statearr_26400_26434[(1)] = (10));

} else {
var statearr_26401_26435 = state_26361__$1;
(statearr_26401_26435[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__25187__auto___26407,mults,ensure_mult,p))
;
return ((function (switch__25099__auto__,c__25187__auto___26407,mults,ensure_mult,p){
return (function() {
var cljs$core$async$state_machine__25100__auto__ = null;
var cljs$core$async$state_machine__25100__auto____0 = (function (){
var statearr_26402 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_26402[(0)] = cljs$core$async$state_machine__25100__auto__);

(statearr_26402[(1)] = (1));

return statearr_26402;
});
var cljs$core$async$state_machine__25100__auto____1 = (function (state_26361){
while(true){
var ret_value__25101__auto__ = (function (){try{while(true){
var result__25102__auto__ = switch__25099__auto__.call(null,state_26361);
if(cljs.core.keyword_identical_QMARK_.call(null,result__25102__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__25102__auto__;
}
break;
}
}catch (e26403){if((e26403 instanceof Object)){
var ex__25103__auto__ = e26403;
var statearr_26404_26436 = state_26361;
(statearr_26404_26436[(5)] = ex__25103__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_26361);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e26403;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__25101__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__26437 = state_26361;
state_26361 = G__26437;
continue;
} else {
return ret_value__25101__auto__;
}
break;
}
});
cljs$core$async$state_machine__25100__auto__ = function(state_26361){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__25100__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__25100__auto____1.call(this,state_26361);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$state_machine__25100__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__25100__auto____0;
cljs$core$async$state_machine__25100__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__25100__auto____1;
return cljs$core$async$state_machine__25100__auto__;
})()
;})(switch__25099__auto__,c__25187__auto___26407,mults,ensure_mult,p))
})();
var state__25189__auto__ = (function (){var statearr_26405 = f__25188__auto__.call(null);
(statearr_26405[(6)] = c__25187__auto___26407);

return statearr_26405;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__25189__auto__);
});})(c__25187__auto___26407,mults,ensure_mult,p))
);


return p;
});

cljs.core.async.pub.cljs$lang$maxFixedArity = 3;

/**
 * Subscribes a channel to a topic of a pub.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.sub = (function cljs$core$async$sub(var_args){
var G__26439 = arguments.length;
switch (G__26439) {
case 3:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3 = (function (p,topic,ch){
return cljs.core.async.sub.call(null,p,topic,ch,true);
});

cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4 = (function (p,topic,ch,close_QMARK_){
return cljs.core.async.sub_STAR_.call(null,p,topic,ch,close_QMARK_);
});

cljs.core.async.sub.cljs$lang$maxFixedArity = 4;

/**
 * Unsubscribes a channel from a topic of a pub
 */
cljs.core.async.unsub = (function cljs$core$async$unsub(p,topic,ch){
return cljs.core.async.unsub_STAR_.call(null,p,topic,ch);
});
/**
 * Unsubscribes all channels from a pub, or a topic of a pub
 */
cljs.core.async.unsub_all = (function cljs$core$async$unsub_all(var_args){
var G__26442 = arguments.length;
switch (G__26442) {
case 1:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1 = (function (p){
return cljs.core.async.unsub_all_STAR_.call(null,p);
});

cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2 = (function (p,topic){
return cljs.core.async.unsub_all_STAR_.call(null,p,topic);
});

cljs.core.async.unsub_all.cljs$lang$maxFixedArity = 2;

/**
 * Takes a function and a collection of source channels, and returns a
 *   channel which contains the values produced by applying f to the set
 *   of first items taken from each source channel, followed by applying
 *   f to the set of second items from each channel, until any one of the
 *   channels is closed, at which point the output channel will be
 *   closed. The returned channel will be unbuffered by default, or a
 *   buf-or-n can be supplied
 */
cljs.core.async.map = (function cljs$core$async$map(var_args){
var G__26445 = arguments.length;
switch (G__26445) {
case 2:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.map.cljs$core$IFn$_invoke$arity$2 = (function (f,chs){
return cljs.core.async.map.call(null,f,chs,null);
});

cljs.core.async.map.cljs$core$IFn$_invoke$arity$3 = (function (f,chs,buf_or_n){
var chs__$1 = cljs.core.vec.call(null,chs);
var out = cljs.core.async.chan.call(null,buf_or_n);
var cnt = cljs.core.count.call(null,chs__$1);
var rets = cljs.core.object_array.call(null,cnt);
var dchan = cljs.core.async.chan.call(null,(1));
var dctr = cljs.core.atom.call(null,null);
var done = cljs.core.mapv.call(null,((function (chs__$1,out,cnt,rets,dchan,dctr){
return (function (i){
return ((function (chs__$1,out,cnt,rets,dchan,dctr){
return (function (ret){
(rets[i] = ret);

if((cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.call(null,dchan,rets.slice((0)));
} else {
return null;
}
});
;})(chs__$1,out,cnt,rets,dchan,dctr))
});})(chs__$1,out,cnt,rets,dchan,dctr))
,cljs.core.range.call(null,cnt));
var c__25187__auto___26512 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__25187__auto___26512,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function (){
var f__25188__auto__ = (function (){var switch__25099__auto__ = ((function (c__25187__auto___26512,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function (state_26484){
var state_val_26485 = (state_26484[(1)]);
if((state_val_26485 === (7))){
var state_26484__$1 = state_26484;
var statearr_26486_26513 = state_26484__$1;
(statearr_26486_26513[(2)] = null);

(statearr_26486_26513[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26485 === (1))){
var state_26484__$1 = state_26484;
var statearr_26487_26514 = state_26484__$1;
(statearr_26487_26514[(2)] = null);

(statearr_26487_26514[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26485 === (4))){
var inst_26448 = (state_26484[(7)]);
var inst_26450 = (inst_26448 < cnt);
var state_26484__$1 = state_26484;
if(cljs.core.truth_(inst_26450)){
var statearr_26488_26515 = state_26484__$1;
(statearr_26488_26515[(1)] = (6));

} else {
var statearr_26489_26516 = state_26484__$1;
(statearr_26489_26516[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26485 === (15))){
var inst_26480 = (state_26484[(2)]);
var state_26484__$1 = state_26484;
var statearr_26490_26517 = state_26484__$1;
(statearr_26490_26517[(2)] = inst_26480);

(statearr_26490_26517[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26485 === (13))){
var inst_26473 = cljs.core.async.close_BANG_.call(null,out);
var state_26484__$1 = state_26484;
var statearr_26491_26518 = state_26484__$1;
(statearr_26491_26518[(2)] = inst_26473);

(statearr_26491_26518[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26485 === (6))){
var state_26484__$1 = state_26484;
var statearr_26492_26519 = state_26484__$1;
(statearr_26492_26519[(2)] = null);

(statearr_26492_26519[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26485 === (3))){
var inst_26482 = (state_26484[(2)]);
var state_26484__$1 = state_26484;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_26484__$1,inst_26482);
} else {
if((state_val_26485 === (12))){
var inst_26470 = (state_26484[(8)]);
var inst_26470__$1 = (state_26484[(2)]);
var inst_26471 = cljs.core.some.call(null,cljs.core.nil_QMARK_,inst_26470__$1);
var state_26484__$1 = (function (){var statearr_26493 = state_26484;
(statearr_26493[(8)] = inst_26470__$1);

return statearr_26493;
})();
if(cljs.core.truth_(inst_26471)){
var statearr_26494_26520 = state_26484__$1;
(statearr_26494_26520[(1)] = (13));

} else {
var statearr_26495_26521 = state_26484__$1;
(statearr_26495_26521[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26485 === (2))){
var inst_26447 = cljs.core.reset_BANG_.call(null,dctr,cnt);
var inst_26448 = (0);
var state_26484__$1 = (function (){var statearr_26496 = state_26484;
(statearr_26496[(9)] = inst_26447);

(statearr_26496[(7)] = inst_26448);

return statearr_26496;
})();
var statearr_26497_26522 = state_26484__$1;
(statearr_26497_26522[(2)] = null);

(statearr_26497_26522[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26485 === (11))){
var inst_26448 = (state_26484[(7)]);
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame.call(null,state_26484,(10),Object,null,(9));
var inst_26457 = chs__$1.call(null,inst_26448);
var inst_26458 = done.call(null,inst_26448);
var inst_26459 = cljs.core.async.take_BANG_.call(null,inst_26457,inst_26458);
var state_26484__$1 = state_26484;
var statearr_26498_26523 = state_26484__$1;
(statearr_26498_26523[(2)] = inst_26459);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_26484__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26485 === (9))){
var inst_26448 = (state_26484[(7)]);
var inst_26461 = (state_26484[(2)]);
var inst_26462 = (inst_26448 + (1));
var inst_26448__$1 = inst_26462;
var state_26484__$1 = (function (){var statearr_26499 = state_26484;
(statearr_26499[(10)] = inst_26461);

(statearr_26499[(7)] = inst_26448__$1);

return statearr_26499;
})();
var statearr_26500_26524 = state_26484__$1;
(statearr_26500_26524[(2)] = null);

(statearr_26500_26524[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26485 === (5))){
var inst_26468 = (state_26484[(2)]);
var state_26484__$1 = (function (){var statearr_26501 = state_26484;
(statearr_26501[(11)] = inst_26468);

return statearr_26501;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_26484__$1,(12),dchan);
} else {
if((state_val_26485 === (14))){
var inst_26470 = (state_26484[(8)]);
var inst_26475 = cljs.core.apply.call(null,f,inst_26470);
var state_26484__$1 = state_26484;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_26484__$1,(16),out,inst_26475);
} else {
if((state_val_26485 === (16))){
var inst_26477 = (state_26484[(2)]);
var state_26484__$1 = (function (){var statearr_26502 = state_26484;
(statearr_26502[(12)] = inst_26477);

return statearr_26502;
})();
var statearr_26503_26525 = state_26484__$1;
(statearr_26503_26525[(2)] = null);

(statearr_26503_26525[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26485 === (10))){
var inst_26452 = (state_26484[(2)]);
var inst_26453 = cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec);
var state_26484__$1 = (function (){var statearr_26504 = state_26484;
(statearr_26504[(13)] = inst_26452);

return statearr_26504;
})();
var statearr_26505_26526 = state_26484__$1;
(statearr_26505_26526[(2)] = inst_26453);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_26484__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26485 === (8))){
var inst_26466 = (state_26484[(2)]);
var state_26484__$1 = state_26484;
var statearr_26506_26527 = state_26484__$1;
(statearr_26506_26527[(2)] = inst_26466);

(statearr_26506_26527[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__25187__auto___26512,chs__$1,out,cnt,rets,dchan,dctr,done))
;
return ((function (switch__25099__auto__,c__25187__auto___26512,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function() {
var cljs$core$async$state_machine__25100__auto__ = null;
var cljs$core$async$state_machine__25100__auto____0 = (function (){
var statearr_26507 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_26507[(0)] = cljs$core$async$state_machine__25100__auto__);

(statearr_26507[(1)] = (1));

return statearr_26507;
});
var cljs$core$async$state_machine__25100__auto____1 = (function (state_26484){
while(true){
var ret_value__25101__auto__ = (function (){try{while(true){
var result__25102__auto__ = switch__25099__auto__.call(null,state_26484);
if(cljs.core.keyword_identical_QMARK_.call(null,result__25102__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__25102__auto__;
}
break;
}
}catch (e26508){if((e26508 instanceof Object)){
var ex__25103__auto__ = e26508;
var statearr_26509_26528 = state_26484;
(statearr_26509_26528[(5)] = ex__25103__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_26484);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e26508;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__25101__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__26529 = state_26484;
state_26484 = G__26529;
continue;
} else {
return ret_value__25101__auto__;
}
break;
}
});
cljs$core$async$state_machine__25100__auto__ = function(state_26484){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__25100__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__25100__auto____1.call(this,state_26484);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$state_machine__25100__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__25100__auto____0;
cljs$core$async$state_machine__25100__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__25100__auto____1;
return cljs$core$async$state_machine__25100__auto__;
})()
;})(switch__25099__auto__,c__25187__auto___26512,chs__$1,out,cnt,rets,dchan,dctr,done))
})();
var state__25189__auto__ = (function (){var statearr_26510 = f__25188__auto__.call(null);
(statearr_26510[(6)] = c__25187__auto___26512);

return statearr_26510;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__25189__auto__);
});})(c__25187__auto___26512,chs__$1,out,cnt,rets,dchan,dctr,done))
);


return out;
});

cljs.core.async.map.cljs$lang$maxFixedArity = 3;

/**
 * Takes a collection of source channels and returns a channel which
 *   contains all values taken from them. The returned channel will be
 *   unbuffered by default, or a buf-or-n can be supplied. The channel
 *   will close after all the source channels have closed.
 */
cljs.core.async.merge = (function cljs$core$async$merge(var_args){
var G__26532 = arguments.length;
switch (G__26532) {
case 1:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1 = (function (chs){
return cljs.core.async.merge.call(null,chs,null);
});

cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2 = (function (chs,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__25187__auto___26586 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__25187__auto___26586,out){
return (function (){
var f__25188__auto__ = (function (){var switch__25099__auto__ = ((function (c__25187__auto___26586,out){
return (function (state_26564){
var state_val_26565 = (state_26564[(1)]);
if((state_val_26565 === (7))){
var inst_26543 = (state_26564[(7)]);
var inst_26544 = (state_26564[(8)]);
var inst_26543__$1 = (state_26564[(2)]);
var inst_26544__$1 = cljs.core.nth.call(null,inst_26543__$1,(0),null);
var inst_26545 = cljs.core.nth.call(null,inst_26543__$1,(1),null);
var inst_26546 = (inst_26544__$1 == null);
var state_26564__$1 = (function (){var statearr_26566 = state_26564;
(statearr_26566[(7)] = inst_26543__$1);

(statearr_26566[(8)] = inst_26544__$1);

(statearr_26566[(9)] = inst_26545);

return statearr_26566;
})();
if(cljs.core.truth_(inst_26546)){
var statearr_26567_26587 = state_26564__$1;
(statearr_26567_26587[(1)] = (8));

} else {
var statearr_26568_26588 = state_26564__$1;
(statearr_26568_26588[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26565 === (1))){
var inst_26533 = cljs.core.vec.call(null,chs);
var inst_26534 = inst_26533;
var state_26564__$1 = (function (){var statearr_26569 = state_26564;
(statearr_26569[(10)] = inst_26534);

return statearr_26569;
})();
var statearr_26570_26589 = state_26564__$1;
(statearr_26570_26589[(2)] = null);

(statearr_26570_26589[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26565 === (4))){
var inst_26534 = (state_26564[(10)]);
var state_26564__$1 = state_26564;
return cljs.core.async.ioc_alts_BANG_.call(null,state_26564__$1,(7),inst_26534);
} else {
if((state_val_26565 === (6))){
var inst_26560 = (state_26564[(2)]);
var state_26564__$1 = state_26564;
var statearr_26571_26590 = state_26564__$1;
(statearr_26571_26590[(2)] = inst_26560);

(statearr_26571_26590[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26565 === (3))){
var inst_26562 = (state_26564[(2)]);
var state_26564__$1 = state_26564;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_26564__$1,inst_26562);
} else {
if((state_val_26565 === (2))){
var inst_26534 = (state_26564[(10)]);
var inst_26536 = cljs.core.count.call(null,inst_26534);
var inst_26537 = (inst_26536 > (0));
var state_26564__$1 = state_26564;
if(cljs.core.truth_(inst_26537)){
var statearr_26573_26591 = state_26564__$1;
(statearr_26573_26591[(1)] = (4));

} else {
var statearr_26574_26592 = state_26564__$1;
(statearr_26574_26592[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26565 === (11))){
var inst_26534 = (state_26564[(10)]);
var inst_26553 = (state_26564[(2)]);
var tmp26572 = inst_26534;
var inst_26534__$1 = tmp26572;
var state_26564__$1 = (function (){var statearr_26575 = state_26564;
(statearr_26575[(10)] = inst_26534__$1);

(statearr_26575[(11)] = inst_26553);

return statearr_26575;
})();
var statearr_26576_26593 = state_26564__$1;
(statearr_26576_26593[(2)] = null);

(statearr_26576_26593[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26565 === (9))){
var inst_26544 = (state_26564[(8)]);
var state_26564__$1 = state_26564;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_26564__$1,(11),out,inst_26544);
} else {
if((state_val_26565 === (5))){
var inst_26558 = cljs.core.async.close_BANG_.call(null,out);
var state_26564__$1 = state_26564;
var statearr_26577_26594 = state_26564__$1;
(statearr_26577_26594[(2)] = inst_26558);

(statearr_26577_26594[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26565 === (10))){
var inst_26556 = (state_26564[(2)]);
var state_26564__$1 = state_26564;
var statearr_26578_26595 = state_26564__$1;
(statearr_26578_26595[(2)] = inst_26556);

(statearr_26578_26595[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26565 === (8))){
var inst_26543 = (state_26564[(7)]);
var inst_26534 = (state_26564[(10)]);
var inst_26544 = (state_26564[(8)]);
var inst_26545 = (state_26564[(9)]);
var inst_26548 = (function (){var cs = inst_26534;
var vec__26539 = inst_26543;
var v = inst_26544;
var c = inst_26545;
return ((function (cs,vec__26539,v,c,inst_26543,inst_26534,inst_26544,inst_26545,state_val_26565,c__25187__auto___26586,out){
return (function (p1__26530_SHARP_){
return cljs.core.not_EQ_.call(null,c,p1__26530_SHARP_);
});
;})(cs,vec__26539,v,c,inst_26543,inst_26534,inst_26544,inst_26545,state_val_26565,c__25187__auto___26586,out))
})();
var inst_26549 = cljs.core.filterv.call(null,inst_26548,inst_26534);
var inst_26534__$1 = inst_26549;
var state_26564__$1 = (function (){var statearr_26579 = state_26564;
(statearr_26579[(10)] = inst_26534__$1);

return statearr_26579;
})();
var statearr_26580_26596 = state_26564__$1;
(statearr_26580_26596[(2)] = null);

(statearr_26580_26596[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__25187__auto___26586,out))
;
return ((function (switch__25099__auto__,c__25187__auto___26586,out){
return (function() {
var cljs$core$async$state_machine__25100__auto__ = null;
var cljs$core$async$state_machine__25100__auto____0 = (function (){
var statearr_26581 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_26581[(0)] = cljs$core$async$state_machine__25100__auto__);

(statearr_26581[(1)] = (1));

return statearr_26581;
});
var cljs$core$async$state_machine__25100__auto____1 = (function (state_26564){
while(true){
var ret_value__25101__auto__ = (function (){try{while(true){
var result__25102__auto__ = switch__25099__auto__.call(null,state_26564);
if(cljs.core.keyword_identical_QMARK_.call(null,result__25102__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__25102__auto__;
}
break;
}
}catch (e26582){if((e26582 instanceof Object)){
var ex__25103__auto__ = e26582;
var statearr_26583_26597 = state_26564;
(statearr_26583_26597[(5)] = ex__25103__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_26564);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e26582;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__25101__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__26598 = state_26564;
state_26564 = G__26598;
continue;
} else {
return ret_value__25101__auto__;
}
break;
}
});
cljs$core$async$state_machine__25100__auto__ = function(state_26564){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__25100__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__25100__auto____1.call(this,state_26564);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$state_machine__25100__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__25100__auto____0;
cljs$core$async$state_machine__25100__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__25100__auto____1;
return cljs$core$async$state_machine__25100__auto__;
})()
;})(switch__25099__auto__,c__25187__auto___26586,out))
})();
var state__25189__auto__ = (function (){var statearr_26584 = f__25188__auto__.call(null);
(statearr_26584[(6)] = c__25187__auto___26586);

return statearr_26584;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__25189__auto__);
});})(c__25187__auto___26586,out))
);


return out;
});

cljs.core.async.merge.cljs$lang$maxFixedArity = 2;

/**
 * Returns a channel containing the single (collection) result of the
 *   items taken from the channel conjoined to the supplied
 *   collection. ch must close before into produces a result.
 */
cljs.core.async.into = (function cljs$core$async$into(coll,ch){
return cljs.core.async.reduce.call(null,cljs.core.conj,coll,ch);
});
/**
 * Returns a channel that will return, at most, n items from ch. After n items
 * have been returned, or ch has been closed, the return chanel will close.
 * 
 *   The output channel is unbuffered by default, unless buf-or-n is given.
 */
cljs.core.async.take = (function cljs$core$async$take(var_args){
var G__26600 = arguments.length;
switch (G__26600) {
case 2:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.take.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.take.call(null,n,ch,null);
});

cljs.core.async.take.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__25187__auto___26645 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__25187__auto___26645,out){
return (function (){
var f__25188__auto__ = (function (){var switch__25099__auto__ = ((function (c__25187__auto___26645,out){
return (function (state_26624){
var state_val_26625 = (state_26624[(1)]);
if((state_val_26625 === (7))){
var inst_26606 = (state_26624[(7)]);
var inst_26606__$1 = (state_26624[(2)]);
var inst_26607 = (inst_26606__$1 == null);
var inst_26608 = cljs.core.not.call(null,inst_26607);
var state_26624__$1 = (function (){var statearr_26626 = state_26624;
(statearr_26626[(7)] = inst_26606__$1);

return statearr_26626;
})();
if(inst_26608){
var statearr_26627_26646 = state_26624__$1;
(statearr_26627_26646[(1)] = (8));

} else {
var statearr_26628_26647 = state_26624__$1;
(statearr_26628_26647[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26625 === (1))){
var inst_26601 = (0);
var state_26624__$1 = (function (){var statearr_26629 = state_26624;
(statearr_26629[(8)] = inst_26601);

return statearr_26629;
})();
var statearr_26630_26648 = state_26624__$1;
(statearr_26630_26648[(2)] = null);

(statearr_26630_26648[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26625 === (4))){
var state_26624__$1 = state_26624;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_26624__$1,(7),ch);
} else {
if((state_val_26625 === (6))){
var inst_26619 = (state_26624[(2)]);
var state_26624__$1 = state_26624;
var statearr_26631_26649 = state_26624__$1;
(statearr_26631_26649[(2)] = inst_26619);

(statearr_26631_26649[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26625 === (3))){
var inst_26621 = (state_26624[(2)]);
var inst_26622 = cljs.core.async.close_BANG_.call(null,out);
var state_26624__$1 = (function (){var statearr_26632 = state_26624;
(statearr_26632[(9)] = inst_26621);

return statearr_26632;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_26624__$1,inst_26622);
} else {
if((state_val_26625 === (2))){
var inst_26601 = (state_26624[(8)]);
var inst_26603 = (inst_26601 < n);
var state_26624__$1 = state_26624;
if(cljs.core.truth_(inst_26603)){
var statearr_26633_26650 = state_26624__$1;
(statearr_26633_26650[(1)] = (4));

} else {
var statearr_26634_26651 = state_26624__$1;
(statearr_26634_26651[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26625 === (11))){
var inst_26601 = (state_26624[(8)]);
var inst_26611 = (state_26624[(2)]);
var inst_26612 = (inst_26601 + (1));
var inst_26601__$1 = inst_26612;
var state_26624__$1 = (function (){var statearr_26635 = state_26624;
(statearr_26635[(10)] = inst_26611);

(statearr_26635[(8)] = inst_26601__$1);

return statearr_26635;
})();
var statearr_26636_26652 = state_26624__$1;
(statearr_26636_26652[(2)] = null);

(statearr_26636_26652[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26625 === (9))){
var state_26624__$1 = state_26624;
var statearr_26637_26653 = state_26624__$1;
(statearr_26637_26653[(2)] = null);

(statearr_26637_26653[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26625 === (5))){
var state_26624__$1 = state_26624;
var statearr_26638_26654 = state_26624__$1;
(statearr_26638_26654[(2)] = null);

(statearr_26638_26654[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26625 === (10))){
var inst_26616 = (state_26624[(2)]);
var state_26624__$1 = state_26624;
var statearr_26639_26655 = state_26624__$1;
(statearr_26639_26655[(2)] = inst_26616);

(statearr_26639_26655[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26625 === (8))){
var inst_26606 = (state_26624[(7)]);
var state_26624__$1 = state_26624;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_26624__$1,(11),out,inst_26606);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__25187__auto___26645,out))
;
return ((function (switch__25099__auto__,c__25187__auto___26645,out){
return (function() {
var cljs$core$async$state_machine__25100__auto__ = null;
var cljs$core$async$state_machine__25100__auto____0 = (function (){
var statearr_26640 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_26640[(0)] = cljs$core$async$state_machine__25100__auto__);

(statearr_26640[(1)] = (1));

return statearr_26640;
});
var cljs$core$async$state_machine__25100__auto____1 = (function (state_26624){
while(true){
var ret_value__25101__auto__ = (function (){try{while(true){
var result__25102__auto__ = switch__25099__auto__.call(null,state_26624);
if(cljs.core.keyword_identical_QMARK_.call(null,result__25102__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__25102__auto__;
}
break;
}
}catch (e26641){if((e26641 instanceof Object)){
var ex__25103__auto__ = e26641;
var statearr_26642_26656 = state_26624;
(statearr_26642_26656[(5)] = ex__25103__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_26624);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e26641;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__25101__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__26657 = state_26624;
state_26624 = G__26657;
continue;
} else {
return ret_value__25101__auto__;
}
break;
}
});
cljs$core$async$state_machine__25100__auto__ = function(state_26624){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__25100__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__25100__auto____1.call(this,state_26624);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$state_machine__25100__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__25100__auto____0;
cljs$core$async$state_machine__25100__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__25100__auto____1;
return cljs$core$async$state_machine__25100__auto__;
})()
;})(switch__25099__auto__,c__25187__auto___26645,out))
})();
var state__25189__auto__ = (function (){var statearr_26643 = f__25188__auto__.call(null);
(statearr_26643[(6)] = c__25187__auto___26645);

return statearr_26643;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__25189__auto__);
});})(c__25187__auto___26645,out))
);


return out;
});

cljs.core.async.take.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_LT_ = (function cljs$core$async$map_LT_(f,ch){
if(typeof cljs.core.async.t_cljs$core$async26659 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async26659 = (function (f,ch,meta26660){
this.f = f;
this.ch = ch;
this.meta26660 = meta26660;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async26659.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_26661,meta26660__$1){
var self__ = this;
var _26661__$1 = this;
return (new cljs.core.async.t_cljs$core$async26659(self__.f,self__.ch,meta26660__$1));
});

cljs.core.async.t_cljs$core$async26659.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_26661){
var self__ = this;
var _26661__$1 = this;
return self__.meta26660;
});

cljs.core.async.t_cljs$core$async26659.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async26659.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async26659.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async26659.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async26659.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
var ret = cljs.core.async.impl.protocols.take_BANG_.call(null,self__.ch,(function (){
if(typeof cljs.core.async.t_cljs$core$async26662 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async26662 = (function (f,ch,meta26660,_,fn1,meta26663){
this.f = f;
this.ch = ch;
this.meta26660 = meta26660;
this._ = _;
this.fn1 = fn1;
this.meta26663 = meta26663;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async26662.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (___$1){
return (function (_26664,meta26663__$1){
var self__ = this;
var _26664__$1 = this;
return (new cljs.core.async.t_cljs$core$async26662(self__.f,self__.ch,self__.meta26660,self__._,self__.fn1,meta26663__$1));
});})(___$1))
;

cljs.core.async.t_cljs$core$async26662.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (___$1){
return (function (_26664){
var self__ = this;
var _26664__$1 = this;
return self__.meta26663;
});})(___$1))
;

cljs.core.async.t_cljs$core$async26662.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async26662.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
return cljs.core.async.impl.protocols.active_QMARK_.call(null,self__.fn1);
});})(___$1))
;

cljs.core.async.t_cljs$core$async26662.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
return true;
});})(___$1))
;

cljs.core.async.t_cljs$core$async26662.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
var f1 = cljs.core.async.impl.protocols.commit.call(null,self__.fn1);
return ((function (f1,___$2,___$1){
return (function (p1__26658_SHARP_){
return f1.call(null,(((p1__26658_SHARP_ == null))?null:self__.f.call(null,p1__26658_SHARP_)));
});
;})(f1,___$2,___$1))
});})(___$1))
;

cljs.core.async.t_cljs$core$async26662.getBasis = ((function (___$1){
return (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta26660","meta26660",-1264278363,null),cljs.core.with_meta(new cljs.core.Symbol(null,"_","_",-1201019570,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol("cljs.core.async","t_cljs$core$async26659","cljs.core.async/t_cljs$core$async26659",1955546931,null)], null)),new cljs.core.Symbol(null,"fn1","fn1",895834444,null),new cljs.core.Symbol(null,"meta26663","meta26663",-555657023,null)], null);
});})(___$1))
;

cljs.core.async.t_cljs$core$async26662.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async26662.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async26662";

cljs.core.async.t_cljs$core$async26662.cljs$lang$ctorPrWriter = ((function (___$1){
return (function (this__8811__auto__,writer__8812__auto__,opt__8813__auto__){
return cljs.core._write.call(null,writer__8812__auto__,"cljs.core.async/t_cljs$core$async26662");
});})(___$1))
;

cljs.core.async.__GT_t_cljs$core$async26662 = ((function (___$1){
return (function cljs$core$async$map_LT__$___GT_t_cljs$core$async26662(f__$1,ch__$1,meta26660__$1,___$2,fn1__$1,meta26663){
return (new cljs.core.async.t_cljs$core$async26662(f__$1,ch__$1,meta26660__$1,___$2,fn1__$1,meta26663));
});})(___$1))
;

}

return (new cljs.core.async.t_cljs$core$async26662(self__.f,self__.ch,self__.meta26660,___$1,fn1,cljs.core.PersistentArrayMap.EMPTY));
})()
);
if(cljs.core.truth_((function (){var and__8174__auto__ = ret;
if(cljs.core.truth_(and__8174__auto__)){
return !((cljs.core.deref.call(null,ret) == null));
} else {
return and__8174__auto__;
}
})())){
return cljs.core.async.impl.channels.box.call(null,self__.f.call(null,cljs.core.deref.call(null,ret)));
} else {
return ret;
}
});

cljs.core.async.t_cljs$core$async26659.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async26659.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_.call(null,self__.ch,val,fn1);
});

cljs.core.async.t_cljs$core$async26659.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta26660","meta26660",-1264278363,null)], null);
});

cljs.core.async.t_cljs$core$async26659.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async26659.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async26659";

cljs.core.async.t_cljs$core$async26659.cljs$lang$ctorPrWriter = (function (this__8811__auto__,writer__8812__auto__,opt__8813__auto__){
return cljs.core._write.call(null,writer__8812__auto__,"cljs.core.async/t_cljs$core$async26659");
});

cljs.core.async.__GT_t_cljs$core$async26659 = (function cljs$core$async$map_LT__$___GT_t_cljs$core$async26659(f__$1,ch__$1,meta26660){
return (new cljs.core.async.t_cljs$core$async26659(f__$1,ch__$1,meta26660));
});

}

return (new cljs.core.async.t_cljs$core$async26659(f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_GT_ = (function cljs$core$async$map_GT_(f,ch){
if(typeof cljs.core.async.t_cljs$core$async26665 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async26665 = (function (f,ch,meta26666){
this.f = f;
this.ch = ch;
this.meta26666 = meta26666;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async26665.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_26667,meta26666__$1){
var self__ = this;
var _26667__$1 = this;
return (new cljs.core.async.t_cljs$core$async26665(self__.f,self__.ch,meta26666__$1));
});

cljs.core.async.t_cljs$core$async26665.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_26667){
var self__ = this;
var _26667__$1 = this;
return self__.meta26666;
});

cljs.core.async.t_cljs$core$async26665.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async26665.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async26665.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async26665.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_.call(null,self__.ch,fn1);
});

cljs.core.async.t_cljs$core$async26665.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async26665.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_.call(null,self__.ch,self__.f.call(null,val),fn1);
});

cljs.core.async.t_cljs$core$async26665.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta26666","meta26666",325939456,null)], null);
});

cljs.core.async.t_cljs$core$async26665.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async26665.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async26665";

cljs.core.async.t_cljs$core$async26665.cljs$lang$ctorPrWriter = (function (this__8811__auto__,writer__8812__auto__,opt__8813__auto__){
return cljs.core._write.call(null,writer__8812__auto__,"cljs.core.async/t_cljs$core$async26665");
});

cljs.core.async.__GT_t_cljs$core$async26665 = (function cljs$core$async$map_GT__$___GT_t_cljs$core$async26665(f__$1,ch__$1,meta26666){
return (new cljs.core.async.t_cljs$core$async26665(f__$1,ch__$1,meta26666));
});

}

return (new cljs.core.async.t_cljs$core$async26665(f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_GT_ = (function cljs$core$async$filter_GT_(p,ch){
if(typeof cljs.core.async.t_cljs$core$async26668 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async26668 = (function (p,ch,meta26669){
this.p = p;
this.ch = ch;
this.meta26669 = meta26669;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async26668.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_26670,meta26669__$1){
var self__ = this;
var _26670__$1 = this;
return (new cljs.core.async.t_cljs$core$async26668(self__.p,self__.ch,meta26669__$1));
});

cljs.core.async.t_cljs$core$async26668.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_26670){
var self__ = this;
var _26670__$1 = this;
return self__.meta26669;
});

cljs.core.async.t_cljs$core$async26668.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async26668.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async26668.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async26668.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async26668.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_.call(null,self__.ch,fn1);
});

cljs.core.async.t_cljs$core$async26668.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async26668.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_(self__.p.call(null,val))){
return cljs.core.async.impl.protocols.put_BANG_.call(null,self__.ch,val,fn1);
} else {
return cljs.core.async.impl.channels.box.call(null,cljs.core.not.call(null,cljs.core.async.impl.protocols.closed_QMARK_.call(null,self__.ch)));
}
});

cljs.core.async.t_cljs$core$async26668.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"p","p",1791580836,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta26669","meta26669",-347556177,null)], null);
});

cljs.core.async.t_cljs$core$async26668.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async26668.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async26668";

cljs.core.async.t_cljs$core$async26668.cljs$lang$ctorPrWriter = (function (this__8811__auto__,writer__8812__auto__,opt__8813__auto__){
return cljs.core._write.call(null,writer__8812__auto__,"cljs.core.async/t_cljs$core$async26668");
});

cljs.core.async.__GT_t_cljs$core$async26668 = (function cljs$core$async$filter_GT__$___GT_t_cljs$core$async26668(p__$1,ch__$1,meta26669){
return (new cljs.core.async.t_cljs$core$async26668(p__$1,ch__$1,meta26669));
});

}

return (new cljs.core.async.t_cljs$core$async26668(p,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_GT_ = (function cljs$core$async$remove_GT_(p,ch){
return cljs.core.async.filter_GT_.call(null,cljs.core.complement.call(null,p),ch);
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_LT_ = (function cljs$core$async$filter_LT_(var_args){
var G__26672 = arguments.length;
switch (G__26672) {
case 2:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.filter_LT_.call(null,p,ch,null);
});

cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__25187__auto___26712 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__25187__auto___26712,out){
return (function (){
var f__25188__auto__ = (function (){var switch__25099__auto__ = ((function (c__25187__auto___26712,out){
return (function (state_26693){
var state_val_26694 = (state_26693[(1)]);
if((state_val_26694 === (7))){
var inst_26689 = (state_26693[(2)]);
var state_26693__$1 = state_26693;
var statearr_26695_26713 = state_26693__$1;
(statearr_26695_26713[(2)] = inst_26689);

(statearr_26695_26713[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26694 === (1))){
var state_26693__$1 = state_26693;
var statearr_26696_26714 = state_26693__$1;
(statearr_26696_26714[(2)] = null);

(statearr_26696_26714[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26694 === (4))){
var inst_26675 = (state_26693[(7)]);
var inst_26675__$1 = (state_26693[(2)]);
var inst_26676 = (inst_26675__$1 == null);
var state_26693__$1 = (function (){var statearr_26697 = state_26693;
(statearr_26697[(7)] = inst_26675__$1);

return statearr_26697;
})();
if(cljs.core.truth_(inst_26676)){
var statearr_26698_26715 = state_26693__$1;
(statearr_26698_26715[(1)] = (5));

} else {
var statearr_26699_26716 = state_26693__$1;
(statearr_26699_26716[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26694 === (6))){
var inst_26675 = (state_26693[(7)]);
var inst_26680 = p.call(null,inst_26675);
var state_26693__$1 = state_26693;
if(cljs.core.truth_(inst_26680)){
var statearr_26700_26717 = state_26693__$1;
(statearr_26700_26717[(1)] = (8));

} else {
var statearr_26701_26718 = state_26693__$1;
(statearr_26701_26718[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26694 === (3))){
var inst_26691 = (state_26693[(2)]);
var state_26693__$1 = state_26693;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_26693__$1,inst_26691);
} else {
if((state_val_26694 === (2))){
var state_26693__$1 = state_26693;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_26693__$1,(4),ch);
} else {
if((state_val_26694 === (11))){
var inst_26683 = (state_26693[(2)]);
var state_26693__$1 = state_26693;
var statearr_26702_26719 = state_26693__$1;
(statearr_26702_26719[(2)] = inst_26683);

(statearr_26702_26719[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26694 === (9))){
var state_26693__$1 = state_26693;
var statearr_26703_26720 = state_26693__$1;
(statearr_26703_26720[(2)] = null);

(statearr_26703_26720[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26694 === (5))){
var inst_26678 = cljs.core.async.close_BANG_.call(null,out);
var state_26693__$1 = state_26693;
var statearr_26704_26721 = state_26693__$1;
(statearr_26704_26721[(2)] = inst_26678);

(statearr_26704_26721[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26694 === (10))){
var inst_26686 = (state_26693[(2)]);
var state_26693__$1 = (function (){var statearr_26705 = state_26693;
(statearr_26705[(8)] = inst_26686);

return statearr_26705;
})();
var statearr_26706_26722 = state_26693__$1;
(statearr_26706_26722[(2)] = null);

(statearr_26706_26722[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26694 === (8))){
var inst_26675 = (state_26693[(7)]);
var state_26693__$1 = state_26693;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_26693__$1,(11),out,inst_26675);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__25187__auto___26712,out))
;
return ((function (switch__25099__auto__,c__25187__auto___26712,out){
return (function() {
var cljs$core$async$state_machine__25100__auto__ = null;
var cljs$core$async$state_machine__25100__auto____0 = (function (){
var statearr_26707 = [null,null,null,null,null,null,null,null,null];
(statearr_26707[(0)] = cljs$core$async$state_machine__25100__auto__);

(statearr_26707[(1)] = (1));

return statearr_26707;
});
var cljs$core$async$state_machine__25100__auto____1 = (function (state_26693){
while(true){
var ret_value__25101__auto__ = (function (){try{while(true){
var result__25102__auto__ = switch__25099__auto__.call(null,state_26693);
if(cljs.core.keyword_identical_QMARK_.call(null,result__25102__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__25102__auto__;
}
break;
}
}catch (e26708){if((e26708 instanceof Object)){
var ex__25103__auto__ = e26708;
var statearr_26709_26723 = state_26693;
(statearr_26709_26723[(5)] = ex__25103__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_26693);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e26708;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__25101__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__26724 = state_26693;
state_26693 = G__26724;
continue;
} else {
return ret_value__25101__auto__;
}
break;
}
});
cljs$core$async$state_machine__25100__auto__ = function(state_26693){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__25100__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__25100__auto____1.call(this,state_26693);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$state_machine__25100__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__25100__auto____0;
cljs$core$async$state_machine__25100__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__25100__auto____1;
return cljs$core$async$state_machine__25100__auto__;
})()
;})(switch__25099__auto__,c__25187__auto___26712,out))
})();
var state__25189__auto__ = (function (){var statearr_26710 = f__25188__auto__.call(null);
(statearr_26710[(6)] = c__25187__auto___26712);

return statearr_26710;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__25189__auto__);
});})(c__25187__auto___26712,out))
);


return out;
});

cljs.core.async.filter_LT_.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_LT_ = (function cljs$core$async$remove_LT_(var_args){
var G__26726 = arguments.length;
switch (G__26726) {
case 2:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.remove_LT_.call(null,p,ch,null);
});

cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
return cljs.core.async.filter_LT_.call(null,cljs.core.complement.call(null,p),ch,buf_or_n);
});

cljs.core.async.remove_LT_.cljs$lang$maxFixedArity = 3;

cljs.core.async.mapcat_STAR_ = (function cljs$core$async$mapcat_STAR_(f,in$,out){
var c__25187__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__25187__auto__){
return (function (){
var f__25188__auto__ = (function (){var switch__25099__auto__ = ((function (c__25187__auto__){
return (function (state_26789){
var state_val_26790 = (state_26789[(1)]);
if((state_val_26790 === (7))){
var inst_26785 = (state_26789[(2)]);
var state_26789__$1 = state_26789;
var statearr_26791_26829 = state_26789__$1;
(statearr_26791_26829[(2)] = inst_26785);

(statearr_26791_26829[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26790 === (20))){
var inst_26755 = (state_26789[(7)]);
var inst_26766 = (state_26789[(2)]);
var inst_26767 = cljs.core.next.call(null,inst_26755);
var inst_26741 = inst_26767;
var inst_26742 = null;
var inst_26743 = (0);
var inst_26744 = (0);
var state_26789__$1 = (function (){var statearr_26792 = state_26789;
(statearr_26792[(8)] = inst_26766);

(statearr_26792[(9)] = inst_26743);

(statearr_26792[(10)] = inst_26741);

(statearr_26792[(11)] = inst_26744);

(statearr_26792[(12)] = inst_26742);

return statearr_26792;
})();
var statearr_26793_26830 = state_26789__$1;
(statearr_26793_26830[(2)] = null);

(statearr_26793_26830[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26790 === (1))){
var state_26789__$1 = state_26789;
var statearr_26794_26831 = state_26789__$1;
(statearr_26794_26831[(2)] = null);

(statearr_26794_26831[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26790 === (4))){
var inst_26730 = (state_26789[(13)]);
var inst_26730__$1 = (state_26789[(2)]);
var inst_26731 = (inst_26730__$1 == null);
var state_26789__$1 = (function (){var statearr_26795 = state_26789;
(statearr_26795[(13)] = inst_26730__$1);

return statearr_26795;
})();
if(cljs.core.truth_(inst_26731)){
var statearr_26796_26832 = state_26789__$1;
(statearr_26796_26832[(1)] = (5));

} else {
var statearr_26797_26833 = state_26789__$1;
(statearr_26797_26833[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26790 === (15))){
var state_26789__$1 = state_26789;
var statearr_26801_26834 = state_26789__$1;
(statearr_26801_26834[(2)] = null);

(statearr_26801_26834[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26790 === (21))){
var state_26789__$1 = state_26789;
var statearr_26802_26835 = state_26789__$1;
(statearr_26802_26835[(2)] = null);

(statearr_26802_26835[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26790 === (13))){
var inst_26743 = (state_26789[(9)]);
var inst_26741 = (state_26789[(10)]);
var inst_26744 = (state_26789[(11)]);
var inst_26742 = (state_26789[(12)]);
var inst_26751 = (state_26789[(2)]);
var inst_26752 = (inst_26744 + (1));
var tmp26798 = inst_26743;
var tmp26799 = inst_26741;
var tmp26800 = inst_26742;
var inst_26741__$1 = tmp26799;
var inst_26742__$1 = tmp26800;
var inst_26743__$1 = tmp26798;
var inst_26744__$1 = inst_26752;
var state_26789__$1 = (function (){var statearr_26803 = state_26789;
(statearr_26803[(9)] = inst_26743__$1);

(statearr_26803[(10)] = inst_26741__$1);

(statearr_26803[(14)] = inst_26751);

(statearr_26803[(11)] = inst_26744__$1);

(statearr_26803[(12)] = inst_26742__$1);

return statearr_26803;
})();
var statearr_26804_26836 = state_26789__$1;
(statearr_26804_26836[(2)] = null);

(statearr_26804_26836[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26790 === (22))){
var state_26789__$1 = state_26789;
var statearr_26805_26837 = state_26789__$1;
(statearr_26805_26837[(2)] = null);

(statearr_26805_26837[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26790 === (6))){
var inst_26730 = (state_26789[(13)]);
var inst_26739 = f.call(null,inst_26730);
var inst_26740 = cljs.core.seq.call(null,inst_26739);
var inst_26741 = inst_26740;
var inst_26742 = null;
var inst_26743 = (0);
var inst_26744 = (0);
var state_26789__$1 = (function (){var statearr_26806 = state_26789;
(statearr_26806[(9)] = inst_26743);

(statearr_26806[(10)] = inst_26741);

(statearr_26806[(11)] = inst_26744);

(statearr_26806[(12)] = inst_26742);

return statearr_26806;
})();
var statearr_26807_26838 = state_26789__$1;
(statearr_26807_26838[(2)] = null);

(statearr_26807_26838[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26790 === (17))){
var inst_26755 = (state_26789[(7)]);
var inst_26759 = cljs.core.chunk_first.call(null,inst_26755);
var inst_26760 = cljs.core.chunk_rest.call(null,inst_26755);
var inst_26761 = cljs.core.count.call(null,inst_26759);
var inst_26741 = inst_26760;
var inst_26742 = inst_26759;
var inst_26743 = inst_26761;
var inst_26744 = (0);
var state_26789__$1 = (function (){var statearr_26808 = state_26789;
(statearr_26808[(9)] = inst_26743);

(statearr_26808[(10)] = inst_26741);

(statearr_26808[(11)] = inst_26744);

(statearr_26808[(12)] = inst_26742);

return statearr_26808;
})();
var statearr_26809_26839 = state_26789__$1;
(statearr_26809_26839[(2)] = null);

(statearr_26809_26839[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26790 === (3))){
var inst_26787 = (state_26789[(2)]);
var state_26789__$1 = state_26789;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_26789__$1,inst_26787);
} else {
if((state_val_26790 === (12))){
var inst_26775 = (state_26789[(2)]);
var state_26789__$1 = state_26789;
var statearr_26810_26840 = state_26789__$1;
(statearr_26810_26840[(2)] = inst_26775);

(statearr_26810_26840[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26790 === (2))){
var state_26789__$1 = state_26789;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_26789__$1,(4),in$);
} else {
if((state_val_26790 === (23))){
var inst_26783 = (state_26789[(2)]);
var state_26789__$1 = state_26789;
var statearr_26811_26841 = state_26789__$1;
(statearr_26811_26841[(2)] = inst_26783);

(statearr_26811_26841[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26790 === (19))){
var inst_26770 = (state_26789[(2)]);
var state_26789__$1 = state_26789;
var statearr_26812_26842 = state_26789__$1;
(statearr_26812_26842[(2)] = inst_26770);

(statearr_26812_26842[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26790 === (11))){
var inst_26741 = (state_26789[(10)]);
var inst_26755 = (state_26789[(7)]);
var inst_26755__$1 = cljs.core.seq.call(null,inst_26741);
var state_26789__$1 = (function (){var statearr_26813 = state_26789;
(statearr_26813[(7)] = inst_26755__$1);

return statearr_26813;
})();
if(inst_26755__$1){
var statearr_26814_26843 = state_26789__$1;
(statearr_26814_26843[(1)] = (14));

} else {
var statearr_26815_26844 = state_26789__$1;
(statearr_26815_26844[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26790 === (9))){
var inst_26777 = (state_26789[(2)]);
var inst_26778 = cljs.core.async.impl.protocols.closed_QMARK_.call(null,out);
var state_26789__$1 = (function (){var statearr_26816 = state_26789;
(statearr_26816[(15)] = inst_26777);

return statearr_26816;
})();
if(cljs.core.truth_(inst_26778)){
var statearr_26817_26845 = state_26789__$1;
(statearr_26817_26845[(1)] = (21));

} else {
var statearr_26818_26846 = state_26789__$1;
(statearr_26818_26846[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26790 === (5))){
var inst_26733 = cljs.core.async.close_BANG_.call(null,out);
var state_26789__$1 = state_26789;
var statearr_26819_26847 = state_26789__$1;
(statearr_26819_26847[(2)] = inst_26733);

(statearr_26819_26847[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26790 === (14))){
var inst_26755 = (state_26789[(7)]);
var inst_26757 = cljs.core.chunked_seq_QMARK_.call(null,inst_26755);
var state_26789__$1 = state_26789;
if(inst_26757){
var statearr_26820_26848 = state_26789__$1;
(statearr_26820_26848[(1)] = (17));

} else {
var statearr_26821_26849 = state_26789__$1;
(statearr_26821_26849[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26790 === (16))){
var inst_26773 = (state_26789[(2)]);
var state_26789__$1 = state_26789;
var statearr_26822_26850 = state_26789__$1;
(statearr_26822_26850[(2)] = inst_26773);

(statearr_26822_26850[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26790 === (10))){
var inst_26744 = (state_26789[(11)]);
var inst_26742 = (state_26789[(12)]);
var inst_26749 = cljs.core._nth.call(null,inst_26742,inst_26744);
var state_26789__$1 = state_26789;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_26789__$1,(13),out,inst_26749);
} else {
if((state_val_26790 === (18))){
var inst_26755 = (state_26789[(7)]);
var inst_26764 = cljs.core.first.call(null,inst_26755);
var state_26789__$1 = state_26789;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_26789__$1,(20),out,inst_26764);
} else {
if((state_val_26790 === (8))){
var inst_26743 = (state_26789[(9)]);
var inst_26744 = (state_26789[(11)]);
var inst_26746 = (inst_26744 < inst_26743);
var inst_26747 = inst_26746;
var state_26789__$1 = state_26789;
if(cljs.core.truth_(inst_26747)){
var statearr_26823_26851 = state_26789__$1;
(statearr_26823_26851[(1)] = (10));

} else {
var statearr_26824_26852 = state_26789__$1;
(statearr_26824_26852[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__25187__auto__))
;
return ((function (switch__25099__auto__,c__25187__auto__){
return (function() {
var cljs$core$async$mapcat_STAR__$_state_machine__25100__auto__ = null;
var cljs$core$async$mapcat_STAR__$_state_machine__25100__auto____0 = (function (){
var statearr_26825 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_26825[(0)] = cljs$core$async$mapcat_STAR__$_state_machine__25100__auto__);

(statearr_26825[(1)] = (1));

return statearr_26825;
});
var cljs$core$async$mapcat_STAR__$_state_machine__25100__auto____1 = (function (state_26789){
while(true){
var ret_value__25101__auto__ = (function (){try{while(true){
var result__25102__auto__ = switch__25099__auto__.call(null,state_26789);
if(cljs.core.keyword_identical_QMARK_.call(null,result__25102__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__25102__auto__;
}
break;
}
}catch (e26826){if((e26826 instanceof Object)){
var ex__25103__auto__ = e26826;
var statearr_26827_26853 = state_26789;
(statearr_26827_26853[(5)] = ex__25103__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_26789);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e26826;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__25101__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__26854 = state_26789;
state_26789 = G__26854;
continue;
} else {
return ret_value__25101__auto__;
}
break;
}
});
cljs$core$async$mapcat_STAR__$_state_machine__25100__auto__ = function(state_26789){
switch(arguments.length){
case 0:
return cljs$core$async$mapcat_STAR__$_state_machine__25100__auto____0.call(this);
case 1:
return cljs$core$async$mapcat_STAR__$_state_machine__25100__auto____1.call(this,state_26789);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$mapcat_STAR__$_state_machine__25100__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mapcat_STAR__$_state_machine__25100__auto____0;
cljs$core$async$mapcat_STAR__$_state_machine__25100__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mapcat_STAR__$_state_machine__25100__auto____1;
return cljs$core$async$mapcat_STAR__$_state_machine__25100__auto__;
})()
;})(switch__25099__auto__,c__25187__auto__))
})();
var state__25189__auto__ = (function (){var statearr_26828 = f__25188__auto__.call(null);
(statearr_26828[(6)] = c__25187__auto__);

return statearr_26828;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__25189__auto__);
});})(c__25187__auto__))
);

return c__25187__auto__;
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_LT_ = (function cljs$core$async$mapcat_LT_(var_args){
var G__26856 = arguments.length;
switch (G__26856) {
case 2:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2 = (function (f,in$){
return cljs.core.async.mapcat_LT_.call(null,f,in$,null);
});

cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3 = (function (f,in$,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
cljs.core.async.mapcat_STAR_.call(null,f,in$,out);

return out;
});

cljs.core.async.mapcat_LT_.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_GT_ = (function cljs$core$async$mapcat_GT_(var_args){
var G__26859 = arguments.length;
switch (G__26859) {
case 2:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2 = (function (f,out){
return cljs.core.async.mapcat_GT_.call(null,f,out,null);
});

cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3 = (function (f,out,buf_or_n){
var in$ = cljs.core.async.chan.call(null,buf_or_n);
cljs.core.async.mapcat_STAR_.call(null,f,in$,out);

return in$;
});

cljs.core.async.mapcat_GT_.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.unique = (function cljs$core$async$unique(var_args){
var G__26862 = arguments.length;
switch (G__26862) {
case 1:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1 = (function (ch){
return cljs.core.async.unique.call(null,ch,null);
});

cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2 = (function (ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__25187__auto___26909 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__25187__auto___26909,out){
return (function (){
var f__25188__auto__ = (function (){var switch__25099__auto__ = ((function (c__25187__auto___26909,out){
return (function (state_26886){
var state_val_26887 = (state_26886[(1)]);
if((state_val_26887 === (7))){
var inst_26881 = (state_26886[(2)]);
var state_26886__$1 = state_26886;
var statearr_26888_26910 = state_26886__$1;
(statearr_26888_26910[(2)] = inst_26881);

(statearr_26888_26910[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26887 === (1))){
var inst_26863 = null;
var state_26886__$1 = (function (){var statearr_26889 = state_26886;
(statearr_26889[(7)] = inst_26863);

return statearr_26889;
})();
var statearr_26890_26911 = state_26886__$1;
(statearr_26890_26911[(2)] = null);

(statearr_26890_26911[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26887 === (4))){
var inst_26866 = (state_26886[(8)]);
var inst_26866__$1 = (state_26886[(2)]);
var inst_26867 = (inst_26866__$1 == null);
var inst_26868 = cljs.core.not.call(null,inst_26867);
var state_26886__$1 = (function (){var statearr_26891 = state_26886;
(statearr_26891[(8)] = inst_26866__$1);

return statearr_26891;
})();
if(inst_26868){
var statearr_26892_26912 = state_26886__$1;
(statearr_26892_26912[(1)] = (5));

} else {
var statearr_26893_26913 = state_26886__$1;
(statearr_26893_26913[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26887 === (6))){
var state_26886__$1 = state_26886;
var statearr_26894_26914 = state_26886__$1;
(statearr_26894_26914[(2)] = null);

(statearr_26894_26914[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26887 === (3))){
var inst_26883 = (state_26886[(2)]);
var inst_26884 = cljs.core.async.close_BANG_.call(null,out);
var state_26886__$1 = (function (){var statearr_26895 = state_26886;
(statearr_26895[(9)] = inst_26883);

return statearr_26895;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_26886__$1,inst_26884);
} else {
if((state_val_26887 === (2))){
var state_26886__$1 = state_26886;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_26886__$1,(4),ch);
} else {
if((state_val_26887 === (11))){
var inst_26866 = (state_26886[(8)]);
var inst_26875 = (state_26886[(2)]);
var inst_26863 = inst_26866;
var state_26886__$1 = (function (){var statearr_26896 = state_26886;
(statearr_26896[(10)] = inst_26875);

(statearr_26896[(7)] = inst_26863);

return statearr_26896;
})();
var statearr_26897_26915 = state_26886__$1;
(statearr_26897_26915[(2)] = null);

(statearr_26897_26915[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26887 === (9))){
var inst_26866 = (state_26886[(8)]);
var state_26886__$1 = state_26886;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_26886__$1,(11),out,inst_26866);
} else {
if((state_val_26887 === (5))){
var inst_26863 = (state_26886[(7)]);
var inst_26866 = (state_26886[(8)]);
var inst_26870 = cljs.core._EQ_.call(null,inst_26866,inst_26863);
var state_26886__$1 = state_26886;
if(inst_26870){
var statearr_26899_26916 = state_26886__$1;
(statearr_26899_26916[(1)] = (8));

} else {
var statearr_26900_26917 = state_26886__$1;
(statearr_26900_26917[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26887 === (10))){
var inst_26878 = (state_26886[(2)]);
var state_26886__$1 = state_26886;
var statearr_26901_26918 = state_26886__$1;
(statearr_26901_26918[(2)] = inst_26878);

(statearr_26901_26918[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26887 === (8))){
var inst_26863 = (state_26886[(7)]);
var tmp26898 = inst_26863;
var inst_26863__$1 = tmp26898;
var state_26886__$1 = (function (){var statearr_26902 = state_26886;
(statearr_26902[(7)] = inst_26863__$1);

return statearr_26902;
})();
var statearr_26903_26919 = state_26886__$1;
(statearr_26903_26919[(2)] = null);

(statearr_26903_26919[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__25187__auto___26909,out))
;
return ((function (switch__25099__auto__,c__25187__auto___26909,out){
return (function() {
var cljs$core$async$state_machine__25100__auto__ = null;
var cljs$core$async$state_machine__25100__auto____0 = (function (){
var statearr_26904 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_26904[(0)] = cljs$core$async$state_machine__25100__auto__);

(statearr_26904[(1)] = (1));

return statearr_26904;
});
var cljs$core$async$state_machine__25100__auto____1 = (function (state_26886){
while(true){
var ret_value__25101__auto__ = (function (){try{while(true){
var result__25102__auto__ = switch__25099__auto__.call(null,state_26886);
if(cljs.core.keyword_identical_QMARK_.call(null,result__25102__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__25102__auto__;
}
break;
}
}catch (e26905){if((e26905 instanceof Object)){
var ex__25103__auto__ = e26905;
var statearr_26906_26920 = state_26886;
(statearr_26906_26920[(5)] = ex__25103__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_26886);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e26905;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__25101__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__26921 = state_26886;
state_26886 = G__26921;
continue;
} else {
return ret_value__25101__auto__;
}
break;
}
});
cljs$core$async$state_machine__25100__auto__ = function(state_26886){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__25100__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__25100__auto____1.call(this,state_26886);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$state_machine__25100__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__25100__auto____0;
cljs$core$async$state_machine__25100__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__25100__auto____1;
return cljs$core$async$state_machine__25100__auto__;
})()
;})(switch__25099__auto__,c__25187__auto___26909,out))
})();
var state__25189__auto__ = (function (){var statearr_26907 = f__25188__auto__.call(null);
(statearr_26907[(6)] = c__25187__auto___26909);

return statearr_26907;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__25189__auto__);
});})(c__25187__auto___26909,out))
);


return out;
});

cljs.core.async.unique.cljs$lang$maxFixedArity = 2;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition = (function cljs$core$async$partition(var_args){
var G__26923 = arguments.length;
switch (G__26923) {
case 2:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.partition.call(null,n,ch,null);
});

cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__25187__auto___26989 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__25187__auto___26989,out){
return (function (){
var f__25188__auto__ = (function (){var switch__25099__auto__ = ((function (c__25187__auto___26989,out){
return (function (state_26961){
var state_val_26962 = (state_26961[(1)]);
if((state_val_26962 === (7))){
var inst_26957 = (state_26961[(2)]);
var state_26961__$1 = state_26961;
var statearr_26963_26990 = state_26961__$1;
(statearr_26963_26990[(2)] = inst_26957);

(statearr_26963_26990[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26962 === (1))){
var inst_26924 = (new Array(n));
var inst_26925 = inst_26924;
var inst_26926 = (0);
var state_26961__$1 = (function (){var statearr_26964 = state_26961;
(statearr_26964[(7)] = inst_26925);

(statearr_26964[(8)] = inst_26926);

return statearr_26964;
})();
var statearr_26965_26991 = state_26961__$1;
(statearr_26965_26991[(2)] = null);

(statearr_26965_26991[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26962 === (4))){
var inst_26929 = (state_26961[(9)]);
var inst_26929__$1 = (state_26961[(2)]);
var inst_26930 = (inst_26929__$1 == null);
var inst_26931 = cljs.core.not.call(null,inst_26930);
var state_26961__$1 = (function (){var statearr_26966 = state_26961;
(statearr_26966[(9)] = inst_26929__$1);

return statearr_26966;
})();
if(inst_26931){
var statearr_26967_26992 = state_26961__$1;
(statearr_26967_26992[(1)] = (5));

} else {
var statearr_26968_26993 = state_26961__$1;
(statearr_26968_26993[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26962 === (15))){
var inst_26951 = (state_26961[(2)]);
var state_26961__$1 = state_26961;
var statearr_26969_26994 = state_26961__$1;
(statearr_26969_26994[(2)] = inst_26951);

(statearr_26969_26994[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26962 === (13))){
var state_26961__$1 = state_26961;
var statearr_26970_26995 = state_26961__$1;
(statearr_26970_26995[(2)] = null);

(statearr_26970_26995[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26962 === (6))){
var inst_26926 = (state_26961[(8)]);
var inst_26947 = (inst_26926 > (0));
var state_26961__$1 = state_26961;
if(cljs.core.truth_(inst_26947)){
var statearr_26971_26996 = state_26961__$1;
(statearr_26971_26996[(1)] = (12));

} else {
var statearr_26972_26997 = state_26961__$1;
(statearr_26972_26997[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26962 === (3))){
var inst_26959 = (state_26961[(2)]);
var state_26961__$1 = state_26961;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_26961__$1,inst_26959);
} else {
if((state_val_26962 === (12))){
var inst_26925 = (state_26961[(7)]);
var inst_26949 = cljs.core.vec.call(null,inst_26925);
var state_26961__$1 = state_26961;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_26961__$1,(15),out,inst_26949);
} else {
if((state_val_26962 === (2))){
var state_26961__$1 = state_26961;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_26961__$1,(4),ch);
} else {
if((state_val_26962 === (11))){
var inst_26941 = (state_26961[(2)]);
var inst_26942 = (new Array(n));
var inst_26925 = inst_26942;
var inst_26926 = (0);
var state_26961__$1 = (function (){var statearr_26973 = state_26961;
(statearr_26973[(7)] = inst_26925);

(statearr_26973[(8)] = inst_26926);

(statearr_26973[(10)] = inst_26941);

return statearr_26973;
})();
var statearr_26974_26998 = state_26961__$1;
(statearr_26974_26998[(2)] = null);

(statearr_26974_26998[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26962 === (9))){
var inst_26925 = (state_26961[(7)]);
var inst_26939 = cljs.core.vec.call(null,inst_26925);
var state_26961__$1 = state_26961;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_26961__$1,(11),out,inst_26939);
} else {
if((state_val_26962 === (5))){
var inst_26925 = (state_26961[(7)]);
var inst_26926 = (state_26961[(8)]);
var inst_26934 = (state_26961[(11)]);
var inst_26929 = (state_26961[(9)]);
var inst_26933 = (inst_26925[inst_26926] = inst_26929);
var inst_26934__$1 = (inst_26926 + (1));
var inst_26935 = (inst_26934__$1 < n);
var state_26961__$1 = (function (){var statearr_26975 = state_26961;
(statearr_26975[(11)] = inst_26934__$1);

(statearr_26975[(12)] = inst_26933);

return statearr_26975;
})();
if(cljs.core.truth_(inst_26935)){
var statearr_26976_26999 = state_26961__$1;
(statearr_26976_26999[(1)] = (8));

} else {
var statearr_26977_27000 = state_26961__$1;
(statearr_26977_27000[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26962 === (14))){
var inst_26954 = (state_26961[(2)]);
var inst_26955 = cljs.core.async.close_BANG_.call(null,out);
var state_26961__$1 = (function (){var statearr_26979 = state_26961;
(statearr_26979[(13)] = inst_26954);

return statearr_26979;
})();
var statearr_26980_27001 = state_26961__$1;
(statearr_26980_27001[(2)] = inst_26955);

(statearr_26980_27001[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26962 === (10))){
var inst_26945 = (state_26961[(2)]);
var state_26961__$1 = state_26961;
var statearr_26981_27002 = state_26961__$1;
(statearr_26981_27002[(2)] = inst_26945);

(statearr_26981_27002[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26962 === (8))){
var inst_26925 = (state_26961[(7)]);
var inst_26934 = (state_26961[(11)]);
var tmp26978 = inst_26925;
var inst_26925__$1 = tmp26978;
var inst_26926 = inst_26934;
var state_26961__$1 = (function (){var statearr_26982 = state_26961;
(statearr_26982[(7)] = inst_26925__$1);

(statearr_26982[(8)] = inst_26926);

return statearr_26982;
})();
var statearr_26983_27003 = state_26961__$1;
(statearr_26983_27003[(2)] = null);

(statearr_26983_27003[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__25187__auto___26989,out))
;
return ((function (switch__25099__auto__,c__25187__auto___26989,out){
return (function() {
var cljs$core$async$state_machine__25100__auto__ = null;
var cljs$core$async$state_machine__25100__auto____0 = (function (){
var statearr_26984 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_26984[(0)] = cljs$core$async$state_machine__25100__auto__);

(statearr_26984[(1)] = (1));

return statearr_26984;
});
var cljs$core$async$state_machine__25100__auto____1 = (function (state_26961){
while(true){
var ret_value__25101__auto__ = (function (){try{while(true){
var result__25102__auto__ = switch__25099__auto__.call(null,state_26961);
if(cljs.core.keyword_identical_QMARK_.call(null,result__25102__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__25102__auto__;
}
break;
}
}catch (e26985){if((e26985 instanceof Object)){
var ex__25103__auto__ = e26985;
var statearr_26986_27004 = state_26961;
(statearr_26986_27004[(5)] = ex__25103__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_26961);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e26985;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__25101__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__27005 = state_26961;
state_26961 = G__27005;
continue;
} else {
return ret_value__25101__auto__;
}
break;
}
});
cljs$core$async$state_machine__25100__auto__ = function(state_26961){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__25100__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__25100__auto____1.call(this,state_26961);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$state_machine__25100__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__25100__auto____0;
cljs$core$async$state_machine__25100__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__25100__auto____1;
return cljs$core$async$state_machine__25100__auto__;
})()
;})(switch__25099__auto__,c__25187__auto___26989,out))
})();
var state__25189__auto__ = (function (){var statearr_26987 = f__25188__auto__.call(null);
(statearr_26987[(6)] = c__25187__auto___26989);

return statearr_26987;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__25189__auto__);
});})(c__25187__auto___26989,out))
);


return out;
});

cljs.core.async.partition.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition_by = (function cljs$core$async$partition_by(var_args){
var G__27007 = arguments.length;
switch (G__27007) {
case 2:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2 = (function (f,ch){
return cljs.core.async.partition_by.call(null,f,ch,null);
});

cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3 = (function (f,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__25187__auto___27077 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__25187__auto___27077,out){
return (function (){
var f__25188__auto__ = (function (){var switch__25099__auto__ = ((function (c__25187__auto___27077,out){
return (function (state_27049){
var state_val_27050 = (state_27049[(1)]);
if((state_val_27050 === (7))){
var inst_27045 = (state_27049[(2)]);
var state_27049__$1 = state_27049;
var statearr_27051_27078 = state_27049__$1;
(statearr_27051_27078[(2)] = inst_27045);

(statearr_27051_27078[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27050 === (1))){
var inst_27008 = [];
var inst_27009 = inst_27008;
var inst_27010 = new cljs.core.Keyword("cljs.core.async","nothing","cljs.core.async/nothing",-69252123);
var state_27049__$1 = (function (){var statearr_27052 = state_27049;
(statearr_27052[(7)] = inst_27010);

(statearr_27052[(8)] = inst_27009);

return statearr_27052;
})();
var statearr_27053_27079 = state_27049__$1;
(statearr_27053_27079[(2)] = null);

(statearr_27053_27079[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27050 === (4))){
var inst_27013 = (state_27049[(9)]);
var inst_27013__$1 = (state_27049[(2)]);
var inst_27014 = (inst_27013__$1 == null);
var inst_27015 = cljs.core.not.call(null,inst_27014);
var state_27049__$1 = (function (){var statearr_27054 = state_27049;
(statearr_27054[(9)] = inst_27013__$1);

return statearr_27054;
})();
if(inst_27015){
var statearr_27055_27080 = state_27049__$1;
(statearr_27055_27080[(1)] = (5));

} else {
var statearr_27056_27081 = state_27049__$1;
(statearr_27056_27081[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27050 === (15))){
var inst_27039 = (state_27049[(2)]);
var state_27049__$1 = state_27049;
var statearr_27057_27082 = state_27049__$1;
(statearr_27057_27082[(2)] = inst_27039);

(statearr_27057_27082[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27050 === (13))){
var state_27049__$1 = state_27049;
var statearr_27058_27083 = state_27049__$1;
(statearr_27058_27083[(2)] = null);

(statearr_27058_27083[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27050 === (6))){
var inst_27009 = (state_27049[(8)]);
var inst_27034 = inst_27009.length;
var inst_27035 = (inst_27034 > (0));
var state_27049__$1 = state_27049;
if(cljs.core.truth_(inst_27035)){
var statearr_27059_27084 = state_27049__$1;
(statearr_27059_27084[(1)] = (12));

} else {
var statearr_27060_27085 = state_27049__$1;
(statearr_27060_27085[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27050 === (3))){
var inst_27047 = (state_27049[(2)]);
var state_27049__$1 = state_27049;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_27049__$1,inst_27047);
} else {
if((state_val_27050 === (12))){
var inst_27009 = (state_27049[(8)]);
var inst_27037 = cljs.core.vec.call(null,inst_27009);
var state_27049__$1 = state_27049;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_27049__$1,(15),out,inst_27037);
} else {
if((state_val_27050 === (2))){
var state_27049__$1 = state_27049;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_27049__$1,(4),ch);
} else {
if((state_val_27050 === (11))){
var inst_27013 = (state_27049[(9)]);
var inst_27017 = (state_27049[(10)]);
var inst_27027 = (state_27049[(2)]);
var inst_27028 = [];
var inst_27029 = inst_27028.push(inst_27013);
var inst_27009 = inst_27028;
var inst_27010 = inst_27017;
var state_27049__$1 = (function (){var statearr_27061 = state_27049;
(statearr_27061[(7)] = inst_27010);

(statearr_27061[(11)] = inst_27027);

(statearr_27061[(12)] = inst_27029);

(statearr_27061[(8)] = inst_27009);

return statearr_27061;
})();
var statearr_27062_27086 = state_27049__$1;
(statearr_27062_27086[(2)] = null);

(statearr_27062_27086[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27050 === (9))){
var inst_27009 = (state_27049[(8)]);
var inst_27025 = cljs.core.vec.call(null,inst_27009);
var state_27049__$1 = state_27049;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_27049__$1,(11),out,inst_27025);
} else {
if((state_val_27050 === (5))){
var inst_27010 = (state_27049[(7)]);
var inst_27013 = (state_27049[(9)]);
var inst_27017 = (state_27049[(10)]);
var inst_27017__$1 = f.call(null,inst_27013);
var inst_27018 = cljs.core._EQ_.call(null,inst_27017__$1,inst_27010);
var inst_27019 = cljs.core.keyword_identical_QMARK_.call(null,inst_27010,new cljs.core.Keyword("cljs.core.async","nothing","cljs.core.async/nothing",-69252123));
var inst_27020 = (inst_27018) || (inst_27019);
var state_27049__$1 = (function (){var statearr_27063 = state_27049;
(statearr_27063[(10)] = inst_27017__$1);

return statearr_27063;
})();
if(cljs.core.truth_(inst_27020)){
var statearr_27064_27087 = state_27049__$1;
(statearr_27064_27087[(1)] = (8));

} else {
var statearr_27065_27088 = state_27049__$1;
(statearr_27065_27088[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27050 === (14))){
var inst_27042 = (state_27049[(2)]);
var inst_27043 = cljs.core.async.close_BANG_.call(null,out);
var state_27049__$1 = (function (){var statearr_27067 = state_27049;
(statearr_27067[(13)] = inst_27042);

return statearr_27067;
})();
var statearr_27068_27089 = state_27049__$1;
(statearr_27068_27089[(2)] = inst_27043);

(statearr_27068_27089[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27050 === (10))){
var inst_27032 = (state_27049[(2)]);
var state_27049__$1 = state_27049;
var statearr_27069_27090 = state_27049__$1;
(statearr_27069_27090[(2)] = inst_27032);

(statearr_27069_27090[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27050 === (8))){
var inst_27013 = (state_27049[(9)]);
var inst_27017 = (state_27049[(10)]);
var inst_27009 = (state_27049[(8)]);
var inst_27022 = inst_27009.push(inst_27013);
var tmp27066 = inst_27009;
var inst_27009__$1 = tmp27066;
var inst_27010 = inst_27017;
var state_27049__$1 = (function (){var statearr_27070 = state_27049;
(statearr_27070[(7)] = inst_27010);

(statearr_27070[(8)] = inst_27009__$1);

(statearr_27070[(14)] = inst_27022);

return statearr_27070;
})();
var statearr_27071_27091 = state_27049__$1;
(statearr_27071_27091[(2)] = null);

(statearr_27071_27091[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__25187__auto___27077,out))
;
return ((function (switch__25099__auto__,c__25187__auto___27077,out){
return (function() {
var cljs$core$async$state_machine__25100__auto__ = null;
var cljs$core$async$state_machine__25100__auto____0 = (function (){
var statearr_27072 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_27072[(0)] = cljs$core$async$state_machine__25100__auto__);

(statearr_27072[(1)] = (1));

return statearr_27072;
});
var cljs$core$async$state_machine__25100__auto____1 = (function (state_27049){
while(true){
var ret_value__25101__auto__ = (function (){try{while(true){
var result__25102__auto__ = switch__25099__auto__.call(null,state_27049);
if(cljs.core.keyword_identical_QMARK_.call(null,result__25102__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__25102__auto__;
}
break;
}
}catch (e27073){if((e27073 instanceof Object)){
var ex__25103__auto__ = e27073;
var statearr_27074_27092 = state_27049;
(statearr_27074_27092[(5)] = ex__25103__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_27049);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e27073;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__25101__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__27093 = state_27049;
state_27049 = G__27093;
continue;
} else {
return ret_value__25101__auto__;
}
break;
}
});
cljs$core$async$state_machine__25100__auto__ = function(state_27049){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__25100__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__25100__auto____1.call(this,state_27049);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$state_machine__25100__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__25100__auto____0;
cljs$core$async$state_machine__25100__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__25100__auto____1;
return cljs$core$async$state_machine__25100__auto__;
})()
;})(switch__25099__auto__,c__25187__auto___27077,out))
})();
var state__25189__auto__ = (function (){var statearr_27075 = f__25188__auto__.call(null);
(statearr_27075[(6)] = c__25187__auto___27077);

return statearr_27075;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__25189__auto__);
});})(c__25187__auto___27077,out))
);


return out;
});

cljs.core.async.partition_by.cljs$lang$maxFixedArity = 3;

