// Compiled by ClojureScript 1.9.946 {}
goog.provide('re_frame.events');
goog.require('cljs.core');
goog.require('re_frame.db');
goog.require('re_frame.utils');
goog.require('re_frame.interop');
goog.require('re_frame.registrar');
goog.require('re_frame.loggers');
goog.require('re_frame.interceptor');
goog.require('re_frame.trace');
re_frame.events.kind = new cljs.core.Keyword(null,"event","event",301435442);
if(cljs.core.truth_(re_frame.registrar.kinds.call(null,re_frame.events.kind))){
} else {
throw (new Error("Assert failed: (re-frame.registrar/kinds kind)"));
}
/**
 * `interceptors` might have nested collections, and contain nil elements.
 *   return a flat collection, with all nils removed.
 *   This function is 9/10 about giving good error messages.
 */
re_frame.events.flatten_and_remove_nils = (function re_frame$events$flatten_and_remove_nils(id,interceptors){
var make_chain = (function (p1__31693_SHARP_){
return cljs.core.remove.call(null,cljs.core.nil_QMARK_,cljs.core.flatten.call(null,p1__31693_SHARP_));
});
if(!(re_frame.interop.debug_enabled_QMARK_)){
return make_chain.call(null,interceptors);
} else {
if(cljs.core.coll_QMARK_.call(null,interceptors)){
} else {
re_frame.loggers.console.call(null,new cljs.core.Keyword(null,"error","error",-978969032),"re-frame: when registering ",id,", expected a collection of interceptors, got: ",interceptors);
}

var chain = make_chain.call(null,interceptors);
if(cljs.core.empty_QMARK_.call(null,chain)){
re_frame.loggers.console.call(null,new cljs.core.Keyword(null,"error","error",-978969032),"re-frame: when registering ",id,", given an empty interceptor chain");
} else {
}

var temp__4657__auto___31694 = cljs.core.first.call(null,cljs.core.remove.call(null,re_frame.interceptor.interceptor_QMARK_,chain));
if(cljs.core.truth_(temp__4657__auto___31694)){
var not_i_31695 = temp__4657__auto___31694;
if(cljs.core.fn_QMARK_.call(null,not_i_31695)){
re_frame.loggers.console.call(null,new cljs.core.Keyword(null,"error","error",-978969032),"re-frame: when registering ",id,", got a function instead of an interceptor. Did you provide old style middleware by mistake? Got: ",not_i_31695);
} else {
re_frame.loggers.console.call(null,new cljs.core.Keyword(null,"error","error",-978969032),"re-frame: when registering ",id,", expected interceptors, but got: ",not_i_31695);
}
} else {
}

return chain;
}
});
/**
 * Associate the given event `id` with the given collection of `interceptors`.
 * 
 * `interceptors` may contain nested collections and there may be nils
 * at any level,so process this structure into a simple, nil-less vector
 * before registration.
 * 
 * Typically, an `event handler` will be at the end of the chain (wrapped
 * in an interceptor).
 */
re_frame.events.register = (function re_frame$events$register(id,interceptors){
return re_frame.registrar.register_handler.call(null,re_frame.events.kind,id,re_frame.events.flatten_and_remove_nils.call(null,id,interceptors));
});
re_frame.events._STAR_handling_STAR_ = null;
/**
 * Given an event vector `event-v`, look up the associated interceptor chain, and execute it.
 */
re_frame.events.handle = (function re_frame$events$handle(event_v){
var event_id = re_frame.utils.first_in_vector.call(null,event_v);
var temp__4655__auto__ = re_frame.registrar.get_handler.call(null,re_frame.events.kind,event_id,true);
if(cljs.core.truth_(temp__4655__auto__)){
var interceptors = temp__4655__auto__;
if(cljs.core.truth_(re_frame.events._STAR_handling_STAR_)){
return re_frame.loggers.console.call(null,new cljs.core.Keyword(null,"error","error",-978969032),"re-frame: while handling \"",re_frame.events._STAR_handling_STAR_,"\", dispatch-sync was called for \"",event_v,"\". You can't call dispatch-sync within an event handler.");
} else {
var _STAR_handling_STAR_31696 = re_frame.events._STAR_handling_STAR_;
re_frame.events._STAR_handling_STAR_ = event_v;

try{if(re_frame.trace.is_trace_enabled_QMARK_.call(null)){
var _STAR_current_trace_STAR_31697 = re_frame.trace._STAR_current_trace_STAR_;
re_frame.trace._STAR_current_trace_STAR_ = re_frame.trace.start_trace.call(null,new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"operation","operation",-1267664310),event_id,new cljs.core.Keyword(null,"op-type","op-type",-1636141668),re_frame.events.kind,new cljs.core.Keyword(null,"tags","tags",1771418977),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"event","event",301435442),event_v], null)], null));

try{try{return re_frame.interceptor.execute.call(null,event_v,interceptors);
}finally {if(re_frame.trace.is_trace_enabled_QMARK_.call(null)){
var end__31641__auto___31710 = re_frame.interop.now.call(null);
var duration__31642__auto___31711 = (end__31641__auto___31710 - new cljs.core.Keyword(null,"start","start",-355208981).cljs$core$IFn$_invoke$arity$1(re_frame.trace._STAR_current_trace_STAR_));
var seq__31698_31712 = cljs.core.seq.call(null,cljs.core.deref.call(null,re_frame.trace.trace_cbs));
var chunk__31699_31713 = null;
var count__31700_31714 = (0);
var i__31701_31715 = (0);
while(true){
if((i__31701_31715 < count__31700_31714)){
var vec__31702_31716 = cljs.core._nth.call(null,chunk__31699_31713,i__31701_31715);
var k__31643__auto___31717 = cljs.core.nth.call(null,vec__31702_31716,(0),null);
var cb__31644__auto___31718 = cljs.core.nth.call(null,vec__31702_31716,(1),null);
try{cb__31644__auto___31718.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.assoc.call(null,re_frame.trace._STAR_current_trace_STAR_,new cljs.core.Keyword(null,"duration","duration",1444101068),duration__31642__auto___31711,new cljs.core.Keyword(null,"end","end",-268185958),re_frame.interop.now.call(null))], null));
}catch (e31705){if((e31705 instanceof java.lang.Exception)){
var e__31645__auto___31719 = e31705;
re_frame.loggers.console.call(null,new cljs.core.Keyword(null,"error","error",-978969032),"Error thrown from trace cb",k__31643__auto___31717,"while storing",re_frame.trace._STAR_current_trace_STAR_,e__31645__auto___31719);
} else {
throw e31705;

}
}
var G__31720 = seq__31698_31712;
var G__31721 = chunk__31699_31713;
var G__31722 = count__31700_31714;
var G__31723 = (i__31701_31715 + (1));
seq__31698_31712 = G__31720;
chunk__31699_31713 = G__31721;
count__31700_31714 = G__31722;
i__31701_31715 = G__31723;
continue;
} else {
var temp__4657__auto___31724 = cljs.core.seq.call(null,seq__31698_31712);
if(temp__4657__auto___31724){
var seq__31698_31725__$1 = temp__4657__auto___31724;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__31698_31725__$1)){
var c__9025__auto___31726 = cljs.core.chunk_first.call(null,seq__31698_31725__$1);
var G__31727 = cljs.core.chunk_rest.call(null,seq__31698_31725__$1);
var G__31728 = c__9025__auto___31726;
var G__31729 = cljs.core.count.call(null,c__9025__auto___31726);
var G__31730 = (0);
seq__31698_31712 = G__31727;
chunk__31699_31713 = G__31728;
count__31700_31714 = G__31729;
i__31701_31715 = G__31730;
continue;
} else {
var vec__31706_31731 = cljs.core.first.call(null,seq__31698_31725__$1);
var k__31643__auto___31732 = cljs.core.nth.call(null,vec__31706_31731,(0),null);
var cb__31644__auto___31733 = cljs.core.nth.call(null,vec__31706_31731,(1),null);
try{cb__31644__auto___31733.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.assoc.call(null,re_frame.trace._STAR_current_trace_STAR_,new cljs.core.Keyword(null,"duration","duration",1444101068),duration__31642__auto___31711,new cljs.core.Keyword(null,"end","end",-268185958),re_frame.interop.now.call(null))], null));
}catch (e31709){if((e31709 instanceof java.lang.Exception)){
var e__31645__auto___31734 = e31709;
re_frame.loggers.console.call(null,new cljs.core.Keyword(null,"error","error",-978969032),"Error thrown from trace cb",k__31643__auto___31732,"while storing",re_frame.trace._STAR_current_trace_STAR_,e__31645__auto___31734);
} else {
throw e31709;

}
}
var G__31735 = cljs.core.next.call(null,seq__31698_31725__$1);
var G__31736 = null;
var G__31737 = (0);
var G__31738 = (0);
seq__31698_31712 = G__31735;
chunk__31699_31713 = G__31736;
count__31700_31714 = G__31737;
i__31701_31715 = G__31738;
continue;
}
} else {
}
}
break;
}
} else {
}
}}finally {re_frame.trace._STAR_current_trace_STAR_ = _STAR_current_trace_STAR_31697;
}} else {
return re_frame.interceptor.execute.call(null,event_v,interceptors);
}
}finally {re_frame.events._STAR_handling_STAR_ = _STAR_handling_STAR_31696;
}}
} else {
return null;
}
});
