// Compiled by ClojureScript 1.9.946 {}
goog.provide('re_frame.fx');
goog.require('cljs.core');
goog.require('re_frame.router');
goog.require('re_frame.db');
goog.require('re_frame.interceptor');
goog.require('re_frame.interop');
goog.require('re_frame.events');
goog.require('re_frame.registrar');
goog.require('re_frame.loggers');
re_frame.fx.kind = new cljs.core.Keyword(null,"fx","fx",-1237829572);
if(cljs.core.truth_(re_frame.registrar.kinds.call(null,re_frame.fx.kind))){
} else {
throw (new Error("Assert failed: (re-frame.registrar/kinds kind)"));
}
/**
 * Register the given effect `handler` for the given `id`.
 * 
 *   `id` is keyword, often namespaced.
 *   `handler` is a side-effecting function which takes a single argument and whose return
 *   value is ignored.
 * 
 *   Example Use
 *   -----------
 * 
 *   First, registration ... associate `:effect2` with a handler.
 * 
 *   (reg-fx
 *   :effect2
 *   (fn [value]
 *      ... do something side-effect-y))
 * 
 *   Then, later, if an event handler were to return this effects map ...
 * 
 *   {...
 * :effect2  [1 2]}
 * 
 * ... then the `handler` `fn` we registered previously, using `reg-fx`, will be
 * called with an argument of `[1 2]`.
 */
re_frame.fx.reg_fx = (function re_frame$fx$reg_fx(id,handler){
return re_frame.registrar.register_handler.call(null,re_frame.fx.kind,id,handler);
});
/**
 * An interceptor whose `:after` actions the contents of `:effects`. As a result,
 *   this interceptor is Domino 3.
 * 
 *   This interceptor is silently added (by reg-event-db etc) to the front of
 *   interceptor chains for all events.
 * 
 *   For each key in `:effects` (a map), it calls the registered `effects handler`
 *   (see `reg-fx` for registration of effect handlers).
 * 
 *   So, if `:effects` was:
 *    {:dispatch  [:hello 42]
 *     :db        {...}
 *     :undo      "set flag"}
 * 
 *   it will call the registered effect handlers for each of the map's keys:
 *   `:dispatch`, `:undo` and `:db`. When calling each handler, provides the map
 *   value for that key - so in the example above the effect handler for :dispatch
 *   will be given one arg `[:hello 42]`.
 * 
 *   You cannot rely on the ordering in which effects are executed.
 */
re_frame.fx.do_fx = re_frame.interceptor.__GT_interceptor.call(null,new cljs.core.Keyword(null,"id","id",-1388402092),new cljs.core.Keyword(null,"do-fx","do-fx",1194163050),new cljs.core.Keyword(null,"after","after",594996914),(function re_frame$fx$do_fx_after(context){
var seq__31813 = cljs.core.seq.call(null,new cljs.core.Keyword(null,"effects","effects",-282369292).cljs$core$IFn$_invoke$arity$1(context));
var chunk__31814 = null;
var count__31815 = (0);
var i__31816 = (0);
while(true){
if((i__31816 < count__31815)){
var vec__31817 = cljs.core._nth.call(null,chunk__31814,i__31816);
var effect_key = cljs.core.nth.call(null,vec__31817,(0),null);
var effect_value = cljs.core.nth.call(null,vec__31817,(1),null);
var temp__4655__auto___31823 = re_frame.registrar.get_handler.call(null,re_frame.fx.kind,effect_key,false);
if(cljs.core.truth_(temp__4655__auto___31823)){
var effect_fn_31824 = temp__4655__auto___31823;
effect_fn_31824.call(null,effect_value);
} else {
re_frame.loggers.console.call(null,new cljs.core.Keyword(null,"error","error",-978969032),"re-frame: no handler registered for effect: \"",effect_key,"\". Ignoring.");
}

var G__31825 = seq__31813;
var G__31826 = chunk__31814;
var G__31827 = count__31815;
var G__31828 = (i__31816 + (1));
seq__31813 = G__31825;
chunk__31814 = G__31826;
count__31815 = G__31827;
i__31816 = G__31828;
continue;
} else {
var temp__4657__auto__ = cljs.core.seq.call(null,seq__31813);
if(temp__4657__auto__){
var seq__31813__$1 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__31813__$1)){
var c__9025__auto__ = cljs.core.chunk_first.call(null,seq__31813__$1);
var G__31829 = cljs.core.chunk_rest.call(null,seq__31813__$1);
var G__31830 = c__9025__auto__;
var G__31831 = cljs.core.count.call(null,c__9025__auto__);
var G__31832 = (0);
seq__31813 = G__31829;
chunk__31814 = G__31830;
count__31815 = G__31831;
i__31816 = G__31832;
continue;
} else {
var vec__31820 = cljs.core.first.call(null,seq__31813__$1);
var effect_key = cljs.core.nth.call(null,vec__31820,(0),null);
var effect_value = cljs.core.nth.call(null,vec__31820,(1),null);
var temp__4655__auto___31833 = re_frame.registrar.get_handler.call(null,re_frame.fx.kind,effect_key,false);
if(cljs.core.truth_(temp__4655__auto___31833)){
var effect_fn_31834 = temp__4655__auto___31833;
effect_fn_31834.call(null,effect_value);
} else {
re_frame.loggers.console.call(null,new cljs.core.Keyword(null,"error","error",-978969032),"re-frame: no handler registered for effect: \"",effect_key,"\". Ignoring.");
}

var G__31835 = cljs.core.next.call(null,seq__31813__$1);
var G__31836 = null;
var G__31837 = (0);
var G__31838 = (0);
seq__31813 = G__31835;
chunk__31814 = G__31836;
count__31815 = G__31837;
i__31816 = G__31838;
continue;
}
} else {
return null;
}
}
break;
}
}));
re_frame.fx.reg_fx.call(null,new cljs.core.Keyword(null,"dispatch-later","dispatch-later",291951390),(function (value){
var seq__31839 = cljs.core.seq.call(null,value);
var chunk__31840 = null;
var count__31841 = (0);
var i__31842 = (0);
while(true){
if((i__31842 < count__31841)){
var map__31843 = cljs.core._nth.call(null,chunk__31840,i__31842);
var map__31843__$1 = ((((!((map__31843 == null)))?((((map__31843.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__31843.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__31843):map__31843);
var effect = map__31843__$1;
var ms = cljs.core.get.call(null,map__31843__$1,new cljs.core.Keyword(null,"ms","ms",-1152709733));
var dispatch = cljs.core.get.call(null,map__31843__$1,new cljs.core.Keyword(null,"dispatch","dispatch",1319337009));
if((cljs.core.empty_QMARK_.call(null,dispatch)) || (!(typeof ms === 'number'))){
re_frame.loggers.console.call(null,new cljs.core.Keyword(null,"error","error",-978969032),"re-frame: ignoring bad :dispatch-later value:",effect);
} else {
re_frame.interop.set_timeout_BANG_.call(null,((function (seq__31839,chunk__31840,count__31841,i__31842,map__31843,map__31843__$1,effect,ms,dispatch){
return (function (){
return re_frame.router.dispatch.call(null,dispatch);
});})(seq__31839,chunk__31840,count__31841,i__31842,map__31843,map__31843__$1,effect,ms,dispatch))
,ms);
}

var G__31847 = seq__31839;
var G__31848 = chunk__31840;
var G__31849 = count__31841;
var G__31850 = (i__31842 + (1));
seq__31839 = G__31847;
chunk__31840 = G__31848;
count__31841 = G__31849;
i__31842 = G__31850;
continue;
} else {
var temp__4657__auto__ = cljs.core.seq.call(null,seq__31839);
if(temp__4657__auto__){
var seq__31839__$1 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__31839__$1)){
var c__9025__auto__ = cljs.core.chunk_first.call(null,seq__31839__$1);
var G__31851 = cljs.core.chunk_rest.call(null,seq__31839__$1);
var G__31852 = c__9025__auto__;
var G__31853 = cljs.core.count.call(null,c__9025__auto__);
var G__31854 = (0);
seq__31839 = G__31851;
chunk__31840 = G__31852;
count__31841 = G__31853;
i__31842 = G__31854;
continue;
} else {
var map__31845 = cljs.core.first.call(null,seq__31839__$1);
var map__31845__$1 = ((((!((map__31845 == null)))?((((map__31845.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__31845.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__31845):map__31845);
var effect = map__31845__$1;
var ms = cljs.core.get.call(null,map__31845__$1,new cljs.core.Keyword(null,"ms","ms",-1152709733));
var dispatch = cljs.core.get.call(null,map__31845__$1,new cljs.core.Keyword(null,"dispatch","dispatch",1319337009));
if((cljs.core.empty_QMARK_.call(null,dispatch)) || (!(typeof ms === 'number'))){
re_frame.loggers.console.call(null,new cljs.core.Keyword(null,"error","error",-978969032),"re-frame: ignoring bad :dispatch-later value:",effect);
} else {
re_frame.interop.set_timeout_BANG_.call(null,((function (seq__31839,chunk__31840,count__31841,i__31842,map__31845,map__31845__$1,effect,ms,dispatch,seq__31839__$1,temp__4657__auto__){
return (function (){
return re_frame.router.dispatch.call(null,dispatch);
});})(seq__31839,chunk__31840,count__31841,i__31842,map__31845,map__31845__$1,effect,ms,dispatch,seq__31839__$1,temp__4657__auto__))
,ms);
}

var G__31855 = cljs.core.next.call(null,seq__31839__$1);
var G__31856 = null;
var G__31857 = (0);
var G__31858 = (0);
seq__31839 = G__31855;
chunk__31840 = G__31856;
count__31841 = G__31857;
i__31842 = G__31858;
continue;
}
} else {
return null;
}
}
break;
}
}));
re_frame.fx.reg_fx.call(null,new cljs.core.Keyword(null,"dispatch","dispatch",1319337009),(function (value){
if(!(cljs.core.vector_QMARK_.call(null,value))){
return re_frame.loggers.console.call(null,new cljs.core.Keyword(null,"error","error",-978969032),"re-frame: ignoring bad :dispatch value. Expected a vector, but got:",value);
} else {
return re_frame.router.dispatch.call(null,value);
}
}));
re_frame.fx.reg_fx.call(null,new cljs.core.Keyword(null,"dispatch-n","dispatch-n",-504469236),(function (value){
if(!(cljs.core.sequential_QMARK_.call(null,value))){
return re_frame.loggers.console.call(null,new cljs.core.Keyword(null,"error","error",-978969032),"re-frame: ignoring bad :dispatch-n value. Expected a collection, got got:",value);
} else {
var seq__31859 = cljs.core.seq.call(null,cljs.core.remove.call(null,cljs.core.nil_QMARK_,value));
var chunk__31860 = null;
var count__31861 = (0);
var i__31862 = (0);
while(true){
if((i__31862 < count__31861)){
var event = cljs.core._nth.call(null,chunk__31860,i__31862);
re_frame.router.dispatch.call(null,event);

var G__31863 = seq__31859;
var G__31864 = chunk__31860;
var G__31865 = count__31861;
var G__31866 = (i__31862 + (1));
seq__31859 = G__31863;
chunk__31860 = G__31864;
count__31861 = G__31865;
i__31862 = G__31866;
continue;
} else {
var temp__4657__auto__ = cljs.core.seq.call(null,seq__31859);
if(temp__4657__auto__){
var seq__31859__$1 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__31859__$1)){
var c__9025__auto__ = cljs.core.chunk_first.call(null,seq__31859__$1);
var G__31867 = cljs.core.chunk_rest.call(null,seq__31859__$1);
var G__31868 = c__9025__auto__;
var G__31869 = cljs.core.count.call(null,c__9025__auto__);
var G__31870 = (0);
seq__31859 = G__31867;
chunk__31860 = G__31868;
count__31861 = G__31869;
i__31862 = G__31870;
continue;
} else {
var event = cljs.core.first.call(null,seq__31859__$1);
re_frame.router.dispatch.call(null,event);

var G__31871 = cljs.core.next.call(null,seq__31859__$1);
var G__31872 = null;
var G__31873 = (0);
var G__31874 = (0);
seq__31859 = G__31871;
chunk__31860 = G__31872;
count__31861 = G__31873;
i__31862 = G__31874;
continue;
}
} else {
return null;
}
}
break;
}
}
}));
re_frame.fx.reg_fx.call(null,new cljs.core.Keyword(null,"deregister-event-handler","deregister-event-handler",-1096518994),(function (value){
var clear_event = cljs.core.partial.call(null,re_frame.registrar.clear_handlers,re_frame.events.kind);
if(cljs.core.sequential_QMARK_.call(null,value)){
var seq__31875 = cljs.core.seq.call(null,value);
var chunk__31876 = null;
var count__31877 = (0);
var i__31878 = (0);
while(true){
if((i__31878 < count__31877)){
var event = cljs.core._nth.call(null,chunk__31876,i__31878);
clear_event.call(null,event);

var G__31879 = seq__31875;
var G__31880 = chunk__31876;
var G__31881 = count__31877;
var G__31882 = (i__31878 + (1));
seq__31875 = G__31879;
chunk__31876 = G__31880;
count__31877 = G__31881;
i__31878 = G__31882;
continue;
} else {
var temp__4657__auto__ = cljs.core.seq.call(null,seq__31875);
if(temp__4657__auto__){
var seq__31875__$1 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__31875__$1)){
var c__9025__auto__ = cljs.core.chunk_first.call(null,seq__31875__$1);
var G__31883 = cljs.core.chunk_rest.call(null,seq__31875__$1);
var G__31884 = c__9025__auto__;
var G__31885 = cljs.core.count.call(null,c__9025__auto__);
var G__31886 = (0);
seq__31875 = G__31883;
chunk__31876 = G__31884;
count__31877 = G__31885;
i__31878 = G__31886;
continue;
} else {
var event = cljs.core.first.call(null,seq__31875__$1);
clear_event.call(null,event);

var G__31887 = cljs.core.next.call(null,seq__31875__$1);
var G__31888 = null;
var G__31889 = (0);
var G__31890 = (0);
seq__31875 = G__31887;
chunk__31876 = G__31888;
count__31877 = G__31889;
i__31878 = G__31890;
continue;
}
} else {
return null;
}
}
break;
}
} else {
return clear_event.call(null,value);
}
}));
re_frame.fx.reg_fx.call(null,new cljs.core.Keyword(null,"db","db",993250759),(function (value){
if(!((cljs.core.deref.call(null,re_frame.db.app_db) === value))){
return cljs.core.reset_BANG_.call(null,re_frame.db.app_db,value);
} else {
return null;
}
}));
