// Compiled by ClojureScript 1.9.946 {}
goog.provide('cljs.source_map');
goog.require('cljs.core');
goog.require('goog.object');
goog.require('clojure.string');
goog.require('clojure.set');
goog.require('cljs.source_map.base64_vlq');
/**
 * Take a seq of source file names and return a map from
 * file number to integer index. For reverse source maps.
 */
cljs.source_map.indexed_sources = (function cljs$source_map$indexed_sources(sources){
return cljs.core.reduce.call(null,(function (m,p__31190){
var vec__31191 = p__31190;
var i = cljs.core.nth.call(null,vec__31191,(0),null);
var v = cljs.core.nth.call(null,vec__31191,(1),null);
return cljs.core.assoc.call(null,m,v,i);
}),cljs.core.PersistentArrayMap.EMPTY,cljs.core.map_indexed.call(null,(function (a,b){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [a,b], null);
}),sources));
});
/**
 * Take a seq of source file names and return a comparator
 * that can be used to construct a sorted map. For reverse
 * source maps.
 */
cljs.source_map.source_compare = (function cljs$source_map$source_compare(sources){
var sources__$1 = cljs.source_map.indexed_sources.call(null,sources);
return ((function (sources__$1){
return (function (a,b){
return cljs.core.compare.call(null,sources__$1.call(null,a),sources__$1.call(null,b));
});
;})(sources__$1))
});
/**
 * Take a source map segment represented as a vector
 * and return a map.
 */
cljs.source_map.seg__GT_map = (function cljs$source_map$seg__GT_map(seg,source_map){
var vec__31194 = seg;
var gcol = cljs.core.nth.call(null,vec__31194,(0),null);
var source = cljs.core.nth.call(null,vec__31194,(1),null);
var line = cljs.core.nth.call(null,vec__31194,(2),null);
var col = cljs.core.nth.call(null,vec__31194,(3),null);
var name = cljs.core.nth.call(null,vec__31194,(4),null);
return new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"gcol","gcol",309250807),gcol,new cljs.core.Keyword(null,"source","source",-433931539),(goog.object.get(source_map,"sources")[source]),new cljs.core.Keyword(null,"line","line",212345235),line,new cljs.core.Keyword(null,"col","col",-1959363084),col,new cljs.core.Keyword(null,"name","name",1843675177),(function (){var temp__4657__auto__ = new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(cljs.core.meta.call(null,seg));
if(cljs.core.truth_(temp__4657__auto__)){
var name__$1 = temp__4657__auto__;
return (goog.object.get(source_map,"names")[name__$1]);
} else {
return null;
}
})()], null);
});
/**
 * Combine a source map segment vector and a relative
 * source map segment vector and combine them to get
 * an absolute segment posititon information as a vector.
 */
cljs.source_map.seg_combine = (function cljs$source_map$seg_combine(seg,relseg){
var vec__31197 = seg;
var gcol = cljs.core.nth.call(null,vec__31197,(0),null);
var source = cljs.core.nth.call(null,vec__31197,(1),null);
var line = cljs.core.nth.call(null,vec__31197,(2),null);
var col = cljs.core.nth.call(null,vec__31197,(3),null);
var name = cljs.core.nth.call(null,vec__31197,(4),null);
var vec__31200 = relseg;
var rgcol = cljs.core.nth.call(null,vec__31200,(0),null);
var rsource = cljs.core.nth.call(null,vec__31200,(1),null);
var rline = cljs.core.nth.call(null,vec__31200,(2),null);
var rcol = cljs.core.nth.call(null,vec__31200,(3),null);
var rname = cljs.core.nth.call(null,vec__31200,(4),null);
var nseg = new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [(gcol + rgcol),((function (){var or__8186__auto__ = source;
if(cljs.core.truth_(or__8186__auto__)){
return or__8186__auto__;
} else {
return (0);
}
})() + rsource),((function (){var or__8186__auto__ = line;
if(cljs.core.truth_(or__8186__auto__)){
return or__8186__auto__;
} else {
return (0);
}
})() + rline),((function (){var or__8186__auto__ = col;
if(cljs.core.truth_(or__8186__auto__)){
return or__8186__auto__;
} else {
return (0);
}
})() + rcol),((function (){var or__8186__auto__ = name;
if(cljs.core.truth_(or__8186__auto__)){
return or__8186__auto__;
} else {
return (0);
}
})() + rname)], null);
if(cljs.core.truth_(name)){
return cljs.core.with_meta.call(null,nseg,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"name","name",1843675177),(name + rname)], null));
} else {
return nseg;
}
});
/**
 * Helper for decode-reverse. Take a reverse source map and
 *   update it with a segment map.
 */
cljs.source_map.update_reverse_result = (function cljs$source_map$update_reverse_result(result,segmap,gline){
var map__31203 = segmap;
var map__31203__$1 = ((((!((map__31203 == null)))?((((map__31203.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__31203.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__31203):map__31203);
var gcol = cljs.core.get.call(null,map__31203__$1,new cljs.core.Keyword(null,"gcol","gcol",309250807));
var source = cljs.core.get.call(null,map__31203__$1,new cljs.core.Keyword(null,"source","source",-433931539));
var line = cljs.core.get.call(null,map__31203__$1,new cljs.core.Keyword(null,"line","line",212345235));
var col = cljs.core.get.call(null,map__31203__$1,new cljs.core.Keyword(null,"col","col",-1959363084));
var name = cljs.core.get.call(null,map__31203__$1,new cljs.core.Keyword(null,"name","name",1843675177));
var d = new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"gline","gline",-1086242431),gline,new cljs.core.Keyword(null,"gcol","gcol",309250807),gcol], null);
var d__$1 = (cljs.core.truth_(name)?cljs.core.assoc.call(null,d,new cljs.core.Keyword(null,"name","name",1843675177),name):d);
return cljs.core.update_in.call(null,result,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [source], null),cljs.core.fnil.call(null,((function (map__31203,map__31203__$1,gcol,source,line,col,name,d,d__$1){
return (function (m){
return cljs.core.update_in.call(null,m,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [line], null),cljs.core.fnil.call(null,((function (map__31203,map__31203__$1,gcol,source,line,col,name,d,d__$1){
return (function (m__$1){
return cljs.core.update_in.call(null,m__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [col], null),cljs.core.fnil.call(null,((function (map__31203,map__31203__$1,gcol,source,line,col,name,d,d__$1){
return (function (v){
return cljs.core.conj.call(null,v,d__$1);
});})(map__31203,map__31203__$1,gcol,source,line,col,name,d,d__$1))
,cljs.core.PersistentVector.EMPTY));
});})(map__31203,map__31203__$1,gcol,source,line,col,name,d,d__$1))
,cljs.core.sorted_map.call(null)));
});})(map__31203,map__31203__$1,gcol,source,line,col,name,d,d__$1))
,cljs.core.sorted_map.call(null)));
});
/**
 * Convert a v3 source map JSON object into a reverse source map
 *   mapping original ClojureScript source locations to the generated
 *   JavaScript.
 */
cljs.source_map.decode_reverse = (function cljs$source_map$decode_reverse(var_args){
var G__31206 = arguments.length;
switch (G__31206) {
case 1:
return cljs.source_map.decode_reverse.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.source_map.decode_reverse.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.source_map.decode_reverse.cljs$core$IFn$_invoke$arity$1 = (function (source_map){
return cljs.source_map.decode_reverse.call(null,goog.object.get(source_map,"mappings"),source_map);
});

cljs.source_map.decode_reverse.cljs$core$IFn$_invoke$arity$2 = (function (mappings,source_map){
var sources = goog.object.get(source_map,"sources");
var relseg_init = new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),(0),(0),(0),(0)], null);
var lines = cljs.core.seq.call(null,clojure.string.split.call(null,mappings,/;/));
var gline = (0);
var lines__$1 = lines;
var relseg = relseg_init;
var result = cljs.core.sorted_map_by.call(null,cljs.source_map.source_compare.call(null,sources));
while(true){
if(lines__$1){
var line = cljs.core.first.call(null,lines__$1);
var vec__31207 = ((clojure.string.blank_QMARK_.call(null,line))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [result,relseg], null):(function (){var segs = cljs.core.seq.call(null,clojure.string.split.call(null,line,/,/));
var segs__$1 = segs;
var relseg__$1 = relseg;
var result__$1 = result;
while(true){
if(segs__$1){
var seg = cljs.core.first.call(null,segs__$1);
var nrelseg = cljs.source_map.seg_combine.call(null,cljs.source_map.base64_vlq.decode.call(null,seg),relseg__$1);
var G__31211 = cljs.core.next.call(null,segs__$1);
var G__31212 = nrelseg;
var G__31213 = cljs.source_map.update_reverse_result.call(null,result__$1,cljs.source_map.seg__GT_map.call(null,nrelseg,source_map),gline);
segs__$1 = G__31211;
relseg__$1 = G__31212;
result__$1 = G__31213;
continue;
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [result__$1,relseg__$1], null);
}
break;
}
})());
var result__$1 = cljs.core.nth.call(null,vec__31207,(0),null);
var relseg__$1 = cljs.core.nth.call(null,vec__31207,(1),null);
var G__31214 = (gline + (1));
var G__31215 = cljs.core.next.call(null,lines__$1);
var G__31216 = cljs.core.assoc.call(null,relseg__$1,(0),(0));
var G__31217 = result__$1;
gline = G__31214;
lines__$1 = G__31215;
relseg = G__31216;
result = G__31217;
continue;
} else {
return result;
}
break;
}
});

cljs.source_map.decode_reverse.cljs$lang$maxFixedArity = 2;

/**
 * Helper for decode. Take a source map and update it based on a
 *   segment map.
 */
cljs.source_map.update_result = (function cljs$source_map$update_result(result,segmap,gline){
var map__31219 = segmap;
var map__31219__$1 = ((((!((map__31219 == null)))?((((map__31219.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__31219.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__31219):map__31219);
var gcol = cljs.core.get.call(null,map__31219__$1,new cljs.core.Keyword(null,"gcol","gcol",309250807));
var source = cljs.core.get.call(null,map__31219__$1,new cljs.core.Keyword(null,"source","source",-433931539));
var line = cljs.core.get.call(null,map__31219__$1,new cljs.core.Keyword(null,"line","line",212345235));
var col = cljs.core.get.call(null,map__31219__$1,new cljs.core.Keyword(null,"col","col",-1959363084));
var name = cljs.core.get.call(null,map__31219__$1,new cljs.core.Keyword(null,"name","name",1843675177));
var d = new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"line","line",212345235),line,new cljs.core.Keyword(null,"col","col",-1959363084),col,new cljs.core.Keyword(null,"source","source",-433931539),source], null);
var d__$1 = (cljs.core.truth_(name)?cljs.core.assoc.call(null,d,new cljs.core.Keyword(null,"name","name",1843675177),name):d);
return cljs.core.update_in.call(null,result,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline], null),cljs.core.fnil.call(null,((function (map__31219,map__31219__$1,gcol,source,line,col,name,d,d__$1){
return (function (m){
return cljs.core.update_in.call(null,m,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol], null),cljs.core.fnil.call(null,((function (map__31219,map__31219__$1,gcol,source,line,col,name,d,d__$1){
return (function (p1__31218_SHARP_){
return cljs.core.conj.call(null,p1__31218_SHARP_,d__$1);
});})(map__31219,map__31219__$1,gcol,source,line,col,name,d,d__$1))
,cljs.core.PersistentVector.EMPTY));
});})(map__31219,map__31219__$1,gcol,source,line,col,name,d,d__$1))
,cljs.core.sorted_map.call(null)));
});
/**
 * Convert a v3 source map JSON object into a source map mapping
 *   generated JavaScript source locations to the original
 *   ClojureScript.
 */
cljs.source_map.decode = (function cljs$source_map$decode(var_args){
var G__31222 = arguments.length;
switch (G__31222) {
case 1:
return cljs.source_map.decode.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.source_map.decode.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.source_map.decode.cljs$core$IFn$_invoke$arity$1 = (function (source_map){
return cljs.source_map.decode.call(null,goog.object.get(source_map,"mappings"),source_map);
});

cljs.source_map.decode.cljs$core$IFn$_invoke$arity$2 = (function (mappings,source_map){
var sources = goog.object.get(source_map,"sources");
var relseg_init = new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),(0),(0),(0),(0)], null);
var lines = cljs.core.seq.call(null,clojure.string.split.call(null,mappings,/;/));
var gline = (0);
var lines__$1 = lines;
var relseg = relseg_init;
var result = cljs.core.PersistentArrayMap.EMPTY;
while(true){
if(lines__$1){
var line = cljs.core.first.call(null,lines__$1);
var vec__31223 = ((clojure.string.blank_QMARK_.call(null,line))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [result,relseg], null):(function (){var segs = cljs.core.seq.call(null,clojure.string.split.call(null,line,/,/));
var segs__$1 = segs;
var relseg__$1 = relseg;
var result__$1 = result;
while(true){
if(segs__$1){
var seg = cljs.core.first.call(null,segs__$1);
var nrelseg = cljs.source_map.seg_combine.call(null,cljs.source_map.base64_vlq.decode.call(null,seg),relseg__$1);
var G__31227 = cljs.core.next.call(null,segs__$1);
var G__31228 = nrelseg;
var G__31229 = cljs.source_map.update_result.call(null,result__$1,cljs.source_map.seg__GT_map.call(null,nrelseg,source_map),gline);
segs__$1 = G__31227;
relseg__$1 = G__31228;
result__$1 = G__31229;
continue;
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [result__$1,relseg__$1], null);
}
break;
}
})());
var result__$1 = cljs.core.nth.call(null,vec__31223,(0),null);
var relseg__$1 = cljs.core.nth.call(null,vec__31223,(1),null);
var G__31230 = (gline + (1));
var G__31231 = cljs.core.next.call(null,lines__$1);
var G__31232 = cljs.core.assoc.call(null,relseg__$1,(0),(0));
var G__31233 = result__$1;
gline = G__31230;
lines__$1 = G__31231;
relseg = G__31232;
result = G__31233;
continue;
} else {
return result;
}
break;
}
});

cljs.source_map.decode.cljs$lang$maxFixedArity = 2;

/**
 * Take a nested sorted map encoding line and column information
 * for a file and return a vector of vectors of encoded segments.
 * Each vector represents a line, and the internal vectors are segments
 * representing the contents of the line.
 */
cljs.source_map.lines__GT_segs = (function cljs$source_map$lines__GT_segs(lines){
var relseg = cljs.core.atom.call(null,new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),(0),(0),(0),(0)], null));
return cljs.core.reduce.call(null,((function (relseg){
return (function (segs,cols){
cljs.core.swap_BANG_.call(null,relseg,((function (relseg){
return (function (p__31234){
var vec__31235 = p__31234;
var _ = cljs.core.nth.call(null,vec__31235,(0),null);
var source = cljs.core.nth.call(null,vec__31235,(1),null);
var line = cljs.core.nth.call(null,vec__31235,(2),null);
var col = cljs.core.nth.call(null,vec__31235,(3),null);
var name = cljs.core.nth.call(null,vec__31235,(4),null);
return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),source,line,col,name], null);
});})(relseg))
);

return cljs.core.conj.call(null,segs,cljs.core.reduce.call(null,((function (relseg){
return (function (cols__$1,p__31238){
var vec__31239 = p__31238;
var gcol = cljs.core.nth.call(null,vec__31239,(0),null);
var sidx = cljs.core.nth.call(null,vec__31239,(1),null);
var line = cljs.core.nth.call(null,vec__31239,(2),null);
var col = cljs.core.nth.call(null,vec__31239,(3),null);
var name = cljs.core.nth.call(null,vec__31239,(4),null);
var seg = vec__31239;
var offset = cljs.core.map.call(null,cljs.core._,seg,cljs.core.deref.call(null,relseg));
cljs.core.swap_BANG_.call(null,relseg,((function (offset,vec__31239,gcol,sidx,line,col,name,seg,relseg){
return (function (p__31242){
var vec__31243 = p__31242;
var _ = cljs.core.nth.call(null,vec__31243,(0),null);
var ___$1 = cljs.core.nth.call(null,vec__31243,(1),null);
var ___$2 = cljs.core.nth.call(null,vec__31243,(2),null);
var ___$3 = cljs.core.nth.call(null,vec__31243,(3),null);
var lname = cljs.core.nth.call(null,vec__31243,(4),null);
return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol,sidx,line,col,(function (){var or__8186__auto__ = name;
if(cljs.core.truth_(or__8186__auto__)){
return or__8186__auto__;
} else {
return lname;
}
})()], null);
});})(offset,vec__31239,gcol,sidx,line,col,name,seg,relseg))
);

return cljs.core.conj.call(null,cols__$1,cljs.source_map.base64_vlq.encode.call(null,offset));
});})(relseg))
,cljs.core.PersistentVector.EMPTY,cols));
});})(relseg))
,cljs.core.PersistentVector.EMPTY,lines);
});
/**
 * Take an internal source map representation represented as nested
 * sorted maps of file, line, column and return a source map v3 JSON
 * string.
 */
cljs.source_map.encode = (function cljs$source_map$encode(m,opts){
var lines = cljs.core.atom.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.PersistentVector.EMPTY], null));
var names__GT_idx = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var name_idx = cljs.core.atom.call(null,(0));
var preamble_lines = cljs.core.take.call(null,(function (){var or__8186__auto__ = new cljs.core.Keyword(null,"preamble-line-count","preamble-line-count",-659949744).cljs$core$IFn$_invoke$arity$1(opts);
if(cljs.core.truth_(or__8186__auto__)){
return or__8186__auto__;
} else {
return (0);
}
})(),cljs.core.repeat.call(null,cljs.core.PersistentVector.EMPTY));
var info__GT_segv = ((function (lines,names__GT_idx,name_idx,preamble_lines){
return (function (info,source_idx,line,col){
var segv = new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"gcol","gcol",309250807).cljs$core$IFn$_invoke$arity$1(info),source_idx,line,col], null);
var temp__4655__auto__ = new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(info);
if(cljs.core.truth_(temp__4655__auto__)){
var name = temp__4655__auto__;
var idx = (function (){var temp__4655__auto____$1 = cljs.core.get.call(null,cljs.core.deref.call(null,names__GT_idx),name);
if(cljs.core.truth_(temp__4655__auto____$1)){
var idx = temp__4655__auto____$1;
return idx;
} else {
var cidx = cljs.core.deref.call(null,name_idx);
cljs.core.swap_BANG_.call(null,names__GT_idx,cljs.core.assoc,name,cidx);

cljs.core.swap_BANG_.call(null,name_idx,cljs.core.inc);

return cidx;
}
})();
return cljs.core.conj.call(null,segv,idx);
} else {
return segv;
}
});})(lines,names__GT_idx,name_idx,preamble_lines))
;
var encode_cols = ((function (lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv){
return (function (infos,source_idx,line,col){
var seq__31249 = cljs.core.seq.call(null,infos);
var chunk__31250 = null;
var count__31251 = (0);
var i__31252 = (0);
while(true){
if((i__31252 < count__31251)){
var info = cljs.core._nth.call(null,chunk__31250,i__31252);
var segv_31331 = info__GT_segv.call(null,info,source_idx,line,col);
var gline_31332 = new cljs.core.Keyword(null,"gline","gline",-1086242431).cljs$core$IFn$_invoke$arity$1(info);
var lc_31333 = cljs.core.count.call(null,cljs.core.deref.call(null,lines));
if((gline_31332 > (lc_31333 - (1)))){
cljs.core.swap_BANG_.call(null,lines,((function (seq__31249,chunk__31250,count__31251,i__31252,segv_31331,gline_31332,lc_31333,info,lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv){
return (function (lines__$1){
return cljs.core.conj.call(null,cljs.core.into.call(null,lines__$1,cljs.core.repeat.call(null,((gline_31332 - (lc_31333 - (1))) - (1)),cljs.core.PersistentVector.EMPTY)),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [segv_31331], null));
});})(seq__31249,chunk__31250,count__31251,i__31252,segv_31331,gline_31332,lc_31333,info,lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv))
);
} else {
cljs.core.swap_BANG_.call(null,lines,((function (seq__31249,chunk__31250,count__31251,i__31252,segv_31331,gline_31332,lc_31333,info,lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv){
return (function (lines__$1){
return cljs.core.update_in.call(null,lines__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_31332], null),cljs.core.conj,segv_31331);
});})(seq__31249,chunk__31250,count__31251,i__31252,segv_31331,gline_31332,lc_31333,info,lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv))
);
}

var G__31334 = seq__31249;
var G__31335 = chunk__31250;
var G__31336 = count__31251;
var G__31337 = (i__31252 + (1));
seq__31249 = G__31334;
chunk__31250 = G__31335;
count__31251 = G__31336;
i__31252 = G__31337;
continue;
} else {
var temp__4657__auto__ = cljs.core.seq.call(null,seq__31249);
if(temp__4657__auto__){
var seq__31249__$1 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__31249__$1)){
var c__9025__auto__ = cljs.core.chunk_first.call(null,seq__31249__$1);
var G__31338 = cljs.core.chunk_rest.call(null,seq__31249__$1);
var G__31339 = c__9025__auto__;
var G__31340 = cljs.core.count.call(null,c__9025__auto__);
var G__31341 = (0);
seq__31249 = G__31338;
chunk__31250 = G__31339;
count__31251 = G__31340;
i__31252 = G__31341;
continue;
} else {
var info = cljs.core.first.call(null,seq__31249__$1);
var segv_31342 = info__GT_segv.call(null,info,source_idx,line,col);
var gline_31343 = new cljs.core.Keyword(null,"gline","gline",-1086242431).cljs$core$IFn$_invoke$arity$1(info);
var lc_31344 = cljs.core.count.call(null,cljs.core.deref.call(null,lines));
if((gline_31343 > (lc_31344 - (1)))){
cljs.core.swap_BANG_.call(null,lines,((function (seq__31249,chunk__31250,count__31251,i__31252,segv_31342,gline_31343,lc_31344,info,seq__31249__$1,temp__4657__auto__,lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv){
return (function (lines__$1){
return cljs.core.conj.call(null,cljs.core.into.call(null,lines__$1,cljs.core.repeat.call(null,((gline_31343 - (lc_31344 - (1))) - (1)),cljs.core.PersistentVector.EMPTY)),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [segv_31342], null));
});})(seq__31249,chunk__31250,count__31251,i__31252,segv_31342,gline_31343,lc_31344,info,seq__31249__$1,temp__4657__auto__,lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv))
);
} else {
cljs.core.swap_BANG_.call(null,lines,((function (seq__31249,chunk__31250,count__31251,i__31252,segv_31342,gline_31343,lc_31344,info,seq__31249__$1,temp__4657__auto__,lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv){
return (function (lines__$1){
return cljs.core.update_in.call(null,lines__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_31343], null),cljs.core.conj,segv_31342);
});})(seq__31249,chunk__31250,count__31251,i__31252,segv_31342,gline_31343,lc_31344,info,seq__31249__$1,temp__4657__auto__,lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv))
);
}

var G__31345 = cljs.core.next.call(null,seq__31249__$1);
var G__31346 = null;
var G__31347 = (0);
var G__31348 = (0);
seq__31249 = G__31345;
chunk__31250 = G__31346;
count__31251 = G__31347;
i__31252 = G__31348;
continue;
}
} else {
return null;
}
}
break;
}
});})(lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv))
;
var seq__31253_31349 = cljs.core.seq.call(null,cljs.core.map_indexed.call(null,((function (lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv,encode_cols){
return (function (i,v){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [i,v], null);
});})(lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv,encode_cols))
,m));
var chunk__31254_31350 = null;
var count__31255_31351 = (0);
var i__31256_31352 = (0);
while(true){
if((i__31256_31352 < count__31255_31351)){
var vec__31257_31353 = cljs.core._nth.call(null,chunk__31254_31350,i__31256_31352);
var source_idx_31354 = cljs.core.nth.call(null,vec__31257_31353,(0),null);
var vec__31260_31355 = cljs.core.nth.call(null,vec__31257_31353,(1),null);
var __31356 = cljs.core.nth.call(null,vec__31260_31355,(0),null);
var lines_31357__$1 = cljs.core.nth.call(null,vec__31260_31355,(1),null);
var seq__31263_31358 = cljs.core.seq.call(null,lines_31357__$1);
var chunk__31264_31359 = null;
var count__31265_31360 = (0);
var i__31266_31361 = (0);
while(true){
if((i__31266_31361 < count__31265_31360)){
var vec__31267_31362 = cljs.core._nth.call(null,chunk__31264_31359,i__31266_31361);
var line_31363 = cljs.core.nth.call(null,vec__31267_31362,(0),null);
var cols_31364 = cljs.core.nth.call(null,vec__31267_31362,(1),null);
var seq__31270_31365 = cljs.core.seq.call(null,cols_31364);
var chunk__31271_31366 = null;
var count__31272_31367 = (0);
var i__31273_31368 = (0);
while(true){
if((i__31273_31368 < count__31272_31367)){
var vec__31274_31369 = cljs.core._nth.call(null,chunk__31271_31366,i__31273_31368);
var col_31370 = cljs.core.nth.call(null,vec__31274_31369,(0),null);
var infos_31371 = cljs.core.nth.call(null,vec__31274_31369,(1),null);
encode_cols.call(null,infos_31371,source_idx_31354,line_31363,col_31370);

var G__31372 = seq__31270_31365;
var G__31373 = chunk__31271_31366;
var G__31374 = count__31272_31367;
var G__31375 = (i__31273_31368 + (1));
seq__31270_31365 = G__31372;
chunk__31271_31366 = G__31373;
count__31272_31367 = G__31374;
i__31273_31368 = G__31375;
continue;
} else {
var temp__4657__auto___31376 = cljs.core.seq.call(null,seq__31270_31365);
if(temp__4657__auto___31376){
var seq__31270_31377__$1 = temp__4657__auto___31376;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__31270_31377__$1)){
var c__9025__auto___31378 = cljs.core.chunk_first.call(null,seq__31270_31377__$1);
var G__31379 = cljs.core.chunk_rest.call(null,seq__31270_31377__$1);
var G__31380 = c__9025__auto___31378;
var G__31381 = cljs.core.count.call(null,c__9025__auto___31378);
var G__31382 = (0);
seq__31270_31365 = G__31379;
chunk__31271_31366 = G__31380;
count__31272_31367 = G__31381;
i__31273_31368 = G__31382;
continue;
} else {
var vec__31277_31383 = cljs.core.first.call(null,seq__31270_31377__$1);
var col_31384 = cljs.core.nth.call(null,vec__31277_31383,(0),null);
var infos_31385 = cljs.core.nth.call(null,vec__31277_31383,(1),null);
encode_cols.call(null,infos_31385,source_idx_31354,line_31363,col_31384);

var G__31386 = cljs.core.next.call(null,seq__31270_31377__$1);
var G__31387 = null;
var G__31388 = (0);
var G__31389 = (0);
seq__31270_31365 = G__31386;
chunk__31271_31366 = G__31387;
count__31272_31367 = G__31388;
i__31273_31368 = G__31389;
continue;
}
} else {
}
}
break;
}

var G__31390 = seq__31263_31358;
var G__31391 = chunk__31264_31359;
var G__31392 = count__31265_31360;
var G__31393 = (i__31266_31361 + (1));
seq__31263_31358 = G__31390;
chunk__31264_31359 = G__31391;
count__31265_31360 = G__31392;
i__31266_31361 = G__31393;
continue;
} else {
var temp__4657__auto___31394 = cljs.core.seq.call(null,seq__31263_31358);
if(temp__4657__auto___31394){
var seq__31263_31395__$1 = temp__4657__auto___31394;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__31263_31395__$1)){
var c__9025__auto___31396 = cljs.core.chunk_first.call(null,seq__31263_31395__$1);
var G__31397 = cljs.core.chunk_rest.call(null,seq__31263_31395__$1);
var G__31398 = c__9025__auto___31396;
var G__31399 = cljs.core.count.call(null,c__9025__auto___31396);
var G__31400 = (0);
seq__31263_31358 = G__31397;
chunk__31264_31359 = G__31398;
count__31265_31360 = G__31399;
i__31266_31361 = G__31400;
continue;
} else {
var vec__31280_31401 = cljs.core.first.call(null,seq__31263_31395__$1);
var line_31402 = cljs.core.nth.call(null,vec__31280_31401,(0),null);
var cols_31403 = cljs.core.nth.call(null,vec__31280_31401,(1),null);
var seq__31283_31404 = cljs.core.seq.call(null,cols_31403);
var chunk__31284_31405 = null;
var count__31285_31406 = (0);
var i__31286_31407 = (0);
while(true){
if((i__31286_31407 < count__31285_31406)){
var vec__31287_31408 = cljs.core._nth.call(null,chunk__31284_31405,i__31286_31407);
var col_31409 = cljs.core.nth.call(null,vec__31287_31408,(0),null);
var infos_31410 = cljs.core.nth.call(null,vec__31287_31408,(1),null);
encode_cols.call(null,infos_31410,source_idx_31354,line_31402,col_31409);

var G__31411 = seq__31283_31404;
var G__31412 = chunk__31284_31405;
var G__31413 = count__31285_31406;
var G__31414 = (i__31286_31407 + (1));
seq__31283_31404 = G__31411;
chunk__31284_31405 = G__31412;
count__31285_31406 = G__31413;
i__31286_31407 = G__31414;
continue;
} else {
var temp__4657__auto___31415__$1 = cljs.core.seq.call(null,seq__31283_31404);
if(temp__4657__auto___31415__$1){
var seq__31283_31416__$1 = temp__4657__auto___31415__$1;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__31283_31416__$1)){
var c__9025__auto___31417 = cljs.core.chunk_first.call(null,seq__31283_31416__$1);
var G__31418 = cljs.core.chunk_rest.call(null,seq__31283_31416__$1);
var G__31419 = c__9025__auto___31417;
var G__31420 = cljs.core.count.call(null,c__9025__auto___31417);
var G__31421 = (0);
seq__31283_31404 = G__31418;
chunk__31284_31405 = G__31419;
count__31285_31406 = G__31420;
i__31286_31407 = G__31421;
continue;
} else {
var vec__31290_31422 = cljs.core.first.call(null,seq__31283_31416__$1);
var col_31423 = cljs.core.nth.call(null,vec__31290_31422,(0),null);
var infos_31424 = cljs.core.nth.call(null,vec__31290_31422,(1),null);
encode_cols.call(null,infos_31424,source_idx_31354,line_31402,col_31423);

var G__31425 = cljs.core.next.call(null,seq__31283_31416__$1);
var G__31426 = null;
var G__31427 = (0);
var G__31428 = (0);
seq__31283_31404 = G__31425;
chunk__31284_31405 = G__31426;
count__31285_31406 = G__31427;
i__31286_31407 = G__31428;
continue;
}
} else {
}
}
break;
}

var G__31429 = cljs.core.next.call(null,seq__31263_31395__$1);
var G__31430 = null;
var G__31431 = (0);
var G__31432 = (0);
seq__31263_31358 = G__31429;
chunk__31264_31359 = G__31430;
count__31265_31360 = G__31431;
i__31266_31361 = G__31432;
continue;
}
} else {
}
}
break;
}

var G__31433 = seq__31253_31349;
var G__31434 = chunk__31254_31350;
var G__31435 = count__31255_31351;
var G__31436 = (i__31256_31352 + (1));
seq__31253_31349 = G__31433;
chunk__31254_31350 = G__31434;
count__31255_31351 = G__31435;
i__31256_31352 = G__31436;
continue;
} else {
var temp__4657__auto___31437 = cljs.core.seq.call(null,seq__31253_31349);
if(temp__4657__auto___31437){
var seq__31253_31438__$1 = temp__4657__auto___31437;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__31253_31438__$1)){
var c__9025__auto___31439 = cljs.core.chunk_first.call(null,seq__31253_31438__$1);
var G__31440 = cljs.core.chunk_rest.call(null,seq__31253_31438__$1);
var G__31441 = c__9025__auto___31439;
var G__31442 = cljs.core.count.call(null,c__9025__auto___31439);
var G__31443 = (0);
seq__31253_31349 = G__31440;
chunk__31254_31350 = G__31441;
count__31255_31351 = G__31442;
i__31256_31352 = G__31443;
continue;
} else {
var vec__31293_31444 = cljs.core.first.call(null,seq__31253_31438__$1);
var source_idx_31445 = cljs.core.nth.call(null,vec__31293_31444,(0),null);
var vec__31296_31446 = cljs.core.nth.call(null,vec__31293_31444,(1),null);
var __31447 = cljs.core.nth.call(null,vec__31296_31446,(0),null);
var lines_31448__$1 = cljs.core.nth.call(null,vec__31296_31446,(1),null);
var seq__31299_31449 = cljs.core.seq.call(null,lines_31448__$1);
var chunk__31300_31450 = null;
var count__31301_31451 = (0);
var i__31302_31452 = (0);
while(true){
if((i__31302_31452 < count__31301_31451)){
var vec__31303_31453 = cljs.core._nth.call(null,chunk__31300_31450,i__31302_31452);
var line_31454 = cljs.core.nth.call(null,vec__31303_31453,(0),null);
var cols_31455 = cljs.core.nth.call(null,vec__31303_31453,(1),null);
var seq__31306_31456 = cljs.core.seq.call(null,cols_31455);
var chunk__31307_31457 = null;
var count__31308_31458 = (0);
var i__31309_31459 = (0);
while(true){
if((i__31309_31459 < count__31308_31458)){
var vec__31310_31460 = cljs.core._nth.call(null,chunk__31307_31457,i__31309_31459);
var col_31461 = cljs.core.nth.call(null,vec__31310_31460,(0),null);
var infos_31462 = cljs.core.nth.call(null,vec__31310_31460,(1),null);
encode_cols.call(null,infos_31462,source_idx_31445,line_31454,col_31461);

var G__31463 = seq__31306_31456;
var G__31464 = chunk__31307_31457;
var G__31465 = count__31308_31458;
var G__31466 = (i__31309_31459 + (1));
seq__31306_31456 = G__31463;
chunk__31307_31457 = G__31464;
count__31308_31458 = G__31465;
i__31309_31459 = G__31466;
continue;
} else {
var temp__4657__auto___31467__$1 = cljs.core.seq.call(null,seq__31306_31456);
if(temp__4657__auto___31467__$1){
var seq__31306_31468__$1 = temp__4657__auto___31467__$1;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__31306_31468__$1)){
var c__9025__auto___31469 = cljs.core.chunk_first.call(null,seq__31306_31468__$1);
var G__31470 = cljs.core.chunk_rest.call(null,seq__31306_31468__$1);
var G__31471 = c__9025__auto___31469;
var G__31472 = cljs.core.count.call(null,c__9025__auto___31469);
var G__31473 = (0);
seq__31306_31456 = G__31470;
chunk__31307_31457 = G__31471;
count__31308_31458 = G__31472;
i__31309_31459 = G__31473;
continue;
} else {
var vec__31313_31474 = cljs.core.first.call(null,seq__31306_31468__$1);
var col_31475 = cljs.core.nth.call(null,vec__31313_31474,(0),null);
var infos_31476 = cljs.core.nth.call(null,vec__31313_31474,(1),null);
encode_cols.call(null,infos_31476,source_idx_31445,line_31454,col_31475);

var G__31477 = cljs.core.next.call(null,seq__31306_31468__$1);
var G__31478 = null;
var G__31479 = (0);
var G__31480 = (0);
seq__31306_31456 = G__31477;
chunk__31307_31457 = G__31478;
count__31308_31458 = G__31479;
i__31309_31459 = G__31480;
continue;
}
} else {
}
}
break;
}

var G__31481 = seq__31299_31449;
var G__31482 = chunk__31300_31450;
var G__31483 = count__31301_31451;
var G__31484 = (i__31302_31452 + (1));
seq__31299_31449 = G__31481;
chunk__31300_31450 = G__31482;
count__31301_31451 = G__31483;
i__31302_31452 = G__31484;
continue;
} else {
var temp__4657__auto___31485__$1 = cljs.core.seq.call(null,seq__31299_31449);
if(temp__4657__auto___31485__$1){
var seq__31299_31486__$1 = temp__4657__auto___31485__$1;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__31299_31486__$1)){
var c__9025__auto___31487 = cljs.core.chunk_first.call(null,seq__31299_31486__$1);
var G__31488 = cljs.core.chunk_rest.call(null,seq__31299_31486__$1);
var G__31489 = c__9025__auto___31487;
var G__31490 = cljs.core.count.call(null,c__9025__auto___31487);
var G__31491 = (0);
seq__31299_31449 = G__31488;
chunk__31300_31450 = G__31489;
count__31301_31451 = G__31490;
i__31302_31452 = G__31491;
continue;
} else {
var vec__31316_31492 = cljs.core.first.call(null,seq__31299_31486__$1);
var line_31493 = cljs.core.nth.call(null,vec__31316_31492,(0),null);
var cols_31494 = cljs.core.nth.call(null,vec__31316_31492,(1),null);
var seq__31319_31495 = cljs.core.seq.call(null,cols_31494);
var chunk__31320_31496 = null;
var count__31321_31497 = (0);
var i__31322_31498 = (0);
while(true){
if((i__31322_31498 < count__31321_31497)){
var vec__31323_31499 = cljs.core._nth.call(null,chunk__31320_31496,i__31322_31498);
var col_31500 = cljs.core.nth.call(null,vec__31323_31499,(0),null);
var infos_31501 = cljs.core.nth.call(null,vec__31323_31499,(1),null);
encode_cols.call(null,infos_31501,source_idx_31445,line_31493,col_31500);

var G__31502 = seq__31319_31495;
var G__31503 = chunk__31320_31496;
var G__31504 = count__31321_31497;
var G__31505 = (i__31322_31498 + (1));
seq__31319_31495 = G__31502;
chunk__31320_31496 = G__31503;
count__31321_31497 = G__31504;
i__31322_31498 = G__31505;
continue;
} else {
var temp__4657__auto___31506__$2 = cljs.core.seq.call(null,seq__31319_31495);
if(temp__4657__auto___31506__$2){
var seq__31319_31507__$1 = temp__4657__auto___31506__$2;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__31319_31507__$1)){
var c__9025__auto___31508 = cljs.core.chunk_first.call(null,seq__31319_31507__$1);
var G__31509 = cljs.core.chunk_rest.call(null,seq__31319_31507__$1);
var G__31510 = c__9025__auto___31508;
var G__31511 = cljs.core.count.call(null,c__9025__auto___31508);
var G__31512 = (0);
seq__31319_31495 = G__31509;
chunk__31320_31496 = G__31510;
count__31321_31497 = G__31511;
i__31322_31498 = G__31512;
continue;
} else {
var vec__31326_31513 = cljs.core.first.call(null,seq__31319_31507__$1);
var col_31514 = cljs.core.nth.call(null,vec__31326_31513,(0),null);
var infos_31515 = cljs.core.nth.call(null,vec__31326_31513,(1),null);
encode_cols.call(null,infos_31515,source_idx_31445,line_31493,col_31514);

var G__31516 = cljs.core.next.call(null,seq__31319_31507__$1);
var G__31517 = null;
var G__31518 = (0);
var G__31519 = (0);
seq__31319_31495 = G__31516;
chunk__31320_31496 = G__31517;
count__31321_31497 = G__31518;
i__31322_31498 = G__31519;
continue;
}
} else {
}
}
break;
}

var G__31520 = cljs.core.next.call(null,seq__31299_31486__$1);
var G__31521 = null;
var G__31522 = (0);
var G__31523 = (0);
seq__31299_31449 = G__31520;
chunk__31300_31450 = G__31521;
count__31301_31451 = G__31522;
i__31302_31452 = G__31523;
continue;
}
} else {
}
}
break;
}

var G__31524 = cljs.core.next.call(null,seq__31253_31438__$1);
var G__31525 = null;
var G__31526 = (0);
var G__31527 = (0);
seq__31253_31349 = G__31524;
chunk__31254_31350 = G__31525;
count__31255_31351 = G__31526;
i__31256_31352 = G__31527;
continue;
}
} else {
}
}
break;
}

var source_map_file_contents = (function (){var G__31329 = ({"version": (3), "file": new cljs.core.Keyword(null,"file","file",-1269645878).cljs$core$IFn$_invoke$arity$1(opts), "sources": (function (){var paths = cljs.core.keys.call(null,m);
var f = cljs.core.comp.call(null,((new cljs.core.Keyword(null,"source-map-timestamp","source-map-timestamp",1973015633).cljs$core$IFn$_invoke$arity$1(opts) === true)?((function (paths,lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv,encode_cols){
return (function (p1__31246_SHARP_){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(p1__31246_SHARP_),"?rel=",cljs.core.str.cljs$core$IFn$_invoke$arity$1((new Date()).valueOf())].join('');
});})(paths,lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv,encode_cols))
:cljs.core.identity),((function (paths,lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv,encode_cols){
return (function (p1__31247_SHARP_){
return cljs.core.last.call(null,clojure.string.split.call(null,p1__31247_SHARP_,/\//));
});})(paths,lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv,encode_cols))
);
return cljs.core.into_array.call(null,cljs.core.map.call(null,f,paths));
})(), "lineCount": new cljs.core.Keyword(null,"lines","lines",-700165781).cljs$core$IFn$_invoke$arity$1(opts), "mappings": clojure.string.join.call(null,";",cljs.core.map.call(null,((function (lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv,encode_cols){
return (function (p1__31248_SHARP_){
return clojure.string.join.call(null,",",p1__31248_SHARP_);
});})(lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv,encode_cols))
,cljs.source_map.lines__GT_segs.call(null,cljs.core.concat.call(null,preamble_lines,cljs.core.deref.call(null,lines))))), "names": cljs.core.into_array.call(null,cljs.core.map.call(null,clojure.set.map_invert.call(null,cljs.core.deref.call(null,names__GT_idx)),cljs.core.range.call(null,cljs.core.count.call(null,cljs.core.deref.call(null,names__GT_idx)))))});
if(cljs.core.truth_(new cljs.core.Keyword(null,"sources-content","sources-content",1729970239).cljs$core$IFn$_invoke$arity$1(opts))){
var G__31330 = G__31329;
goog.object.set(G__31330,"sourcesContent",cljs.core.into_array.call(null,new cljs.core.Keyword(null,"sources-content","sources-content",1729970239).cljs$core$IFn$_invoke$arity$1(opts)));

return G__31330;
} else {
return G__31329;
}
})();
return JSON.stringify(source_map_file_contents);
});
/**
 * Merge an internal source map representation of a single
 * ClojureScript file mapping original to generated with a
 * second source map mapping original JS to generated JS.
 * The is to support source maps that work through multiple
 * compilation steps like Google Closure optimization passes.
 */
cljs.source_map.merge_source_maps = (function cljs$source_map$merge_source_maps(cljs_map,js_map){
var line_map_seq = cljs.core.seq.call(null,cljs_map);
var new_lines = cljs.core.sorted_map.call(null);
while(true){
if(line_map_seq){
var vec__31528 = cljs.core.first.call(null,line_map_seq);
var line = cljs.core.nth.call(null,vec__31528,(0),null);
var col_map = cljs.core.nth.call(null,vec__31528,(1),null);
var new_cols = (function (){var col_map_seq = cljs.core.seq.call(null,col_map);
var new_cols = cljs.core.sorted_map.call(null);
while(true){
if(col_map_seq){
var vec__31531 = cljs.core.first.call(null,col_map_seq);
var col = cljs.core.nth.call(null,vec__31531,(0),null);
var infos = cljs.core.nth.call(null,vec__31531,(1),null);
var G__31537 = cljs.core.next.call(null,col_map_seq);
var G__31538 = cljs.core.assoc.call(null,new_cols,col,cljs.core.reduce.call(null,((function (col_map_seq,new_cols,line_map_seq,new_lines,vec__31531,col,infos,vec__31528,line,col_map){
return (function (v,p__31534){
var map__31535 = p__31534;
var map__31535__$1 = ((((!((map__31535 == null)))?((((map__31535.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__31535.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__31535):map__31535);
var gline = cljs.core.get.call(null,map__31535__$1,new cljs.core.Keyword(null,"gline","gline",-1086242431));
var gcol = cljs.core.get.call(null,map__31535__$1,new cljs.core.Keyword(null,"gcol","gcol",309250807));
return cljs.core.into.call(null,v,cljs.core.get_in.call(null,js_map,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline,gcol], null)));
});})(col_map_seq,new_cols,line_map_seq,new_lines,vec__31531,col,infos,vec__31528,line,col_map))
,cljs.core.PersistentVector.EMPTY,infos));
col_map_seq = G__31537;
new_cols = G__31538;
continue;
} else {
return new_cols;
}
break;
}
})();
var G__31539 = cljs.core.next.call(null,line_map_seq);
var G__31540 = cljs.core.assoc.call(null,new_lines,line,new_cols);
line_map_seq = G__31539;
new_lines = G__31540;
continue;
} else {
return new_lines;
}
break;
}
});
/**
 * Given a ClojureScript to JavaScript source map, invert it. Useful when
 * mapping JavaScript stack traces when environment support is unavailable.
 */
cljs.source_map.invert_reverse_map = (function cljs$source_map$invert_reverse_map(reverse_map){
var inverted = cljs.core.atom.call(null,cljs.core.sorted_map.call(null));
var seq__31541_31603 = cljs.core.seq.call(null,reverse_map);
var chunk__31542_31604 = null;
var count__31543_31605 = (0);
var i__31544_31606 = (0);
while(true){
if((i__31544_31606 < count__31543_31605)){
var vec__31545_31607 = cljs.core._nth.call(null,chunk__31542_31604,i__31544_31606);
var line_31608 = cljs.core.nth.call(null,vec__31545_31607,(0),null);
var columns_31609 = cljs.core.nth.call(null,vec__31545_31607,(1),null);
var seq__31548_31610 = cljs.core.seq.call(null,columns_31609);
var chunk__31549_31611 = null;
var count__31550_31612 = (0);
var i__31551_31613 = (0);
while(true){
if((i__31551_31613 < count__31550_31612)){
var vec__31552_31614 = cljs.core._nth.call(null,chunk__31549_31611,i__31551_31613);
var column_31615 = cljs.core.nth.call(null,vec__31552_31614,(0),null);
var column_info_31616 = cljs.core.nth.call(null,vec__31552_31614,(1),null);
var seq__31555_31617 = cljs.core.seq.call(null,column_info_31616);
var chunk__31556_31618 = null;
var count__31557_31619 = (0);
var i__31558_31620 = (0);
while(true){
if((i__31558_31620 < count__31557_31619)){
var map__31559_31621 = cljs.core._nth.call(null,chunk__31556_31618,i__31558_31620);
var map__31559_31622__$1 = ((((!((map__31559_31621 == null)))?((((map__31559_31621.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__31559_31621.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__31559_31621):map__31559_31621);
var gline_31623 = cljs.core.get.call(null,map__31559_31622__$1,new cljs.core.Keyword(null,"gline","gline",-1086242431));
var gcol_31624 = cljs.core.get.call(null,map__31559_31622__$1,new cljs.core.Keyword(null,"gcol","gcol",309250807));
var name_31625 = cljs.core.get.call(null,map__31559_31622__$1,new cljs.core.Keyword(null,"name","name",1843675177));
cljs.core.swap_BANG_.call(null,inverted,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_31623], null),cljs.core.fnil.call(null,((function (seq__31555_31617,chunk__31556_31618,count__31557_31619,i__31558_31620,seq__31548_31610,chunk__31549_31611,count__31550_31612,i__31551_31613,seq__31541_31603,chunk__31542_31604,count__31543_31605,i__31544_31606,map__31559_31621,map__31559_31622__$1,gline_31623,gcol_31624,name_31625,vec__31552_31614,column_31615,column_info_31616,vec__31545_31607,line_31608,columns_31609,inverted){
return (function (columns__$1){
return cljs.core.update_in.call(null,columns__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol_31624], null),cljs.core.fnil.call(null,cljs.core.conj,cljs.core.PersistentVector.EMPTY),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"line","line",212345235),line_31608,new cljs.core.Keyword(null,"col","col",-1959363084),column_31615,new cljs.core.Keyword(null,"name","name",1843675177),name_31625], null));
});})(seq__31555_31617,chunk__31556_31618,count__31557_31619,i__31558_31620,seq__31548_31610,chunk__31549_31611,count__31550_31612,i__31551_31613,seq__31541_31603,chunk__31542_31604,count__31543_31605,i__31544_31606,map__31559_31621,map__31559_31622__$1,gline_31623,gcol_31624,name_31625,vec__31552_31614,column_31615,column_info_31616,vec__31545_31607,line_31608,columns_31609,inverted))
,cljs.core.sorted_map.call(null)));

var G__31626 = seq__31555_31617;
var G__31627 = chunk__31556_31618;
var G__31628 = count__31557_31619;
var G__31629 = (i__31558_31620 + (1));
seq__31555_31617 = G__31626;
chunk__31556_31618 = G__31627;
count__31557_31619 = G__31628;
i__31558_31620 = G__31629;
continue;
} else {
var temp__4657__auto___31630 = cljs.core.seq.call(null,seq__31555_31617);
if(temp__4657__auto___31630){
var seq__31555_31631__$1 = temp__4657__auto___31630;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__31555_31631__$1)){
var c__9025__auto___31632 = cljs.core.chunk_first.call(null,seq__31555_31631__$1);
var G__31633 = cljs.core.chunk_rest.call(null,seq__31555_31631__$1);
var G__31634 = c__9025__auto___31632;
var G__31635 = cljs.core.count.call(null,c__9025__auto___31632);
var G__31636 = (0);
seq__31555_31617 = G__31633;
chunk__31556_31618 = G__31634;
count__31557_31619 = G__31635;
i__31558_31620 = G__31636;
continue;
} else {
var map__31561_31637 = cljs.core.first.call(null,seq__31555_31631__$1);
var map__31561_31638__$1 = ((((!((map__31561_31637 == null)))?((((map__31561_31637.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__31561_31637.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__31561_31637):map__31561_31637);
var gline_31639 = cljs.core.get.call(null,map__31561_31638__$1,new cljs.core.Keyword(null,"gline","gline",-1086242431));
var gcol_31640 = cljs.core.get.call(null,map__31561_31638__$1,new cljs.core.Keyword(null,"gcol","gcol",309250807));
var name_31641 = cljs.core.get.call(null,map__31561_31638__$1,new cljs.core.Keyword(null,"name","name",1843675177));
cljs.core.swap_BANG_.call(null,inverted,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_31639], null),cljs.core.fnil.call(null,((function (seq__31555_31617,chunk__31556_31618,count__31557_31619,i__31558_31620,seq__31548_31610,chunk__31549_31611,count__31550_31612,i__31551_31613,seq__31541_31603,chunk__31542_31604,count__31543_31605,i__31544_31606,map__31561_31637,map__31561_31638__$1,gline_31639,gcol_31640,name_31641,seq__31555_31631__$1,temp__4657__auto___31630,vec__31552_31614,column_31615,column_info_31616,vec__31545_31607,line_31608,columns_31609,inverted){
return (function (columns__$1){
return cljs.core.update_in.call(null,columns__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol_31640], null),cljs.core.fnil.call(null,cljs.core.conj,cljs.core.PersistentVector.EMPTY),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"line","line",212345235),line_31608,new cljs.core.Keyword(null,"col","col",-1959363084),column_31615,new cljs.core.Keyword(null,"name","name",1843675177),name_31641], null));
});})(seq__31555_31617,chunk__31556_31618,count__31557_31619,i__31558_31620,seq__31548_31610,chunk__31549_31611,count__31550_31612,i__31551_31613,seq__31541_31603,chunk__31542_31604,count__31543_31605,i__31544_31606,map__31561_31637,map__31561_31638__$1,gline_31639,gcol_31640,name_31641,seq__31555_31631__$1,temp__4657__auto___31630,vec__31552_31614,column_31615,column_info_31616,vec__31545_31607,line_31608,columns_31609,inverted))
,cljs.core.sorted_map.call(null)));

var G__31642 = cljs.core.next.call(null,seq__31555_31631__$1);
var G__31643 = null;
var G__31644 = (0);
var G__31645 = (0);
seq__31555_31617 = G__31642;
chunk__31556_31618 = G__31643;
count__31557_31619 = G__31644;
i__31558_31620 = G__31645;
continue;
}
} else {
}
}
break;
}

var G__31646 = seq__31548_31610;
var G__31647 = chunk__31549_31611;
var G__31648 = count__31550_31612;
var G__31649 = (i__31551_31613 + (1));
seq__31548_31610 = G__31646;
chunk__31549_31611 = G__31647;
count__31550_31612 = G__31648;
i__31551_31613 = G__31649;
continue;
} else {
var temp__4657__auto___31650 = cljs.core.seq.call(null,seq__31548_31610);
if(temp__4657__auto___31650){
var seq__31548_31651__$1 = temp__4657__auto___31650;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__31548_31651__$1)){
var c__9025__auto___31652 = cljs.core.chunk_first.call(null,seq__31548_31651__$1);
var G__31653 = cljs.core.chunk_rest.call(null,seq__31548_31651__$1);
var G__31654 = c__9025__auto___31652;
var G__31655 = cljs.core.count.call(null,c__9025__auto___31652);
var G__31656 = (0);
seq__31548_31610 = G__31653;
chunk__31549_31611 = G__31654;
count__31550_31612 = G__31655;
i__31551_31613 = G__31656;
continue;
} else {
var vec__31563_31657 = cljs.core.first.call(null,seq__31548_31651__$1);
var column_31658 = cljs.core.nth.call(null,vec__31563_31657,(0),null);
var column_info_31659 = cljs.core.nth.call(null,vec__31563_31657,(1),null);
var seq__31566_31660 = cljs.core.seq.call(null,column_info_31659);
var chunk__31567_31661 = null;
var count__31568_31662 = (0);
var i__31569_31663 = (0);
while(true){
if((i__31569_31663 < count__31568_31662)){
var map__31570_31664 = cljs.core._nth.call(null,chunk__31567_31661,i__31569_31663);
var map__31570_31665__$1 = ((((!((map__31570_31664 == null)))?((((map__31570_31664.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__31570_31664.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__31570_31664):map__31570_31664);
var gline_31666 = cljs.core.get.call(null,map__31570_31665__$1,new cljs.core.Keyword(null,"gline","gline",-1086242431));
var gcol_31667 = cljs.core.get.call(null,map__31570_31665__$1,new cljs.core.Keyword(null,"gcol","gcol",309250807));
var name_31668 = cljs.core.get.call(null,map__31570_31665__$1,new cljs.core.Keyword(null,"name","name",1843675177));
cljs.core.swap_BANG_.call(null,inverted,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_31666], null),cljs.core.fnil.call(null,((function (seq__31566_31660,chunk__31567_31661,count__31568_31662,i__31569_31663,seq__31548_31610,chunk__31549_31611,count__31550_31612,i__31551_31613,seq__31541_31603,chunk__31542_31604,count__31543_31605,i__31544_31606,map__31570_31664,map__31570_31665__$1,gline_31666,gcol_31667,name_31668,vec__31563_31657,column_31658,column_info_31659,seq__31548_31651__$1,temp__4657__auto___31650,vec__31545_31607,line_31608,columns_31609,inverted){
return (function (columns__$1){
return cljs.core.update_in.call(null,columns__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol_31667], null),cljs.core.fnil.call(null,cljs.core.conj,cljs.core.PersistentVector.EMPTY),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"line","line",212345235),line_31608,new cljs.core.Keyword(null,"col","col",-1959363084),column_31658,new cljs.core.Keyword(null,"name","name",1843675177),name_31668], null));
});})(seq__31566_31660,chunk__31567_31661,count__31568_31662,i__31569_31663,seq__31548_31610,chunk__31549_31611,count__31550_31612,i__31551_31613,seq__31541_31603,chunk__31542_31604,count__31543_31605,i__31544_31606,map__31570_31664,map__31570_31665__$1,gline_31666,gcol_31667,name_31668,vec__31563_31657,column_31658,column_info_31659,seq__31548_31651__$1,temp__4657__auto___31650,vec__31545_31607,line_31608,columns_31609,inverted))
,cljs.core.sorted_map.call(null)));

var G__31669 = seq__31566_31660;
var G__31670 = chunk__31567_31661;
var G__31671 = count__31568_31662;
var G__31672 = (i__31569_31663 + (1));
seq__31566_31660 = G__31669;
chunk__31567_31661 = G__31670;
count__31568_31662 = G__31671;
i__31569_31663 = G__31672;
continue;
} else {
var temp__4657__auto___31673__$1 = cljs.core.seq.call(null,seq__31566_31660);
if(temp__4657__auto___31673__$1){
var seq__31566_31674__$1 = temp__4657__auto___31673__$1;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__31566_31674__$1)){
var c__9025__auto___31675 = cljs.core.chunk_first.call(null,seq__31566_31674__$1);
var G__31676 = cljs.core.chunk_rest.call(null,seq__31566_31674__$1);
var G__31677 = c__9025__auto___31675;
var G__31678 = cljs.core.count.call(null,c__9025__auto___31675);
var G__31679 = (0);
seq__31566_31660 = G__31676;
chunk__31567_31661 = G__31677;
count__31568_31662 = G__31678;
i__31569_31663 = G__31679;
continue;
} else {
var map__31572_31680 = cljs.core.first.call(null,seq__31566_31674__$1);
var map__31572_31681__$1 = ((((!((map__31572_31680 == null)))?((((map__31572_31680.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__31572_31680.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__31572_31680):map__31572_31680);
var gline_31682 = cljs.core.get.call(null,map__31572_31681__$1,new cljs.core.Keyword(null,"gline","gline",-1086242431));
var gcol_31683 = cljs.core.get.call(null,map__31572_31681__$1,new cljs.core.Keyword(null,"gcol","gcol",309250807));
var name_31684 = cljs.core.get.call(null,map__31572_31681__$1,new cljs.core.Keyword(null,"name","name",1843675177));
cljs.core.swap_BANG_.call(null,inverted,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_31682], null),cljs.core.fnil.call(null,((function (seq__31566_31660,chunk__31567_31661,count__31568_31662,i__31569_31663,seq__31548_31610,chunk__31549_31611,count__31550_31612,i__31551_31613,seq__31541_31603,chunk__31542_31604,count__31543_31605,i__31544_31606,map__31572_31680,map__31572_31681__$1,gline_31682,gcol_31683,name_31684,seq__31566_31674__$1,temp__4657__auto___31673__$1,vec__31563_31657,column_31658,column_info_31659,seq__31548_31651__$1,temp__4657__auto___31650,vec__31545_31607,line_31608,columns_31609,inverted){
return (function (columns__$1){
return cljs.core.update_in.call(null,columns__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol_31683], null),cljs.core.fnil.call(null,cljs.core.conj,cljs.core.PersistentVector.EMPTY),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"line","line",212345235),line_31608,new cljs.core.Keyword(null,"col","col",-1959363084),column_31658,new cljs.core.Keyword(null,"name","name",1843675177),name_31684], null));
});})(seq__31566_31660,chunk__31567_31661,count__31568_31662,i__31569_31663,seq__31548_31610,chunk__31549_31611,count__31550_31612,i__31551_31613,seq__31541_31603,chunk__31542_31604,count__31543_31605,i__31544_31606,map__31572_31680,map__31572_31681__$1,gline_31682,gcol_31683,name_31684,seq__31566_31674__$1,temp__4657__auto___31673__$1,vec__31563_31657,column_31658,column_info_31659,seq__31548_31651__$1,temp__4657__auto___31650,vec__31545_31607,line_31608,columns_31609,inverted))
,cljs.core.sorted_map.call(null)));

var G__31685 = cljs.core.next.call(null,seq__31566_31674__$1);
var G__31686 = null;
var G__31687 = (0);
var G__31688 = (0);
seq__31566_31660 = G__31685;
chunk__31567_31661 = G__31686;
count__31568_31662 = G__31687;
i__31569_31663 = G__31688;
continue;
}
} else {
}
}
break;
}

var G__31689 = cljs.core.next.call(null,seq__31548_31651__$1);
var G__31690 = null;
var G__31691 = (0);
var G__31692 = (0);
seq__31548_31610 = G__31689;
chunk__31549_31611 = G__31690;
count__31550_31612 = G__31691;
i__31551_31613 = G__31692;
continue;
}
} else {
}
}
break;
}

var G__31693 = seq__31541_31603;
var G__31694 = chunk__31542_31604;
var G__31695 = count__31543_31605;
var G__31696 = (i__31544_31606 + (1));
seq__31541_31603 = G__31693;
chunk__31542_31604 = G__31694;
count__31543_31605 = G__31695;
i__31544_31606 = G__31696;
continue;
} else {
var temp__4657__auto___31697 = cljs.core.seq.call(null,seq__31541_31603);
if(temp__4657__auto___31697){
var seq__31541_31698__$1 = temp__4657__auto___31697;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__31541_31698__$1)){
var c__9025__auto___31699 = cljs.core.chunk_first.call(null,seq__31541_31698__$1);
var G__31700 = cljs.core.chunk_rest.call(null,seq__31541_31698__$1);
var G__31701 = c__9025__auto___31699;
var G__31702 = cljs.core.count.call(null,c__9025__auto___31699);
var G__31703 = (0);
seq__31541_31603 = G__31700;
chunk__31542_31604 = G__31701;
count__31543_31605 = G__31702;
i__31544_31606 = G__31703;
continue;
} else {
var vec__31574_31704 = cljs.core.first.call(null,seq__31541_31698__$1);
var line_31705 = cljs.core.nth.call(null,vec__31574_31704,(0),null);
var columns_31706 = cljs.core.nth.call(null,vec__31574_31704,(1),null);
var seq__31577_31707 = cljs.core.seq.call(null,columns_31706);
var chunk__31578_31708 = null;
var count__31579_31709 = (0);
var i__31580_31710 = (0);
while(true){
if((i__31580_31710 < count__31579_31709)){
var vec__31581_31711 = cljs.core._nth.call(null,chunk__31578_31708,i__31580_31710);
var column_31712 = cljs.core.nth.call(null,vec__31581_31711,(0),null);
var column_info_31713 = cljs.core.nth.call(null,vec__31581_31711,(1),null);
var seq__31584_31714 = cljs.core.seq.call(null,column_info_31713);
var chunk__31585_31715 = null;
var count__31586_31716 = (0);
var i__31587_31717 = (0);
while(true){
if((i__31587_31717 < count__31586_31716)){
var map__31588_31718 = cljs.core._nth.call(null,chunk__31585_31715,i__31587_31717);
var map__31588_31719__$1 = ((((!((map__31588_31718 == null)))?((((map__31588_31718.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__31588_31718.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__31588_31718):map__31588_31718);
var gline_31720 = cljs.core.get.call(null,map__31588_31719__$1,new cljs.core.Keyword(null,"gline","gline",-1086242431));
var gcol_31721 = cljs.core.get.call(null,map__31588_31719__$1,new cljs.core.Keyword(null,"gcol","gcol",309250807));
var name_31722 = cljs.core.get.call(null,map__31588_31719__$1,new cljs.core.Keyword(null,"name","name",1843675177));
cljs.core.swap_BANG_.call(null,inverted,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_31720], null),cljs.core.fnil.call(null,((function (seq__31584_31714,chunk__31585_31715,count__31586_31716,i__31587_31717,seq__31577_31707,chunk__31578_31708,count__31579_31709,i__31580_31710,seq__31541_31603,chunk__31542_31604,count__31543_31605,i__31544_31606,map__31588_31718,map__31588_31719__$1,gline_31720,gcol_31721,name_31722,vec__31581_31711,column_31712,column_info_31713,vec__31574_31704,line_31705,columns_31706,seq__31541_31698__$1,temp__4657__auto___31697,inverted){
return (function (columns__$1){
return cljs.core.update_in.call(null,columns__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol_31721], null),cljs.core.fnil.call(null,cljs.core.conj,cljs.core.PersistentVector.EMPTY),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"line","line",212345235),line_31705,new cljs.core.Keyword(null,"col","col",-1959363084),column_31712,new cljs.core.Keyword(null,"name","name",1843675177),name_31722], null));
});})(seq__31584_31714,chunk__31585_31715,count__31586_31716,i__31587_31717,seq__31577_31707,chunk__31578_31708,count__31579_31709,i__31580_31710,seq__31541_31603,chunk__31542_31604,count__31543_31605,i__31544_31606,map__31588_31718,map__31588_31719__$1,gline_31720,gcol_31721,name_31722,vec__31581_31711,column_31712,column_info_31713,vec__31574_31704,line_31705,columns_31706,seq__31541_31698__$1,temp__4657__auto___31697,inverted))
,cljs.core.sorted_map.call(null)));

var G__31723 = seq__31584_31714;
var G__31724 = chunk__31585_31715;
var G__31725 = count__31586_31716;
var G__31726 = (i__31587_31717 + (1));
seq__31584_31714 = G__31723;
chunk__31585_31715 = G__31724;
count__31586_31716 = G__31725;
i__31587_31717 = G__31726;
continue;
} else {
var temp__4657__auto___31727__$1 = cljs.core.seq.call(null,seq__31584_31714);
if(temp__4657__auto___31727__$1){
var seq__31584_31728__$1 = temp__4657__auto___31727__$1;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__31584_31728__$1)){
var c__9025__auto___31729 = cljs.core.chunk_first.call(null,seq__31584_31728__$1);
var G__31730 = cljs.core.chunk_rest.call(null,seq__31584_31728__$1);
var G__31731 = c__9025__auto___31729;
var G__31732 = cljs.core.count.call(null,c__9025__auto___31729);
var G__31733 = (0);
seq__31584_31714 = G__31730;
chunk__31585_31715 = G__31731;
count__31586_31716 = G__31732;
i__31587_31717 = G__31733;
continue;
} else {
var map__31590_31734 = cljs.core.first.call(null,seq__31584_31728__$1);
var map__31590_31735__$1 = ((((!((map__31590_31734 == null)))?((((map__31590_31734.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__31590_31734.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__31590_31734):map__31590_31734);
var gline_31736 = cljs.core.get.call(null,map__31590_31735__$1,new cljs.core.Keyword(null,"gline","gline",-1086242431));
var gcol_31737 = cljs.core.get.call(null,map__31590_31735__$1,new cljs.core.Keyword(null,"gcol","gcol",309250807));
var name_31738 = cljs.core.get.call(null,map__31590_31735__$1,new cljs.core.Keyword(null,"name","name",1843675177));
cljs.core.swap_BANG_.call(null,inverted,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_31736], null),cljs.core.fnil.call(null,((function (seq__31584_31714,chunk__31585_31715,count__31586_31716,i__31587_31717,seq__31577_31707,chunk__31578_31708,count__31579_31709,i__31580_31710,seq__31541_31603,chunk__31542_31604,count__31543_31605,i__31544_31606,map__31590_31734,map__31590_31735__$1,gline_31736,gcol_31737,name_31738,seq__31584_31728__$1,temp__4657__auto___31727__$1,vec__31581_31711,column_31712,column_info_31713,vec__31574_31704,line_31705,columns_31706,seq__31541_31698__$1,temp__4657__auto___31697,inverted){
return (function (columns__$1){
return cljs.core.update_in.call(null,columns__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol_31737], null),cljs.core.fnil.call(null,cljs.core.conj,cljs.core.PersistentVector.EMPTY),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"line","line",212345235),line_31705,new cljs.core.Keyword(null,"col","col",-1959363084),column_31712,new cljs.core.Keyword(null,"name","name",1843675177),name_31738], null));
});})(seq__31584_31714,chunk__31585_31715,count__31586_31716,i__31587_31717,seq__31577_31707,chunk__31578_31708,count__31579_31709,i__31580_31710,seq__31541_31603,chunk__31542_31604,count__31543_31605,i__31544_31606,map__31590_31734,map__31590_31735__$1,gline_31736,gcol_31737,name_31738,seq__31584_31728__$1,temp__4657__auto___31727__$1,vec__31581_31711,column_31712,column_info_31713,vec__31574_31704,line_31705,columns_31706,seq__31541_31698__$1,temp__4657__auto___31697,inverted))
,cljs.core.sorted_map.call(null)));

var G__31739 = cljs.core.next.call(null,seq__31584_31728__$1);
var G__31740 = null;
var G__31741 = (0);
var G__31742 = (0);
seq__31584_31714 = G__31739;
chunk__31585_31715 = G__31740;
count__31586_31716 = G__31741;
i__31587_31717 = G__31742;
continue;
}
} else {
}
}
break;
}

var G__31743 = seq__31577_31707;
var G__31744 = chunk__31578_31708;
var G__31745 = count__31579_31709;
var G__31746 = (i__31580_31710 + (1));
seq__31577_31707 = G__31743;
chunk__31578_31708 = G__31744;
count__31579_31709 = G__31745;
i__31580_31710 = G__31746;
continue;
} else {
var temp__4657__auto___31747__$1 = cljs.core.seq.call(null,seq__31577_31707);
if(temp__4657__auto___31747__$1){
var seq__31577_31748__$1 = temp__4657__auto___31747__$1;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__31577_31748__$1)){
var c__9025__auto___31749 = cljs.core.chunk_first.call(null,seq__31577_31748__$1);
var G__31750 = cljs.core.chunk_rest.call(null,seq__31577_31748__$1);
var G__31751 = c__9025__auto___31749;
var G__31752 = cljs.core.count.call(null,c__9025__auto___31749);
var G__31753 = (0);
seq__31577_31707 = G__31750;
chunk__31578_31708 = G__31751;
count__31579_31709 = G__31752;
i__31580_31710 = G__31753;
continue;
} else {
var vec__31592_31754 = cljs.core.first.call(null,seq__31577_31748__$1);
var column_31755 = cljs.core.nth.call(null,vec__31592_31754,(0),null);
var column_info_31756 = cljs.core.nth.call(null,vec__31592_31754,(1),null);
var seq__31595_31757 = cljs.core.seq.call(null,column_info_31756);
var chunk__31596_31758 = null;
var count__31597_31759 = (0);
var i__31598_31760 = (0);
while(true){
if((i__31598_31760 < count__31597_31759)){
var map__31599_31761 = cljs.core._nth.call(null,chunk__31596_31758,i__31598_31760);
var map__31599_31762__$1 = ((((!((map__31599_31761 == null)))?((((map__31599_31761.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__31599_31761.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__31599_31761):map__31599_31761);
var gline_31763 = cljs.core.get.call(null,map__31599_31762__$1,new cljs.core.Keyword(null,"gline","gline",-1086242431));
var gcol_31764 = cljs.core.get.call(null,map__31599_31762__$1,new cljs.core.Keyword(null,"gcol","gcol",309250807));
var name_31765 = cljs.core.get.call(null,map__31599_31762__$1,new cljs.core.Keyword(null,"name","name",1843675177));
cljs.core.swap_BANG_.call(null,inverted,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_31763], null),cljs.core.fnil.call(null,((function (seq__31595_31757,chunk__31596_31758,count__31597_31759,i__31598_31760,seq__31577_31707,chunk__31578_31708,count__31579_31709,i__31580_31710,seq__31541_31603,chunk__31542_31604,count__31543_31605,i__31544_31606,map__31599_31761,map__31599_31762__$1,gline_31763,gcol_31764,name_31765,vec__31592_31754,column_31755,column_info_31756,seq__31577_31748__$1,temp__4657__auto___31747__$1,vec__31574_31704,line_31705,columns_31706,seq__31541_31698__$1,temp__4657__auto___31697,inverted){
return (function (columns__$1){
return cljs.core.update_in.call(null,columns__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol_31764], null),cljs.core.fnil.call(null,cljs.core.conj,cljs.core.PersistentVector.EMPTY),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"line","line",212345235),line_31705,new cljs.core.Keyword(null,"col","col",-1959363084),column_31755,new cljs.core.Keyword(null,"name","name",1843675177),name_31765], null));
});})(seq__31595_31757,chunk__31596_31758,count__31597_31759,i__31598_31760,seq__31577_31707,chunk__31578_31708,count__31579_31709,i__31580_31710,seq__31541_31603,chunk__31542_31604,count__31543_31605,i__31544_31606,map__31599_31761,map__31599_31762__$1,gline_31763,gcol_31764,name_31765,vec__31592_31754,column_31755,column_info_31756,seq__31577_31748__$1,temp__4657__auto___31747__$1,vec__31574_31704,line_31705,columns_31706,seq__31541_31698__$1,temp__4657__auto___31697,inverted))
,cljs.core.sorted_map.call(null)));

var G__31766 = seq__31595_31757;
var G__31767 = chunk__31596_31758;
var G__31768 = count__31597_31759;
var G__31769 = (i__31598_31760 + (1));
seq__31595_31757 = G__31766;
chunk__31596_31758 = G__31767;
count__31597_31759 = G__31768;
i__31598_31760 = G__31769;
continue;
} else {
var temp__4657__auto___31770__$2 = cljs.core.seq.call(null,seq__31595_31757);
if(temp__4657__auto___31770__$2){
var seq__31595_31771__$1 = temp__4657__auto___31770__$2;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__31595_31771__$1)){
var c__9025__auto___31772 = cljs.core.chunk_first.call(null,seq__31595_31771__$1);
var G__31773 = cljs.core.chunk_rest.call(null,seq__31595_31771__$1);
var G__31774 = c__9025__auto___31772;
var G__31775 = cljs.core.count.call(null,c__9025__auto___31772);
var G__31776 = (0);
seq__31595_31757 = G__31773;
chunk__31596_31758 = G__31774;
count__31597_31759 = G__31775;
i__31598_31760 = G__31776;
continue;
} else {
var map__31601_31777 = cljs.core.first.call(null,seq__31595_31771__$1);
var map__31601_31778__$1 = ((((!((map__31601_31777 == null)))?((((map__31601_31777.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__31601_31777.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__31601_31777):map__31601_31777);
var gline_31779 = cljs.core.get.call(null,map__31601_31778__$1,new cljs.core.Keyword(null,"gline","gline",-1086242431));
var gcol_31780 = cljs.core.get.call(null,map__31601_31778__$1,new cljs.core.Keyword(null,"gcol","gcol",309250807));
var name_31781 = cljs.core.get.call(null,map__31601_31778__$1,new cljs.core.Keyword(null,"name","name",1843675177));
cljs.core.swap_BANG_.call(null,inverted,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_31779], null),cljs.core.fnil.call(null,((function (seq__31595_31757,chunk__31596_31758,count__31597_31759,i__31598_31760,seq__31577_31707,chunk__31578_31708,count__31579_31709,i__31580_31710,seq__31541_31603,chunk__31542_31604,count__31543_31605,i__31544_31606,map__31601_31777,map__31601_31778__$1,gline_31779,gcol_31780,name_31781,seq__31595_31771__$1,temp__4657__auto___31770__$2,vec__31592_31754,column_31755,column_info_31756,seq__31577_31748__$1,temp__4657__auto___31747__$1,vec__31574_31704,line_31705,columns_31706,seq__31541_31698__$1,temp__4657__auto___31697,inverted){
return (function (columns__$1){
return cljs.core.update_in.call(null,columns__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol_31780], null),cljs.core.fnil.call(null,cljs.core.conj,cljs.core.PersistentVector.EMPTY),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"line","line",212345235),line_31705,new cljs.core.Keyword(null,"col","col",-1959363084),column_31755,new cljs.core.Keyword(null,"name","name",1843675177),name_31781], null));
});})(seq__31595_31757,chunk__31596_31758,count__31597_31759,i__31598_31760,seq__31577_31707,chunk__31578_31708,count__31579_31709,i__31580_31710,seq__31541_31603,chunk__31542_31604,count__31543_31605,i__31544_31606,map__31601_31777,map__31601_31778__$1,gline_31779,gcol_31780,name_31781,seq__31595_31771__$1,temp__4657__auto___31770__$2,vec__31592_31754,column_31755,column_info_31756,seq__31577_31748__$1,temp__4657__auto___31747__$1,vec__31574_31704,line_31705,columns_31706,seq__31541_31698__$1,temp__4657__auto___31697,inverted))
,cljs.core.sorted_map.call(null)));

var G__31782 = cljs.core.next.call(null,seq__31595_31771__$1);
var G__31783 = null;
var G__31784 = (0);
var G__31785 = (0);
seq__31595_31757 = G__31782;
chunk__31596_31758 = G__31783;
count__31597_31759 = G__31784;
i__31598_31760 = G__31785;
continue;
}
} else {
}
}
break;
}

var G__31786 = cljs.core.next.call(null,seq__31577_31748__$1);
var G__31787 = null;
var G__31788 = (0);
var G__31789 = (0);
seq__31577_31707 = G__31786;
chunk__31578_31708 = G__31787;
count__31579_31709 = G__31788;
i__31580_31710 = G__31789;
continue;
}
} else {
}
}
break;
}

var G__31790 = cljs.core.next.call(null,seq__31541_31698__$1);
var G__31791 = null;
var G__31792 = (0);
var G__31793 = (0);
seq__31541_31603 = G__31790;
chunk__31542_31604 = G__31791;
count__31543_31605 = G__31792;
i__31544_31606 = G__31793;
continue;
}
} else {
}
}
break;
}

return cljs.core.deref.call(null,inverted);
});
