// Compiled by ClojureScript 1.9.946 {}
goog.provide('grapple.cell');
goog.require('cljs.core');
goog.require('clojure.walk');
goog.require('cljs_uuid_utils.core');
goog.require('reagent.core');
goog.require('re_frame.core');
goog.require('grapple.render');
grapple.cell.pending = new cljs.core.Keyword("grapple.cell","pending","grapple.cell/pending",-1949747408);
grapple.cell.interrupted = new cljs.core.Keyword("grapple.cell","interrupted","grapple.cell/interrupted",-1024431114);

/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {grapple.render.Renderable}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
grapple.cell.Cell = (function (id,opts,value,__meta,__extmap,__hash){
this.id = id;
this.opts = opts;
this.value = value;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2229667594;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
grapple.cell.Cell.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__8826__auto__,k__8827__auto__){
var self__ = this;
var this__8826__auto____$1 = this;
return this__8826__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__8827__auto__,null);
});

grapple.cell.Cell.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__8828__auto__,k35945,else__8829__auto__){
var self__ = this;
var this__8828__auto____$1 = this;
var G__35949 = k35945;
var G__35949__$1 = (((G__35949 instanceof cljs.core.Keyword))?G__35949.fqn:null);
switch (G__35949__$1) {
case "id":
return self__.id;

break;
case "opts":
return self__.opts;

break;
case "value":
return self__.value;

break;
default:
return cljs.core.get.call(null,self__.__extmap,k35945,else__8829__auto__);

}
});

grapple.cell.Cell.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__8840__auto__,writer__8841__auto__,opts__8842__auto__){
var self__ = this;
var this__8840__auto____$1 = this;
var pr_pair__8843__auto__ = ((function (this__8840__auto____$1){
return (function (keyval__8844__auto__){
return cljs.core.pr_sequential_writer.call(null,writer__8841__auto__,cljs.core.pr_writer,""," ","",opts__8842__auto__,keyval__8844__auto__);
});})(this__8840__auto____$1))
;
return cljs.core.pr_sequential_writer.call(null,writer__8841__auto__,pr_pair__8843__auto__,"#grapple.cell.Cell{",", ","}",opts__8842__auto__,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"id","id",-1388402092),self__.id],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"opts","opts",155075701),self__.opts],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"value","value",305978217),self__.value],null))], null),self__.__extmap));
});

grapple.cell.Cell.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__35944){
var self__ = this;
var G__35944__$1 = this;
return (new cljs.core.RecordIter((0),G__35944__$1,3,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"id","id",-1388402092),new cljs.core.Keyword(null,"opts","opts",155075701),new cljs.core.Keyword(null,"value","value",305978217)], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator.call(null,self__.__extmap):cljs.core.nil_iter.call(null))));
});

grapple.cell.Cell.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__8824__auto__){
var self__ = this;
var this__8824__auto____$1 = this;
return self__.__meta;
});

grapple.cell.Cell.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__8821__auto__){
var self__ = this;
var this__8821__auto____$1 = this;
return (new grapple.cell.Cell(self__.id,self__.opts,self__.value,self__.__meta,self__.__extmap,self__.__hash));
});

grapple.cell.Cell.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__8830__auto__){
var self__ = this;
var this__8830__auto____$1 = this;
return (3 + cljs.core.count.call(null,self__.__extmap));
});

grapple.cell.Cell.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__8822__auto__){
var self__ = this;
var this__8822__auto____$1 = this;
var h__8640__auto__ = self__.__hash;
if(!((h__8640__auto__ == null))){
return h__8640__auto__;
} else {
var h__8640__auto____$1 = ((function (h__8640__auto__,this__8822__auto____$1){
return (function (coll__8823__auto__){
return (880221274 ^ cljs.core.hash_unordered_coll.call(null,coll__8823__auto__));
});})(h__8640__auto__,this__8822__auto____$1))
.call(null,this__8822__auto____$1);
self__.__hash = h__8640__auto____$1;

return h__8640__auto____$1;
}
});

grapple.cell.Cell.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this35946,other35947){
var self__ = this;
var this35946__$1 = this;
return (!((other35947 == null))) && ((this35946__$1.constructor === other35947.constructor)) && (cljs.core._EQ_.call(null,this35946__$1.id,other35947.id)) && (cljs.core._EQ_.call(null,this35946__$1.opts,other35947.opts)) && (cljs.core._EQ_.call(null,this35946__$1.value,other35947.value)) && (cljs.core._EQ_.call(null,this35946__$1.__extmap,other35947.__extmap));
});

grapple.cell.Cell.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__8835__auto__,k__8836__auto__){
var self__ = this;
var this__8835__auto____$1 = this;
if(cljs.core.contains_QMARK_.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"value","value",305978217),null,new cljs.core.Keyword(null,"id","id",-1388402092),null,new cljs.core.Keyword(null,"opts","opts",155075701),null], null), null),k__8836__auto__)){
return cljs.core.dissoc.call(null,cljs.core._with_meta.call(null,cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,this__8835__auto____$1),self__.__meta),k__8836__auto__);
} else {
return (new grapple.cell.Cell(self__.id,self__.opts,self__.value,self__.__meta,cljs.core.not_empty.call(null,cljs.core.dissoc.call(null,self__.__extmap,k__8836__auto__)),null));
}
});

grapple.cell.Cell.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__8833__auto__,k__8834__auto__,G__35944){
var self__ = this;
var this__8833__auto____$1 = this;
var pred__35950 = cljs.core.keyword_identical_QMARK_;
var expr__35951 = k__8834__auto__;
if(cljs.core.truth_(pred__35950.call(null,new cljs.core.Keyword(null,"id","id",-1388402092),expr__35951))){
return (new grapple.cell.Cell(G__35944,self__.opts,self__.value,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__35950.call(null,new cljs.core.Keyword(null,"opts","opts",155075701),expr__35951))){
return (new grapple.cell.Cell(self__.id,G__35944,self__.value,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__35950.call(null,new cljs.core.Keyword(null,"value","value",305978217),expr__35951))){
return (new grapple.cell.Cell(self__.id,self__.opts,G__35944,self__.__meta,self__.__extmap,null));
} else {
return (new grapple.cell.Cell(self__.id,self__.opts,self__.value,self__.__meta,cljs.core.assoc.call(null,self__.__extmap,k__8834__auto__,G__35944),null));
}
}
}
});

grapple.cell.Cell.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__8838__auto__){
var self__ = this;
var this__8838__auto____$1 = this;
return cljs.core.seq.call(null,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"id","id",-1388402092),self__.id],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"opts","opts",155075701),self__.opts],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"value","value",305978217),self__.value],null))], null),self__.__extmap));
});

grapple.cell.Cell.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__8825__auto__,G__35944){
var self__ = this;
var this__8825__auto____$1 = this;
return (new grapple.cell.Cell(self__.id,self__.opts,self__.value,G__35944,self__.__extmap,self__.__hash));
});

grapple.cell.Cell.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__8831__auto__,entry__8832__auto__){
var self__ = this;
var this__8831__auto____$1 = this;
if(cljs.core.vector_QMARK_.call(null,entry__8832__auto__)){
return this__8831__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth.call(null,entry__8832__auto__,(0)),cljs.core._nth.call(null,entry__8832__auto__,(1)));
} else {
return cljs.core.reduce.call(null,cljs.core._conj,this__8831__auto____$1,entry__8832__auto__);
}
});

grapple.cell.Cell.prototype.grapple$render$Renderable$ = cljs.core.PROTOCOL_SENTINEL;

grapple.cell.Cell.prototype.grapple$render$Renderable$__GT_component$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return reagent.core.create_class.call(null,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"reagent-render","reagent-render",-985383853),((function (___$1){
return (function (){
if(cljs.core._EQ_.call(null,grapple.cell.pending,self__.value)){
var map__35953 = self__.opts;
var map__35953__$1 = ((((!((map__35953 == null)))?((((map__35953.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__35953.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__35953):map__35953);
var vec__35954 = cljs.core.get.call(null,map__35953__$1,new cljs.core.Keyword(null,"form","form",-1624062471));
var ___$2 = cljs.core.nth.call(null,vec__35954,(0),null);
var form = cljs.core.nth.call(null,vec__35954,(1),null);
var interruptible_QMARK_ = cljs.core.get.call(null,map__35953__$1,new cljs.core.Keyword(null,"interruptible?","interruptible?",1750203066));
var cancel = (cljs.core.truth_(interruptible_QMARK_)?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"span.cancel","span.cancel",-2143187319),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"on-click","on-click",1632826543),((function (map__35953,map__35953__$1,vec__35954,___$2,form,interruptible_QMARK_,___$1){
return (function (){
return re_frame.core.dispatch.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("clojure","interrupt","clojure/interrupt",-809736070),self__.id], null));
});})(map__35953,map__35953__$1,vec__35954,___$2,form,interruptible_QMARK_,___$1))
], null)], null):null);
var temp__4655__auto__ = self__.opts.call(null,new cljs.core.Keyword(null,"form","form",-1624062471));
if(cljs.core.truth_(temp__4655__auto__)){
var f = temp__4655__auto__;
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"div.result__loading","div.result__loading",-2099688203),cancel,"Evaluating ",new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"code","code",1586293142),cljs.core.pr_str.call(null,form)], null)], null);
} else {
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"div.result__loading","div.result__loading",-2099688203),cancel,"Evaluating..."], null);
}
} else {
if(cljs.core._EQ_.call(null,grapple.cell.interrupted,self__.value)){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"div.result__interrupted","div.result__interrupted",443427769),"Interrupted"], null);
} else {
if(cljs.core.contains_QMARK_.call(null,self__.value,new cljs.core.Keyword(null,"error","error",-978969032))){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [grapple.render.__GT_Error.call(null,self__.value.call(null,new cljs.core.Keyword(null,"error","error",-978969032)))], null);
} else {
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [grapple.render.__GT_component.call(null,self__.value.call(null,new cljs.core.Keyword(null,"value","value",305978217)))], null);

}
}
}
});})(___$1))
], null));
});

grapple.cell.Cell.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"id","id",252129435,null),new cljs.core.Symbol(null,"opts","opts",1795607228,null),new cljs.core.Symbol(null,"value","value",1946509744,null)], null);
});

grapple.cell.Cell.cljs$lang$type = true;

grapple.cell.Cell.cljs$lang$ctorPrSeq = (function (this__8862__auto__){
return cljs.core._conj.call(null,cljs.core.List.EMPTY,"grapple.cell/Cell");
});

grapple.cell.Cell.cljs$lang$ctorPrWriter = (function (this__8862__auto__,writer__8863__auto__){
return cljs.core._write.call(null,writer__8863__auto__,"grapple.cell/Cell");
});

grapple.cell.__GT_Cell = (function grapple$cell$__GT_Cell(id,opts,value){
return (new grapple.cell.Cell(id,opts,value,null,null,null));
});

grapple.cell.map__GT_Cell = (function grapple$cell$map__GT_Cell(G__35948){
return (new grapple.cell.Cell(new cljs.core.Keyword(null,"id","id",-1388402092).cljs$core$IFn$_invoke$arity$1(G__35948),new cljs.core.Keyword(null,"opts","opts",155075701).cljs$core$IFn$_invoke$arity$1(G__35948),new cljs.core.Keyword(null,"value","value",305978217).cljs$core$IFn$_invoke$arity$1(G__35948),null,cljs.core.not_empty.call(null,cljs.core.dissoc.call(null,G__35948,new cljs.core.Keyword(null,"id","id",-1388402092),new cljs.core.Keyword(null,"opts","opts",155075701),new cljs.core.Keyword(null,"value","value",305978217))),null));
});

grapple.cell.cell = (function grapple$cell$cell(var_args){
var G__35960 = arguments.length;
switch (G__35960) {
case 1:
return grapple.cell.cell.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return grapple.cell.cell.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return grapple.cell.cell.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

grapple.cell.cell.cljs$core$IFn$_invoke$arity$1 = (function (opts){
return grapple.cell.cell.call(null,opts,grapple.cell.pending);
});

grapple.cell.cell.cljs$core$IFn$_invoke$arity$2 = (function (opts,value){
return grapple.cell.cell.call(null,cljs_uuid_utils.core.make_random_uuid.call(null),opts,value);
});

grapple.cell.cell.cljs$core$IFn$_invoke$arity$3 = (function (id,opts,value){
var c = grapple.cell.__GT_Cell.call(null,id,opts,value);
re_frame.core.dispatch.call(null,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("page","new-cell","page/new-cell",654629022),id,c], null));

return c;
});

grapple.cell.cell.cljs$lang$maxFixedArity = 3;

grapple.cell.pending_QMARK_ = (function grapple$cell$pending_QMARK_(cell){
return cljs.core._EQ_.call(null,grapple.cell.pending,new cljs.core.Keyword(null,"value","value",305978217).cljs$core$IFn$_invoke$arity$1(cell));
});
grapple.cell.update_cell = (function grapple$cell$update_cell(db,eval_id,value,source){
return cljs.core.update_in.call(null,db,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("page","cells","page/cells",-971691089),eval_id], null),(function (cell){
if(cljs.core._EQ_.call(null,source,new cljs.core.Keyword(null,"source","source",-433931539).cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"opts","opts",155075701).cljs$core$IFn$_invoke$arity$1(cell)))){
return cljs.core.assoc.call(null,cell,new cljs.core.Keyword(null,"value","value",305978217),value);
} else {
return cell;
}
}));
});
grapple.cell.build_results = (function grapple$cell$build_results(cells,cell_ids){
return clojure.walk.prewalk.call(null,(function (node){
if((node instanceof grapple.cell.Cell)){
return cljs.core.get.call(null,cells,new cljs.core.Keyword(null,"id","id",-1388402092).cljs$core$IFn$_invoke$arity$1(node));
} else {
return node;
}
}),cljs.core.map.call(null,cells,cell_ids));
});
