// Compiled by ClojureScript 1.9.946 {}
goog.provide('grapple.nav');
goog.require('cljs.core');
goog.require('clojure.zip');
goog.require('cljs_uuid_utils.core');
goog.require('re_frame.core');
grapple.nav.new_block = (function grapple$nav$new_block(){
return new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword("block","id","block/id",-1461684825),cljs_uuid_utils.core.make_random_uuid.call(null),new cljs.core.Keyword("block","content","block/content",-161885195),"",new cljs.core.Keyword("block","active?","block/active?",-444944723),false,new cljs.core.Keyword("block","results","block/results",-1274140812),cljs.core.PersistentVector.EMPTY], null);
});
grapple.nav.goto$ = (function grapple$nav$goto(loc,pred){
var loc__$1 = loc;
while(true){
if(cljs.core.truth_(clojure.zip.end_QMARK_.call(null,loc__$1))){
return loc__$1;
} else {
if(cljs.core.truth_(pred.call(null,clojure.zip.node.call(null,loc__$1)))){
return loc__$1;
} else {
var G__37534 = clojure.zip.next.call(null,loc__$1);
loc__$1 = G__37534;
continue;
}
}
break;
}
});
grapple.nav.move_left = (function grapple$nav$move_left(loc){
return clojure.zip.insert_left.call(null,clojure.zip.remove.call(null,loc),clojure.zip.node.call(null,loc));
});
grapple.nav.move_right = (function grapple$nav$move_right(loc){
return clojure.zip.insert_right.call(null,clojure.zip.right.call(null,clojure.zip.remove.call(null,loc)),clojure.zip.node.call(null,loc));
});
grapple.nav.cursor_up = (function grapple$nav$cursor_up(id,cm){
var cursor = cm.getCursor();
if((cursor.line === (0))){
return re_frame.core.dispatch.call(null,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("nav","focus-previous","nav/focus-previous",-1925718262),id,new cljs.core.Keyword("line","default","line/default",-1991693044)], null));
} else {
return CodeMirror.Pass;
}
});
grapple.nav.cursor_down = (function grapple$nav$cursor_down(id,cm){
var cursor = cm.getCursor();
var last_line = (cm.lineCount() - (1));
if(cljs.core._EQ_.call(null,last_line,cursor.line)){
return re_frame.core.dispatch.call(null,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("nav","focus-next","nav/focus-next",-1933036901),id,new cljs.core.Keyword("line","default","line/default",-1991693044)], null));
} else {
return CodeMirror.Pass;
}
});
grapple.nav.cursor_left = (function grapple$nav$cursor_left(id,cm){
var cursor = cm.getCursor();
if(((cursor.line === (0))) && ((cursor.ch === (0)))){
return re_frame.core.dispatch.call(null,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("nav","focus-previous","nav/focus-previous",-1925718262),id,new cljs.core.Keyword("line","end","line/end",-269025650)], null));
} else {
return CodeMirror.Pass;
}
});
grapple.nav.cursor_right = (function grapple$nav$cursor_right(id,cm){
var cursor = cm.getCursor();
var last_line = (cm.lineCount() - (1));
var last_ch = cm.getLine(last_line).length;
if((cljs.core._EQ_.call(null,last_line,cursor.line)) && (cljs.core._EQ_.call(null,last_ch,cursor.ch))){
return re_frame.core.dispatch.call(null,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("nav","focus-next","nav/focus-next",-1933036901),id,new cljs.core.Keyword("line","start","line/start",-352280353)], null));
} else {
return CodeMirror.Pass;
}
});
grapple.nav.current_word = (function grapple$nav$current_word(cm){
var sel = cm.findWordAt(cm.getCursor());
return cm.getRange(sel.anchor,sel.head);
});
grapple.nav.node_or_nil = (function grapple$nav$node_or_nil(loc){
if(cljs.core.truth_(loc)){
return clojure.zip.node.call(null,loc);
} else {
return null;
}
});
grapple.nav.block_before = (function grapple$nav$block_before(db,id){
return cljs.core.get.call(null,db.call(null,new cljs.core.Keyword("page","blocks","page/blocks",-611190360)),grapple.nav.node_or_nil.call(null,clojure.zip.left.call(null,grapple.nav.goto$.call(null,clojure.zip.vector_zip.call(null,new cljs.core.Keyword("page","block-order","page/block-order",496949686).cljs$core$IFn$_invoke$arity$1(db)),(function (p1__37535_SHARP_){
return cljs.core._EQ_.call(null,id,p1__37535_SHARP_);
})))));
});
grapple.nav.block_after = (function grapple$nav$block_after(db,id){
return cljs.core.get.call(null,db.call(null,new cljs.core.Keyword("page","blocks","page/blocks",-611190360)),grapple.nav.node_or_nil.call(null,clojure.zip.right.call(null,grapple.nav.goto$.call(null,clojure.zip.vector_zip.call(null,new cljs.core.Keyword("page","block-order","page/block-order",496949686).cljs$core$IFn$_invoke$arity$1(db)),(function (p1__37536_SHARP_){
return cljs.core._EQ_.call(null,id,p1__37536_SHARP_);
})))));
});
grapple.nav.ensure_next_block = (function grapple$nav$ensure_next_block(db,id,p__37537){
var map__37538 = p__37537;
var map__37538__$1 = ((((!((map__37538 == null)))?((((map__37538.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__37538.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__37538):map__37538);
var new_block = map__37538__$1;
var new_block_id = cljs.core.get.call(null,map__37538__$1,new cljs.core.Keyword("block","id","block/id",-1461684825));
var temp__4655__auto__ = grapple.nav.block_after.call(null,db,id);
if(cljs.core.truth_(temp__4655__auto__)){
var next_block = temp__4655__auto__;
return db;
} else {
return cljs.core.update.call(null,cljs.core.update.call(null,db,new cljs.core.Keyword("page","blocks","page/blocks",-611190360),cljs.core.assoc,new_block_id,new_block),new cljs.core.Keyword("page","block-order","page/block-order",496949686),cljs.core.conj,new_block_id);
}
});
grapple.nav.insert_new_block = (function grapple$nav$insert_new_block(f){
return (function (p__37540,p__37541){
var map__37542 = p__37540;
var map__37542__$1 = ((((!((map__37542 == null)))?((((map__37542.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__37542.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__37542):map__37542);
var generate_empty_block = cljs.core.get.call(null,map__37542__$1,new cljs.core.Keyword("generator","empty-block","generator/empty-block",116519553));
var db = cljs.core.get.call(null,map__37542__$1,new cljs.core.Keyword(null,"db","db",993250759));
var vec__37543 = p__37541;
var _ = cljs.core.nth.call(null,vec__37543,(0),null);
var id = cljs.core.nth.call(null,vec__37543,(1),null);
var map__37547 = generate_empty_block.call(null);
var map__37547__$1 = ((((!((map__37547 == null)))?((((map__37547.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__37547.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__37547):map__37547);
var new_block = map__37547__$1;
var new_id = cljs.core.get.call(null,map__37547__$1,new cljs.core.Keyword("block","id","block/id",-1461684825));
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"db","db",993250759),cljs.core.update.call(null,cljs.core.update.call(null,db,new cljs.core.Keyword("page","blocks","page/blocks",-611190360),cljs.core.assoc,new_id,new_block),new cljs.core.Keyword("page","block-order","page/block-order",496949686),f,id,new_id),new cljs.core.Keyword("nav","focus","nav/focus",238194924),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword("focus","id","focus/id",-1282538148),new_id], null)], null);
});
});
grapple.nav.activate = (function grapple$nav$activate(db,id){
return cljs.core.assoc_in.call(null,cljs.core.update.call(null,db,new cljs.core.Keyword("page","blocks","page/blocks",-611190360),(function (blocks){
return cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,cljs.core.map.call(null,(function (p__37549){
var vec__37550 = p__37549;
var k = cljs.core.nth.call(null,vec__37550,(0),null);
var v = cljs.core.nth.call(null,vec__37550,(1),null);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [k,cljs.core.assoc.call(null,v,new cljs.core.Keyword("block","active?","block/active?",-444944723),false)], null);
})),blocks);
})),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("page","blocks","page/blocks",-611190360),id,new cljs.core.Keyword("block","active?","block/active?",-444944723)], null),true);
});
re_frame.core.reg_event_db.call(null,new cljs.core.Keyword("nav","activate","nav/activate",441398015),(function (db,p__37553){
var vec__37554 = p__37553;
var _ = cljs.core.nth.call(null,vec__37554,(0),null);
var id = cljs.core.nth.call(null,vec__37554,(1),null);
var pos = cljs.core.nth.call(null,vec__37554,(2),null);
var map__37557 = cljs.core.get_in.call(null,db,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("page","blocks","page/blocks",-611190360),id], null));
var map__37557__$1 = ((((!((map__37557 == null)))?((((map__37557.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__37557.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__37557):map__37557);
var id__$1 = cljs.core.get.call(null,map__37557__$1,new cljs.core.Keyword("block","id","block/id",-1461684825));
var codemirror = cljs.core.get.call(null,map__37557__$1,new cljs.core.Keyword("block","codemirror","block/codemirror",-1114467838));
return grapple.nav.activate.call(null,db,id__$1);
}));
re_frame.core.reg_event_fx.call(null,new cljs.core.Keyword("nav","focus","nav/focus",238194924),(function (p__37559,p__37560){
var map__37561 = p__37559;
var map__37561__$1 = ((((!((map__37561 == null)))?((((map__37561.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__37561.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__37561):map__37561);
var db = cljs.core.get.call(null,map__37561__$1,new cljs.core.Keyword(null,"db","db",993250759));
var vec__37562 = p__37560;
var _ = cljs.core.nth.call(null,vec__37562,(0),null);
var id = cljs.core.nth.call(null,vec__37562,(1),null);
var pos = cljs.core.nth.call(null,vec__37562,(2),null);
var map__37566 = cljs.core.get_in.call(null,db,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("page","blocks","page/blocks",-611190360),id], null));
var map__37566__$1 = ((((!((map__37566 == null)))?((((map__37566.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__37566.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__37566):map__37566);
var id__$1 = cljs.core.get.call(null,map__37566__$1,new cljs.core.Keyword("block","id","block/id",-1461684825));
var codemirror = cljs.core.get.call(null,map__37566__$1,new cljs.core.Keyword("block","codemirror","block/codemirror",-1114467838));
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword("codemirror","focus","codemirror/focus",-19393885),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword("focus","codemirror","focus/codemirror",-1120050705),codemirror,new cljs.core.Keyword("focus","position","focus/position",841225488),pos], null),new cljs.core.Keyword(null,"db","db",993250759),grapple.nav.activate.call(null,db,id__$1)], null);
}));
re_frame.core.reg_event_fx.call(null,new cljs.core.Keyword("nav","focus-previous","nav/focus-previous",-1925718262),(function (p__37568,p__37569){
var map__37570 = p__37568;
var map__37570__$1 = ((((!((map__37570 == null)))?((((map__37570.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__37570.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__37570):map__37570);
var db = cljs.core.get.call(null,map__37570__$1,new cljs.core.Keyword(null,"db","db",993250759));
var vec__37571 = p__37569;
var _ = cljs.core.nth.call(null,vec__37571,(0),null);
var id = cljs.core.nth.call(null,vec__37571,(1),null);
var pos = cljs.core.nth.call(null,vec__37571,(2),null);
var map__37575 = grapple.nav.block_before.call(null,db,id);
var map__37575__$1 = ((((!((map__37575 == null)))?((((map__37575.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__37575.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__37575):map__37575);
var id__$1 = cljs.core.get.call(null,map__37575__$1,new cljs.core.Keyword("block","id","block/id",-1461684825));
return new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword("nav","focus","nav/focus",238194924),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword("focus","id","focus/id",-1282538148),id__$1,new cljs.core.Keyword("focus","position","focus/position",841225488),pos], null)], null);
}));
re_frame.core.reg_event_fx.call(null,new cljs.core.Keyword("nav","focus-next","nav/focus-next",-1933036901),(function (p__37577,p__37578){
var map__37579 = p__37577;
var map__37579__$1 = ((((!((map__37579 == null)))?((((map__37579.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__37579.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__37579):map__37579);
var db = cljs.core.get.call(null,map__37579__$1,new cljs.core.Keyword(null,"db","db",993250759));
var vec__37580 = p__37578;
var _ = cljs.core.nth.call(null,vec__37580,(0),null);
var id = cljs.core.nth.call(null,vec__37580,(1),null);
var pos = cljs.core.nth.call(null,vec__37580,(2),null);
var map__37584 = grapple.nav.block_after.call(null,db,id);
var map__37584__$1 = ((((!((map__37584 == null)))?((((map__37584.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__37584.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__37584):map__37584);
var id__$1 = cljs.core.get.call(null,map__37584__$1,new cljs.core.Keyword("block","id","block/id",-1461684825));
return new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword("nav","focus","nav/focus",238194924),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword("focus","id","focus/id",-1282538148),id__$1,new cljs.core.Keyword("focus","position","focus/position",841225488),pos], null)], null);
}));
re_frame.core.reg_event_fx.call(null,new cljs.core.Keyword("nav","ensure-focus-next","nav/ensure-focus-next",54351188),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [re_frame.core.inject_cofx.call(null,new cljs.core.Keyword("generator","empty-block","generator/empty-block",116519553))], null),(function (p__37586,p__37587){
var map__37588 = p__37586;
var map__37588__$1 = ((((!((map__37588 == null)))?((((map__37588.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__37588.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__37588):map__37588);
var generate_empty_block = cljs.core.get.call(null,map__37588__$1,new cljs.core.Keyword("generator","empty-block","generator/empty-block",116519553));
var db = cljs.core.get.call(null,map__37588__$1,new cljs.core.Keyword(null,"db","db",993250759));
var vec__37589 = p__37587;
var _ = cljs.core.nth.call(null,vec__37589,(0),null);
var id = cljs.core.nth.call(null,vec__37589,(1),null);
var pos = cljs.core.nth.call(null,vec__37589,(2),null);
var db__$1 = grapple.nav.ensure_next_block.call(null,db,id,generate_empty_block.call(null));
var map__37593 = grapple.nav.block_after.call(null,db__$1,id);
var map__37593__$1 = ((((!((map__37593 == null)))?((((map__37593.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__37593.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__37593):map__37593);
var id__$1 = cljs.core.get.call(null,map__37593__$1,new cljs.core.Keyword("block","id","block/id",-1461684825));
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword("nav","focus","nav/focus",238194924),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword("focus","id","focus/id",-1282538148),id__$1,new cljs.core.Keyword("focus","position","focus/position",841225488),pos], null),new cljs.core.Keyword(null,"db","db",993250759),db__$1], null);
}));
re_frame.core.reg_event_fx.call(null,new cljs.core.Keyword("nav","insert-new-before","nav/insert-new-before",370981298),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [re_frame.core.inject_cofx.call(null,new cljs.core.Keyword("generator","empty-block","generator/empty-block",116519553))], null),grapple.nav.insert_new_block.call(null,(function (ids,id,new_id){
return cljs.core.vec.call(null,clojure.zip.root.call(null,clojure.zip.insert_left.call(null,grapple.nav.goto$.call(null,clojure.zip.vector_zip.call(null,ids),cljs.core.PersistentHashSet.createAsIfByAssoc([id])),new_id)));
})));
re_frame.core.reg_event_fx.call(null,new cljs.core.Keyword("nav","insert-new-after","nav/insert-new-after",-1052665766),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [re_frame.core.inject_cofx.call(null,new cljs.core.Keyword("generator","empty-block","generator/empty-block",116519553))], null),grapple.nav.insert_new_block.call(null,(function (ids,id,new_id){
return cljs.core.vec.call(null,clojure.zip.root.call(null,clojure.zip.insert_right.call(null,grapple.nav.goto$.call(null,clojure.zip.vector_zip.call(null,ids),cljs.core.PersistentHashSet.createAsIfByAssoc([id])),new_id)));
})));
re_frame.core.reg_event_fx.call(null,new cljs.core.Keyword("nav","delete","nav/delete",-1768520753),(function (p__37596,p__37597){
var map__37598 = p__37596;
var map__37598__$1 = ((((!((map__37598 == null)))?((((map__37598.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__37598.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__37598):map__37598);
var db = cljs.core.get.call(null,map__37598__$1,new cljs.core.Keyword(null,"db","db",993250759));
var vec__37599 = p__37597;
var _ = cljs.core.nth.call(null,vec__37599,(0),null);
var id = cljs.core.nth.call(null,vec__37599,(1),null);
if(cljs.core.truth_(cljs.core.get_in.call(null,db,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("page","blocks","page/blocks",-611190360),id,new cljs.core.Keyword("block","permanent?","block/permanent?",-1182966562)], null)))){
return null;
} else {
var move_to_block = (function (){var or__8186__auto__ = grapple.nav.block_after.call(null,db,id);
if(cljs.core.truth_(or__8186__auto__)){
return or__8186__auto__;
} else {
return grapple.nav.block_before.call(null,db,id);
}
})();
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword("codemirror","focus","codemirror/focus",-19393885),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword("focus","codemirror","focus/codemirror",-1120050705),new cljs.core.Keyword("block","codemirror","block/codemirror",-1114467838).cljs$core$IFn$_invoke$arity$1(move_to_block)], null),new cljs.core.Keyword(null,"db","db",993250759),cljs.core.update.call(null,cljs.core.update.call(null,db,new cljs.core.Keyword("page","block-order","page/block-order",496949686),((function (move_to_block,map__37598,map__37598__$1,db,vec__37599,_,id){
return (function (p1__37595_SHARP_){
return cljs.core.vec.call(null,cljs.core.filter.call(null,cljs.core.partial.call(null,cljs.core.not_EQ_,id),p1__37595_SHARP_));
});})(move_to_block,map__37598,map__37598__$1,db,vec__37599,_,id))
),new cljs.core.Keyword("page","blocks","page/blocks",-611190360),cljs.core.dissoc,id)], null);
}
}));
re_frame.core.reg_event_db.call(null,new cljs.core.Keyword("nav","move-up","nav/move-up",-1153032456),(function (db,p__37604){
var vec__37605 = p__37604;
var _ = cljs.core.nth.call(null,vec__37605,(0),null);
var id = cljs.core.nth.call(null,vec__37605,(1),null);
return cljs.core.update.call(null,db,new cljs.core.Keyword("page","block-order","page/block-order",496949686),((function (vec__37605,_,id){
return (function (ids){
return cljs.core.vec.call(null,clojure.zip.root.call(null,grapple.nav.move_left.call(null,grapple.nav.goto$.call(null,clojure.zip.vector_zip.call(null,ids),((function (vec__37605,_,id){
return (function (p1__37603_SHARP_){
return cljs.core._EQ_.call(null,id,p1__37603_SHARP_);
});})(vec__37605,_,id))
))));
});})(vec__37605,_,id))
);
}));
re_frame.core.reg_event_db.call(null,new cljs.core.Keyword("nav","move-down","nav/move-down",-1148169948),(function (db,p__37609){
var vec__37610 = p__37609;
var _ = cljs.core.nth.call(null,vec__37610,(0),null);
var id = cljs.core.nth.call(null,vec__37610,(1),null);
return cljs.core.update.call(null,db,new cljs.core.Keyword("page","block-order","page/block-order",496949686),((function (vec__37610,_,id){
return (function (ids){
return cljs.core.vec.call(null,clojure.zip.root.call(null,grapple.nav.move_right.call(null,grapple.nav.goto$.call(null,clojure.zip.vector_zip.call(null,ids),((function (vec__37610,_,id){
return (function (p1__37608_SHARP_){
return cljs.core._EQ_.call(null,id,p1__37608_SHARP_);
});})(vec__37610,_,id))
))));
});})(vec__37610,_,id))
);
}));
re_frame.core.reg_fx.call(null,new cljs.core.Keyword("nav","focus","nav/focus",238194924),(function (p__37613){
var map__37614 = p__37613;
var map__37614__$1 = ((((!((map__37614 == null)))?((((map__37614.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__37614.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__37614):map__37614);
var id = cljs.core.get.call(null,map__37614__$1,new cljs.core.Keyword("focus","id","focus/id",-1282538148));
var position = cljs.core.get.call(null,map__37614__$1,new cljs.core.Keyword("focus","position","focus/position",841225488));
return re_frame.core.dispatch.call(null,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("nav","focus","nav/focus",238194924),id,position], null));
}));
re_frame.core.reg_cofx.call(null,new cljs.core.Keyword("generator","empty-block","generator/empty-block",116519553),(function (cofx,_){
return cljs.core.assoc.call(null,cofx,new cljs.core.Keyword("generator","empty-block","generator/empty-block",116519553),grapple.nav.new_block);
}));
