// Compiled by ClojureScript 1.9.946 {}
goog.provide('re_frame.events');
goog.require('cljs.core');
goog.require('re_frame.db');
goog.require('re_frame.utils');
goog.require('re_frame.interop');
goog.require('re_frame.registrar');
goog.require('re_frame.loggers');
goog.require('re_frame.interceptor');
goog.require('re_frame.trace');
re_frame.events.kind = new cljs.core.Keyword(null,"event","event",301435442);
if(cljs.core.truth_(re_frame.registrar.kinds.call(null,re_frame.events.kind))){
} else {
throw (new Error("Assert failed: (re-frame.registrar/kinds kind)"));
}
/**
 * `interceptors` might have nested collections, and contain nil elements.
 *   return a flat collection, with all nils removed.
 *   This function is 9/10 about giving good error messages.
 */
re_frame.events.flatten_and_remove_nils = (function re_frame$events$flatten_and_remove_nils(id,interceptors){
var make_chain = (function (p1__33907_SHARP_){
return cljs.core.remove.call(null,cljs.core.nil_QMARK_,cljs.core.flatten.call(null,p1__33907_SHARP_));
});
if(!(re_frame.interop.debug_enabled_QMARK_)){
return make_chain.call(null,interceptors);
} else {
if(cljs.core.coll_QMARK_.call(null,interceptors)){
} else {
re_frame.loggers.console.call(null,new cljs.core.Keyword(null,"error","error",-978969032),"re-frame: when registering ",id,", expected a collection of interceptors, got: ",interceptors);
}

var chain = make_chain.call(null,interceptors);
if(cljs.core.empty_QMARK_.call(null,chain)){
re_frame.loggers.console.call(null,new cljs.core.Keyword(null,"error","error",-978969032),"re-frame: when registering ",id,", given an empty interceptor chain");
} else {
}

var temp__4657__auto___33908 = cljs.core.first.call(null,cljs.core.remove.call(null,re_frame.interceptor.interceptor_QMARK_,chain));
if(cljs.core.truth_(temp__4657__auto___33908)){
var not_i_33909 = temp__4657__auto___33908;
if(cljs.core.fn_QMARK_.call(null,not_i_33909)){
re_frame.loggers.console.call(null,new cljs.core.Keyword(null,"error","error",-978969032),"re-frame: when registering ",id,", got a function instead of an interceptor. Did you provide old style middleware by mistake? Got: ",not_i_33909);
} else {
re_frame.loggers.console.call(null,new cljs.core.Keyword(null,"error","error",-978969032),"re-frame: when registering ",id,", expected interceptors, but got: ",not_i_33909);
}
} else {
}

return chain;
}
});
/**
 * Associate the given event `id` with the given collection of `interceptors`.
 * 
 * `interceptors` may contain nested collections and there may be nils
 * at any level,so process this structure into a simple, nil-less vector
 * before registration.
 * 
 * Typically, an `event handler` will be at the end of the chain (wrapped
 * in an interceptor).
 */
re_frame.events.register = (function re_frame$events$register(id,interceptors){
return re_frame.registrar.register_handler.call(null,re_frame.events.kind,id,re_frame.events.flatten_and_remove_nils.call(null,id,interceptors));
});
re_frame.events._STAR_handling_STAR_ = null;
/**
 * Given an event vector `event-v`, look up the associated interceptor chain, and execute it.
 */
re_frame.events.handle = (function re_frame$events$handle(event_v){
var event_id = re_frame.utils.first_in_vector.call(null,event_v);
var temp__4655__auto__ = re_frame.registrar.get_handler.call(null,re_frame.events.kind,event_id,true);
if(cljs.core.truth_(temp__4655__auto__)){
var interceptors = temp__4655__auto__;
if(cljs.core.truth_(re_frame.events._STAR_handling_STAR_)){
return re_frame.loggers.console.call(null,new cljs.core.Keyword(null,"error","error",-978969032),"re-frame: while handling \"",re_frame.events._STAR_handling_STAR_,"\", dispatch-sync was called for \"",event_v,"\". You can't call dispatch-sync within an event handler.");
} else {
var _STAR_handling_STAR_33910 = re_frame.events._STAR_handling_STAR_;
re_frame.events._STAR_handling_STAR_ = event_v;

try{if(re_frame.trace.is_trace_enabled_QMARK_.call(null)){
var _STAR_current_trace_STAR_33911 = re_frame.trace._STAR_current_trace_STAR_;
re_frame.trace._STAR_current_trace_STAR_ = re_frame.trace.start_trace.call(null,new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"operation","operation",-1267664310),event_id,new cljs.core.Keyword(null,"op-type","op-type",-1636141668),re_frame.events.kind,new cljs.core.Keyword(null,"tags","tags",1771418977),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"event","event",301435442),event_v], null)], null));

try{try{return re_frame.interceptor.execute.call(null,event_v,interceptors);
}finally {if(re_frame.trace.is_trace_enabled_QMARK_.call(null)){
var end__33855__auto___33924 = re_frame.interop.now.call(null);
var duration__33856__auto___33925 = (end__33855__auto___33924 - new cljs.core.Keyword(null,"start","start",-355208981).cljs$core$IFn$_invoke$arity$1(re_frame.trace._STAR_current_trace_STAR_));
var seq__33912_33926 = cljs.core.seq.call(null,cljs.core.deref.call(null,re_frame.trace.trace_cbs));
var chunk__33913_33927 = null;
var count__33914_33928 = (0);
var i__33915_33929 = (0);
while(true){
if((i__33915_33929 < count__33914_33928)){
var vec__33916_33930 = cljs.core._nth.call(null,chunk__33913_33927,i__33915_33929);
var k__33857__auto___33931 = cljs.core.nth.call(null,vec__33916_33930,(0),null);
var cb__33858__auto___33932 = cljs.core.nth.call(null,vec__33916_33930,(1),null);
try{cb__33858__auto___33932.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.assoc.call(null,re_frame.trace._STAR_current_trace_STAR_,new cljs.core.Keyword(null,"duration","duration",1444101068),duration__33856__auto___33925,new cljs.core.Keyword(null,"end","end",-268185958),re_frame.interop.now.call(null))], null));
}catch (e33919){if((e33919 instanceof java.lang.Exception)){
var e__33859__auto___33933 = e33919;
re_frame.loggers.console.call(null,new cljs.core.Keyword(null,"error","error",-978969032),"Error thrown from trace cb",k__33857__auto___33931,"while storing",re_frame.trace._STAR_current_trace_STAR_,e__33859__auto___33933);
} else {
throw e33919;

}
}
var G__33934 = seq__33912_33926;
var G__33935 = chunk__33913_33927;
var G__33936 = count__33914_33928;
var G__33937 = (i__33915_33929 + (1));
seq__33912_33926 = G__33934;
chunk__33913_33927 = G__33935;
count__33914_33928 = G__33936;
i__33915_33929 = G__33937;
continue;
} else {
var temp__4657__auto___33938 = cljs.core.seq.call(null,seq__33912_33926);
if(temp__4657__auto___33938){
var seq__33912_33939__$1 = temp__4657__auto___33938;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__33912_33939__$1)){
var c__9025__auto___33940 = cljs.core.chunk_first.call(null,seq__33912_33939__$1);
var G__33941 = cljs.core.chunk_rest.call(null,seq__33912_33939__$1);
var G__33942 = c__9025__auto___33940;
var G__33943 = cljs.core.count.call(null,c__9025__auto___33940);
var G__33944 = (0);
seq__33912_33926 = G__33941;
chunk__33913_33927 = G__33942;
count__33914_33928 = G__33943;
i__33915_33929 = G__33944;
continue;
} else {
var vec__33920_33945 = cljs.core.first.call(null,seq__33912_33939__$1);
var k__33857__auto___33946 = cljs.core.nth.call(null,vec__33920_33945,(0),null);
var cb__33858__auto___33947 = cljs.core.nth.call(null,vec__33920_33945,(1),null);
try{cb__33858__auto___33947.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.assoc.call(null,re_frame.trace._STAR_current_trace_STAR_,new cljs.core.Keyword(null,"duration","duration",1444101068),duration__33856__auto___33925,new cljs.core.Keyword(null,"end","end",-268185958),re_frame.interop.now.call(null))], null));
}catch (e33923){if((e33923 instanceof java.lang.Exception)){
var e__33859__auto___33948 = e33923;
re_frame.loggers.console.call(null,new cljs.core.Keyword(null,"error","error",-978969032),"Error thrown from trace cb",k__33857__auto___33946,"while storing",re_frame.trace._STAR_current_trace_STAR_,e__33859__auto___33948);
} else {
throw e33923;

}
}
var G__33949 = cljs.core.next.call(null,seq__33912_33939__$1);
var G__33950 = null;
var G__33951 = (0);
var G__33952 = (0);
seq__33912_33926 = G__33949;
chunk__33913_33927 = G__33950;
count__33914_33928 = G__33951;
i__33915_33929 = G__33952;
continue;
}
} else {
}
}
break;
}
} else {
}
}}finally {re_frame.trace._STAR_current_trace_STAR_ = _STAR_current_trace_STAR_33911;
}} else {
return re_frame.interceptor.execute.call(null,event_v,interceptors);
}
}finally {re_frame.events._STAR_handling_STAR_ = _STAR_handling_STAR_33910;
}}
} else {
return null;
}
});
