// Compiled by ClojureScript 1.9.946 {}
goog.provide('re_frame.fx');
goog.require('cljs.core');
goog.require('re_frame.router');
goog.require('re_frame.db');
goog.require('re_frame.interceptor');
goog.require('re_frame.interop');
goog.require('re_frame.events');
goog.require('re_frame.registrar');
goog.require('re_frame.loggers');
re_frame.fx.kind = new cljs.core.Keyword(null,"fx","fx",-1237829572);
if(cljs.core.truth_(re_frame.registrar.kinds.call(null,re_frame.fx.kind))){
} else {
throw (new Error("Assert failed: (re-frame.registrar/kinds kind)"));
}
/**
 * Register the given effect `handler` for the given `id`.
 * 
 *   `id` is keyword, often namespaced.
 *   `handler` is a side-effecting function which takes a single argument and whose return
 *   value is ignored.
 * 
 *   Example Use
 *   -----------
 * 
 *   First, registration ... associate `:effect2` with a handler.
 * 
 *   (reg-fx
 *   :effect2
 *   (fn [value]
 *      ... do something side-effect-y))
 * 
 *   Then, later, if an event handler were to return this effects map ...
 * 
 *   {...
 * :effect2  [1 2]}
 * 
 * ... then the `handler` `fn` we registered previously, using `reg-fx`, will be
 * called with an argument of `[1 2]`.
 */
re_frame.fx.reg_fx = (function re_frame$fx$reg_fx(id,handler){
return re_frame.registrar.register_handler.call(null,re_frame.fx.kind,id,handler);
});
/**
 * An interceptor whose `:after` actions the contents of `:effects`. As a result,
 *   this interceptor is Domino 3.
 * 
 *   This interceptor is silently added (by reg-event-db etc) to the front of
 *   interceptor chains for all events.
 * 
 *   For each key in `:effects` (a map), it calls the registered `effects handler`
 *   (see `reg-fx` for registration of effect handlers).
 * 
 *   So, if `:effects` was:
 *    {:dispatch  [:hello 42]
 *     :db        {...}
 *     :undo      "set flag"}
 * 
 *   it will call the registered effect handlers for each of the map's keys:
 *   `:dispatch`, `:undo` and `:db`. When calling each handler, provides the map
 *   value for that key - so in the example above the effect handler for :dispatch
 *   will be given one arg `[:hello 42]`.
 * 
 *   You cannot rely on the ordering in which effects are executed.
 */
re_frame.fx.do_fx = re_frame.interceptor.__GT_interceptor.call(null,new cljs.core.Keyword(null,"id","id",-1388402092),new cljs.core.Keyword(null,"do-fx","do-fx",1194163050),new cljs.core.Keyword(null,"after","after",594996914),(function re_frame$fx$do_fx_after(context){
var seq__35478 = cljs.core.seq.call(null,new cljs.core.Keyword(null,"effects","effects",-282369292).cljs$core$IFn$_invoke$arity$1(context));
var chunk__35479 = null;
var count__35480 = (0);
var i__35481 = (0);
while(true){
if((i__35481 < count__35480)){
var vec__35482 = cljs.core._nth.call(null,chunk__35479,i__35481);
var effect_key = cljs.core.nth.call(null,vec__35482,(0),null);
var effect_value = cljs.core.nth.call(null,vec__35482,(1),null);
var temp__4655__auto___35488 = re_frame.registrar.get_handler.call(null,re_frame.fx.kind,effect_key,false);
if(cljs.core.truth_(temp__4655__auto___35488)){
var effect_fn_35489 = temp__4655__auto___35488;
effect_fn_35489.call(null,effect_value);
} else {
re_frame.loggers.console.call(null,new cljs.core.Keyword(null,"error","error",-978969032),"re-frame: no handler registered for effect: \"",effect_key,"\". Ignoring.");
}

var G__35490 = seq__35478;
var G__35491 = chunk__35479;
var G__35492 = count__35480;
var G__35493 = (i__35481 + (1));
seq__35478 = G__35490;
chunk__35479 = G__35491;
count__35480 = G__35492;
i__35481 = G__35493;
continue;
} else {
var temp__4657__auto__ = cljs.core.seq.call(null,seq__35478);
if(temp__4657__auto__){
var seq__35478__$1 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__35478__$1)){
var c__9025__auto__ = cljs.core.chunk_first.call(null,seq__35478__$1);
var G__35494 = cljs.core.chunk_rest.call(null,seq__35478__$1);
var G__35495 = c__9025__auto__;
var G__35496 = cljs.core.count.call(null,c__9025__auto__);
var G__35497 = (0);
seq__35478 = G__35494;
chunk__35479 = G__35495;
count__35480 = G__35496;
i__35481 = G__35497;
continue;
} else {
var vec__35485 = cljs.core.first.call(null,seq__35478__$1);
var effect_key = cljs.core.nth.call(null,vec__35485,(0),null);
var effect_value = cljs.core.nth.call(null,vec__35485,(1),null);
var temp__4655__auto___35498 = re_frame.registrar.get_handler.call(null,re_frame.fx.kind,effect_key,false);
if(cljs.core.truth_(temp__4655__auto___35498)){
var effect_fn_35499 = temp__4655__auto___35498;
effect_fn_35499.call(null,effect_value);
} else {
re_frame.loggers.console.call(null,new cljs.core.Keyword(null,"error","error",-978969032),"re-frame: no handler registered for effect: \"",effect_key,"\". Ignoring.");
}

var G__35500 = cljs.core.next.call(null,seq__35478__$1);
var G__35501 = null;
var G__35502 = (0);
var G__35503 = (0);
seq__35478 = G__35500;
chunk__35479 = G__35501;
count__35480 = G__35502;
i__35481 = G__35503;
continue;
}
} else {
return null;
}
}
break;
}
}));
re_frame.fx.reg_fx.call(null,new cljs.core.Keyword(null,"dispatch-later","dispatch-later",291951390),(function (value){
var seq__35504 = cljs.core.seq.call(null,value);
var chunk__35505 = null;
var count__35506 = (0);
var i__35507 = (0);
while(true){
if((i__35507 < count__35506)){
var map__35508 = cljs.core._nth.call(null,chunk__35505,i__35507);
var map__35508__$1 = ((((!((map__35508 == null)))?((((map__35508.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__35508.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__35508):map__35508);
var effect = map__35508__$1;
var ms = cljs.core.get.call(null,map__35508__$1,new cljs.core.Keyword(null,"ms","ms",-1152709733));
var dispatch = cljs.core.get.call(null,map__35508__$1,new cljs.core.Keyword(null,"dispatch","dispatch",1319337009));
if((cljs.core.empty_QMARK_.call(null,dispatch)) || (!(typeof ms === 'number'))){
re_frame.loggers.console.call(null,new cljs.core.Keyword(null,"error","error",-978969032),"re-frame: ignoring bad :dispatch-later value:",effect);
} else {
re_frame.interop.set_timeout_BANG_.call(null,((function (seq__35504,chunk__35505,count__35506,i__35507,map__35508,map__35508__$1,effect,ms,dispatch){
return (function (){
return re_frame.router.dispatch.call(null,dispatch);
});})(seq__35504,chunk__35505,count__35506,i__35507,map__35508,map__35508__$1,effect,ms,dispatch))
,ms);
}

var G__35512 = seq__35504;
var G__35513 = chunk__35505;
var G__35514 = count__35506;
var G__35515 = (i__35507 + (1));
seq__35504 = G__35512;
chunk__35505 = G__35513;
count__35506 = G__35514;
i__35507 = G__35515;
continue;
} else {
var temp__4657__auto__ = cljs.core.seq.call(null,seq__35504);
if(temp__4657__auto__){
var seq__35504__$1 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__35504__$1)){
var c__9025__auto__ = cljs.core.chunk_first.call(null,seq__35504__$1);
var G__35516 = cljs.core.chunk_rest.call(null,seq__35504__$1);
var G__35517 = c__9025__auto__;
var G__35518 = cljs.core.count.call(null,c__9025__auto__);
var G__35519 = (0);
seq__35504 = G__35516;
chunk__35505 = G__35517;
count__35506 = G__35518;
i__35507 = G__35519;
continue;
} else {
var map__35510 = cljs.core.first.call(null,seq__35504__$1);
var map__35510__$1 = ((((!((map__35510 == null)))?((((map__35510.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__35510.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__35510):map__35510);
var effect = map__35510__$1;
var ms = cljs.core.get.call(null,map__35510__$1,new cljs.core.Keyword(null,"ms","ms",-1152709733));
var dispatch = cljs.core.get.call(null,map__35510__$1,new cljs.core.Keyword(null,"dispatch","dispatch",1319337009));
if((cljs.core.empty_QMARK_.call(null,dispatch)) || (!(typeof ms === 'number'))){
re_frame.loggers.console.call(null,new cljs.core.Keyword(null,"error","error",-978969032),"re-frame: ignoring bad :dispatch-later value:",effect);
} else {
re_frame.interop.set_timeout_BANG_.call(null,((function (seq__35504,chunk__35505,count__35506,i__35507,map__35510,map__35510__$1,effect,ms,dispatch,seq__35504__$1,temp__4657__auto__){
return (function (){
return re_frame.router.dispatch.call(null,dispatch);
});})(seq__35504,chunk__35505,count__35506,i__35507,map__35510,map__35510__$1,effect,ms,dispatch,seq__35504__$1,temp__4657__auto__))
,ms);
}

var G__35520 = cljs.core.next.call(null,seq__35504__$1);
var G__35521 = null;
var G__35522 = (0);
var G__35523 = (0);
seq__35504 = G__35520;
chunk__35505 = G__35521;
count__35506 = G__35522;
i__35507 = G__35523;
continue;
}
} else {
return null;
}
}
break;
}
}));
re_frame.fx.reg_fx.call(null,new cljs.core.Keyword(null,"dispatch","dispatch",1319337009),(function (value){
if(!(cljs.core.vector_QMARK_.call(null,value))){
return re_frame.loggers.console.call(null,new cljs.core.Keyword(null,"error","error",-978969032),"re-frame: ignoring bad :dispatch value. Expected a vector, but got:",value);
} else {
return re_frame.router.dispatch.call(null,value);
}
}));
re_frame.fx.reg_fx.call(null,new cljs.core.Keyword(null,"dispatch-n","dispatch-n",-504469236),(function (value){
if(!(cljs.core.sequential_QMARK_.call(null,value))){
return re_frame.loggers.console.call(null,new cljs.core.Keyword(null,"error","error",-978969032),"re-frame: ignoring bad :dispatch-n value. Expected a collection, got got:",value);
} else {
var seq__35524 = cljs.core.seq.call(null,cljs.core.remove.call(null,cljs.core.nil_QMARK_,value));
var chunk__35525 = null;
var count__35526 = (0);
var i__35527 = (0);
while(true){
if((i__35527 < count__35526)){
var event = cljs.core._nth.call(null,chunk__35525,i__35527);
re_frame.router.dispatch.call(null,event);

var G__35528 = seq__35524;
var G__35529 = chunk__35525;
var G__35530 = count__35526;
var G__35531 = (i__35527 + (1));
seq__35524 = G__35528;
chunk__35525 = G__35529;
count__35526 = G__35530;
i__35527 = G__35531;
continue;
} else {
var temp__4657__auto__ = cljs.core.seq.call(null,seq__35524);
if(temp__4657__auto__){
var seq__35524__$1 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__35524__$1)){
var c__9025__auto__ = cljs.core.chunk_first.call(null,seq__35524__$1);
var G__35532 = cljs.core.chunk_rest.call(null,seq__35524__$1);
var G__35533 = c__9025__auto__;
var G__35534 = cljs.core.count.call(null,c__9025__auto__);
var G__35535 = (0);
seq__35524 = G__35532;
chunk__35525 = G__35533;
count__35526 = G__35534;
i__35527 = G__35535;
continue;
} else {
var event = cljs.core.first.call(null,seq__35524__$1);
re_frame.router.dispatch.call(null,event);

var G__35536 = cljs.core.next.call(null,seq__35524__$1);
var G__35537 = null;
var G__35538 = (0);
var G__35539 = (0);
seq__35524 = G__35536;
chunk__35525 = G__35537;
count__35526 = G__35538;
i__35527 = G__35539;
continue;
}
} else {
return null;
}
}
break;
}
}
}));
re_frame.fx.reg_fx.call(null,new cljs.core.Keyword(null,"deregister-event-handler","deregister-event-handler",-1096518994),(function (value){
var clear_event = cljs.core.partial.call(null,re_frame.registrar.clear_handlers,re_frame.events.kind);
if(cljs.core.sequential_QMARK_.call(null,value)){
var seq__35540 = cljs.core.seq.call(null,value);
var chunk__35541 = null;
var count__35542 = (0);
var i__35543 = (0);
while(true){
if((i__35543 < count__35542)){
var event = cljs.core._nth.call(null,chunk__35541,i__35543);
clear_event.call(null,event);

var G__35544 = seq__35540;
var G__35545 = chunk__35541;
var G__35546 = count__35542;
var G__35547 = (i__35543 + (1));
seq__35540 = G__35544;
chunk__35541 = G__35545;
count__35542 = G__35546;
i__35543 = G__35547;
continue;
} else {
var temp__4657__auto__ = cljs.core.seq.call(null,seq__35540);
if(temp__4657__auto__){
var seq__35540__$1 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__35540__$1)){
var c__9025__auto__ = cljs.core.chunk_first.call(null,seq__35540__$1);
var G__35548 = cljs.core.chunk_rest.call(null,seq__35540__$1);
var G__35549 = c__9025__auto__;
var G__35550 = cljs.core.count.call(null,c__9025__auto__);
var G__35551 = (0);
seq__35540 = G__35548;
chunk__35541 = G__35549;
count__35542 = G__35550;
i__35543 = G__35551;
continue;
} else {
var event = cljs.core.first.call(null,seq__35540__$1);
clear_event.call(null,event);

var G__35552 = cljs.core.next.call(null,seq__35540__$1);
var G__35553 = null;
var G__35554 = (0);
var G__35555 = (0);
seq__35540 = G__35552;
chunk__35541 = G__35553;
count__35542 = G__35554;
i__35543 = G__35555;
continue;
}
} else {
return null;
}
}
break;
}
} else {
return clear_event.call(null,value);
}
}));
re_frame.fx.reg_fx.call(null,new cljs.core.Keyword(null,"db","db",993250759),(function (value){
if(!((cljs.core.deref.call(null,re_frame.db.app_db) === value))){
return cljs.core.reset_BANG_.call(null,re_frame.db.app_db,value);
} else {
return null;
}
}));
