(ns ezand.flume-engine.coercer
  (:require [clojure.algo.generic.functor :refer [fmap]]
            [ezand.flume-engine.utils :as util]))

(defn coerce-config
  [config]
  (letfn [(coerce-control [control]
            (update control :type util/lispy-key))
          (coerce-port [port]
            (-> port
                (update :type util/lispy-key)
                (update :name util/lispy-key)
                (update :controls (partial map coerce-control))))
          (coerce-ports [node-type]
            (-> node-type
                (update :inputs (partial map coerce-port))
                (update :outputs (partial map coerce-port))))
          (coerce-connections [node-type]
            (fmap coerce-ports node-type))
          (coerce-node-type [node-type]
            (update node-type :type util/lispy-key))
          (coerce-node-types [config]
            (update config :node-types (comp
                                         coerce-connections
                                         (partial fmap coerce-node-type))))
          (coerce-accept-types [accept-types]
            (set (map util/lispy-key accept-types)))
          (coerce-port-types [config]
            (update config :port-types (comp
                                         (partial fmap #(update % :accept-types coerce-accept-types))
                                         (partial fmap coerce-port))))]
    (-> (util/lispy-keys config)
        (coerce-node-types)
        (coerce-port-types))))

(defn coerce-nodes
  [nodes]
  (letfn [(coerce-id [node]
            (update node :id keyword))
          (coerce-node-type [node]
            (update node :type util/lispy-key))
          (coerce-node-id [port]
            (update port :node-id keyword))
          (coerce-port-name [port]
            (update port :port-name util/lispy-key))
          (coerce-connection [connection]
            (fmap (partial map (comp coerce-node-id
                                     coerce-port-name))
                  connection))
          (coerce-connections [direction node]
            (update-in node [:connections direction] coerce-connection))]
    (fmap (comp (partial coerce-connections :outputs)
                (partial coerce-connections :inputs)
                coerce-node-type
                coerce-id
                util/lispy-keys)
          nodes)))
