(ns ezand.flume-engine.utils
  (:require [clojure.walk :as walk]
            [superstring.core :as str]
            [clojure.set :as set]))

(defn lispy-key
  [k]
  (-> k name str/lisp-case keyword))

(defn- lispy-keys*
  "Rename the keys in `m` to use the lisp-case naming convention."
  [m]
  (set/rename-keys
    m
    (reduce
      (fn rename-key [acc k]
        (letfn [(->lisp-case [k]
                  (let [key-name (name k)]
                    (keyword (if (str/starts-with? key-name "_")
                               key-name
                               (str/lisp-case key-name)))))]
          (cond
            (keyword? k)
            (assoc acc k (->lisp-case k))
            :else acc)))
      {}
      (keys m))))

(defn lispy-keys
  "Recurisvely rename the keys in `m` to use the lisp-case naming convention."
  [m]
  (walk/postwalk (fn [v]
                   (if (and (map? v)
                            (not (record? v)))
                     (lispy-keys* v)
                     v))
                 m))

(defn find-first
  [f coll]
  (first (filter f coll)))
