/*
 * Decompiled with CFR 0.152.
 */
package org.fife.ui.rsyntaxtextarea;

import java.security.AccessControlException;
import java.util.Set;
import org.fife.ui.rsyntaxtextarea.TokenMaker;
import org.fife.ui.rsyntaxtextarea.modes.PlainTextTokenMaker;

public abstract class TokenMakerFactory {
    public static final String PROPERTY_DEFAULT_TOKEN_MAKER_FACTORY = "TokenMakerFactory";
    private static TokenMakerFactory DEFAULT_INSTANCE;

    public static synchronized TokenMakerFactory getDefaultInstance() {
        if (DEFAULT_INSTANCE == null) {
            String string = null;
            try {
                string = System.getProperty(PROPERTY_DEFAULT_TOKEN_MAKER_FACTORY);
            }
            catch (AccessControlException accessControlException) {
                string = null;
            }
            if (string == null) {
                string = "org.fife.ui.rsyntaxtextarea.DefaultTokenMakerFactory";
            }
            try {
                DEFAULT_INSTANCE = (TokenMakerFactory)Class.forName(string).newInstance();
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                exception.printStackTrace();
                throw new InternalError("Cannot find TokenMakerFactory: " + string);
            }
        }
        return DEFAULT_INSTANCE;
    }

    public final TokenMaker getTokenMaker(String string) {
        TokenMaker tokenMaker = this.getTokenMakerImpl(string);
        if (tokenMaker == null) {
            tokenMaker = new PlainTextTokenMaker();
        }
        return tokenMaker;
    }

    protected abstract TokenMaker getTokenMakerImpl(String var1);

    public abstract Set keySet();

    public static synchronized void setDefaultInstance(TokenMakerFactory tokenMakerFactory) {
        if (tokenMakerFactory == null) {
            throw new IllegalArgumentException("tmf cannot be null");
        }
        DEFAULT_INSTANCE = tokenMakerFactory;
    }
}

