/*
 * Decompiled with CFR 0.152.
 */
package org.fife.ui.rsyntaxtextarea.focusabletip;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.Serializable;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JWindow;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.event.MouseInputAdapter;
import javax.swing.text.BadLocationException;
import javax.swing.text.html.HTMLDocument;
import org.fife.ui.rsyntaxtextarea.RSyntaxUtilities;
import org.fife.ui.rsyntaxtextarea.focusabletip.FocusableTip;
import org.fife.ui.rsyntaxtextarea.focusabletip.SizeGrip;
import org.fife.ui.rsyntaxtextarea.focusabletip.TipUtil;

class TipWindow
extends JWindow
implements ActionListener {
    private FocusableTip ft;
    private JEditorPane textArea;
    private String text;
    private TipListener tipListener;
    private HyperlinkListener userHyperlinkListener;
    private static TipWindow visibleInstance;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TipWindow(Window window, FocusableTip focusableTip, String string) {
        super(window);
        this.ft = focusableTip;
        if (string != null && string.length() >= 6 && !string.substring(0, 6).toLowerCase().equals("<html>")) {
            string = "<html>" + RSyntaxUtilities.escapeForHtml(string, "<br>", false);
        }
        this.text = string;
        this.tipListener = new TipListener();
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.setBorder(TipUtil.getToolTipBorder());
        jPanel.setBackground(TipUtil.getToolTipBackground());
        this.textArea = new JEditorPane("text/html", this.text);
        TipUtil.tweakTipEditorPane(this.textArea);
        if (focusableTip.getImageBase() != null) {
            ((HTMLDocument)this.textArea.getDocument()).setBase(focusableTip.getImageBase());
        }
        this.textArea.addMouseListener(this.tipListener);
        this.textArea.addHyperlinkListener(new HyperlinkListener(){

            public void hyperlinkUpdate(HyperlinkEvent hyperlinkEvent) {
                if (hyperlinkEvent.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                    TipWindow.this.ft.possiblyDisposeOfTipWindow();
                }
            }
        });
        jPanel.add(this.textArea);
        this.setFocusableWindowState(false);
        this.setContentPane(jPanel);
        this.setBottomPanel();
        this.pack();
        KeyAdapter keyAdapter = new KeyAdapter(){

            public void keyPressed(KeyEvent keyEvent) {
                if (keyEvent.getKeyCode() == 27) {
                    TipWindow.this.ft.possiblyDisposeOfTipWindow();
                }
            }
        };
        this.addKeyListener(keyAdapter);
        this.textArea.addKeyListener(keyAdapter);
        Class clazz = TipWindow.class;
        synchronized (clazz) {
            if (visibleInstance != null) {
                visibleInstance.dispose();
            }
            visibleInstance = this;
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (!this.getFocusableWindowState()) {
            this.setFocusableWindowState(true);
            this.setBottomPanel();
            this.textArea.removeMouseListener(this.tipListener);
            this.pack();
            this.addWindowFocusListener(new WindowAdapter(){

                public void windowLostFocus(WindowEvent windowEvent) {
                    TipWindow.this.ft.possiblyDisposeOfTipWindow();
                }
            });
            this.ft.removeListeners();
            if (actionEvent == null) {
                this.requestFocus();
            }
        }
    }

    public void dispose() {
        Container container = this.getContentPane();
        for (int i = 0; i < container.getComponentCount(); ++i) {
            container.getComponent(i).removeMouseListener(this.tipListener);
        }
        this.ft.removeListeners();
        super.dispose();
    }

    void fixSize() {
        Dimension dimension = this.textArea.getPreferredSize();
        Rectangle rectangle = null;
        try {
            rectangle = this.textArea.modelToView(this.textArea.getDocument().getLength() - 1);
            dimension = this.textArea.getPreferredSize();
            dimension.width += 25;
            dimension.width = Math.min(dimension.width, 600);
            dimension.height = Math.min(dimension.height, 400);
            this.textArea.setPreferredSize(dimension);
            this.textArea.setSize(dimension);
            rectangle = this.textArea.modelToView(this.textArea.getDocument().getLength() - 1);
            if (rectangle.y + rectangle.height > dimension.height) {
                dimension.height = rectangle.y + rectangle.height + 5;
                this.textArea.setPreferredSize(dimension);
            }
        }
        catch (BadLocationException badLocationException) {
            badLocationException.printStackTrace();
        }
        this.pack();
    }

    public String getText() {
        return this.text;
    }

    private void setBottomPanel() {
        Object object;
        Serializable serializable;
        Object object2;
        Container container;
        final JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.add((Component)new JSeparator(), "North");
        boolean bl = this.getFocusableWindowState();
        if (bl) {
            container = new SizeGrip();
            ((SizeGrip)container).applyComponentOrientation(container.getComponentOrientation());
            jPanel.add((Component)container, "After");
            object2 = new MouseInputAdapter(){
                private Point lastPoint;

                public void mouseDragged(MouseEvent mouseEvent) {
                    Point point = mouseEvent.getPoint();
                    SwingUtilities.convertPointToScreen(point, jPanel);
                    if (this.lastPoint == null) {
                        this.lastPoint = point;
                    } else {
                        int n = point.x - this.lastPoint.x;
                        int n2 = point.y - this.lastPoint.y;
                        TipWindow.this.setLocation(TipWindow.this.getX() + n, TipWindow.this.getY() + n2);
                        this.lastPoint = point;
                    }
                }

                public void mousePressed(MouseEvent mouseEvent) {
                    this.lastPoint = mouseEvent.getPoint();
                    SwingUtilities.convertPointToScreen(this.lastPoint, jPanel);
                }
            };
            jPanel.addMouseListener((MouseListener)object2);
            jPanel.addMouseMotionListener((MouseMotionListener)object2);
        } else {
            jPanel.setOpaque(false);
            container = new JLabel(FocusableTip.getString("FocusHotkey"));
            object2 = UIManager.getColor("Label.disabledForeground");
            serializable = this.textArea.getFont();
            serializable = ((Font)serializable).deriveFont(((Font)serializable).getSize2D() - 1.0f);
            ((JComponent)container).setFont((Font)serializable);
            if (object2 == null) {
                object2 = Color.GRAY;
            }
            ((JComponent)container).setOpaque(true);
            object = TipUtil.getToolTipBackground();
            ((JComponent)container).setBackground((Color)object);
            ((JComponent)container).setForeground((Color)object2);
            ((JLabel)container).setHorizontalAlignment(11);
            ((JComponent)container).setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 5));
            jPanel.add(container);
            jPanel.addMouseListener(this.tipListener);
        }
        container = this.getContentPane();
        if (container.getComponentCount() == 2) {
            object2 = container.getComponent(0);
            container.remove(0);
            serializable = new JScrollPane((Component)object2);
            object = BorderFactory.createEmptyBorder();
            ((JComponent)serializable).setBorder((Border)object);
            ((JScrollPane)serializable).setViewportBorder((Border)object);
            ((JComponent)serializable).setBackground(this.textArea.getBackground());
            ((JScrollPane)serializable).getViewport().setBackground(this.textArea.getBackground());
            container.add((Component)serializable);
            container.getComponent(0).removeMouseListener(this.tipListener);
            container.remove(0);
        }
        container.add((Component)jPanel, "South");
    }

    public void setHyperlinkListener(HyperlinkListener hyperlinkListener) {
        if (this.userHyperlinkListener != null) {
            this.textArea.removeHyperlinkListener(this.userHyperlinkListener);
        }
        this.userHyperlinkListener = hyperlinkListener;
        if (this.userHyperlinkListener != null) {
            this.textArea.addHyperlinkListener(this.userHyperlinkListener);
        }
    }

    private class TipListener
    extends MouseAdapter {
        public void mousePressed(MouseEvent mouseEvent) {
            TipWindow.this.actionPerformed(null);
        }

        public void mouseExited(MouseEvent mouseEvent) {
            Component component = (Component)mouseEvent.getSource();
            Point point = mouseEvent.getPoint();
            SwingUtilities.convertPointToScreen(point, component);
            if (!TipWindow.this.getBounds().contains(point)) {
                TipWindow.this.ft.possiblyDisposeOfTipWindow();
            }
        }
    }
}

