/*
 * Decompiled with CFR 0.152.
 */
package org.fife.ui.rtextarea;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.event.ComponentEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import javax.swing.JTextArea;
import javax.swing.event.CaretEvent;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.TextUI;
import javax.swing.text.AbstractDocument;
import javax.swing.text.BadLocationException;
import javax.swing.text.StyleContext;
import org.fife.ui.rtextarea.BackgroundPainterStrategy;
import org.fife.ui.rtextarea.BufferedImageBackgroundPainterStrategy;
import org.fife.ui.rtextarea.ColorBackgroundPainterStrategy;
import org.fife.ui.rtextarea.ConfigurableCaret;
import org.fife.ui.rtextarea.ImageBackgroundPainterStrategy;
import org.fife.ui.rtextarea.RTextAreaUI;

abstract class RTextAreaBase
extends JTextArea {
    public static final String BACKGROUND_IMAGE_PROPERTY = "background.image";
    public static final String CURRENT_LINE_HIGHLIGHT_COLOR_PROPERTY = "RTA.currentLineHighlightColor";
    public static final String CURRENT_LINE_HIGHLIGHT_FADE_PROPERTY = "RTA.currentLineHighlightFade";
    public static final String HIGHLIGHT_CURRENT_LINE_PROPERTY = "RTA.currentLineHighlight";
    public static final String ROUNDED_SELECTION_PROPERTY = "RTA.roundedSelection";
    private boolean tabsEmulatedWithSpaces;
    private boolean highlightCurrentLine;
    private Color currentLineColor;
    private boolean marginLineEnabled;
    private Color marginLineColor;
    private int marginLineX;
    private int marginSizeInChars;
    private boolean fadeCurrentLineHighlight;
    private boolean roundedSelectionEdges;
    private int previousCaretY;
    int currentCaretY;
    private BackgroundPainterStrategy backgroundPainter;
    private RTAMouseListener mouseListener;
    private static final Color DEFAULT_CARET_COLOR = new ColorUIResource(255, 51, 51);
    private static final Color DEFAULT_CURRENT_LINE_HIGHLIGHT_COLOR = new Color(255, 255, 170);
    private static final Color DEFAULT_MARGIN_LINE_COLOR = new Color(255, 224, 224);
    private static final int DEFAULT_TAB_SIZE = 4;
    private static final int DEFAULT_MARGIN_LINE_POSITION = 80;

    public RTextAreaBase() {
        this.init();
    }

    public RTextAreaBase(AbstractDocument abstractDocument) {
        super(abstractDocument);
        this.init();
    }

    public RTextAreaBase(String string) {
        super(string);
        this.init();
    }

    public RTextAreaBase(int n, int n2) {
        super(n, n2);
        this.init();
    }

    public RTextAreaBase(String string, int n, int n2) {
        super(string, n, n2);
        this.init();
    }

    public RTextAreaBase(AbstractDocument abstractDocument, String string, int n, int n2) {
        super(abstractDocument, string, n, n2);
        this.init();
    }

    protected void addCurrentLineHighlightListeners() {
        boolean bl = true;
        MouseMotionListener[] mouseMotionListenerArray = this.getMouseMotionListeners();
        for (int i = 0; i < mouseMotionListenerArray.length; ++i) {
            if (mouseMotionListenerArray[i] != this.mouseListener) continue;
            bl = false;
            break;
        }
        if (bl) {
            this.addMouseMotionListener(this.mouseListener);
        }
        MouseListener[] mouseListenerArray = this.getMouseListeners();
        for (int i = 0; i < mouseListenerArray.length; ++i) {
            if (mouseListenerArray[i] != this.mouseListener) continue;
            bl = false;
            break;
        }
        if (bl) {
            this.addMouseListener(this.mouseListener);
        }
    }

    public void convertSpacesToTabs() {
        int n = this.getCaretPosition();
        int n2 = this.getTabSize();
        String string = "";
        for (int i = 0; i < n2; ++i) {
            string = string + " ";
        }
        String string2 = this.getText();
        this.setText(string2.replaceAll(string, "\t"));
        int n3 = this.getDocument().getLength();
        if (n < n3) {
            this.setCaretPosition(n);
        } else {
            this.setCaretPosition(n3 - 1);
        }
    }

    public void convertTabsToSpaces() {
        int n = this.getCaretPosition();
        int n2 = this.getTabSize();
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < n2; ++i) {
            stringBuffer.append(' ');
        }
        String string = this.getText();
        this.setText(string.replaceAll("\t", stringBuffer.toString()));
        this.setCaretPosition(n);
    }

    protected abstract RTAMouseListener createMouseListener();

    protected abstract RTextAreaUI createRTextAreaUI();

    protected void forceCurrentLineHighlightRepaint() {
        if (this.isShowing()) {
            this.previousCaretY = -1;
            this.fireCaretUpdate(this.mouseListener);
        }
    }

    public final Color getBackground() {
        Object object = this.getBackgroundObject();
        return object instanceof Color ? (Color)object : null;
    }

    public final Image getBackgroundImage() {
        Object object = this.getBackgroundObject();
        return object instanceof Image ? (Image)object : null;
    }

    public final Object getBackgroundObject() {
        if (this.backgroundPainter == null) {
            return null;
        }
        return this.backgroundPainter instanceof ImageBackgroundPainterStrategy ? ((ImageBackgroundPainterStrategy)this.backgroundPainter).getMasterImage() : ((ColorBackgroundPainterStrategy)this.backgroundPainter).getColor();
    }

    public final int getCaretLineNumber() {
        try {
            return this.getLineOfOffset(this.getCaretPosition());
        }
        catch (BadLocationException badLocationException) {
            return 0;
        }
    }

    public final int getCaretOffsetFromLineStart() {
        try {
            int n = this.getCaretPosition();
            return n - this.getLineStartOffset(this.getLineOfOffset(n));
        }
        catch (BadLocationException badLocationException) {
            return 0;
        }
    }

    public Color getCurrentLineHighlightColor() {
        return this.currentLineColor;
    }

    public static final Color getDefaultCaretColor() {
        return DEFAULT_CARET_COLOR;
    }

    public static final Color getDefaultCurrentLineHighlightColor() {
        return DEFAULT_CURRENT_LINE_HIGHLIGHT_COLOR;
    }

    public static final Font getDefaultFont() {
        StyleContext styleContext = StyleContext.getDefaultStyleContext();
        Font font = null;
        if (RTextAreaBase.isOSX()) {
            font = styleContext.getFont("Menlo", 0, 12);
            if (!"Menlo".equals(font.getFamily()) && !"Monaco".equals((font = styleContext.getFont("Monaco", 0, 12)).getFamily())) {
                font = styleContext.getFont("Monospaced", 0, 13);
            }
        } else {
            font = styleContext.getFont("Consolas", 0, 13);
            if (!"Consolas".equals(font.getFamily())) {
                font = styleContext.getFont("Monospaced", 0, 13);
            }
        }
        return font;
    }

    public static final Color getDefaultForeground() {
        return Color.BLACK;
    }

    public static final Color getDefaultMarginLineColor() {
        return DEFAULT_MARGIN_LINE_COLOR;
    }

    public static final int getDefaultMarginLinePosition() {
        return 80;
    }

    public static final int getDefaultTabSize() {
        return 4;
    }

    public boolean getFadeCurrentLineHighlight() {
        return this.fadeCurrentLineHighlight;
    }

    public boolean getHighlightCurrentLine() {
        return this.highlightCurrentLine;
    }

    public final int getLineEndOffsetOfCurrentLine() {
        try {
            return this.getLineEndOffset(this.getCaretLineNumber());
        }
        catch (BadLocationException badLocationException) {
            return 0;
        }
    }

    public int getLineHeight() {
        return this.getRowHeight();
    }

    public final int getLineStartOffsetOfCurrentLine() {
        try {
            return this.getLineStartOffset(this.getCaretLineNumber());
        }
        catch (BadLocationException badLocationException) {
            return 0;
        }
    }

    public Color getMarginLineColor() {
        return this.marginLineColor;
    }

    public int getMarginLinePixelLocation() {
        return this.marginLineX;
    }

    public int getMarginLinePosition() {
        return this.marginSizeInChars;
    }

    public boolean getRoundedSelectionEdges() {
        return this.roundedSelectionEdges;
    }

    public boolean getTabsEmulated() {
        return this.tabsEmulatedWithSpaces;
    }

    private void init() {
        this.setRTextAreaUI(this.createRTextAreaUI());
        this.enableEvents(9L);
        this.setHighlightCurrentLine(true);
        this.setCurrentLineHighlightColor(RTextAreaBase.getDefaultCurrentLineHighlightColor());
        this.setMarginLineEnabled(false);
        this.setMarginLineColor(RTextAreaBase.getDefaultMarginLineColor());
        this.setMarginLinePosition(RTextAreaBase.getDefaultMarginLinePosition());
        this.setBackgroundObject(Color.WHITE);
        this.setWrapStyleWord(true);
        this.setTabSize(5);
        this.setForeground(Color.BLACK);
        this.setTabsEmulated(false);
        this.previousCaretY = this.currentCaretY = this.getInsets().top;
        this.mouseListener = this.createMouseListener();
        this.addFocusListener(this.mouseListener);
        this.addCurrentLineHighlightListeners();
    }

    public boolean isMarginLineEnabled() {
        return this.marginLineEnabled;
    }

    public static boolean isOSX() {
        String string = System.getProperty("os.name").toLowerCase();
        return string.startsWith("mac os x");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void paintComponent(Graphics graphics) {
        this.backgroundPainter.paint(graphics, this.getVisibleRect());
        TextUI textUI = this.getUI();
        if (textUI != null) {
            Graphics graphics2 = graphics.create();
            try {
                textUI.update(graphics2, this);
            }
            finally {
                graphics2.dispose();
            }
        }
    }

    protected void possiblyUpdateCurrentLineHighlightLocation() {
        int n = this.getWidth();
        int n2 = this.getLineHeight();
        int n3 = this.getCaretPosition();
        if (this.getLineWrap()) {
            try {
                Rectangle rectangle = this.modelToView(n3);
                if (rectangle != null) {
                    this.currentCaretY = rectangle.y;
                }
            }
            catch (BadLocationException badLocationException) {
                badLocationException.printStackTrace();
            }
        } else {
            try {
                Rectangle rectangle = this.modelToView(n3);
                if (rectangle != null) {
                    this.currentCaretY = rectangle.y;
                }
            }
            catch (BadLocationException badLocationException) {
                badLocationException.printStackTrace();
            }
        }
        this.repaint(0, this.currentCaretY, n, n2);
        if (this.previousCaretY != this.currentCaretY) {
            this.repaint(0, this.previousCaretY, n, n2);
        }
        this.previousCaretY = this.currentCaretY;
    }

    protected void processComponentEvent(ComponentEvent componentEvent) {
        if (componentEvent.getID() == 101 && this.getLineWrap() && this.getHighlightCurrentLine()) {
            this.previousCaretY = -1;
            this.fireCaretUpdate(this.mouseListener);
        }
        super.processComponentEvent(componentEvent);
    }

    public void setBackground(Color color) {
        Object object = this.getBackgroundObject();
        if (object instanceof Color) {
            ((ColorBackgroundPainterStrategy)this.backgroundPainter).setColor(color);
        } else {
            this.backgroundPainter = new ColorBackgroundPainterStrategy(color);
        }
        this.setOpaque(true);
        this.firePropertyChange("background", object, color);
        this.repaint();
    }

    public void setBackgroundImage(Image image) {
        Object object = this.getBackgroundObject();
        if (object instanceof Image) {
            ((BufferedImageBackgroundPainterStrategy)this.backgroundPainter).setImage(image);
        } else {
            BufferedImageBackgroundPainterStrategy bufferedImageBackgroundPainterStrategy = new BufferedImageBackgroundPainterStrategy(this);
            bufferedImageBackgroundPainterStrategy.setImage(image);
            this.backgroundPainter = bufferedImageBackgroundPainterStrategy;
        }
        this.setOpaque(false);
        this.firePropertyChange(BACKGROUND_IMAGE_PROPERTY, object, image);
        this.repaint();
    }

    public void setBackgroundObject(Object object) {
        if (object instanceof Color) {
            this.setBackground((Color)object);
        } else if (object instanceof Image) {
            this.setBackgroundImage((Image)object);
        } else {
            this.setBackground(Color.WHITE);
        }
    }

    public void setCurrentLineHighlightColor(Color color) {
        if (color == null) {
            throw new NullPointerException();
        }
        if (!color.equals(this.currentLineColor)) {
            Color color2 = this.currentLineColor;
            this.currentLineColor = color;
            this.firePropertyChange(CURRENT_LINE_HIGHLIGHT_COLOR_PROPERTY, color2, color);
        }
    }

    public void setFadeCurrentLineHighlight(boolean bl) {
        if (bl != this.fadeCurrentLineHighlight) {
            this.fadeCurrentLineHighlight = bl;
            if (this.getHighlightCurrentLine()) {
                this.forceCurrentLineHighlightRepaint();
            }
            this.firePropertyChange(CURRENT_LINE_HIGHLIGHT_FADE_PROPERTY, !bl, bl);
        }
    }

    public void setFont(Font font) {
        super.setFont(font);
        this.updateMarginLineX();
        if (this.highlightCurrentLine) {
            this.possiblyUpdateCurrentLineHighlightLocation();
        }
    }

    public void setHighlightCurrentLine(boolean bl) {
        if (bl != this.highlightCurrentLine) {
            this.highlightCurrentLine = bl;
            this.firePropertyChange(HIGHLIGHT_CURRENT_LINE_PROPERTY, !bl, bl);
            this.repaint();
        }
    }

    public void setLineWrap(boolean bl) {
        super.setLineWrap(bl);
        this.forceCurrentLineHighlightRepaint();
    }

    public void setMarginLineColor(Color color) {
        this.marginLineColor = color;
        if (this.marginLineEnabled) {
            Rectangle rectangle = this.getVisibleRect();
            this.repaint(this.marginLineX, rectangle.y, 1, rectangle.height);
        }
    }

    public void setMarginLineEnabled(boolean bl) {
        if (bl != this.marginLineEnabled) {
            this.marginLineEnabled = bl;
            if (this.marginLineEnabled) {
                Rectangle rectangle = this.getVisibleRect();
                this.repaint(this.marginLineX, rectangle.y, 1, rectangle.height);
            }
        }
    }

    public void setMarginLinePosition(int n) {
        this.marginSizeInChars = n;
        if (this.marginLineEnabled) {
            Rectangle rectangle = this.getVisibleRect();
            this.repaint(this.marginLineX, rectangle.y, 1, rectangle.height);
            this.updateMarginLineX();
            this.repaint(this.marginLineX, rectangle.y, 1, rectangle.height);
        }
    }

    public void setRoundedSelectionEdges(boolean bl) {
        if (this.roundedSelectionEdges != bl) {
            this.roundedSelectionEdges = bl;
            ConfigurableCaret configurableCaret = (ConfigurableCaret)this.getCaret();
            configurableCaret.setRoundedSelectionEdges(bl);
            if (configurableCaret.getDot() != configurableCaret.getMark()) {
                this.repaint();
            }
            this.firePropertyChange(ROUNDED_SELECTION_PROPERTY, !bl, bl);
        }
    }

    protected void setRTextAreaUI(RTextAreaUI rTextAreaUI) {
        super.setUI(rTextAreaUI);
        this.setOpaque(this.getBackgroundObject() instanceof Color);
    }

    public void setTabsEmulated(boolean bl) {
        this.tabsEmulatedWithSpaces = bl;
    }

    public void setTabSize(int n) {
        super.setTabSize(n);
        boolean bl = this.getLineWrap();
        this.setLineWrap(!bl);
        this.setLineWrap(bl);
    }

    protected void updateMarginLineX() {
        this.marginLineX = this.getFontMetrics(this.getFont()).charWidth('m') * this.marginSizeInChars;
    }

    public int yForLine(int n) throws BadLocationException {
        return ((RTextAreaUI)this.getUI()).yForLine(n);
    }

    public int yForLineContaining(int n) throws BadLocationException {
        return ((RTextAreaUI)this.getUI()).yForLineContaining(n);
    }

    protected class RTAMouseListener
    extends CaretEvent
    implements MouseListener,
    MouseMotionListener,
    FocusListener {
        protected int dot;
        protected int mark;

        RTAMouseListener(RTextAreaBase rTextAreaBase2) {
            super(rTextAreaBase2);
        }

        public void focusGained(FocusEvent focusEvent) {
        }

        public void focusLost(FocusEvent focusEvent) {
        }

        public void mouseDragged(MouseEvent mouseEvent) {
        }

        public void mouseMoved(MouseEvent mouseEvent) {
        }

        public void mouseClicked(MouseEvent mouseEvent) {
        }

        public void mousePressed(MouseEvent mouseEvent) {
        }

        public void mouseReleased(MouseEvent mouseEvent) {
        }

        public void mouseEntered(MouseEvent mouseEvent) {
        }

        public void mouseExited(MouseEvent mouseEvent) {
        }

        public int getDot() {
            return this.dot;
        }

        public int getMark() {
            return this.mark;
        }
    }
}

