/*
 * Decompiled with CFR 0.152.
 */
package flatgui.controlcenter.view;

import flatgui.controlcenter.IFGStateProvider;
import flatgui.controlcenter.view.ComponentDetailsPanel;
import flatgui.controlcenter.view.ContainerTreePanel;
import flatgui.controlcenter.view.IControlCenterPanel;
import flatgui.controlcenter.view.TreeTableRelation;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JSplitPane;
import javax.swing.JToolBar;
import javax.swing.border.TitledBorder;

public class ControlCenterFrame
extends JFrame {
    private JToolBar toolBar_;
    private JSplitPane splitPane_;
    private IFGStateProvider fgStateProvider_;
    private Map<String, IControlCenterPanel> panels_;

    public ControlCenterFrame(IFGStateProvider iFGStateProvider) {
        super("FlatGUI Control Center");
        this.fgStateProvider_ = iFGStateProvider;
        this.prepare();
    }

    private void prepare() {
        this.setLayout(new BorderLayout());
        this.toolBar_ = new JToolBar();
        this.splitPane_ = new JSplitPane();
        this.splitPane_.setDividerLocation(300);
        this.add((Component)this.toolBar_, "North");
        this.add((Component)this.splitPane_, "Center");
        this.panels_ = this.createPanels();
        this.placePanels();
        this.setupPanelToolButtons();
    }

    private Map<String, IControlCenterPanel> createPanels() {
        LinkedHashMap<String, IControlCenterPanel> linkedHashMap = new LinkedHashMap<String, IControlCenterPanel>();
        ContainerTreePanel containerTreePanel = new ContainerTreePanel(this.fgStateProvider_);
        linkedHashMap.put(containerTreePanel.getName(), containerTreePanel);
        ComponentDetailsPanel componentDetailsPanel = new ComponentDetailsPanel();
        linkedHashMap.put(componentDetailsPanel.getName(), componentDetailsPanel);
        TreeTableRelation.setup(containerTreePanel, componentDetailsPanel);
        return linkedHashMap;
    }

    private void placePanels() {
        IControlCenterPanel iControlCenterPanel = this.panels_.get("Container");
        IControlCenterPanel iControlCenterPanel2 = this.panels_.get("Component Details");
        this.splitPane_.setLeftComponent(this.createPanelComponent(iControlCenterPanel));
        this.splitPane_.setRightComponent(this.createPanelComponent(iControlCenterPanel2));
    }

    private JComponent createPanelComponent(IControlCenterPanel iControlCenterPanel) {
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.add((Component)iControlCenterPanel.getContentComponent(), "Center");
        jPanel.setBorder(new TitledBorder(iControlCenterPanel.getName()));
        return jPanel;
    }

    private void setupPanelToolButtons() {
        for (IControlCenterPanel iControlCenterPanel : this.panels_.values()) {
            JButton[] jButtonArray;
            if (this.toolBar_.getComponentCount() > 0) {
                this.toolBar_.add(new JSeparator(1));
            }
            for (JButton jButton : jButtonArray = iControlCenterPanel.getToolButtons()) {
                this.toolBar_.add(jButton);
            }
        }
    }
}

