/*
 * Decompiled with CFR 0.152.
 */
package flatgui.core.engine;

import clojure.lang.IPersistentMap;
import clojure.lang.Keyword;
import clojure.lang.PersistentHashMap;
import clojure.lang.PersistentVector;
import flatgui.core.IFGEvolveConsumer;
import flatgui.core.engine.EvolvingNode;
import flatgui.core.engine.GetPropertyDelegate;
import flatgui.core.engine.IResultCollector;
import flatgui.core.engine.Node;
import flatgui.util.CompactList;
import flatgui.util.ObjectMatrix;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;

public class Container {
    private final IResultCollector resultCollector_;
    private final Set<Integer> vacantComponentIndices_;
    private final Set<Integer> vacantNodeIndices_;
    private final ObjectMatrix<Object> keys_ = new ObjectMatrix();
    private final List<ComponentAccessor> components_;
    private final Map<List<Object>, Integer> componentPathToIndex_;
    private final List<Node> nodes_;
    private final List<Node> nodesWithAmbiguousDependencies_;
    private final List<Object> values_;
    private final Map<List<Object>, Integer> pathToIndex_;
    private final IContainerAccessor containerAccessor_;
    private final IPropertyValueAccessor propertyValueAccessor_;
    private final IContainerMutator containerMutator_;
    private final IEvolverAccess evolverAccess_;
    private final IContainerParser containerParser_;
    private Node[] reusableNodeBuffer_;
    private Object[] reusableReasonBuffer_;
    private int indexBufferSize_;
    private int currentCycleBufIndex_;
    private Map<Integer, Map<Object, Object>> nodeIndexToComponentCopyForConsumers_;
    private Set<Integer> initializedNodes_;
    private final HashMap<Integer, GetPropertyDelegate> delegateByIdMap_;
    private final HashMap<Integer, Map<List<Object>, GetPropertyDelegate>> delegateByIdAndPathMap_;
    private final HashMap<Integer, Map<Keyword, GetPropertyDelegate>> delegateByIdAndPropertyMap_;
    private final HashMap<Integer, Map<List<Object>, Map<Keyword, GetPropertyDelegate>>> delegateByIdPathAndPropertyMap_;
    public static boolean debug_ = false;

    public Container(IContainerParser iContainerParser, IResultCollector iResultCollector, Map<Object, Object> map) {
        this.containerParser_ = iContainerParser;
        this.containerParser_.setKeyMatrix(this.keys_);
        this.resultCollector_ = iResultCollector;
        this.components_ = new ArrayList<ComponentAccessor>();
        this.componentPathToIndex_ = new HashMap<List<Object>, Integer>();
        this.vacantComponentIndices_ = new HashSet<Integer>();
        this.vacantNodeIndices_ = new HashSet<Integer>();
        this.nodes_ = new ArrayList<Node>();
        this.nodesWithAmbiguousDependencies_ = new ArrayList<Node>();
        this.values_ = new ArrayList<Object>();
        this.pathToIndex_ = new HashMap<List<Object>, Integer>();
        this.nodeIndexToComponentCopyForConsumers_ = new LinkedHashMap<Integer, Map<Object, Object>>();
        this.delegateByIdMap_ = new HashMap();
        this.delegateByIdAndPathMap_ = new HashMap();
        this.delegateByIdAndPropertyMap_ = new HashMap();
        this.delegateByIdPathAndPropertyMap_ = new HashMap();
        this.reusableNodeBuffer_ = new Node[0x100000];
        this.reusableReasonBuffer_ = new Object[0x100000];
        this.indexBufferSize_ = 0;
        this.containerAccessor_ = this.components_::get;
        this.propertyValueAccessor_ = this::getPropertyValue;
        this.evolverAccess_ = new IEvolverAccess(){

            @Override
            public Integer indexOfPath(List<Object> list) {
                return Container.this.indexOfPath(list);
            }

            @Override
            public Object getPropertyValue(Integer n) {
                return Container.this.getPropertyValue(n);
            }

            @Override
            public Map<Integer, GetPropertyDelegate> getDelegateByIdMap() {
                return Container.this.delegateByIdMap_;
            }

            @Override
            public Map<Integer, Map<List<Object>, GetPropertyDelegate>> getDelegateByIdAndPathMap() {
                return Container.this.delegateByIdAndPathMap_;
            }

            @Override
            public Map<Integer, Map<Keyword, GetPropertyDelegate>> getDelegateByIdAndPropertyMap() {
                return Container.this.delegateByIdAndPropertyMap_;
            }

            @Override
            public Map<Integer, Map<List<Object>, Map<Keyword, GetPropertyDelegate>>> getDelegateByIdPathAndPropertyMap() {
                return Container.this.delegateByIdPathAndPropertyMap_;
            }

            @Override
            public ObjectMatrix<Object> getKeyMatrix() {
                return Container.this.keys_;
            }
        };
        this.containerMutator_ = (n, object) -> this.values_.set(n, object);
        this.addContainer(null, Collections.emptyList(), map, null);
        this.finishContainerIndexing();
        this.initializeContainer();
    }

    public Integer addComponent(Integer n, List<Object> list, ComponentAccessor componentAccessor) {
        return this.addComponentImpl(n, list, componentAccessor);
    }

    public Integer indexOfPath(List<Object> list) {
        return this.pathToIndex_.get(list);
    }

    public Integer indexOfPathStrict(List<Object> list) {
        Integer n = this.pathToIndex_.get(list);
        return n;
    }

    public void evolve(List<Object> list, Object object) {
        Integer n = this.getComponentUid(list);
        if (n == null) {
            throw new IllegalArgumentException("Component path does not exist: " + list);
        }
        this.evolve(n, object);
    }

    public void evolve(Integer n, Object object) {
        long l = System.currentTimeMillis();
        this.indexBufferSize_ = 0;
        if (debug_) {
            Container.logDebug("----------------Started evolve cycle ---- for reason: " + Container.valueToString(object));
        }
        ComponentAccessor componentAccessor = this.components_.get(n);
        Map<Object, Integer> map = componentAccessor.getPropertyIdToIndex();
        for (Object object3 : map.keySet()) {
            Integer object22 = map.get(object3);
            Node node = this.nodes_.get(object22);
            if (object != null && (node.getEvolver() == null || !this.containerParser_.isInterestedIn(node.getInputDependencies(), object.getClass()))) continue;
            this.addNodeToReusableBuffer(node, object);
        }
        for (int i = 0; i < this.indexBufferSize_; ++i) {
            if (!debug_) continue;
            Container.logDebug(" Initial component: " + this.reusableNodeBuffer_[i].getNodePath());
        }
        HashSet<Integer> hashSet = new HashSet<Integer>();
        this.currentCycleBufIndex_ = 0;
        this.nodeIndexToComponentCopyForConsumers_.clear();
        while (this.currentCycleBufIndex_ < this.indexBufferSize_) {
            Object object3;
            object3 = this.reusableNodeBuffer_[this.currentCycleBufIndex_];
            if (object3 == null) {
                ++this.currentCycleBufIndex_;
                continue;
            }
            Object object2 = this.reusableReasonBuffer_[this.currentCycleBufIndex_];
            int n2 = ((Node)object3).getNodeIndex();
            Function<Map<Object, Object>, Object> function = ((Node)object3).getEvolver();
            if (object2 != null || this.initializedNodes_ != null && !this.initializedNodes_.contains(n2)) {
                AbstractCollection abstractCollection;
                Map<Object, Object> map2;
                Object object42;
                Map map3;
                IPersistentMap iPersistentMap;
                Object object5;
                ComponentAccessor componentAccessor2 = this.components_.get(((Node)object3).getComponentUid());
                if (object2 == null) {
                    if (function == null) {
                        object5 = null;
                        iPersistentMap = this.values_.get(n2);
                    } else {
                        componentAccessor2.setEvolveReason(null);
                        object5 = this.values_.get(n2);
                        try {
                            iPersistentMap = function.apply(componentAccessor2);
                        }
                        catch (Exception exception) {
                            Container.logError(" Error evolving " + ((Node)object3).getNodePath() + " " + ((Node)object3).getPropertyId() + " while initializing ");
                            exception.printStackTrace();
                            throw exception;
                        }
                    }
                } else {
                    componentAccessor2.setEvolveReason(object2);
                    object5 = this.values_.get(n2);
                    try {
                        iPersistentMap = function.apply(componentAccessor2);
                    }
                    catch (Exception exception) {
                        Container.logError(" Error evolving " + ((Node)object3).getNodePath() + " " + ((Node)object3).getPropertyId() + " for reason: " + object2);
                        exception.printStackTrace();
                        throw exception;
                    }
                }
                boolean bl = this.initializedNodes_ != null && !this.initializedNodes_.contains(n2);
                HashSet<Object> hashSet2 = null;
                HashSet<AbstractCollection> hashSet3 = null;
                HashSet<AbstractCollection> hashSet4 = null;
                if (((Node)object3).isChildrenProperty()) {
                    hashSet2 = new HashSet<Object>();
                    hashSet3 = new HashSet<AbstractCollection>();
                    hashSet4 = new HashSet<AbstractCollection>();
                    map3 = (Map)iPersistentMap;
                    if (map3 == null) {
                        map3 = Collections.emptyMap();
                    }
                    iPersistentMap = new HashMap();
                    for (Object object42 : map3.keySet()) {
                        if (object42.toString().contains("_flex")) continue;
                        ((Map)iPersistentMap).put(object42, map3.get(object42));
                    }
                    iPersistentMap = PersistentHashMap.create((Map)((Map)iPersistentMap));
                    map2 = (Map<Object, Object>)object5;
                    object42 = map2 != null ? map2 : Collections.emptyMap();
                    abstractCollection = new HashSet();
                    abstractCollection.addAll(object42.keySet());
                    abstractCollection.addAll(((Map)iPersistentMap).keySet());
                    for (AbstractCollection abstractCollection2 : abstractCollection) {
                        if (!object42.containsKey(abstractCollection2)) {
                            hashSet4.add(abstractCollection2);
                            continue;
                        }
                        if (!((Map)iPersistentMap).containsKey(abstractCollection2)) {
                            hashSet2.add(abstractCollection2);
                            continue;
                        }
                        if (((Map)object42.get(abstractCollection2)).equals(((Map)iPersistentMap).get(abstractCollection2))) continue;
                        hashSet3.add(abstractCollection2);
                    }
                    if (!bl) {
                        bl = hashSet4.size() > 0 || hashSet2.size() > 0 || hashSet3.size() > 0;
                    }
                } else {
                    if (!bl) {
                        bl = !Objects.equals(object5, iPersistentMap);
                    }
                }
                if (bl) {
                    AbstractCollection abstractCollection2;
                    if (debug_) {
                        Container.logDebug(" Evolved: " + n2 + " " + ((Node)object3).getNodePath() + " for reason: " + Container.valueToString(object2) + ": " + Container.valueToString(object5) + " -> " + Container.valueToString(iPersistentMap));
                    }
                    this.containerMutator_.setValue(n2, iPersistentMap);
                    map3 = ((Node)object3).getEvolveConsumers();
                    if (map3 != null) {
                        map2 = this.nodeIndexToComponentCopyForConsumers_.get(((Node)object3).getNodeIndex());
                        if (map2 == null) {
                            map2 = new HashMap<Object, Object>();
                            this.nodeIndexToComponentCopyForConsumers_.put(((Node)object3).getNodeIndex(), map2);
                        }
                        map2.put(((Node)object3).getPropertyId(), iPersistentMap);
                    }
                    map2 = componentAccessor2.getComponentPath();
                    this.addNodeDependentsToEvolvebuffer((Node)object3);
                    if (object2 != null && ((Node)object3).isChildrenProperty()) {
                        Object object62;
                        if (debug_) {
                            Container.logDebug(" Detected children change");
                        }
                        object42 = (Map)iPersistentMap;
                        abstractCollection = new HashSet<AbstractCollection>(hashSet2);
                        abstractCollection.addAll(hashSet3);
                        HashSet<AbstractCollection> hashSet5 = new HashSet<AbstractCollection>(hashSet4);
                        hashSet5.addAll(hashSet3);
                        if (debug_) {
                            Container.logDebug(" Removing " + hashSet2.size() + " removed and " + hashSet3.size() + " changed children...");
                        }
                        abstractCollection2 = new HashSet(abstractCollection.size());
                        for (Object object62 : abstractCollection) {
                            CompactList compactList = new CompactList(this.keys_, map2);
                            compactList.add(object62);
                            Integer n3 = this.getComponentUid(compactList);
                            this.removeComponent(n3);
                            abstractCollection2.add(n3);
                            hashSet.remove(n3);
                        }
                        if (debug_) {
                            Container.logDebug(" Adding " + hashSet3.size() + " changed and " + hashSet4.size() + " added children...");
                        }
                        HashSet hashSet6 = new HashSet(hashSet5.size());
                        object62 = new HashMap();
                        hashSet5.forEach(arg_0 -> this.lambda$evolve$1((Map)object42, object3, componentAccessor2, hashSet, hashSet6, object62, arg_0));
                        componentAccessor2.removeChildIndices(abstractCollection2, hashSet2);
                        componentAccessor2.addChildIndices(hashSet6, (Map<Object, Integer>)object62);
                    }
                    if (((Node)object3).isChildOrderProperty() && iPersistentMap != null) {
                        object42 = (List)iPersistentMap;
                        abstractCollection = new ArrayList(object42.size());
                        for (int i = 0; i < object42.size(); ++i) {
                            abstractCollection2 = new CompactList(this.keys_, map2);
                            abstractCollection2.add(object42.get(i));
                            abstractCollection.add(this.getComponentUid((List<Object>)((Object)abstractCollection2)));
                        }
                        componentAccessor2.changeChildIndicesOrder(abstractCollection);
                    }
                    this.resultCollector_.appendResult(((Node)object3).getParentComponentUid(), (List<Object>)((Object)map2), (Node)object3, iPersistentMap);
                } else if (debug_) {
                    Container.logDebug(" Evolved: " + n2 + " " + ((Node)object3).getNodePath() + " for reason: " + Container.valueToString(object2) + ": no change (" + object5 + ").");
                }
                if (this.initializedNodes_ != null) {
                    this.initializedNodes_.add(n2);
                }
            }
            ++this.currentCycleBufIndex_;
        }
        this.resultCollector_.postProcessAfterEvolveCycle(this.containerAccessor_, this.containerMutator_);
        this.notifyEvolverConsumers();
        if (debug_) {
            Container.logDebug("---Ended evolve cycle");
        }
        if (!hashSet.isEmpty()) {
            boolean bl;
            this.processAllNodesOfComponents(hashSet, this::setupEvolversForNode);
            this.processAllNodesOfComponents(hashSet, this::resolveDependencyIndicesForNode);
            this.processAllNodesOfComponents(hashSet, this::markNodeAsDependent);
            for (Node node : this.nodesWithAmbiguousDependencies_) {
                Collection<Node.Dependency> collection = node.reevaluateAmbiguousDependencies(this.components_, this.containerParser_::isWildcardPathElement);
                this.markNodeAsDependent(node, collection);
            }
            boolean bl2 = bl = this.initializedNodes_ == null;
            if (bl) {
                this.initializedNodes_ = new HashSet<Integer>();
            }
            hashSet.forEach(this::initializeAddedComponent);
            if (bl) {
                this.initializedNodes_.clear();
                this.initializedNodes_ = null;
            }
        }
        long l2 = System.currentTimeMillis() - l;
    }

    public boolean isInterestedIn(Integer n, Object object) {
        if (object == null) {
            throw new IllegalArgumentException();
        }
        ComponentAccessor componentAccessor = this.components_.get(n);
        Map<Object, Integer> map = componentAccessor.getPropertyIdToIndex();
        for (Object object2 : map.keySet()) {
            Integer n2 = map.get(object2);
            Node node = this.nodes_.get(n2);
            if (node.getEvolver() == null || !this.containerParser_.isInterestedIn(node.getInputDependencies(), object.getClass())) continue;
            return true;
        }
        return false;
    }

    public IContainerAccessor getContainerAccessor() {
        return this.containerAccessor_;
    }

    public IPropertyValueAccessor getPropertyValueAccessor() {
        return this.propertyValueAccessor_;
    }

    public final Integer getComponentUid(List<Object> list) {
        return this.componentPathToIndex_.get(list);
    }

    public IComponent getRootComponent() {
        return this.components_.get(0);
    }

    public IComponent getComponent(Integer n) {
        return this.components_.get(n);
    }

    public Node getNode(Integer n) {
        return this.nodes_.get(n);
    }

    public int getNodeCount() {
        return this.nodes_.size();
    }

    public <V> V getPropertyValue(Integer n) {
        return (V)(n != null ? this.values_.get(n) : null);
    }

    public IResultCollector getResultCollector() {
        return this.resultCollector_;
    }

    public Collection<List<Object>> getAllIdPaths() {
        return Collections.unmodifiableSet(this.pathToIndex_.keySet());
    }

    public void addEvolveConsumer(IFGEvolveConsumer iFGEvolveConsumer) {
        List<Object> list = iFGEvolveConsumer.getTargetPath();
        Collection<Object> collection = iFGEvolveConsumer.getTargetProperties();
        for (Object object : collection) {
            CompactList<Object, ObjectMatrix<Object>> compactList = new CompactList<Object, ObjectMatrix<Object>>(this.keys_, list);
            compactList.add(object);
            Integer n = this.pathToIndex_.get(compactList);
            if (n != null) {
                this.nodes_.get(n).addEvolveConsumer(iFGEvolveConsumer);
                continue;
            }
            System.out.println("Error: node for " + list + "/" + object + " is not found.");
        }
    }

    private Integer addComponentImpl(Integer n, List<Object> list, ComponentAccessor componentAccessor) {
        Integer n2;
        if (this.vacantComponentIndices_.isEmpty()) {
            n2 = this.components_.size();
            this.components_.add(n2, componentAccessor);
        } else {
            n2 = (Integer)this.vacantComponentIndices_.stream().findAny().get();
            this.vacantComponentIndices_.remove(n2);
            this.components_.set(n2, componentAccessor);
        }
        this.componentPathToIndex_.put(list, n2);
        this.resultCollector_.componentAdded(n, n2);
        return n2;
    }

    private void removeComponent(Integer n2) {
        if (n2 >= this.components_.size()) {
            throw new IllegalArgumentException("Component does not exist: " + n2);
        }
        ComponentAccessor componentAccessor = this.components_.get(n2);
        if (componentAccessor == null) {
            throw new IllegalArgumentException("Component already removed: " + n2);
        }
        Collection<Integer> collection = componentAccessor.getPropertyIndices();
        collection.forEach(n -> {
            this.vacantNodeIndices_.add((Integer)n);
            Node node = this.nodes_.set((int)n, (Node)null);
            this.nodesWithAmbiguousDependencies_.remove(node);
            this.values_.set((int)n, null);
            this.pathToIndex_.remove(node.getNodePath());
            this.unMarkNodeAsDependent(node, node.getDependencyIndices());
            for (Integer n2 : node.getDependentIndices().keySet()) {
                Node node2 = this.nodes_.get(n2);
                if (node2 == null) continue;
                node2.forgetDependency((Integer)n);
            }
            if (this.initializedNodes_ != null) {
                this.initializedNodes_.remove(n);
            }
            for (int i = this.currentCycleBufIndex_; i < this.indexBufferSize_; ++i) {
                if (this.reusableNodeBuffer_[i] != node) continue;
                this.reusableNodeBuffer_[i] = null;
            }
        });
        this.components_.set(n2, null);
        this.componentPathToIndex_.remove(componentAccessor.getComponentPath());
        this.vacantComponentIndices_.add(n2);
        this.resultCollector_.componentRemoved(n2);
        List<Integer> list = componentAccessor.getChildIndices();
        if (list != null) {
            list.forEach(this::removeComponent);
        }
    }

    private Integer addContainer(Integer n, List<Object> list2, Map<Object, Object> map, Collection<Integer> collection) {
        Serializable serializable;
        CompactList<Object, ObjectMatrix<Object>> compactList = new CompactList<Object, ObjectMatrix<Object>>(this.keys_, list2);
        compactList.add(this.containerParser_.getComponentId(map));
        ComponentAccessor componentAccessor = new ComponentAccessor(compactList, this.values_, list -> this.getPropertyValue(this.indexOfPathStrict((List<Object>)list)));
        Integer n2 = this.addComponent(n, compactList, componentAccessor);
        componentAccessor.setComponentUid(n2);
        if (collection != null) {
            collection.add(n2);
        }
        if (debug_) {
            Container.logDebug("Added and indexed component " + compactList + ": " + n2);
        }
        Collection<SourceNode> collection2 = this.containerParser_.processComponent(compactList, map);
        for (SourceNode object : collection2) {
            serializable = this.addNode(n, n2, object, map.get(object.getPropertyId()));
            if (debug_) {
                Container.logDebug("Indexing " + compactList + " node " + object.getNodePath() + ": " + serializable);
            }
            componentAccessor.putPropertyIndex(object.getPropertyId(), (Integer)serializable);
        }
        this.containerParser_.processComponentAfterIndexing(componentAccessor);
        Map map2 = (Map)map.get(this.containerParser_.getChildrenPropertyName());
        if (map2 != null) {
            ArrayList<Integer> arrayList = new ArrayList<Integer>(map2.size());
            serializable = new HashMap();
            for (Map map3 : map2.values()) {
                Object object = this.containerParser_.getComponentId(map3);
                Integer n3 = this.addContainer(n2, compactList, map3, collection);
                arrayList.add(n3);
                serializable.put(object, n3);
            }
            componentAccessor.setChildIndices(arrayList, (Map<Object, Integer>)((Object)serializable));
        }
        return n2;
    }

    private void processAllNodesOfComponents(Collection<Integer> collection, Consumer<Node> consumer) {
        for (Integer n : collection) {
            ComponentAccessor componentAccessor = this.components_.get(n);
            Map<Object, Integer> map = componentAccessor.getPropertyIdToIndex();
            for (Object object : map.keySet()) {
                Integer n2 = map.get(object);
                Node node = this.nodes_.get(n2);
                consumer.accept(node);
            }
        }
    }

    private void initializeAddedComponent(Integer n) {
        ComponentAccessor componentAccessor = this.components_.get(n);
        if (componentAccessor == null) {
            return;
        }
        this.evolve(n, null);
    }

    private List<Object> dropLast(List<Object> list) {
        CompactList<Object, ObjectMatrix<Object>> compactList = new CompactList<Object, ObjectMatrix<Object>>(this.keys_, list);
        compactList.remove(compactList.size() - 1);
        return compactList;
    }

    private void setupEvolversForNode(Node node) {
    }

    private void resolveDependencyIndicesForNode(Node node) {
        node.resolveDependencyIndices(this.components_, this.containerParser_::isWildcardPathElement);
    }

    private void markNodeAsDependent(Node node) {
        this.markNodeAsDependent(node, node.getDependencyIndices());
    }

    private void markNodeAsDependent(Node node, Collection<Node.Dependency> collection) {
        collection.forEach(dependency2 -> this.nodes_.get(dependency2.getNodeIndex()).addDependent(node.getNodeIndex(), node.getNodePath(), dependency2.getRelPath(), this.keys_));
    }

    private void unMarkNodeAsDependent(Node node, Collection<Node.Dependency> collection) {
        collection.forEach(dependency2 -> {
            Node node2 = this.nodes_.get(dependency2.getNodeIndex());
            if (node2 != null) {
                node2.removeDependent(node.getNodeIndex());
            }
        });
    }

    private void finishContainerIndexing() {
        this.nodes_.forEach(this::setupEvolversForNode);
        this.nodes_.forEach(this::resolveDependencyIndicesForNode);
        this.nodes_.forEach(this::markNodeAsDependent);
    }

    private Integer addNode(Integer n, Integer n2, SourceNode sourceNode, Object object) {
        Integer n3;
        if (this.vacantNodeIndices_.isEmpty()) {
            n3 = this.nodes_.size();
        } else {
            n3 = (Integer)this.vacantNodeIndices_.stream().findAny().get();
            this.vacantNodeIndices_.remove(n3);
        }
        Node node = sourceNode.getEvolverCode() != null ? new EvolvingNode(n2, n != null ? n : -1, sourceNode, n3, this.evolverAccess_) : new Node(n2, n != null ? n : -1, sourceNode, n3);
        int n4 = n3;
        if (n3 < this.nodes_.size()) {
            this.nodes_.set(n4, node);
            this.values_.set(n4, object);
        } else {
            this.nodes_.add(node);
            this.values_.add(object);
            if (node.isHasAmbiguousDependencies()) {
                this.nodesWithAmbiguousDependencies_.add(node);
            }
        }
        this.pathToIndex_.put(sourceNode.getNodePath(), n3);
        return n3;
    }

    private void addNodeToReusableBuffer(Node node, Object object) {
        this.ensureIndexBufferSize(this.indexBufferSize_ + 1);
        this.reusableNodeBuffer_[this.indexBufferSize_] = node;
        this.reusableReasonBuffer_[this.indexBufferSize_] = object;
        ++this.indexBufferSize_;
    }

    private void addNodeDependentsToEvolvebuffer(Node node) {
        Map<Integer, List<Object>> map = node.getDependentIndices();
        int n = map.size();
        this.ensureIndexBufferSize(this.indexBufferSize_ + n);
        for (Integer n2 : map.keySet()) {
            Node node2 = this.nodes_.get(n2);
            PersistentVector persistentVector = new CompactList(this.keys_, map.get(n2));
            persistentVector.remove(persistentVector.size() - 1);
            persistentVector = PersistentVector.create(persistentVector);
            this.reusableNodeBuffer_[this.indexBufferSize_] = node2;
            this.reusableReasonBuffer_[this.indexBufferSize_] = persistentVector;
            if (debug_) {
                Container.logDebug("    Triggered dependent: " + node2.getNodePath() + " referenced as " + persistentVector);
            }
            ++this.indexBufferSize_;
        }
    }

    private void ensureIndexBufferSize(int n) {
        if (n >= this.reusableNodeBuffer_.length) {
            this.reusableNodeBuffer_ = Container.ensureBufferSize(this.reusableNodeBuffer_, n);
            this.reusableReasonBuffer_ = Container.ensureBufferSize(this.reusableReasonBuffer_, n);
        }
    }

    private static <T> T[] ensureBufferSize(T[] TArray, int n) {
        if (n >= TArray.length) {
            Object[] objectArray = (Object[])Array.newInstance(TArray.getClass().getComponentType(), TArray.length + 128);
            System.arraycopy(TArray, 0, objectArray, 0, TArray.length);
            return objectArray;
        }
        return TArray;
    }

    private void initializeContainer() {
        this.initializedNodes_ = new HashSet<Integer>();
        if (debug_) {
            Container.logDebug("========================Started initialization cycle================================");
        }
        ArrayList<ComponentAccessor> arrayList = new ArrayList<ComponentAccessor>(this.components_);
        for (int i = 0; i < arrayList.size(); ++i) {
            this.evolve(i, null);
        }
        if (debug_) {
            Container.logDebug("=====Ended initialization cycle");
        }
        this.initializedNodes_.clear();
        this.initializedNodes_ = null;
    }

    static void logDebug(String string) {
        if (debug_) {
            System.out.println("[FG Eng]: " + string);
        }
    }

    static void logError(String string) {
        System.out.println("[FG Eng Error]: " + string);
    }

    static String valueToString(Object object) {
        if (object != null) {
            String string = object.toString();
            if (string.length() > 100) {
                return string.substring(0, 100) + "...";
            }
            return string;
        }
        return null;
    }

    private boolean pathMatches(List<Object> list, List<Object> list2) {
        if (list.size() == list2.size()) {
            for (int i = 0; i < list.size(); ++i) {
                Object object = list.get(i);
                if (object.equals(list2.get(i)) || this.containerParser_.isWildcardPathElement(object)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private void notifyEvolverConsumers() {
        for (Integer n : this.nodeIndexToComponentCopyForConsumers_.keySet()) {
            Node node = this.nodes_.get(n);
            for (IFGEvolveConsumer iFGEvolveConsumer : node.getEvolveConsumers()) {
                Map<Object, Object> map = this.nodeIndexToComponentCopyForConsumers_.get(n);
                Thread thread = new Thread(() -> iFGEvolveConsumer.acceptEvolveResult(null, map), "FlatGUI Evolver Consumer Notifier");
                thread.start();
            }
        }
        this.nodeIndexToComponentCopyForConsumers_.clear();
    }

    private /* synthetic */ void lambda$evolve$1(Map map, Node node, ComponentAccessor componentAccessor, Set set, Set set2, Map map2, Object object) {
        Map map3 = (Map)map.get(object);
        HashSet<Integer> hashSet = new HashSet<Integer>();
        Integer n = this.addContainer(node.getComponentUid(), componentAccessor.getComponentPath(), map3, hashSet);
        hashSet.forEach(set::add);
        set2.add(n);
        map2.put(object, n);
    }

    public static class ComponentAccessor
    implements IComponent {
        private final List<Object> componentPath_;
        private Map<Object, Integer> propertyIdToIndex_;
        private final List<Object> values_;
        private List<Integer> childIndices_;
        private Map<Object, Integer> childIdToIndex_;
        private Integer componentUid_;
        private final Function<List<Object>, Object> globalIndexToValueProvider_;
        private Object currentEvolveReason_;
        private Object customData_;

        public ComponentAccessor(List<Object> list, List<Object> list2, Function<List<Object>, Object> function) {
            this.componentPath_ = Collections.unmodifiableList(list);
            this.propertyIdToIndex_ = new HashMap<Object, Integer>();
            this.values_ = Collections.unmodifiableList(list2);
            this.globalIndexToValueProvider_ = function;
        }

        @Override
        public Object get(Object object) {
            Integer n = this.getPropertyIndex(object);
            return n != null ? this.values_.get(n) : null;
        }

        @Override
        public int size() {
            return this.propertyIdToIndex_.size();
        }

        @Override
        public boolean isEmpty() {
            return this.propertyIdToIndex_.isEmpty();
        }

        @Override
        public boolean containsKey(Object object) {
            return this.propertyIdToIndex_.containsKey(object);
        }

        @Override
        public boolean containsValue(Object object) {
            for (Object object2 : this.propertyIdToIndex_.keySet()) {
                if (!Objects.equals(this.get(object2), object)) continue;
                return true;
            }
            return false;
        }

        @Override
        public Object put(Object object, Object object2) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Object remove(Object object) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void putAll(Map map) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void clear() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Set keySet() {
            return this.propertyIdToIndex_.keySet();
        }

        @Override
        public Collection values() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Set<Map.Entry<Object, Object>> entrySet() {
            HashMap<Object, Object> hashMap = new HashMap<Object, Object>();
            for (Object object : this.propertyIdToIndex_.keySet()) {
                hashMap.put(object, this.get(object));
            }
            return hashMap.entrySet();
        }

        @Override
        public Integer getPropertyIndex(Object object) {
            return this.propertyIdToIndex_.get(object);
        }

        @Override
        public Collection<Integer> getPropertyIndices() {
            return this.propertyIdToIndex_.values();
        }

        @Override
        public Object getCustomData() {
            return this.customData_;
        }

        @Override
        public void setCustomData(Object object) {
            this.customData_ = object;
        }

        @Override
        public List<Integer> getChildIndices() {
            return this.childIndices_;
        }

        @Override
        public Integer getChildIndex(Object object) {
            return this.childIdToIndex_.get(object);
        }

        public Map<Object, Integer> getPropertyIdToIndex() {
            return this.propertyIdToIndex_;
        }

        public Integer getComponentUid() {
            return this.componentUid_;
        }

        void setComponentUid(Integer n) {
            this.componentUid_ = n;
        }

        void putPropertyIndex(Object object, Integer n) {
            this.propertyIdToIndex_.put(object, n);
        }

        void finishInitialization() {
            this.propertyIdToIndex_ = Collections.unmodifiableMap(this.propertyIdToIndex_);
        }

        public List<Object> getComponentPath() {
            return this.componentPath_;
        }

        void setChildIndices(List<Integer> list, Map<Object, Integer> map) {
            this.childIndices_ = list;
            this.childIdToIndex_ = map;
        }

        void changeChildIndicesOrder(Collection<Integer> collection) {
            HashSet<Integer> hashSet;
            HashSet<Integer> hashSet2;
            if (debug_ && !(hashSet2 = new HashSet<Integer>(this.childIndices_)).equals(hashSet = new HashSet<Integer>(collection))) {
                throw new IllegalStateException("Old child indices: " + hashSet2 + " new: " + hashSet);
            }
            this.childIndices_ = new ArrayList<Integer>(collection);
        }

        void addChildIndices(Collection<Integer> collection, Map<Object, Integer> map) {
            this.childIndices_.addAll(collection);
            this.childIdToIndex_.putAll(map);
        }

        void removeChildIndices(Collection<Integer> collection, Collection<Object> collection2) {
            this.childIndices_.removeAll(collection);
            for (Object object : collection2) {
                this.childIdToIndex_.remove(object);
            }
        }

        void setEvolveReason(Object object) {
            this.currentEvolveReason_ = object;
        }

        public Object getNodeValueByIndex(Integer n) {
            return this.values_.get(n);
        }

        public Object getEvolveReason() {
            return this.currentEvolveReason_;
        }

        public Object getValueByAbsPath(List<Object> list) {
            return this.globalIndexToValueProvider_.apply(list);
        }
    }

    public static interface IContainerMutator {
        public void setValue(int var1, Object var2);
    }

    public static interface IEvolverAccess
    extends IPropertyValueAccessor {
        public Integer indexOfPath(List<Object> var1);

        public Map<Integer, GetPropertyDelegate> getDelegateByIdMap();

        public Map<Integer, Map<List<Object>, GetPropertyDelegate>> getDelegateByIdAndPathMap();

        public Map<Integer, Map<Keyword, GetPropertyDelegate>> getDelegateByIdAndPropertyMap();

        public Map<Integer, Map<List<Object>, Map<Keyword, GetPropertyDelegate>>> getDelegateByIdPathAndPropertyMap();

        public ObjectMatrix<Object> getKeyMatrix();
    }

    public static interface IPropertyValueAccessor {
        public Object getPropertyValue(Integer var1);
    }

    public static interface IContainerAccessor {
        public IComponent getComponent(int var1);
    }

    public static interface IComponent
    extends Map<Object, Object> {
        public Integer getPropertyIndex(Object var1);

        public Collection<Integer> getPropertyIndices();

        public List<Integer> getChildIndices();

        public Integer getChildIndex(Object var1);

        public Object getCustomData();

        public void setCustomData(Object var1);
    }

    public static interface IContainerParser {
        public void setKeyMatrix(ObjectMatrix<Object> var1);

        public Object getComponentId(Map<Object, Object> var1);

        public Object getChildrenPropertyName();

        public Object getChildOrderPropertyName();

        public Collection<SourceNode> processComponent(List<Object> var1, Map<Object, Object> var2);

        public void processComponentAfterIndexing(IComponent var1);

        public boolean isInterestedIn(Collection<Object> var1, Class<?> var2);

        public boolean isWildcardPathElement(Object var1);
    }

    public static class SourceNode {
        private final Object propertyId_;
        private final boolean childrenProperty_;
        private final boolean childOrderProperty_;
        private final List<Object> nodePath_;
        private final Collection<DependencyInfo> relAndAbsDependencyPaths_;
        private final boolean hasAmbiguousDependencies_;
        private final Object evolverCode_;
        private final List<Object> inputDependencies_;

        public SourceNode(Object object, boolean bl, boolean bl2, List<Object> list, Collection<DependencyInfo> collection, Object object2, List<Object> list2) {
            this.propertyId_ = object;
            this.childrenProperty_ = bl;
            this.childOrderProperty_ = bl2;
            this.nodePath_ = list;
            this.relAndAbsDependencyPaths_ = collection;
            boolean bl3 = false;
            for (DependencyInfo dependencyInfo : this.relAndAbsDependencyPaths_) {
                if (!dependencyInfo.isAmbiguous()) continue;
                bl3 = true;
                break;
            }
            this.hasAmbiguousDependencies_ = bl3;
            this.evolverCode_ = object2;
            this.inputDependencies_ = list2;
        }

        public Object getPropertyId() {
            return this.propertyId_;
        }

        public boolean isChildrenProperty() {
            return this.childrenProperty_;
        }

        public boolean isChildOrderProperty() {
            return this.childOrderProperty_;
        }

        public List<Object> getNodePath() {
            return this.nodePath_;
        }

        public Collection<DependencyInfo> getRelAndAbsDependencyPaths() {
            return this.relAndAbsDependencyPaths_;
        }

        public boolean isHasAmbiguousDependencies() {
            return this.hasAmbiguousDependencies_;
        }

        public Object getEvolverCode() {
            return this.evolverCode_;
        }

        public List<Object> getInputDependencies() {
            return this.inputDependencies_;
        }
    }

    public static class DependencyInfo {
        private final List<Object> relPath_;
        private final List<Object> absPath_;
        private boolean isAmbiguous_;

        public DependencyInfo(List<Object> list, List<Object> list2, boolean bl) {
            this.relPath_ = list;
            this.absPath_ = list2;
            this.isAmbiguous_ = bl;
        }

        public List<Object> getRelPath() {
            return this.relPath_;
        }

        public List<Object> getAbsPath() {
            return this.absPath_;
        }

        public boolean isAmbiguous() {
            return this.isAmbiguous_;
        }
    }
}

