/*
 * Decompiled with CFR 0.152.
 */
package flatgui.core.engine.ui;

import clojure.lang.Keyword;
import clojure.lang.RT;
import clojure.lang.Var;
import flatgui.core.FGWebContainerWrapper;
import flatgui.core.engine.Container;
import flatgui.core.engine.Node;
import flatgui.core.engine.remote.FGLegacyCoreGlue;
import flatgui.core.engine.ui.FGClojureResultCollector;
import flatgui.core.util.Tuple;
import flatgui.core.websocket.FGPaintVectorBinaryCoder;
import java.io.ByteArrayOutputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;

public class FGRemoteClojureResultCollector
extends FGClojureResultCollector {
    private static final String RESPONSE_FEED_NS = "flatgui.responsefeed";
    private static final Var affineTransform_ = RT.var((String)"flatgui.responsefeed", (String)"affinetransform");
    private static final Var clipSizeExtractor_ = RT.var((String)"flatgui.responsefeed", (String)"clip-size-extractor");
    private static final Var extractRegularStrings_ = RT.var((String)"flatgui.responsefeed", (String)"extract-regular-strings");
    private static final Var extractResourceStrings_ = RT.var((String)"flatgui.responsefeed", (String)"extract-resource-strings");
    private static final Keyword CHILDREN_KW = Keyword.intern((String)"children");
    private static final Keyword Z_POSITION_KW = Keyword.intern((String)"z-position");
    private static final Keyword LOOK_VEC_KW = Keyword.intern((String)"look-vec");
    private static final Keyword MODEL_KW = Keyword.intern((String)"model");
    private static final Keyword CARET_LINE_KW = Keyword.intern((String)"caret-line");
    private static final Keyword CARET_LINE_POS_KW = Keyword.intern((String)"caret-line-pos");
    private static final Keyword SELECTION_MARK_LINE_KW = Keyword.intern((String)"selection-mark-line");
    private static final Keyword SELECTION_MARK_LINE_POS_KW = Keyword.intern((String)"selection-mark-line-pos");
    private static final Keyword LINES_KW = Keyword.intern((String)"lines");
    private final FGWebContainerWrapper.IKeyCache keyCache_;
    private final FGLegacyCoreGlue.GlueModule glueModule_;
    private Supplier<List<Object>> paintAllSequenceSupplier_;
    private List<Object> paintAllList_;
    private boolean paintAllListChanged_;
    private TextSelectionModel textSelectionModel_;
    private List<String> selectedTextComponentLines_;
    private boolean textSelectionModelChanged_;
    private Set<Integer> removedComponentUids_;
    private List<Integer> addedComponentUids_;
    private List<Integer> addedComponentParentUids_;
    private Tuple removedAddedUidsTriple_;
    private final FGWebContainerWrapper.IDataTransmitter<List<Object>> paintAllTransmitter_;
    private final Map<Integer, List<String>> componentIdToStringPool_;
    private final FGWebContainerWrapper.IDataTransmitter<Map<Object, Object>> lookVecStringPoolMapTransmitter_;
    private final Map<Integer, List<String>> componentIdToResourceStringPool_;
    private final FGWebContainerWrapper.IDataTransmitter<Map<Object, Object>> lookVecResourceStringPoolMapTransmitter_;
    private final Map<Object, IDataTransmitterWrapper> propertyToTransWrapper_;
    private final Set<IDataTransmitterWrapper> allWrappers_;
    private final BooleanFlagsMapTransmitterWrapper booleanFlagsMapTransmitterWrapper_;
    private final TextSelectionModelTransmitter textSelectionModelTransmitter_;
    private final AddRemoveComponentsTransmitter addRemoveComponentsTransmitter_;
    private Collection<ByteBuffer> diffsToTransmit_;
    private boolean initialized_;

    public FGRemoteClojureResultCollector(int n, FGWebContainerWrapper.IKeyCache iKeyCache, FGLegacyCoreGlue.GlueModule glueModule, Set<String> set) {
        super(n);
        this.keyCache_ = iKeyCache;
        this.glueModule_ = glueModule;
        this.paintAllTransmitter_ = new FGWebContainerWrapper.PaintAllTransmitter(this.keyCache_, null);
        this.componentIdToStringPool_ = new HashMap<Integer, List<String>>();
        this.lookVecStringPoolMapTransmitter_ = new FGWebContainerWrapper.StringPoolMapTransmitter(this.keyCache_, null);
        this.componentIdToResourceStringPool_ = new HashMap<Integer, List<String>>();
        this.lookVecResourceStringPoolMapTransmitter_ = new FGWebContainerWrapper.ResourceStringPoolMapTransmitter(this.keyCache_, null);
        this.propertyToTransWrapper_ = new LinkedHashMap<Object, IDataTransmitterWrapper>();
        this.diffsToTransmit_ = new ArrayList<ByteBuffer>(3 + this.propertyToTransWrapper_.size());
        this.addTransmitterWrapper(new ChildCountMapTransmitterWrapper(this.keyCache_));
        this.addTransmitterWrapper(new IdentityMapTransmitterWrapper("look-vec", new FGWebContainerWrapper.LookVectorTransmitter(this.glueModule_::getStringPoolId, this.keyCache_, null, set)));
        this.booleanFlagsMapTransmitterWrapper_ = new BooleanFlagsMapTransmitterWrapper(this.keyCache_);
        this.addTransmitterWrapper(this.booleanFlagsMapTransmitterWrapper_);
        this.addTransmitterWrapper(new ClipSizeMapTransmitterWrapper(this.keyCache_));
        this.addTransmitterWrapper(new ViewportMatrixMapTransmitterWrapper(this.keyCache_));
        this.addTransmitterWrapper(new PositionMatrixMapTransmitterWrapper(this.keyCache_));
        this.allWrappers_ = new LinkedHashSet<IDataTransmitterWrapper>(this.propertyToTransWrapper_.values());
        this.textSelectionModelTransmitter_ = new TextSelectionModelTransmitter(this.glueModule_::getStringPoolId);
        this.addRemoveComponentsTransmitter_ = new AddRemoveComponentsTransmitter();
        this.removedComponentUids_ = new HashSet<Integer>();
        this.addedComponentUids_ = new ArrayList<Integer>();
        this.addedComponentParentUids_ = new ArrayList<Integer>();
        this.removedAddedUidsTriple_ = Tuple.triple(this.removedComponentUids_, this.addedComponentParentUids_, this.addedComponentUids_);
    }

    void initialize(Supplier<List<Object>> supplier) {
        this.paintAllSequenceSupplier_ = supplier;
    }

    @Override
    public void componentInitialized(Container container, Integer n) {
        super.componentInitialized(container, n);
        Container.IComponent iComponent = container.getComponent(n);
        Collection<Integer> collection = iComponent.getPropertyIndices();
        for (Integer n2 : collection) {
            this.collectInitialDataForNode(container, n2);
        }
    }

    @Override
    public void appendResult(int n, List<Object> list, Node node, Object object) {
        super.appendResult(n, list, node, object);
        if (this.initialized_) {
            this.collectResultForTransmitting(node.getComponentUid(), node.getPropertyId(), object);
        }
    }

    @Override
    public void postProcessAfterEvolveCycle(Container.IContainerAccessor iContainerAccessor, Container.IContainerMutator iContainerMutator) {
        super.postProcessAfterEvolveCycle(iContainerAccessor, iContainerMutator);
        if (this.initialized_) {
            this.prepareAccumulatedDataForTrasmitting();
        }
    }

    public Collection<ByteBuffer> getInitialDataToTransmit(Container container) {
        this.resetAll(true);
        int n = container.getNodeCount();
        for (int i = 0; i < n; ++i) {
            this.collectInitialDataForNode(container, i);
        }
        this.prepareAccumulatedDataForTrasmitting();
        this.initialized_ = true;
        return this.getDiffsToTransmit();
    }

    public Collection<ByteBuffer> getDiffsToTransmit() {
        this.resetAll(false);
        ArrayList<ByteBuffer> arrayList = new ArrayList<ByteBuffer>(this.diffsToTransmit_);
        this.diffsToTransmit_.clear();
        return arrayList;
    }

    @Override
    protected void lookVectorGenerated(Integer n, List<Object> list) {
        super.lookVectorGenerated(n, list);
        this.collectResultForTransmitting(n, LOOK_VEC_KW, list);
    }

    @Override
    public void componentAdded(Integer n, Integer n2) {
        super.componentAdded(n, n2);
        this.addedComponentUids_.add(n2);
        this.addedComponentParentUids_.add(n);
    }

    @Override
    public void componentRemoved(Integer n) {
        super.componentRemoved(n);
        this.removedComponentUids_.add(n);
        this.booleanFlagsMapTransmitterWrapper_.removeComponent(n);
    }

    private void collectInitialDataForNode(Container container, Integer n) {
        Node node = container.getNode(n);
        this.collectResultForTransmitting(node.getComponentUid(), node.getPropertyId(), container.getPropertyValue(n));
    }

    void collectResultForTransmitting(Integer n, Object object, Object object2) {
        Object object3;
        if (object == CHILDREN_KW || object == Z_POSITION_KW) {
            object3 = this.paintAllSequenceSupplier_.get();
            this.paintAllListChanged_ = this.paintAllList_ == null || !this.paintAllList_.equals(object3);
            this.paintAllList_ = object3;
        }
        if ((object3 = this.propertyToTransWrapper_.get(object)) != null) {
            object3.appendResult(n, object, object2);
            if (object == LOOK_VEC_KW) {
                this.componentIdToStringPool_.put(n, (List)extractRegularStrings_.invoke(object2));
                this.componentIdToResourceStringPool_.put(n, (List)extractResourceStrings_.invoke(object2));
            }
        }
        if (object == MODEL_KW && this.collectTextSelectionModel(n, object2)) {
            this.textSelectionModelChanged_ = true;
        }
    }

    private boolean collectTextSelectionModel(Integer n, Object object) {
        if (object instanceof Map) {
            Map map = (Map)object;
            Object v = map.get(CARET_LINE_KW);
            Object v2 = map.get(CARET_LINE_POS_KW);
            Object v3 = map.get(SELECTION_MARK_LINE_KW);
            Object v4 = map.get(SELECTION_MARK_LINE_POS_KW);
            Object v5 = map.get(LINES_KW);
            if (v instanceof Number && v2 instanceof Number && v3 instanceof Number && v4 instanceof Number && v5 instanceof List) {
                TextSelectionModel textSelectionModel = new TextSelectionModel(((Number)v).intValue(), ((Number)v2).intValue(), ((Number)v3).intValue(), ((Number)v4).intValue());
                if (this.textSelectionModel_ == null || !this.textSelectionModel_.equals(textSelectionModel) && (this.textSelectionModel_.isNonEmpty() || textSelectionModel.isNonEmpty())) {
                    this.textSelectionModel_ = textSelectionModel;
                    this.selectedTextComponentLines_ = (List)v5;
                    this.textSelectionModelTransmitter_.setTextSelectionModel(this.textSelectionModel_, this.selectedTextComponentLines_, n);
                    return true;
                }
            }
        }
        return false;
    }

    private void resetAll(boolean bl) {
        this.paintAllList_ = null;
        this.textSelectionModelChanged_ = false;
        this.componentIdToStringPool_.clear();
        this.componentIdToResourceStringPool_.clear();
        for (IDataTransmitterWrapper iDataTransmitterWrapper : this.allWrappers_) {
            iDataTransmitterWrapper.reset(bl);
        }
        this.removedComponentUids_.clear();
        this.addedComponentUids_.clear();
        this.addedComponentParentUids_.clear();
    }

    private void prepareAccumulatedDataForTrasmitting() {
        Map<Object, Object> map;
        if (this.paintAllList_ != null) {
            this.diffsToTransmit_.add(this.paintAllTransmitter_.convertToBinary(this.paintAllTransmitter_.getCommandCode(), this.paintAllList_));
        }
        if (!this.componentIdToStringPool_.isEmpty()) {
            map = this.glueModule_.getStringPoolDiffs(this.componentIdToStringPool_);
            this.diffsToTransmit_.add(this.lookVecStringPoolMapTransmitter_.convertToBinary(this.lookVecStringPoolMapTransmitter_.getCommandCode(), map));
        }
        if (!this.componentIdToResourceStringPool_.isEmpty()) {
            map = this.glueModule_.getStringPoolDiffs(this.componentIdToResourceStringPool_);
            this.diffsToTransmit_.add(this.lookVecResourceStringPoolMapTransmitter_.convertToBinary(this.lookVecResourceStringPoolMapTransmitter_.getCommandCode(), map));
        }
        for (IDataTransmitterWrapper iDataTransmitterWrapper : this.allWrappers_) {
            ByteBuffer byteBuffer = iDataTransmitterWrapper.commitAndWriteDataDiff();
            if (byteBuffer == null) continue;
            this.diffsToTransmit_.add(byteBuffer);
        }
        if (this.textSelectionModelChanged_) {
            this.diffsToTransmit_.add(this.textSelectionModelTransmitter_.convertToBinary(this.textSelectionModelTransmitter_.getCommandCode(), this.textSelectionModel_));
        }
        if (!this.removedComponentUids_.isEmpty() || !this.addedComponentUids_.isEmpty()) {
            System.out.println("-DLTEMP- FGRemoteClojureResultCollector.prepareAccumulatedDataForTrasmitting-----ADD/REMOVE");
            this.diffsToTransmit_.add(this.addRemoveComponentsTransmitter_.convertToBinary(this.addRemoveComponentsTransmitter_.getCommandCode(), this.removedAddedUidsTriple_));
            this.removedComponentUids_.clear();
            this.addedComponentUids_.clear();
            this.addedComponentParentUids_.clear();
        }
    }

    private void addTransmitterWrapper(IDataTransmitterWrapper iDataTransmitterWrapper) {
        for (Object object : iDataTransmitterWrapper.getContributingPropertyIds()) {
            this.propertyToTransWrapper_.put(object, iDataTransmitterWrapper);
        }
    }

    public static class AddRemoveComponentsTransmitter
    extends FGWebContainerWrapper.AbstractTransmitter<Tuple> {
        @Override
        public int writeBinary(ByteArrayOutputStream byteArrayOutputStream, int n, Tuple tuple) {
            Collection collection = (Collection)tuple.getFirst();
            List list = (List)tuple.getSecond();
            List list2 = (List)tuple.getThird();
            n += FGWebContainerWrapper.wtireShort(byteArrayOutputStream, collection.size());
            for (Integer n2 : collection) {
                n += FGWebContainerWrapper.wtireShort(byteArrayOutputStream, n2);
            }
            for (int i = 0; i < list2.size(); ++i) {
                n += FGWebContainerWrapper.wtireShort(byteArrayOutputStream, (Integer)list.get(i));
                n += FGWebContainerWrapper.wtireShort(byteArrayOutputStream, (Integer)list2.get(i));
            }
            return n;
        }

        @Override
        public byte getCommandCode() {
            return 69;
        }

        @Override
        public Supplier<Tuple> getEmptyDataSupplier() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Supplier<Tuple> getSourceDataSupplier() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Tuple getDiffToTransmit(Tuple tuple, Tuple tuple2) {
            return tuple2;
        }
    }

    private static class TextSelectionModelTransmitter
    extends FGWebContainerWrapper.AbstractTransmitter<TextSelectionModel> {
        private final FGPaintVectorBinaryCoder.StringPoolIdSupplier stringPoolIdSupplier_;
        private TextSelectionModel textSelectionModel_;
        private List<String> selectedTextComponentLines_;
        private Integer textSelectionComponentUid_;

        public TextSelectionModelTransmitter(FGPaintVectorBinaryCoder.StringPoolIdSupplier stringPoolIdSupplier) {
            this.stringPoolIdSupplier_ = stringPoolIdSupplier;
        }

        @Override
        public int writeBinary(ByteArrayOutputStream byteArrayOutputStream, int n, TextSelectionModel textSelectionModel) {
            if (this.textSelectionModel_.isNonEmpty()) {
                int n2;
                boolean bl = this.textSelectionModel_.getCaretLine() <= this.textSelectionModel_.getSelectionMarkLine();
                int n3 = bl ? this.textSelectionModel_.getCaretLine() : this.textSelectionModel_.getSelectionMarkLine();
                int n4 = bl ? this.textSelectionModel_.getSelectionMarkLine() : this.textSelectionModel_.getCaretLine();
                String string = this.selectedTextComponentLines_.get(n3);
                int n5 = this.stringPoolIdSupplier_.getStringPoolId(string, this.textSelectionComponentUid_);
                if (this.textSelectionModel_.isMultiLine()) {
                    String string2 = this.selectedTextComponentLines_.get(n4);
                    n2 = this.stringPoolIdSupplier_.getStringPoolId(string2, this.textSelectionComponentUid_);
                } else {
                    n2 = n5;
                }
                n += FGWebContainerWrapper.wtireShort(byteArrayOutputStream, this.textSelectionComponentUid_);
                if (this.textSelectionModel_.isMultiLine()) {
                    n += FGWebContainerWrapper.wtireShort(byteArrayOutputStream, n5);
                    n += FGWebContainerWrapper.wtireShort(byteArrayOutputStream, bl ? this.textSelectionModel_.getCaretLinePos() : this.textSelectionModel_.getSelectionMarkLinePos());
                    n += FGWebContainerWrapper.wtireShort(byteArrayOutputStream, n2);
                    n += FGWebContainerWrapper.wtireShort(byteArrayOutputStream, bl ? this.textSelectionModel_.getSelectionMarkLinePos() : this.textSelectionModel_.getCaretLinePos());
                    for (int i = n3 + 1; i < n4; ++i) {
                        String string3 = this.selectedTextComponentLines_.get(i);
                        int n6 = this.stringPoolIdSupplier_.getStringPoolId(string3, this.textSelectionComponentUid_);
                        n += FGWebContainerWrapper.wtireShort(byteArrayOutputStream, n6);
                    }
                } else {
                    boolean bl2 = this.textSelectionModel_.getCaretLinePos() < this.textSelectionModel_.getSelectionMarkLinePos();
                    n += FGWebContainerWrapper.wtireShort(byteArrayOutputStream, n5);
                    n += FGWebContainerWrapper.wtireShort(byteArrayOutputStream, bl2 ? this.textSelectionModel_.getCaretLinePos() : this.textSelectionModel_.getSelectionMarkLinePos());
                    n += FGWebContainerWrapper.wtireShort(byteArrayOutputStream, bl2 ? this.textSelectionModel_.getSelectionMarkLinePos() : this.textSelectionModel_.getCaretLinePos());
                }
            }
            return n;
        }

        @Override
        public byte getCommandCode() {
            return 68;
        }

        @Override
        public Supplier<TextSelectionModel> getEmptyDataSupplier() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Supplier<TextSelectionModel> getSourceDataSupplier() {
            throw new UnsupportedOperationException();
        }

        @Override
        public TextSelectionModel getDiffToTransmit(TextSelectionModel textSelectionModel, TextSelectionModel textSelectionModel2) {
            return textSelectionModel2;
        }

        public void setTextSelectionModel(TextSelectionModel textSelectionModel, List<String> list, Integer n) {
            this.textSelectionModel_ = textSelectionModel;
            this.selectedTextComponentLines_ = list;
            this.textSelectionComponentUid_ = n;
        }
    }

    private static class TextSelectionModel {
        private final int caretLine_;
        private final int caretLinePos_;
        private final int selectionMarkLine_;
        private final int selectionMarkLinePos_;

        TextSelectionModel(int n, int n2, int n3, int n4) {
            this.caretLine_ = n;
            this.caretLinePos_ = n2;
            this.selectionMarkLine_ = n3;
            this.selectionMarkLinePos_ = n4;
        }

        int getCaretLine() {
            return this.caretLine_;
        }

        int getCaretLinePos() {
            return this.caretLinePos_;
        }

        int getSelectionMarkLine() {
            return this.selectionMarkLine_;
        }

        int getSelectionMarkLinePos() {
            return this.selectionMarkLinePos_;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null || this.getClass() != object.getClass()) {
                return false;
            }
            TextSelectionModel textSelectionModel = (TextSelectionModel)object;
            if (this.getCaretLine() != textSelectionModel.getCaretLine()) {
                return false;
            }
            if (this.getCaretLinePos() != textSelectionModel.getCaretLinePos()) {
                return false;
            }
            if (this.getSelectionMarkLine() != textSelectionModel.getSelectionMarkLine()) {
                return false;
            }
            return this.getSelectionMarkLinePos() == textSelectionModel.getSelectionMarkLinePos();
        }

        public int hashCode() {
            int n = this.getCaretLine();
            n = 31 * n + this.getCaretLinePos();
            n = 31 * n + this.getSelectionMarkLine();
            n = 31 * n + this.getSelectionMarkLinePos();
            return n;
        }

        public String toString() {
            return this.caretLine_ + "-" + this.caretLinePos_ + "-" + this.selectionMarkLine_ + "-" + this.selectionMarkLinePos_;
        }

        boolean isMultiLine() {
            return this.getCaretLine() != this.getSelectionMarkLine();
        }

        boolean isNonEmpty() {
            return this.isMultiLine() || this.getCaretLinePos() != this.getSelectionMarkLinePos();
        }
    }

    private static class BooleanFlagsMapTransmitterWrapper
    extends AbstractDataTransmitterWrapper<Byte> {
        private static final byte STATE_FLAGS_VISIBILITY_MASK = 1;
        private static final byte STATE_FLAGS_POPUP_MASK = 2;
        private static final byte STATE_FLAGS_ROLLOVER_DISABLED_MASK = 4;
        private static final byte STATE_FLAGS_PRECISE_TEXT_MEASUREMENT = 8;
        private static final Keyword ROLLOWER_NOTIFY_DISABLED_KW = Keyword.intern((String)"rollover-notify-disabled");
        private static final Keyword POPUP_KW = Keyword.intern((String)"popup");
        private static final Keyword VISIBLE_KW = Keyword.intern((String)"visible");
        private static final Keyword EDITABLE_KW = Keyword.intern((String)"editable");
        private boolean hasDataToTransmit_;

        BooleanFlagsMapTransmitterWrapper(FGWebContainerWrapper.IKeyCache iKeyCache) {
            super(new FGWebContainerWrapper.BooleanFlagsMapTransmitter(iKeyCache, null));
        }

        @Override
        public Set<Object> getContributingPropertyIds() {
            return this.setOf(ROLLOWER_NOTIFY_DISABLED_KW, POPUP_KW, VISIBLE_KW, EDITABLE_KW);
        }

        @Override
        public void appendResult(Integer n, Object object, Object object2) {
            Byte by;
            boolean bl = object2 != null && (!(object2 instanceof Boolean) || (Boolean)object2 != false);
            Byte by2 = (Byte)this.componentUidToData_.get(n);
            if (object == ROLLOWER_NOTIFY_DISABLED_KW) {
                by = this.changeFlag(by2, (byte)4, bl);
            } else if (object == POPUP_KW) {
                by = this.changeFlag(by2, (byte)2, bl);
            } else if (object == VISIBLE_KW) {
                by = this.changeFlag(by2, (byte)1, bl);
            } else if (object == EDITABLE_KW) {
                by = this.changeFlag(by2, (byte)8, bl);
            } else {
                throw new IllegalArgumentException("Unsupported property: " + object);
            }
            this.componentUidToData_.put(n, by);
        }

        @Override
        protected boolean hasDataToTransmit() {
            return this.hasDataToTransmit_;
        }

        @Override
        public void reset(boolean bl) {
            if (bl) {
                super.reset(bl);
            } else {
                this.hasDataToTransmit_ = false;
            }
        }

        void removeComponent(Integer n) {
            this.componentUidToData_.remove(n);
        }

        private Byte changeFlag(Byte by, byte by2, boolean bl) {
            this.hasDataToTransmit_ = true;
            if (bl) {
                return by != null ? (byte)(by | by2) : by2;
            }
            return by != null ? (byte)(by & ~by2) : (byte)0;
        }
    }

    private static class ViewportMatrixMapTransmitterWrapper
    extends AbstractDataTransmitterWrapper<Object> {
        ViewportMatrixMapTransmitterWrapper(FGWebContainerWrapper.IKeyCache iKeyCache) {
            super(new FGWebContainerWrapper.ViewportMatrixMapTrasmitter(iKeyCache, null));
        }

        @Override
        public Set<Object> getContributingPropertyIds() {
            return this.setOf(Keyword.intern((String)"viewport-matrix"));
        }

        @Override
        public void appendResult(Integer n, Object object, Object object2) {
            if (object2 != null) {
                this.componentUidToData_.put(n, affineTransform_.invoke(object2));
            }
        }
    }

    private static class PositionMatrixMapTransmitterWrapper
    extends AbstractDataTransmitterWrapper<Object> {
        PositionMatrixMapTransmitterWrapper(FGWebContainerWrapper.IKeyCache iKeyCache) {
            super(new FGWebContainerWrapper.PositionMatrixMapTrasmitter(iKeyCache, null));
        }

        @Override
        public Set<Object> getContributingPropertyIds() {
            return this.setOf(Keyword.intern((String)"position-matrix"));
        }

        @Override
        public void appendResult(Integer n, Object object, Object object2) {
            if (object2 != null) {
                this.componentUidToData_.put(n, affineTransform_.invoke(object2));
            }
        }
    }

    private static class ClipSizeMapTransmitterWrapper
    extends AbstractDataTransmitterWrapper<Object> {
        ClipSizeMapTransmitterWrapper(FGWebContainerWrapper.IKeyCache iKeyCache) {
            super(new FGWebContainerWrapper.ClipRectTransmitter(iKeyCache, null));
        }

        @Override
        public Set<Object> getContributingPropertyIds() {
            return this.setOf(Keyword.intern((String)"clip-size"));
        }

        @Override
        public void appendResult(Integer n, Object object, Object object2) {
            if (object2 != null) {
                this.componentUidToData_.put(n, clipSizeExtractor_.invoke(object2));
            }
        }
    }

    private static class ChildCountMapTransmitterWrapper
    extends AbstractDataTransmitterWrapper<Number> {
        ChildCountMapTransmitterWrapper(FGWebContainerWrapper.IKeyCache iKeyCache) {
            super(new FGWebContainerWrapper.ChildCountMapTransmitter(iKeyCache, null));
        }

        @Override
        public Set<Object> getContributingPropertyIds() {
            return this.setOf(Keyword.intern((String)"children"));
        }

        @Override
        public void appendResult(Integer n, Object object, Object object2) {
            if (object2 != null) {
                this.componentUidToData_.put(n, ((Map)object2).size());
            }
        }
    }

    private static class IdentityMapTransmitterWrapper
    extends AbstractDataTransmitterWrapper<Object> {
        private final Set<Object> propertyIdSet_;

        public IdentityMapTransmitterWrapper(String string, FGWebContainerWrapper.IDataTransmitter<Map<Object, Object>> iDataTransmitter) {
            super(iDataTransmitter);
            this.propertyIdSet_ = Collections.unmodifiableSet(this.setOf(Keyword.intern((String)string)));
        }

        @Override
        public Set<Object> getContributingPropertyIds() {
            return this.propertyIdSet_;
        }

        @Override
        public void appendResult(Integer n, Object object, Object object2) {
            if (object2 != null) {
                this.componentUidToData_.put(n, object2);
            }
        }
    }

    private static abstract class AbstractDataTransmitterWrapper<V>
    implements IDataTransmitterWrapper {
        private final FGWebContainerWrapper.IDataTransmitter<Map<Object, Object>> dataTransmitter_;
        protected final Map<Integer, V> componentUidToData_;

        public AbstractDataTransmitterWrapper(FGWebContainerWrapper.IDataTransmitter<Map<Object, Object>> iDataTransmitter) {
            this.dataTransmitter_ = iDataTransmitter;
            this.componentUidToData_ = new HashMap<Integer, V>();
        }

        @Override
        public ByteBuffer commitAndWriteDataDiff() {
            if (this.hasDataToTransmit()) {
                FGWebContainerWrapper.DEBUG_OP = "NEW";
                ByteBuffer byteBuffer = this.dataTransmitter_.convertToBinary(this.dataTransmitter_.getCommandCode(), this.componentUidToData_);
                FGWebContainerWrapper.DEBUG_OP = "OLD";
                return byteBuffer;
            }
            return null;
        }

        protected boolean hasDataToTransmit() {
            return !this.componentUidToData_.isEmpty();
        }

        protected final Set<Object> setOf(Object ... objectArray) {
            HashSet<Object> hashSet = new HashSet<Object>(objectArray.length);
            Collections.addAll(hashSet, objectArray);
            return hashSet;
        }

        @Override
        public void reset(boolean bl) {
            this.componentUidToData_.clear();
        }
    }

    private static interface IDataTransmitterWrapper {
        public Set<Object> getContributingPropertyIds();

        public void appendResult(Integer var1, Object var2, Object var3);

        public ByteBuffer commitAndWriteDataDiff();

        public void reset(boolean var1);
    }
}

