/*
 * Decompiled with CFR 0.152.
 */
package flatgui.util;

import flatgui.util.CompactList;
import flatgui.util.ObjectMatrix;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;

public class CompactListTest {
    @Test
    public void testSlots() {
        CompactList compactList = new CompactList(null);
        compactList.setSlot(4, 4002);
        compactList.setSlot(3, 5);
        compactList.setSlot(9, 4095);
        compactList.setSlot(2, 4095);
        compactList.setSlot(0, 123);
        compactList.setSlot(7, 5);
        compactList.setSlot(1, 111);
        compactList.setSlot(6, 2222);
        compactList.setSlot(5, 3333);
        compactList.setSlot(8, 4000);
        Assert.assertEquals((long)4002L, (long)compactList.getSlot(4));
        Assert.assertEquals((long)5L, (long)compactList.getSlot(3));
        Assert.assertEquals((long)4095L, (long)compactList.getSlot(9));
        Assert.assertEquals((long)4095L, (long)compactList.getSlot(2));
        Assert.assertEquals((long)123L, (long)compactList.getSlot(0));
        Assert.assertEquals((long)5L, (long)compactList.getSlot(7));
        Assert.assertEquals((long)111L, (long)compactList.getSlot(1));
        Assert.assertEquals((long)2222L, (long)compactList.getSlot(6));
        Assert.assertEquals((long)3333L, (long)compactList.getSlot(5));
        Assert.assertEquals((long)4000L, (long)compactList.getSlot(8));
    }

    @Test
    public void testSlotBitsErased() {
        CompactList compactList = new CompactList(null);
        compactList.setSlot(0, 1);
        compactList.setSlot(1, 2);
        compactList.setSlot(0, 2);
        compactList.setSlot(1, 4);
        Assert.assertEquals((long)2L, (long)compactList.getSlot(0));
        Assert.assertEquals((long)4L, (long)compactList.getSlot(1));
    }

    @Test
    public void testList1() {
        ObjectMatrix<String> objectMatrix = new ObjectMatrix<String>();
        int[] nArray = objectMatrix.addPath(Arrays.asList("x", "y", "z"));
        CompactList<String, ObjectMatrix<String>> compactList = new CompactList<String, ObjectMatrix<String>>(objectMatrix, nArray);
        Assert.assertEquals((long)3L, (long)compactList.size());
        Assert.assertEquals((Object)"x", compactList.get(0));
        Assert.assertEquals((Object)"y", compactList.get(1));
        Assert.assertEquals((Object)"z", compactList.get(2));
        StringBuilder stringBuilder = new StringBuilder();
        compactList.forEach(stringBuilder::append);
        Assert.assertEquals((Object)"xyz", (Object)stringBuilder.toString());
        compactList.remove(2);
        Assert.assertEquals((long)2L, (long)compactList.size());
        Assert.assertEquals((Object)"x", compactList.get(0));
        Assert.assertEquals((Object)"y", compactList.get(1));
        stringBuilder = new StringBuilder();
        compactList.forEach(stringBuilder::append);
        Assert.assertEquals((Object)"xy", (Object)stringBuilder.toString());
        compactList.add("w");
        Assert.assertEquals((long)3L, (long)compactList.size());
        Assert.assertEquals((Object)"x", compactList.get(0));
        Assert.assertEquals((Object)"y", compactList.get(1));
        Assert.assertEquals((Object)"w", compactList.get(2));
        stringBuilder = new StringBuilder();
        compactList.forEach(stringBuilder::append);
        Assert.assertEquals((Object)"xyw", (Object)stringBuilder.toString());
    }

    @Test
    public void testListCopy() {
        ObjectMatrix<String> objectMatrix = new ObjectMatrix<String>();
        int[] nArray = objectMatrix.addPath(Arrays.asList("x", "y", "z"));
        CompactList compactList = new CompactList(objectMatrix, nArray);
        CompactList<String, ObjectMatrix<String>> compactList2 = new CompactList<String, ObjectMatrix<String>>(objectMatrix, compactList);
        Assert.assertEquals(compactList, compactList2);
        Assert.assertEquals((long)3L, (long)compactList2.size());
        Assert.assertEquals((Object)"x", compactList2.get(0));
        Assert.assertEquals((Object)"y", compactList2.get(1));
        Assert.assertEquals((Object)"z", compactList2.get(2));
        StringBuilder stringBuilder = new StringBuilder();
        compactList2.forEach(stringBuilder::append);
        Assert.assertEquals((Object)"xyz", (Object)stringBuilder.toString());
        List<String> list = Arrays.asList("x", "y", "w");
        CompactList<String, ObjectMatrix<String>> compactList3 = new CompactList<String, ObjectMatrix<String>>(objectMatrix, list);
        Assert.assertEquals((long)3L, (long)compactList3.size());
        Assert.assertEquals((Object)"x", compactList3.get(0));
        Assert.assertEquals((Object)"y", compactList3.get(1));
        Assert.assertEquals((Object)"w", compactList3.get(2));
        stringBuilder = new StringBuilder();
        compactList3.forEach(stringBuilder::append);
        Assert.assertEquals((Object)"xyw", (Object)stringBuilder.toString());
        Assert.assertEquals((Object)"z", objectMatrix.get(2, 0));
        Assert.assertEquals((Object)"w", objectMatrix.get(2, 1));
        compactList3.remove(compactList3.size() - 1);
        compactList3.add("w");
        Assert.assertEquals((Object)"w", objectMatrix.get(2, 1));
        compactList3.remove(compactList3.size() - 1);
        compactList3.add("v");
        Assert.assertEquals((Object)"v", objectMatrix.get(2, 2));
    }

    @Test
    public void testEquals() {
        ObjectMatrix objectMatrix = new ObjectMatrix();
        CompactList<String, ObjectMatrix<String>> compactList = new CompactList<String, ObjectMatrix<String>>(objectMatrix);
        CompactList<String, ObjectMatrix<String>> compactList2 = new CompactList<String, ObjectMatrix<String>>(objectMatrix);
        Assert.assertTrue((boolean)compactList.equals(compactList2));
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < CompactList.DISTRIBUTION.length - 1; ++i) {
            System.out.println("-DLTEMP- CompactListTest.testEquals i=" + i + " l1=" + compactList + " l2=" + compactList2);
            String string = String.valueOf(i);
            compactList.add(string);
            Assert.assertTrue((String)("Step " + i + " (not equals)"), (!compactList.equals(compactList2) ? 1 : 0) != 0);
            if (i < CompactList.DISTRIBUTION.length - 2) {
                compactList2.add("t");
                Assert.assertTrue((String)("Step " + i + " (not equals)"), (!compactList.equals(compactList2) ? 1 : 0) != 0);
                compactList2.add(string);
                Assert.assertTrue((String)("Step " + i + " (not equals)"), (!compactList.equals(compactList2) ? 1 : 0) != 0);
                compactList2.remove(compactList2.size() - 1);
                compactList2.remove(compactList2.size() - 1);
            }
            compactList2.add(string);
            Assert.assertTrue((String)("Step " + i + " (equals)"), (boolean)compactList.equals(compactList2));
            arrayList.add(string);
            Assert.assertTrue((String)("Step " + i + " (l1==check)"), (boolean)compactList.equals(arrayList));
            Assert.assertTrue((String)("Step " + i + " (l2==check)"), (boolean)compactList2.equals(arrayList));
        }
    }

    @Test
    public void testEquals1() {
        ObjectMatrix objectMatrix = new ObjectMatrix();
        CompactList<String, ObjectMatrix<String>> compactList = new CompactList<String, ObjectMatrix<String>>(objectMatrix);
        compactList.add("x");
        compactList.add("y");
        compactList.add("z");
        compactList.add("w");
        compactList.add("v");
        compactList.add("a");
        compactList.add("b");
        compactList.add("c");
        CompactList<String, ObjectMatrix<String>> compactList2 = new CompactList<String, ObjectMatrix<String>>(objectMatrix);
        compactList2.add("x");
        compactList2.add("_");
        compactList2.add("z");
        compactList2.add("w");
        compactList2.add("v");
        compactList2.add("a");
        compactList2.add("b");
        compactList2.add("c");
        Assert.assertTrue((!compactList.equals(compactList2) ? 1 : 0) != 0);
        Assert.assertTrue((!compactList2.equals(compactList) ? 1 : 0) != 0);
        for (int i = 0; i < 7; ++i) {
            compactList2.remove(compactList2.size() - 1);
        }
        compactList2.add("y");
        compactList2.add("z");
        compactList2.add("w");
        compactList2.add("v");
        compactList2.add("a");
        compactList2.add("b");
        compactList2.add("_");
        Assert.assertTrue((!compactList.equals(compactList2) ? 1 : 0) != 0);
        Assert.assertTrue((!compactList2.equals(compactList) ? 1 : 0) != 0);
        compactList2.remove(compactList2.size() - 1);
        compactList2.add("c");
        Assert.assertTrue((boolean)compactList.equals(compactList2));
        Assert.assertTrue((boolean)compactList2.equals(compactList));
    }

    @Test
    public void testSet() {
        ObjectMatrix objectMatrix = new ObjectMatrix();
        CompactList<String, ObjectMatrix<String>> compactList = new CompactList<String, ObjectMatrix<String>>(objectMatrix);
        compactList.add("x");
        compactList.add("y");
        compactList.add("z");
        CompactList<String, ObjectMatrix<String>> compactList2 = new CompactList<String, ObjectMatrix<String>>(objectMatrix);
        compactList2.add("a");
        compactList2.add("b");
        compactList2.add("c");
        compactList2.set(1, "y");
        compactList2.set(2, "m");
        compactList.set(2, "m");
        compactList2.set(0, "x");
        Assert.assertEquals((Object)"x", compactList.get(0));
        Assert.assertEquals((Object)"y", compactList.get(1));
        Assert.assertEquals((Object)"m", compactList.get(2));
        Assert.assertEquals((Object)"x", compactList2.get(0));
        Assert.assertEquals((Object)"y", compactList2.get(1));
        Assert.assertEquals((Object)"m", compactList2.get(2));
        Assert.assertEquals((long)3L, (long)compactList.size());
        Assert.assertEquals((long)3L, (long)compactList2.size());
        Assert.assertTrue((boolean)compactList.equals(compactList2));
        compactList.set(0, "n");
        Assert.assertEquals((long)3L, (long)compactList.size());
        Assert.assertEquals((long)3L, (long)compactList2.size());
        Assert.assertTrue((!compactList.equals(compactList2) ? 1 : 0) != 0);
        Assert.assertEquals((Object)"n", compactList.get(0));
        Assert.assertEquals((Object)"y", compactList.get(1));
        Assert.assertEquals((Object)"m", compactList.get(2));
        Assert.assertEquals((Object)"x", compactList2.get(0));
        Assert.assertEquals((Object)"y", compactList2.get(1));
        Assert.assertEquals((Object)"m", compactList2.get(2));
    }

    @Test
    public void testResizeAndDirtySlots() {
        ObjectMatrix objectMatrix = new ObjectMatrix();
        CompactList<String, ObjectMatrix<String>> compactList = new CompactList<String, ObjectMatrix<String>>(objectMatrix);
        compactList.add("a");
        compactList.add("b");
        compactList.add("c");
        compactList.remove(compactList.size() - 1);
        compactList.remove(compactList.size() - 1);
        compactList.remove(compactList.size() - 1);
        compactList.add("x");
        compactList.add("y");
        compactList.add("z");
        Assert.assertEquals((long)1L, (long)compactList.getSlot(0));
        Assert.assertEquals((long)1L, (long)compactList.getSlot(1));
        Assert.assertEquals((long)1L, (long)compactList.getSlot(2));
        compactList.remove(compactList.size() - 1);
        Assert.assertEquals((long)1L, (long)compactList.getSlot(0));
        Assert.assertEquals((long)1L, (long)compactList.getSlot(1));
        Assert.assertEquals((long)0L, (long)compactList.getSlot(2));
        CompactList compactList2 = new CompactList(objectMatrix, compactList);
        CompactList compactList3 = new CompactList(objectMatrix, new ArrayList(compactList));
        Assert.assertTrue((boolean)compactList2.equals(compactList3));
    }
}

